#include <klocale.h>
#include "outputdialog.h"
#include <qevent.h>
#include <ktextedit.h>
#include <kpushbutton.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <iostream>
#include <fstream>
#include "asoundinterface.h"

OutputDialog::OutputDialog(MainDialog *mainDlg, QWidget *parent, const char *name)
	: Output(parent, name), mainDlg (mainDlg)
{
	connect( m_UpdateButton, SIGNAL( clicked() ), this, SLOT ( updateDialog() ) );
	connect( m_SaveButton, SIGNAL( clicked() ), this, SLOT( saveOutput()) );
}


OutputDialog::~OutputDialog()
{
}


#include "outputdialog.moc"


/*!
    \fn OutputDialog::updateDialog()
 */
void OutputDialog::updateDialog()
{
	QString dlgText;
	mainDlg->updateConfig();
	AsoundInterface::genRCEntries(dlgText);
	m_FileText->setText(dlgText);
}


/*!
    \fn OutputDialog::saveOutput()
 */
void OutputDialog::saveOutput()
{
	QString saveName = KFileDialog::getSaveFileName();
        if (saveName.isEmpty()) return;
	std::ofstream outFile;
	outFile.open(saveName);
	if (!outFile) {
		KMessageBox::error(this, QString(i18n("Unabled to save file %1")).arg(saveName), i18n("Kasound: Unable to save file"));
	}
	else {
		outFile << m_FileText->text();
	}
	outFile.close();
}
