#!/usr/bin/perl -w

#usage: isocreateProgressControl.pl dcopTarget

#parse output of mkisofs
#pass back current percentage done value to my progress bar widget.

$dcopTarget=$ARGV[0];
$currentProgress=-1;
$progress=0;

$startTime=time;
$currentTime=$startTime;
$estimateRemain=0;
$estimateRemainText="??h:??m:??s";

while (<STDIN>) {
	if (/(\d+.*\d*)%/) {
		$progress = int ($1 * 2);
		if ($progress != $currentProgress) {
			$currentProgress = $progress;
			$currentTime = time - $startTime;
			if ($currentProgress != 0) {
				$estimateRemain = int ($currentTime/$currentProgress * (200-$currentProgress));
				$hrs = int($estimateRemain / (60 * 60));
				$mins = int(($estimateRemain - $hrs*60*60)/(60));
				$secs = int($estimateRemain - ($hrs*60*60) - ($mins*60));
				$estimateRemainText = sprintf('%1$uh:%2$.2um:%3$.2us', $hrs, $mins, $secs)
			}

			system "dcop $dcopTarget KommanderIf setText \"progressConvert\" \"$currentProgress\"";
			system "dcop $dcopTarget KommanderIf setText \"status\" \"  Processing:  (step 5 of 5) Creating ISO image... ETA: $estimateRemainText\""
		}
	}
}

system "dcop $dcopTarget KommanderIf setText \"progressConvert\" \"200\""



