#!/usr/bin/perl -w

#usage: convertProgressControl.pl frameCount dcopTarget

#parse output of transcode to get current frame that is being processed
#pass back current percentage done value to my progress bar widget.

$frameCount=$ARGV[0];
$dcopTarget=$ARGV[1];
$currentProgress=-1;
$progress=0;

$startTime=time;
$currentTime=$startTime;
$estimateRemain=0;
$estimateRemainText="??h:??m:??s";

while (<STDIN>) {
	if (/\[0+-0*([1-9]\d*)/) {
		$progress = int (($1 / $frameCount) * 200);
		if ($progress != $currentProgress) {
			$currentProgress = $progress;
			$currentTime = time - $startTime;
			if ($currentProgress != 0) {
				$estimateRemain = int ($currentTime/$currentProgress * (200-$currentProgress));
				$hrs = int($estimateRemain / (60 * 60));
				$mins = int(($estimateRemain - $hrs*60*60)/(60));
				$secs = int($estimateRemain - ($hrs*60*60) - ($mins*60));
				$estimateRemainText = sprintf('%1$uh:%2$.2um:%3$.2us', $hrs, $mins, $secs)
			}
			system "dcop $dcopTarget KommanderIf setText \"progressConvert\" \"$currentProgress\"";
			system "dcop $dcopTarget KommanderIf setText \"status\" \"  Processing:  (step 1 of 5) Converting to mpeg2 format... ETA: $estimateRemainText\""
		}
	}
}
system "dcop $dcopTarget KommanderIf setText \"progressConvert\" \"200\""



