/*
 * KDE Radio Station
 * Copyright (C) 2003, 2004 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#include <kapplication.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kcmdlineargs.h>

#include "toplevel.h"

#include "config.h"

int main(int argc, char **argv)
{
	Toplevel *toplevel;
	KAboutData about("kderadiostation",
		I18N_NOOP("KDE Radio Station"),
		VERSION,
		I18N_NOOP("Internet radio station browser"),
		KAboutData::License_GPL,
		I18N_NOOP("Copyright (C) 2003, 2004 Josef Spillner"),
		QString::null,
		"http://kderadiostation.coolprojects.org/",
		"spillner@kde.org");
	about.addAuthor("Josef Spillner", I18N_NOOP("Development"), "spillner@kde.org", "http://mindx.dyndns.org");
	about.addCredit("Tobias König", I18N_NOOP("Improvements"), "tokoe@kde.org", "http://wgess16.dyndns.org");
	about.setTranslator(I18N_NOOP("TRANSLATOR-NAME"), I18N_NOOP("TRANSLATOR-EMAIL"));

	KCmdLineArgs::init(argc, argv, &about);
	KApplication a;

	toplevel = new Toplevel();
	a.setMainWidget(toplevel);
	toplevel->show();
	return a.exec();
}

