/*
 * KDE Radio Station
 * Copyright (C) 2003 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#include "share.h"

#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>

#include <qlayout.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qcombobox.h>

Share::Share(QWidget *parent, const char *name)
: KDialogBase(Plain, i18n("Share"), Ok | Cancel, Ok, parent, name, true, true)
{
	QWidget *page = plainPage();
	QVBoxLayout *vbox;
	QLabel *lstream, *luri, *lspeed, *llocation, *ltype, *lstyle, *lcategory;
	QMap<QString, QString>::Iterator it;

	lstream = new QLabel(i18n("Stream title"), this);
	lstyle = new QLabel(i18n("Style"), this);
	llocation = new QLabel(i18n("Location"), this);
	lspeed = new QLabel(i18n("Bandwidth in kB"), this);
	ltype = new QLabel(i18n("Type"), this);
	luri = new QLabel(i18n("URI"), this);
	lcategory = new QLabel(i18n("Category"), this);

	estream = new QLineEdit(this);
	estyle = new QLineEdit(this);
	elocation = new QLineEdit(this);
	espeed = new QLineEdit(this);
	typebox = new QComboBox(this);
	euri = new QLineEdit(this);
	uribox = new QComboBox(this);

	m_types["playlist"] = i18n("Playlist");
	m_types["stream"] = i18n("Direct Stream");

	for(it = m_types.begin(); it != m_types.end(); it++)
		typebox->insertItem(it.data());

	vbox = new QVBoxLayout(page, marginHint(), spacingHint());
	vbox->add(lstream);
	vbox->add(estream);
	vbox->add(lstyle);
	vbox->add(estyle);
	vbox->add(llocation);
	vbox->add(elocation);
	vbox->add(lspeed);
	vbox->add(espeed);
	vbox->add(ltype);
	vbox->add(typebox);
	vbox->add(luri);
	vbox->add(euri);
	vbox->add(lcategory);
	vbox->add(uribox);

	estream->setFocus();
}

QString Share::value(QString param)
{
	QMap<QString, QString>::Iterator it;

	if(param == "stream") return estream->text();
	else if(param == "uri") return euri->text();
	else if(param == "speed") return espeed->text();
	else if(param == "location") return elocation->text();
	else if(param == "type")
	{
		for(it = m_types.begin(); it != m_types.end(); it++)
			if(it.data() == typebox->currentText()) return it.key();
		return QString::null;
	}
	else if(param == "style") return estyle->text();
	return QString::null;
}

void Share::setUris(QStringList uris)
{
	QStringList::iterator it;
	KConfig *config;
	QString alias;
	QString cleanurl;

	config = kapp->config();
	config->setGroup("identifiers");

	for (it = uris.begin(); it != uris.end(); it++)
	{
		if((*it).startsWith("ggzmeta://"))
		{
			cleanurl = (*it);
			alias = config->readEntry(cleanurl.replace("=", "%3d"), (*it));
			uribox->insertItem(alias);
		}
	}
}

QString Share::uri()
{
	return uribox->currentText();
}

