/*
 * KDE Radio Station
 * Copyright (C) 2003, 2004 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#ifndef STATIONLIST_H
#define STATIONLIST_H

#include <klistview.h>
#include <qsocket.h>
#include <qstringlist.h>

class QListViewItem;
class QPopupMenu;
class Station;

class StationList : public QWidget
{
	Q_OBJECT
	public:
		StationList(QWidget *parent = NULL, const char *name = NULL);
		~StationList();

		QStringList metaservers(bool writeable);
		void addStation(QString metaserver, QString stream, QString uri,
			QString location, QString speed, QString style, QString type);
		void removeStation(QString uri);

	signals:
		void signalNewMetaserver(QString uri);
		void signalStations();
		void signalProgress(QString text, int percentage);

	public slots:
		void slotActivate(QListViewItem *item);
		void slotConnected();
		void slotRead();
		void slotError(int error);
		void slotTimeout();

		void slotUpdateMetaservers();
		void slotUpdateStations();
		void slotGrouping();

	private slots:
		void slotMenu(QListViewItem *item, const QPoint& point, int c);
		void slotMenuAction(int id);
		void slotDelayedUpdateStations();

	private:
		void doconnection(QString query);
		void doupdate(QString query, QString uri);
		void process(QString content);
		void processlocal(QString content);
		void processicecast(QString content);
		void processwiki(QString content);

		void savecache();
		void loadcache();

		void guiupdate();

		void startDrag();

		enum MenuIds
		{
			menu_broken,
			menu_modify,
			menu_information
		};

		enum TransactionIds
		{
			trans_query,
			trans_meta,
			trans_update
		};

		QPopupMenu *m_popup;
		QString m_host;
		int m_port;
		KListView *view;
		QSocket *sock;
		QString m_query;
		QString m_metaquery;
		QString m_curquery;
		QString m_update, m_broken;
		QStringList m_metaservers;
		int m_synchronized;
		int m_transaction;
		QPtrList<Station> m_stations;
		QString m_source, m_feedback;
		Station *m_station;
};

#endif

