/*
 * KDE Radio Station
 * Copyright (C) 2003, 2004 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#include "toplevel.h"
#include "kradiopart.h"
#include "options.h"
#include "share.h"

#include <kpushbutton.h>
#include <kstdguiitem.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kstandarddirs.h>
#include <kapplication.h>
#include <kdeversion.h>
#include <kprogress.h>

#include <qlayout.h>
#include <qpixmap.h>
#include <qlistview.h>

Toplevel::Toplevel()
: QWidget()
{
	QVBoxLayout *vbox;
	QHBoxLayout *hbox;
	QPushButton *finish, *options, *share;

	part = new KRadioPart(this);
	view = part->view();

	options = new KPushButton(KGuiItem(i18n("Options"), "configure"), this);
	share = new KPushButton(KGuiItem(i18n("Share"), "2uparrow"), this);
	finish = new KPushButton(KStdGuiItem::close(), this);

	progress = new KProgress(100, this);
	progress->setFormat("");
	progress->hide();

	vbox = new QVBoxLayout(this, 5);
	vbox->add(view);
	hbox = new QHBoxLayout(vbox, 5);
	hbox->add(options);
	hbox->add(share);
	hbox->add(finish);
	hbox->add(progress);
	hbox->addStretch(1);

	setCaption(i18n("KDE Radio Station"));
	resize(600, 300);

	connect(options, SIGNAL(clicked()), SLOT(slotOptions()));
	connect(share, SIGNAL(clicked()), SLOT(slotShare()));
	connect(finish, SIGNAL(clicked()), SLOT(close()));

	connect(view, SIGNAL(signalProgress(QString, int)), SLOT(slotProgress(QString, int)));

	show();

	m_sizehack = (options->width() + share->width() + finish->width());
	m_sizehack += hbox->spacing() * 5;
	m_sizehack += hbox->margin() * 2;
}

Toplevel::~Toplevel()
{
}

void Toplevel::slotShare()
{
	int ret;
	QString stream, uri, location, speed, style, type;
	QString alias;
	QStringList metaservers;

	metaservers = part->metaservers(true);
	if(metaservers.count() == 0)
	{
		KMessageBox::sorry(this,
			i18n("No metaservers currently accept contributions. "
				"Try to update your server list."),
			i18n("Share"));
		return;
	}

	Share s(this);
	s.setUris(metaservers);
	ret = s.exec();

	if(ret == QDialog::Accepted)
	{
		uri = s.value("uri");
		location = s.value("location");
		stream = s.value("stream");
		style = s.value("style");
		speed = s.value("speed");
		type = s.value("type");

		alias = s.uri();

		part->addStation(alias, stream, uri, location, speed, style, type);
	}
}

void Toplevel::slotOptions()
{
	QStringList metaservers;
	QStringList::iterator it;
	OptionsDialog o(this);

	connect(&o, SIGNAL(signalUpdateMetaservers()), view, SLOT(slotUpdateMetaservers()));
	connect(view, SIGNAL(signalNewMetaserver(QString)), &o, SLOT(slotNewMetaserver(QString)));

	connect(&o, SIGNAL(signalUpdateStations()), view, SLOT(slotUpdateStations()));
	connect(view, SIGNAL(signalStations()), &o, SLOT(slotStations()));

	connect(&o, SIGNAL(signalGrouping()), view, SLOT(slotGrouping()));

	metaservers = part->metaservers(false);
	for(it = metaservers.begin(); it != metaservers.end(); it++)
		o.slotNewMetaserver((*it));

	o.exec();
}

void Toplevel::slotProgress(QString text, int percentage)
{
	if(!percentage) progress->hide();
	else
	{
		progress->show();
		progress->setFixedWidth(width() - m_sizehack); // hack: kprogress layouting/maximizing problem
	}

	progress->setFormat(text);
	progress->setProgress(percentage);
}

