/*
 * KDE Radio Station
 * Copyright (C) 2003 Josef Spillner <spillner@kde.org>
 * Published under GNU GPL conditions.
 */

#include <kpushbutton.h>
#include <klocale.h>
#include <kstdguiitem.h>
#include <kapplication.h>
#include <kconfig.h>
#include <kdebug.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qlistbox.h>

#include "view.h"

ViewDialog::ViewDialog(QWidget *parent, const char *name)
: KDialogBase(Plain, i18n("View metaservers"), Ok | Cancel, Ok, parent, name, true, true)
{
	QWidget *page = plainPage();

	QVBoxLayout *layout = new QVBoxLayout(page, marginHint(), spacingHint());

	list = new QListBox(this);

	KPushButton *consider = new KPushButton(KGuiItem(i18n("Consideration"),
		"music_32ndnote"), this);

	layout->add(list);
	layout->add(consider);

	connect(consider, SIGNAL(clicked()), SLOT(slotConsideration()));
}

void ViewDialog::add(QString uri)
{
	KConfig *config;
	int value;
	QString alias, displayalias;
	bool writeable;
	QString cleanurl;

	config = kapp->config();
	config->setGroup("identifiers");
	cleanurl = uri;
	alias = config->readEntry(cleanurl.replace("=", "%3d"));
	if(alias.isNull()) alias = uri;
	config->setGroup("meta");
	value = config->readNumEntry(alias);
	config->setGroup("contributions");
	writeable = config->readNumEntry(uri);

	displayalias = alias;
	if(writeable)
	{
		displayalias = i18n("%1, supports contributions").arg(alias);
	}
	if(alias.startsWith("file:/"))
	{
		displayalias = i18n("Local resource %1").arg(alias.section("/", -1, -1));
	}

	m_resources[displayalias] = alias;
	list->insertItem(displayalias);

	if(value) consideration(list->count() - 1, value);
}

void ViewDialog::slotConsideration()
{
	KConfig *config;
	int value;
	QString text, displaytext;

	displaytext = list->currentText();
	if((displaytext.startsWith("(")) && (displaytext.endsWith(")")))
		displaytext = displaytext.mid(1, displaytext.length() - 2);
	text = m_resources[displaytext];
	if(text.isEmpty()) return;

	config = kapp->config();
	config->setGroup("meta");
	value = config->readNumEntry(text);
	value = !value;
	config->writeEntry(text, value);
	config->sync();

	consideration(list->currentItem(), value);
}

void ViewDialog::consideration(int index, int value)
{
	QString text = list->text(index);

	kdDebug() << "consider " << text.latin1() << " to change b/c " << value << endl;
	if(value) text = "(" + text + ")";
	else text = text.mid(1, text.length() - 2);
	list->changeItem(text, index);
}

