// -*- c++ -*-
/***************************************************************************
                           videowidgetimpl.h
                           -------------------
    begin                : Sun Sep 6 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __VIDEOWIDGETIMPL_H
#define __VIDEOWIDGETIMPL_H

#include "videowidget.h"
#include "pluginfactory.h"
#include "settingsdialogpage.h"

class ConfigData;
class Kdetv;

/**
 * @author Dirk Ziegelmeier <dziegel@gmx.de>
 */

class VideoWidgetImpl : public VideoWidget, public SettingsDialogPage
{
    Q_OBJECT
	
 public: 
    VideoWidgetImpl(QWidget*, Kdetv*, ConfigData*);
    ~VideoWidgetImpl();
    

 public slots:
    virtual void setup();
    virtual void apply();
    virtual void defaults();

    
 private slots:
    void selectionChanged();
    void configurePlugin();
    void itemDoubleClicked(QListViewItem*);
    void browseClicked();


 private:
    Kdetv*      _ktv;
    ConfigData* _cfg;
};

#endif
