/* kexis.h
 * Kexis is a lossless wav (PCM) sound compressor.
 * Copyright (C) 2000 Wayde Milas (wmilas@rarcoa.com)
 * 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Functions
 */

void useage(void);
void display_copyright(void);
int parse_arg(OPTIONSTRUCT *options, int argc, char *argv[]);
int parse_files(OPTIONSTRUCT *options, int argc, char *argv[]);
int main(int argc, char *argv[]);
void handle_verbose(OPTIONSTRUCT *options, KEXISBLOCKSTRUCT *kexisBlock,
	PCMBLOCKSTRUCT *pcmBlock);
void handle_error(OPTIONSTRUCT *options);
void exit_nicely(OPTIONSTRUCT *options);
void print_progress(KEXISBLOCKSTRUCT *kexisBlock, unsigned long pcmLength,
	OPTIONSTRUCT *options, unsigned long totalLength, int mode);
void free_allocated(PCMBLOCKSTRUCT *pcmBlock, KEXISBLOCKSTRUCT *kexisBlock,
	OPTIONSTRUCT *options);
