/* predictor.c
 * The predictors that attempt to minimize the difference between last and
 * current values.
 * Copyright (C) 2000 Wayde Milas (wmilas@rarcoa.com)
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "types.h"
#include "predictor.h"

void zero_predictor_table(PREDICTORTABLE *predTable, OPTIONSTRUCT *options)
{
	int loop;

	predTable->mid_K = malloc(sizeof(int) * MAX_KHISTORY);
	if(options->encoderVersion == RICE_DUAL_K ||
		options->encoderVersion == RICE_DUAL_K_BLOCK)
		predTable->ave_K = malloc(sizeof(int) * MAX_KHISTORY);
	else
		predTable->ave_K = NULL;

	predTable->newKLookUP = malloc(sizeof(double) * (K_LOOKUP_SIZE+1));

	for(loop=0; loop < 3;loop++) {
		predTable->mid_I[loop] = 0;
		predTable->ave_I[loop] = 0;
	}

	for(loop=0;loop < MAX_KHISTORY;loop++) {
		predTable->mid_K[loop]=INITIAL_K;
		if(options->encoderVersion == RICE_DUAL_K ||
			options->encoderVersion == RICE_DUAL_K_BLOCK)
			predTable->ave_K[loop]=INITIAL_K;
	}

	for(loop=0;loop <= K_LOOKUP_SIZE;loop++) predTable->newKLookUP[loop] = -1;

	predTable->diffAve=predTable->diffMid=0;
	predTable->lowDiffAve=0;
	predTable->highDiffAve=0;
	predTable->sumDiffAve=0;
	predTable->countDiffAve=0;
	predTable->lowDiffMid=0;
	predTable->highDiffMid=0;
	predTable->sumDiffMid=0;
	predTable->countDiffMid=0;
	predTable->midM = MAX_M;
	predTable->aveM = MAX_M;
	predTable->midLowK=0;
	predTable->aveLowK=0;
	predTable->midHighK=0;
	predTable->aveHighK=0;
	predTable->midSumK=0;
	predTable->aveSumK=0;
	predTable->midCountK=0;
	predTable->aveCountK=0;
	predTable->kBlockPointer=0;

	predTable->preLog10_2 = log10(2);
}

void frame_difference_calc(PREDICTORTABLE *predictor, unsigned short predA,
	unsigned short predM, long mid, long ave, int op)
{
	if(predA == ZEROO_PREDICTOR)
    predictor->diffAve = -ave;
  else if(predA == FIRSTO_PREDICTOR)
    predictor->diffAve = predictor->ave_I[0] - ave;
  else if(predA == SECONDO_PREDICTOR)
    predictor->diffAve = ((2*predictor->ave_I[0]) -
			predictor->ave_I[1]) - ave;
  else 
    predictor->diffAve = ((3*predictor->ave_I[0]) -
      (3*predictor->ave_I[1]) + predictor->ave_I[2]) - ave;

	if(predM == ZEROO_PREDICTOR)
    predictor->diffMid = -mid;
  else if(predM == FIRSTO_PREDICTOR)
    predictor->diffMid = predictor->mid_I[0] - mid;
  else if(predM == SECONDO_PREDICTOR)
    predictor->diffMid = ((2*predictor->mid_I[0]) -
			predictor->mid_I[1]) - mid;
  else 
    predictor->diffMid = ((3*predictor->mid_I[0]) -
      (3*predictor->mid_I[1]) + predictor->mid_I[2]) - mid;

	predictor->mid_I[3] = predictor->mid_I[2];
  predictor->mid_I[2] = predictor->mid_I[1];
  predictor->mid_I[1] = predictor->mid_I[0];
  if(op == COMPRESS) {
    predictor->mid_I[0] = mid;
  }
  else {
    predictor->mid_I[0] = predictor->diffMid;
  }
  predictor->ave_I[3] = predictor->ave_I[2];
  predictor->ave_I[2] = predictor->ave_I[1];
  predictor->ave_I[1] = predictor->ave_I[0];
  if(op == COMPRESS) {
    predictor->ave_I[0] = ave;
  }
  else {
    predictor->ave_I[0] = predictor->diffAve;
  }
}
void difference_calc(PREDICTORTABLE *predictor, unsigned short pred, 
	long mid, long ave, int op)
{
	int	hold[4], last, i, smallest, bestPred;

	if(pred == ZEROO_PREDICTOR) {
		predictor->diffMid = -mid;
		predictor->diffAve = -ave;
	}
	else if(pred == FIRSTO_PREDICTOR) {
		predictor->diffMid = predictor->mid_I[0] - mid;	
		predictor->diffAve = predictor->ave_I[0] - ave;
	}
	else if(pred == SECONDO_PREDICTOR) {
		predictor->diffMid = ((2*predictor->mid_I[0]) - predictor->mid_I[1]) - mid;
		predictor->diffAve = ((2*predictor->ave_I[0]) - predictor->ave_I[1]) - ave;
	}
	else if(pred == THIRDO_PREDICTOR) {
		predictor->diffMid = ((3*predictor->mid_I[0]) -
			(3*predictor->mid_I[1]) + predictor->mid_I[2]) - mid;
		predictor->diffAve = ((3*predictor->ave_I[0]) -
			(3*predictor->ave_I[1]) + predictor->ave_I[2]) - ave;
	}
	else if(pred == L_HISTORY_PREDICTOR) {
		last = predictor->mid_I[0];
		hold[0] = 0 - last;
		hold[1] = predictor->mid_I[1] - last;
		hold[2] = ((2*predictor->mid_I[1]) - predictor->mid_I[2]) - last;
		hold[3] = ((3*predictor->mid_I[1]) - (3*predictor->mid_I[2]) +
			predictor->mid_I[3]) - last;

		smallest = (abs(hold[0]));
		bestPred = 0;
		i = 1;
		while(i < 4) {
			if(abs(hold[i]) < smallest) {
				smallest = abs(hold[i]);
				bestPred = i;
			}
			i++;
		}

		if(bestPred == 0)
			predictor->diffMid = -mid;
		else if(bestPred == 1)
			predictor->diffMid = predictor->mid_I[0] -mid;
		else if(bestPred == 2)
			predictor->diffMid = ((2*predictor->mid_I[0]) - predictor->mid_I[1]) -
				mid;
		else
			predictor->diffMid = ((3*predictor->mid_I[0]) -
				(3*predictor->mid_I[1]) + predictor->mid_I[2]) - mid;

		last = predictor->ave_I[0];
		hold[0] = 0 - last;
		hold[1] = predictor->ave_I[1] - last;
		hold[2] = ((2*predictor->ave_I[1]) - predictor->ave_I[2]) - last;
		hold[3] = ((3*predictor->ave_I[1]) - (3*predictor->ave_I[2]) +
			predictor->ave_I[3]) - last;

		smallest = (abs(hold[0]));
		bestPred = 0;
		i = 1;
		while(i < 4) {
			if(abs(hold[i]) < smallest) {
		  	smallest = abs(hold[i]);
			  bestPred = i;
			}
			i++;
		}

		if(bestPred == 0)
			predictor->diffAve = -ave;
		else if(bestPred == 1)
			predictor->diffAve = predictor->ave_I[0] -ave;
		else if(bestPred == 2)
		  predictor->diffAve = ((2*predictor->ave_I[0]) - predictor->ave_I[1]) -
		 		ave;
		else
			predictor->diffAve = ((3*predictor->ave_I[0]) -
		    (3*predictor->ave_I[1]) + predictor->ave_I[2]) - ave;
	}

	predictor->mid_I[3] = predictor->mid_I[2];
	predictor->mid_I[2] = predictor->mid_I[1];
	predictor->mid_I[1] = predictor->mid_I[0];
	if(op == COMPRESS) {
		predictor->mid_I[0] = mid;
	}
	else {
		predictor->mid_I[0] = predictor->diffMid;
	}
	predictor->ave_I[3] = predictor->ave_I[2];
	predictor->ave_I[2] = predictor->ave_I[1];
	predictor->ave_I[1] = predictor->ave_I[0];
	if(op == COMPRESS) {
		predictor->ave_I[0] = ave;
	}
	else {
		predictor->ave_I[0] = predictor->diffAve;
	}
}

void precompute_predictor(KEXISBLOCKSTRUCT *kexisBlock,
	PCMBLOCKSTRUCT *pcmBlock, int *A, int *M)
{
	int loop, loop2, choiceM=0, choiceA=0;
	long   left, right, mid, ave;
	double	m[4], a[4], bestMid, bestAve;
	PREDICTORTABLE *predictor, pred[4];

	predictor = &kexisBlock->predictor;
	// copy the state info over;
	for(loop=0;loop<4;loop++) {
		for(loop2=0;loop2<4;loop2++) {
			pred[loop2].mid_I[loop] = predictor->mid_I[loop];
			pred[loop2].ave_I[loop] = predictor->ave_I[loop];
		}
		a[loop] = 0;
		m[loop] = 0;
	}
	for(loop=0;loop<pcmBlock->size;loop+=2) {
		left = pcmBlock->data[loop];
		right = pcmBlock->data[loop+1];
		mid = left - right;
		ave = right + (mid/2);

		for(loop2=0;loop2<4;loop2++) {
			difference_calc(&(pred[loop2]), loop2+1, mid, ave, COMPRESS);

			a[loop2] += abs(pred[loop2].diffAve);
			m[loop2] += abs(pred[loop2].diffMid);
		}
	}

	bestAve = a[0]; choiceA=0;
	bestMid = m[0]; choiceM=0;
	for(loop=1;loop<4;loop++) {
		if(a[loop] < bestAve) {
			bestAve = a[loop];
			choiceA = loop;
		}
		if(m[loop] < bestMid) {
      bestMid = m[loop];
      choiceM = loop;
    }
	}

	*A = choiceA+1;
	*M = choiceM+1;
}

void collect_prediction_stats(KEXISBLOCKSTRUCT *kexisBlock, long dMid,
	long dAve)
{
	if(dAve < kexisBlock->predictor.lowDiffAve)
  	kexisBlock->predictor.lowDiffAve = dAve;

  if(dAve > kexisBlock->predictor.highDiffAve)
    kexisBlock->predictor.highDiffAve = dAve;

  if(dMid < kexisBlock->predictor.lowDiffMid)
    kexisBlock->predictor.lowDiffMid = dMid;

  if(dMid > kexisBlock->predictor.highDiffMid)
    kexisBlock->predictor.highDiffMid = dMid;

  kexisBlock->predictor.countDiffMid++;
  kexisBlock->predictor.sumDiffMid += abs(dMid);

  kexisBlock->predictor.countDiffAve++;
  kexisBlock->predictor.sumDiffAve += abs(dAve);
}
