/* predictor.h
 * The predictors that attempt to minimize the difference between last and
 * current values.
 * Copyright (C) 2000 Wayde Milas (wmilas@rarcoa.com)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Functions
 */

void zero_predictor_table(PREDICTORTABLE *predTable, OPTIONSTRUCT *options);
void frame_difference_calc(PREDICTORTABLE *predictor, unsigned short predA,
  unsigned short predM, long mid, long ave, int op);
void difference_calc(PREDICTORTABLE *predictor, unsigned short pred,
	long mid, long ave, int op);
void collect_prediction_stats(KEXISBLOCKSTRUCT *kexisBlock, long dMid,
	long dAve);
void precompute_predictor(KEXISBLOCKSTRUCT *kexisBlock,
	PCMBLOCKSTRUCT *pcmBlock, int *A, int *M);
