/* rice.h
 * Pseudo Rice encoding of an integer stream
 * Copyright (C) 2000 Wayde Milas (wmilas@rarcoa.com)
 *
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Functions
 */

void rice_decode(KEXISBLOCKSTRUCT *kexisBlock, long *data,
	OPTIONSTRUCT *options, PCMBLOCKSTRUCT *pcmBlock, int kType);
void rice_encode(KEXISBLOCKSTRUCT *kexisBlock, long data,
	OPTIONSTRUCT *options, PCMBLOCKSTRUCT *pcmBlock, int kType);
void collect_K_stats(PREDICTORTABLE *pred, long newK, int kType,
	unsigned short encoderVersion);
long get_K(PREDICTORTABLE *pred, int kType, unsigned short encoderVersion,
	int kHist);
long calc_newK(long newData, PREDICTORTABLE *pred);
void update_K(PREDICTORTABLE *pred, long newK, int kType,
	unsigned short encoderVersion, int kHist);
int block_ave_K(int table[], int kHist);
long lookup_newK(long holdData, PREDICTORTABLE *pred);
