/* types.h
 * All the defines, and structures and Kexis uses.
 * Copyright (C) 2000 Wayde Milas (wmilas@rarcoa.com)
 * 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* includes:
 */

#include <sys/time.h>

/* defines
 */

#define VERSION_MAJOR 						0
#define VERSION_MINOR 						2
#define VERSION_SUB_MINOR 				2

#define DEBUG 										0
#define PRED_DEBUG 								0
#define DEBUG_UP 									10
#define DEBUG_DOWN								2
#define DEBUG_POS 								113964

#define COMPRESS      						0
#define DECOMPRESS    						1

#define MID 											0
#define AVE 											1	

#define		STANDARD_ENCODER 				3
#define   RICE_SINGLE_K						1
#define   RICE_DUAL_K							2
#define		RICE_DUAL_K_BLOCK				3
#define   MAX_STANDARD_ENCODER    3
#define		MIN_STANDARD_ENCODER    1

#define		STANDARD_PREDICTOR 			6
#define		ZEROO_PREDICTOR					1
#define   FIRSTO_PREDICTOR        2
#define   SECONDO_PREDICTOR				3
#define		THIRDO_PREDICTOR				4
#define   L_HISTORY_PREDICTOR			5
#define		FRAME_PREDICTOR					6
#define   MAX_STANDARD_PREDICTOR	6
#define		MIN_STANDARD_PREDICTOR  1

#define		MAX_M										100

#define		MAX_KHISTORY						256
#define   DEFAULT_KHISTORY				32

#define		INITIAL_KEXIS_HEADER		1
#define   CURRENT_KEXIS_HEADER		1

#define   FRAME_UNITS							1024
#define		K_LOOKUP_SIZE						32000

#define		INITIAL_K								8

/* Structs
 */

typedef struct {
  char            ckID[4];
  unsigned long   ckSize;
  char            wave_ckID[4];
  char            fmt_ckID[4];
  unsigned long   fmt_ckSize;
  unsigned short  formatTag;
  unsigned short  nChannels;
  unsigned long   nSamplesPerSec;
  unsigned long   nAvgBytesPerSec;
  unsigned short  nBlockAlign;
  unsigned short  nBitsPerSample;
  char            data_ckID[4];
  unsigned long   data_ckSize;
} WAVHEADER;

// Dont change this struct until we update parse_kexis_header
typedef struct {
	char						kexisID[4];
	unsigned short	headerVersion;
	unsigned short	encoderVersion;
	unsigned short	predictorVersion;
	unsigned short  kHistorySize;
	unsigned long		dataLength;
	unsigned long		frameSize;
	unsigned short  options;						// First bit is joint stereo or not.
	unsigned short  pad3;
} KEXISHEADER;

typedef struct {
  int             mode;
  int             progress;
	int							verbose;
  int             displayHeader;
	int							dec_stdout;
	int							kHistorySize;
	int							argPosition;
	int							joint;
	int							del_file;
	unsigned long		frameSize;
	unsigned short	predictorVersion;
	unsigned short  encoderVersion;
  FILE            *inFileStream;
  FILE            *outFileStream;
 	struct timeval  time;
	struct timeval  progTime;
	char						errorString[256];
	char            *inFileName;
	char            *outFileName;
} OPTIONSTRUCT;

typedef struct {
	int							mid_I[4];
	int							ave_I[4];
	int							midM;
	int							aveM;
	int							diffAve;
	int							diffMid;
	int							lowDiffAve;
	int							highDiffAve;
	int     	      lowDiffMid;
	int      	  	  highDiffMid;

	int             *mid_K;
	int							*ave_K;
	int							kBlockPointer;
	int             midLowK;
	int							aveLowK;
	int             midHighK;
	int							aveHighK;

	double          sumDiffAve;
	double          countDiffAve;
	double          sumDiffMid;
	double          countDiffMid;
	double          midSumK;
	double					aveSumK;
	double          midCountK;
	double					aveCountK;

	double					preLog10_2;
	long						*newKLookUP;
} PREDICTORTABLE;

typedef struct {
  int             bitCounter;  //Keeps track of the halfway assembled word when
															 //encoding.
	unsigned long   blockPointer;
	unsigned long		subBlockPointer;
	unsigned long		sumTotalSize;
	unsigned long		debugBlockCount;

	long            dataPosition; //position in the block that data is stacked
																//to currently.
	long            bitBucket;   //used to hold partial words between bit pushes
	double          countK;
	PREDICTORTABLE  predictor;
	long           	*data;
} KEXISBLOCKSTRUCT;

typedef struct {
  unsigned long   size;
  unsigned long   pcmStreamLength;
	int							currentAve;
	int							currentMid;
	short           *data;
} PCMBLOCKSTRUCT;
