// $Id: mountpoint.cpp,v 1.1.1.1 2006/01/26 17:09:46 robin_d Exp $

/***************************************************************************
 *   Copyright (C) 2006 by Robin Doer                                      *
 *   robin@robind.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <kdebug.h>

#include <qfile.h>
#include <qfileinfo.h>

#include "mountpoint.h"
#include "psptimer.h"

/* MountPoint::MountPoint (1) **********************************************/
MountPoint::MountPoint() {}

/* MountPoint::MountPoint (2) **********************************************/
MountPoint::MountPoint(const QString& rawData) {
  // One line from /proc/mounts
  QStringList splitted = QStringList::split(" ", rawData, false);
  m_device = splitted[0];
  m_mountPoint = splitted[1];
  m_fsType = splitted[2];
  m_options = QStringList::split(",", splitted[3], false);
}

/* MountPoint::MountPoint (3) **********************************************/
MountPoint::MountPoint(const MountPoint& mp) {
  copy(mp);
}

/* MountPoint::device ******************************************************/
QString MountPoint::device() const {
  return m_device;
}

/* MountPoint::mountPoint **************************************************/
QString MountPoint::mountPoint() const {
  return m_mountPoint;
}

/* MountPoint::fsType ******************************************************/
QString MountPoint::fsType() const {
  return m_fsType;
}

/* MountPoint::options *****************************************************/
QStringList MountPoint::options() const {
  return m_options;
}

/* MountPoint::operator = **************************************************/
void MountPoint::operator = (const MountPoint& mp) {
  copy(mp);
}

/* MountPoint::copy ********************************************************/
inline void MountPoint::copy(const MountPoint& mp) {
  m_device = mp.m_device;
  m_mountPoint = mp.m_mountPoint;
  m_fsType = mp.m_fsType;
  m_options = mp.m_options;
}
