// $Id: mountpoint.h,v 1.1.1.1 2006/01/26 17:09:46 robin_d Exp $

/***************************************************************************
 *   Copyright (C) 2006 by Robin Doer                                      *
 *   robin@robind.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MOUNTPOINT_H
#define MOUNTPOINT_H

#include <qstringlist.h>

/**
 * A single mountpoint.
 * Instances are created by MountPointList.
 *
 * @author Robin Doer
 */
class MountPoint{
public:
  MountPoint();
  MountPoint(const QString& rawData);
  MountPoint(const MountPoint& mp);

  /**
   * Source-device.
   */
  QString device() const;

  /**
   * Folder, where device is mounted.
   */
  QString mountPoint() const;

  /**
   * The filesystem.
   */
  QString fsType() const;

  /**
   * List with mount-options.
   */
  QStringList options() const;

  void operator = (const MountPoint& mp);

private:
  void copy(const MountPoint& mp);

private:
  QString m_device;
  QString m_mountPoint;
  QString m_fsType;
  QStringList m_options;
};

#endif  // MOUNTPOINT_H
