// $Id: mountpointlist.cpp,v 1.1.1.1 2006/01/26 17:09:46 robin_d Exp $

/***************************************************************************
 *   Copyright (C) 2006 by Robin Doer                                      *
 *   robin@robind.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "mountpointlist.h"
#include "psptimer.h"

#include <kdebug.h>

#include <qfile.h>
#include <qfileinfo.h>

/* MountPointList::MountPointList ******************************************/
MountPointList::MountPointList(QObject* parent, const char* name)
  : QObject(parent, name) {

  m_timer = new PSPTimer(this);
  scan(); // Initially build up mountpoint-list

  m_timer->start(); // Start the timer
}

/* MountPointList::~MountPointList *****************************************/
MountPointList::~MountPointList() {
  delete m_timer;
}

/* MountPointList::scan ****************************************************/
void MountPointList::scan() {
  QFileInfo fi("/etc/mtab");
  if (fi.lastModified() > m_lastModified) {
    // mtab has changed, rebuild list

    kdDebug(7002) << "MountPointList: Scanning mountpoints..." << endl;
    clear();
    QFile file("/etc/mtab");

    if (file.open(IO_ReadOnly)) {
      QTextStream stream(&file);
      while (!stream.atEnd()) {
        QString line = stream.readLine();
        MountPoint mp(line);
        append(mp);
      }
      file.close();
    }

    emit(changed());

    m_lastModified = fi.lastModified();
  }
}
