// $Id: mountpointlist.h,v 1.1.1.1 2006/01/26 17:09:46 robin_d Exp $

/***************************************************************************
 *   Copyright (C) 2006 by Robin Doer                                      *
 *   robin@robind.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef MOUNTPOINTLIST_H
#define MOUNTPOINTLIST_H

#include "mountpoint.h"

#include <qobject.h>
#include <qdatetime.h>

class PSPTimer;

/**
 * A list of all available mount-points. Whenever new mounts are available,
 * the list is updated automatically and changed() is emitted.
 *
 * @author Robin Doer
 */
class MountPointList : public QObject,
                       public QValueList<MountPoint> {
  Q_OBJECT

public:
  /**
   * Constructs a new list.
   */
  MountPointList(QObject* parent = 0, const char* name = 0);

  /**
   * D'tor.
   */
  virtual ~MountPointList();

  friend class PSPTimer;

signals:
  /**
   * Is emitted when list of mountpoints has changed.
   */
  void changed();

private:
  /**
   * Scans all mountpoints and builds up (if necessary) a new list.
   */
  void scan();

private:
  /**
   * My own timer. Calls scan() every 5 seconds.
   * @NOTE: AWFUL
   */
  PSPTimer* m_timer;

  /**
   * Timestamp of /etc/mtab. Use to determine if mtab has changed.
   */
  QDateTime m_lastModified;
};

#endif
