// $Id: pspprotocol.h,v 1.1.1.1 2006/01/26 17:09:45 robin_d Exp $

/***************************************************************************
 *   Copyright (C) 2006 by Robin Doer   *
 *   robin@robind.de   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PSPPROTOCOL_H
#define PSPPROTOCOL_H

#include <kio/slavebase.h>

class MountPointList;

/**
 * KIO::SlaveBase-implementation for protocol "psp".

 * @author Robin Doer
 */
class PSPProtocol : public QObject,
                    public KIO::SlaveBase {
  Q_OBJECT

public:
  PSPProtocol(const QCString& pool, const QCString& app);
  virtual ~PSPProtocol();

  void get(const KURL& url);
  void put(const KURL& url, int permissions, bool overwrite, bool resume);
  void del(const KURL& url, bool isFile);
  void rename(const KURL& src, const KURL& dest, bool overwrite);
  void mkdir(const KURL& url, int permissions);
  void listDir(const KURL& url);
  void stat(const KURL& url);

  /**
   * Returns the mountpoint of the PSP. Might be empty (not mounted).
   */
  QString mountPoint() const;

private slots:
  void scanForMountPoint();

private:
  /**
   * Mount-flag. <i>true</i>, if already mounted.
   */
  bool m_isMounted;

  /**
   * The mountpoint of the PSP
   */
  QString m_mountPoint;

  /**
   * Liste of mountpoints
   */
  MountPointList* m_mountPointList;

  //MountPointObserver* m_observer;
};

#endif // PSPPROTOCOL_H
