#!/usr/bin/env python
#
# Kirocker Music Display startup script for Amarok
# Copyright (c) 2007 Sebastien Laout <slaout@linux62.org>
#
# This scrip originates from "AmarokFS startup script for Amarok"
# Copyright (c) 2007 Martin Kossler <martin.kossler@students.uni-marburg.de>
#
#############################################################################
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#############################################################################

from commands import getoutput
from os import system, getenv
from signal import signal
from sys import exit, stdin

def main():
	""" Main application loop """
	# Test Amarok DCOP connection
	if system('dcop amarok'):
		print 'This script is meant to be called from within Amarok.\n'
		exit(1)
	
	if system('dcop amarok script addCustomMenuItem "kirocker" "Kirocker Music Display"'):
		system('kdialog --error "Could not create \'Kirocker Music Display\' menu entries."')
		exit(1)
	
	while 1:
		# Read notifications
		notification = stdin.readline()
		
		if notification != '':
			if 'customMenuClicked' in notification:
				if 'kirocker' in notification:
					system('kirocker')
					#if (system('kirocker')) != 0:
					#	system('dcop amarok playlist popupMessage "There was an error launching Kirocker Music Display.\nPlease check your installation and configuration."')
					#	stopScript(None, None)
					#	exit(1)
			elif 'configure' in notification:
				system('dcop amarok playlist popupMessage "This script does not require any configuration."')
		else:
			exit(0)

def stopScript(signum, stackframe):
	""" Executed when script is stopped by the user """
	system('dcop amarok script removeCustomMenuItem "kirocker" "Kirocker Music Display"')


def forceStop(signum, stackframe):
	""" Handler to stop the script when Amarok crashes """
	exit(1)

if __name__ == "__main__":
	signal(6, stopScript)
	signal(15, stopScript)
	main()
