/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "amarokapi.h"
#include "dcopinterface.h"

#include <qcstring.h>

void AmarokApi::enableScreenSaver(bool enable)
{
	DcopInterface::send("kdesktop", "KScreensaverIface", "enable(bool)", enable);
}

void AmarokApi::enableOSD(bool enable)
{
	DcopInterface::send("amarok", "player", "enableOSD(bool)", enable);
}

void AmarokApi::setRating(int rating)
{
	DcopInterface::send("amarok", "player", "setRating(int)", rating);
}

void AmarokApi::volumeUp()
{
	DcopInterface::send("amarok", "player", "volumeUp()");
}

void AmarokApi::volumeDown()
{
	DcopInterface::send("amarok", "player", "volumeDown()");
}

bool AmarokApi::screenSaverEnabled()
{
	return DcopInterface::getBool("kdesktop", "KScreensaverIface", "isEnabled()", (bool *) 0);
}

bool AmarokApi::osdEnabled()
{
	return DcopInterface::getBool("amarok", "player", "osdEnabled()", (bool *) 0);
}

bool AmarokApi::playPause()
{
	return DcopInterface::call("amarok", "player", "playPause()");
}

void AmarokApi::stop()
{
	DcopInterface::send("amarok", "player", "stop()");
}

void AmarokApi::previousTrack()
{
	DcopInterface::send("amarok", "player", "prev()");
}

void AmarokApi::nextTrack()
{
	DcopInterface::send("amarok", "player", "next()");
}

void AmarokApi::seek(int position)
{
	DcopInterface::send("amarok", "player", "seek(int)", position);
}

void AmarokApi::seekRelative(int deltaSeconds)
{
	DcopInterface::send("amarok", "player", "seekRelative(int)", deltaSeconds);
}
