/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "applet.h"

#include <kglobal.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <kwin.h>

#include "applet.h"
#include "coverdisplay.h"
#include "fullscreen.h"
#include "thememanager.h"
//#include "testdisplay.h"

Applet::Applet(const QString &configFile, Type type, int actions, QWidget *parent, const char *name)
 : DCOPObject("Kirocker"), KPanelApplet(configFile, type, actions, parent, name)
{
	m_config = config();

	m_coverDisplay = new CoverDisplay(this, this);
	m_coverDisplay->show();

	m_fullScreen = 0;

	connect( m_coverDisplay, SIGNAL(updateLayout()),    this, SIGNAL(updateLayout()) );
	connect( m_coverDisplay, SIGNAL(fullScreenAsked()), this, SLOT(showFullScreen()) );

	connect( &m_desktop,     SIGNAL(resized(int)),      this, SLOT(screenResized())  );
}

Applet::~Applet()
{
}

void Applet::about()
{
	KMessageBox::information(0, "<b>" +
		i18n("Kirocker Music Display") + "</b><br>" +
		i18n("Display cover and information about the currently played music"));
}

void Applet::help()
{
}

void Applet::preferences()
{
}

int Applet::widthForHeight(int height) const
{
	return m_coverDisplay->widthForHeight(height);
}

int Applet::heightForWidth(int width) const
{
	return m_coverDisplay->heightForWidth(width);
}

void Applet::resizeEvent(QResizeEvent *event)
{
	m_coverDisplay->resize(size());

	KPanelApplet::resizeEvent(event);
}

void Applet::showFullScreen()
{
	static QSize oldDesktopSize;
	QSize currentDesktopSize = m_desktop.screenGeometry(m_fullScreen).size();

	// Create a new FullScreen widget if it is the first time it is requested, or if the screen size changed since the last time:
	if (m_fullScreen == 0 || currentDesktopSize != oldDesktopSize) {
		delete m_fullScreen;
		m_fullScreen = new FullScreen();
		watchForFocus(m_fullScreen, /*watch=*/true);
		oldDesktopSize = currentDesktopSize;
	}

	m_fullScreen->update();
	m_fullScreen->setWindowState(m_fullScreen->windowState() & ~Qt::WindowFullScreen);
	m_fullScreen->setWindowState((m_fullScreen->windowState() & ~Qt::WindowMinimized) | Qt::WindowActive | Qt::WindowFullScreen);
	m_fullScreen->show();
	m_fullScreen->setFocus();
	KWin::forceActiveWindow(m_fullScreen->winId());
}

void Applet::loadNewThemesAndSetCurrent(const QString &currentThemeFolderName)
{
	ThemeManager *manager = ThemeManager::instance();
	manager->loadThemeList();
	manager->setTheme(manager->forName(currentThemeFolderName));
}

void Applet::screenResized()
{
	if (m_fullScreen->isShown())
		showFullScreen(); // It will be resized
}

KPanelApplet::Direction Applet::popupDirection()
{
	return KPanelApplet::popupDirection();
}

extern "C"
{
	KPanelApplet* init(QWidget *parent, const QString &configFile)
	{
		KGlobal::locale()->insertCatalogue("kirocker");
//		(new TestDisplay())->show();
		return new Applet(configFile, KPanelApplet::Stretch,
		                  KPanelApplet::About/* | KPanelApplet::Help | KPanelApplet::Preferences*/,
		                  parent, "kirocker");
	}
}

#include "applet.moc"
