/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef COVERDISPLAY_H
#define COVERDISPLAY_H

#include <kdeversion.h> // Detect KDE 3.5

#include <qstringlist.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qtimer.h>
#include <qfont.h>
#include <qpalette.h>
#include <qsimplerichtext.h>
#include <qmap.h>

#include "showanimator.h"
#include "framemanager.h"

#if KDE_IS_VERSION( 3, 5, 0 )
#include "kickertip.h"
#endif

class ProgressBar;
class PlayerInformation;
class TaskBarWatcher;

class Applet;

class QTextBrowser;

// MOC does not care about pre-processing directives: it thinks CoverDisplay ALWAYS inherits KickerTip::Client
#if KDE_IS_VERSION( 3, 5, 0 )
#else
namespace KickerTip
{
	class Client
	{
	};
}
#endif

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class CoverDisplay : public QWidget
#if KDE_IS_VERSION( 3, 5, 0 )
, public KickerTip::Client
#endif
{
  Q_OBJECT
  public:
	CoverDisplay(QWidget *parent, Applet *applet = 0);
	~CoverDisplay();

	int heightForWidth(int width);
	int widthForHeight(int height);
	void setFullScreen();

#if KDE_IS_VERSION( 3, 5, 0 )
	void updateKickerTip(KickerTip::Data &data);
#endif

  signals:
	void updateLayout();
	void fullScreenAsked();
	void closeAsked();
  protected:
	QPixmap getAmarokImage(const QString &imageName);
	void loadButtonImages(QImage icons[3], const QString &iconName, const QString &fallbackIconName, int width);
	void mouseMoveEvent(QMouseEvent *event);
	void enterEvent(QEvent *event);
	void leaveEvent(QEvent *event);
	void mousePressEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
	void wheelEvent(QWheelEvent *event);
	void paintEvent(QPaintEvent *event);
	void hideEvent(QHideEvent *event);
//	bool close(bool alsoDelete);
	void resizeEvent(QResizeEvent *event);
	void setPalette(const QPalette &palette);
	void updateProgressBar();
	void computeButtonRects(int size);
	bool areControlsShown();
	void initPixmaps();
	bool eventFilter(QObject *object, QEvent *event);
	QString informationText(int numberOfLines);
	void computeTextColor();
	int progressHeightForSize(int size);
	void fontChange(const QFont &oldFont);

	void makeShadow(const QPixmap &textPixmap, QPixmap &resultPixmap, const QColor &shadowColor, bool blured);
	void drawShadowedText(QPainter *painter, const QRect &rect, int flags, const QString &text, const QColor &textColor, const QColor &shadowColor, bool blured);
	void drawShadowedRichText(QPainter *painter, const QRect &rect, QSimpleRichText *richText, const QString &source, const QColor &textColor, const QColor &shadowColor, bool blured);
	void drawIcon(QPainter &painter, const QImage &iconImage, int x, int y, const QPixmap &buffer, int bufferX, int bufferY, int percentVisible);
	void drawFrames(QPainter *painter, Frame::ShapeDrawingPhase phase, const QRect &clipRect);

	int coverDelta();
	int oldCoverDelta();

	int taskBarFlickerCount();

	const QPixmap* backgroundPixmap();

  public:
	static bool focusCoverOnDialogDisappearing;

  public slots:
	void hideControls(/*bool update = true*/);
	void setBlankCursor();
	void dialogAppeared();
	void dialogDisappeared();
	void toggleLyrics();
	void scrollLyricsUp();
	void scrollLyricsDown();
  protected slots:
	void setPosition(int i);

	void updateCover();
	void updateStars();
	void updateButtons();
	void updateText();
	void updateProgressDraw();
	void updateNextPlaying();
	void updateClock();
	void updateTaskBar();

	void updateContentFrames();

	void newInformation();
	void newRating();
	void newProgress();
	void newLyrics();

	void themeChanged();

	void taskBarChanged();
	void flickerTaskBar();

	void newClockInformation();
	void initClock();

	void lyricsMoving(int x, int y);

  private:
	bool m_underMouse;

	PlayerInformation *m_infos;

	bool m_progressBarOnLeft;
	bool m_withReflexion;

	QTimer  m_fullScreenTimer;
	int     m_hoveredStar;

	QPixmap m_coverScalledPixmap;
	QPixmap m_coverScalledReflexionPixmap;

	QImage  m_starIcon;
	QImage  m_miniStarIcon;
	QImage  m_hoveredStarIcon;
	QImage  m_hoveredMiniStarIcon;
	QImage  m_hoveredEmptyStarIcon;
	QImage  m_hoveredHoveredEmptyStarIcon;

	QImage  m_starReflexionIcon;
	QImage  m_miniStarReflexionIcon;
	QImage  m_hoveredStarReflexionIcon;
	QImage  m_hoveredMiniStarReflexionIcon;
	QImage  m_hoveredEmptyStarReflexionIcon;
	QImage  m_hoveredHoveredEmptyStarReflexionIcon;

	QImage m_prevIcon[3];
	QImage m_nextIcon[3];
	QImage m_playIcon[3];
	QImage m_pauseIcon[3];
	QImage m_stopIcon[3];
	QImage m_fullIcon[3];
	QImage m_closeIcon[3];
	QImage m_themeIcon[3];
	QImage m_lyricsIcon[3];

	QRect m_prevRect;
	QRect m_nextRect;
	QRect m_playRect; // Also the pause rect
	QRect m_fullRect;
	QRect m_closeRect;
	QRect m_themeRect;
	QRect m_lyricsRect;
	QRect m_nextPlayingRect;
	QRect m_clockRect;
	QRect m_taskBarRect;

	QRect m_frameRects[Frame::SHAPE_COUNT];

	int m_hoveredButton;
	int m_clickedButton;

	int m_hoveredTaskBarEntry;
	int m_taskBarEntryWidth;
	QMap<WId, int> m_taskBarFlickerings;
	QTimer m_taskBarFlickerTimer;

	QFont m_textFont;
	QColor m_textColor;

	enum Orientation { Vertical, Horizontal, FullScreen };
//	bool isFullScreenDisplay();

	Orientation m_orientation;
	int         m_margin;
	int         m_progressMargin;
	int         m_buttonPadding;
	int         m_reflectionDistance;
	int         m_starWidth;
	QRect       m_progressRect;
	QRect       m_coverRect;
	QRect       m_starsRect;
	QRect       m_textRect;

	ShowAnimator m_buttonsAnimator;
	ShowAnimator m_playPauseAnimator;

	ProgressBar *m_progressBar;

	QTextBrowser *m_lyrics;
	int           m_lyricsZoom;
	int           m_lyricsOffset;
	bool          m_ignoreNextLyricsMove;

	ShowAnimator m_trackAnimator;
	bool         m_reverseTrackAnimation;
	int          m_oldStatus;
	QPixmap      m_oldCoverScalledPixmap;
	QPixmap      m_oldCoverReflexionPixmap;
	QString      m_oldText;
	int          m_oldRating;
	int          m_oldDuration;
	int          m_oldPosition;
	QString      m_oldLeftText;
	QString      m_oldRightText;

	QString      m_timesString;

	Applet      *m_applet;

	QSimpleRichText *m_nextPlayingRichText;
	QString          m_nextPlayingRichTextSource;

	TaskBarWatcher *m_taskBarWatcher;

	QSimpleRichText *m_clockRichText;
	QString          m_clockRichTextSource;
	bool             m_clockInitialized;
	QTimer           m_clockTimer;
  private slots:
	void beforeAnimateTrack(int nextStatus, bool isPrevious);
};

#endif // COVERDISPLAY_H
