/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "dcopinterface.h"

#include <qstring.h>
#include <qcstring.h>
#include <qstringlist.h>
#include <kapplication.h>
#include <dcopclient.h>

const int NO_TIMEOUT = -1;
const int DCOP_TIMEOUT = 100;

bool DcopInterface::isApplicationRegistered(const QCString &application)
{
	return kapp->dcopClient()->isApplicationRegistered(application);
}

// Sending Methods:

bool DcopInterface::call(const char *application, const char *object, const char *function)
{
	QByteArray data, replyData;
	QCString replyType;
	return kapp->dcopClient()->call(application, object, function, data, replyType, replyData, /*useEventLoop=*/false, NO_TIMEOUT);
}

void DcopInterface::send(const char *application, const char *object, const char *function)
{
	QByteArray data;
	if (!kapp->dcopClient()->send(application, object, function, data))
		;//qDebug( (QString("Error sending ") + application + "::" + object + "." + function).ascii() );
}

void DcopInterface::send(const char *application, const char *object, const char *function, int integer)
{
	QByteArray data;
	QDataStream arg(data, IO_WriteOnly);
	arg << integer;
	if (!kapp->dcopClient()->send(application, object, function, data))
		;//qDebug( (QString("Error sending ") + application + "::" + object + "." + function).ascii() );
}

void DcopInterface::send(const char *application, const char *object, const char *function, bool boolean)
{
	QByteArray data;
	QDataStream arg(data, IO_WriteOnly);
	arg << boolean;
	if (!kapp->dcopClient()->send(application, object, function, data))
		;//qDebug( (QString("Error sending ") + application + "::" + object + "." + function).ascii() );
}

// Receving Methods:

QString DcopInterface::getString(const QCString &application, const QCString &object, const QCString &function, bool *outSuccess)
{
	QByteArray data, replyData;
	QCString replyType;

	QString result;
	bool success = kapp->dcopClient()->call(application, object, function, data, replyType, replyData, /*useEventLoop=*/false, (outSuccess ? DCOP_TIMEOUT : NO_TIMEOUT));

	if (success &&replyType == "QString") {
		QDataStream reply(replyData, IO_ReadOnly);
		reply >> result;
	} else if (outSuccess)
		*outSuccess = false;//qDebug( QString("Error calling " + application + "::" + object + "." + function).ascii() );

	return result;
}

bool DcopInterface::getBool(const QCString &application, const QCString &object, const QCString &function, bool *outSuccess)
{
	QByteArray data, replyData;
	QCString replyType;

	bool result = false;
	bool success = kapp->dcopClient()->call(application, object, function, data, replyType, replyData, /*useEventLoop=*/false, (outSuccess ? DCOP_TIMEOUT : NO_TIMEOUT));

	if (success && replyType == "bool") {
		QDataStream reply(replyData, IO_ReadOnly);
		reply >> result;
	} else if (outSuccess)
		*outSuccess = false;//qDebug( QString("Error calling " + application + "::" + object + "." + function).ascii() );

	return result;
}

int DcopInterface::getInt(const QCString &application, const QCString &object, const QCString &function, bool *outSuccess)
{
	QByteArray data, replyData;
	QCString replyType;

	int result = 0;
	bool success = kapp->dcopClient()->call(application, object, function, data, replyType, replyData, /*useEventLoop=*/false, (outSuccess ? DCOP_TIMEOUT : NO_TIMEOUT));

	if (success && replyType == "int") {
		QDataStream reply(replyData, IO_ReadOnly);
		reply >> result;
	} else if (outSuccess)
		*outSuccess = false;//qDebug( QString("Error calling " + application + "::" + object + "." + function).ascii() );

	return result;
}

QStringList DcopInterface::getStringList(const QCString &application, const QCString &object, const QCString &function, const QString &query, bool *outSuccess)
{
	QByteArray data, replyData;
	QCString replyType;
	QDataStream arg(data, IO_WriteOnly);
	arg << query;

	QStringList result;
	bool success = kapp->dcopClient()->call(application, object, function, data, replyType, replyData, /*useEventLoop=*/false, (outSuccess ? DCOP_TIMEOUT : NO_TIMEOUT));

	if (success && replyType == "QStringList") {
		QDataStream reply(replyData, IO_ReadOnly);
		reply >> result;
	} else if (outSuccess)
		*outSuccess = false;//qDebug( QString("Error calling " + application + "::" + object + "." + function).ascii() );

	return result;
}
