/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FULLSCREEN_H
#define FULLSCREEN_H

#include <qwidget.h>
#include <qtimer.h>

class CoverDisplay;

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class FullScreen : public QWidget
{
  Q_OBJECT
  public:
	FullScreen(QWidget *parent = 0, const char *name = 0);
	~FullScreen();
  protected:
	virtual void keyPressEvent(QKeyEvent *event);
	virtual void windowActivationChange(bool oldActive);
	virtual void contextMenuEvent(QContextMenuEvent *event);
	void clickStar(int star);
	void showKeysInformation();
  private:
	CoverDisplay *m_coverDisplay;

	// Needed to stop Auto Screen Turn Off (energy economy):
	bool          m_haveKWin;
	bool          m_haveXTest;
	QTimer        m_screensaverTimer;
	int           m_fakeKeycode;
  private slots:
	void slotFakeKeyEvent();
};

#endif // FULLSCREEN_H
