/***************************************************************************
 *   Copyright (C) 2003 by S�bastien Lao�t                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "helplink.h"

#include <qwhatsthis.h>

/** class HelpLink: */

HelpLink::HelpLink(QWidget *parent, const char *name)
 : KURLLabel(parent, name)
{
	connect( this, SIGNAL(leftClickedURL()), this, SLOT(showMessage()) );
}

HelpLink::HelpLink(const QString &text, const QString &message, QWidget *parent)
 : KURLLabel(parent), m_message(message)
{
	setText(text);
	connect( this, SIGNAL(leftClickedURL()), this, SLOT(showMessage()) );
}

HelpLink::~HelpLink()
{
}

void HelpLink::showMessage()
{
	QWhatsThis::display(m_message, mapToGlobal( QPoint(width() / 2, height()) ));
}

void HelpLink::keyPressEvent(QKeyEvent *event)
{
	if (event->key() == Qt::Key_Space)
		showMessage();
	else
		KURLLabel::keyPressEvent(event);
}

#include "helplink.moc"
