/***************************************************************************
 *   Copyright (C) 2003 by S�bastien Lao�t                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef HELPLINK_H
#define HELPLINK_H

#include <kurllabel.h>
#include <qstring.h>

/** A label displaying a link that, once clicked, offer a What's This messageBox to help users.
  * @author Sébastien Laoût
  */
class HelpLink : public KURLLabel
{
  Q_OBJECT
  public:
	HelpLink(QWidget *parent = 0, const char *name = 0);
	HelpLink(const QString &text, const QString &message, QWidget *parent);
	~HelpLink();
	QString message()                       { return m_message;    }
  public slots:
	void setMessage(const QString &message) { m_message = message; } // setText() already exist
	void showMessage();
  protected:
	void keyPressEvent(QKeyEvent *event);
  private:
	QString m_message;
};

#endif // HELPLINK_H
