/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef INFORMATIONPOLLER_H
#define INFORMATIONPOLLER_H

//#include <qthread.h>
#include <qobject.h>
#include <qstring.h>

class QTimer;

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
//class InformationPoller : public QThread
class InformationPoller : public QObject
{
//
  Q_OBJECT
  public:
	InformationPoller();
	~InformationPoller();
	virtual void run();
	void suspendPolling();
	void resumePolling();
//  private:
  private slots:
	void poll();
	void retreiveNewCover(const QString &artist, const QString &album, bool *success);
	void retreiveNewLastFmCover();
	void failed();
	void tryGetLyrics();
  private:
	QString bigNoCoverPath();
	QString retreiveNextPlaying(bool isLastFm, bool isStream, bool *success);
	int m_failureCounter;
	QTimer *m_refreshTimer;
  public:
	static const int NEW_INFO_EVENT;
	static const int NEW_RATING_EVENT;
	static const int NEW_PROGRESS_EVENT;
	static const int NEW_LYRICS;
};

#endif // INFORMATIONPOLLER_H
