/***************************************************************************
 *   Copyright (C) 2003 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
 #include <config.h>
#endif

#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <dcopclient.h>
#include <krun.h>
#include <kwin.h>
#include <qfile.h>
#include <kmessagebox.h>

#include "fullscreen.h"
#include "thememanager.h"

int main(int argc, char *argv[])
{
	const char description[] =
		I18N_NOOP("Display cover and information about the currently played music");
	KCmdLineOptions options[] = {
		{ "+[file]", I18N_NOOP("Import theme archive"), 0 },
		KCmdLineLastOption
	};

	KAboutData about("kirocker", I18N_NOOP("Kirocker Music Display"), VERSION, description,
	                 KAboutData::License_GPL, "(C) 2007 Sébastien Laoût", 0, 0, "slaout@linus62.org");
	about.addAuthor("Sébastien Laoût", 0, "slaout@linux62.org");

	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(options);
	//KUniqueApplication::addCmdLineOptions();
	KUniqueApplication app;

	const int NO_TIMOUT = -1;
	QByteArray data;
	QCString foundApp;
	QCString foundObj;

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	if (args && args->count() >= 1) {
		QString fileName = QFile::decodeName(args->arg(args->count() - 1));
		if (QFile::exists(fileName)) {
			ThemeManager::instance()->loadThemeList(); // Load old ones, before adding the new theme
			Theme *theme = ThemeManager::instance()->import(fileName);
			if (theme)
				ThemeManager::instance()->setTheme(theme);
			if (kapp->dcopClient()->findObject("kicker", "Kirocker", ""/*"showFullScreen"*/, data, foundApp, foundObj, /*useEventLoop=*/false, NO_TIMOUT))
				KRun::runCommand("dcop kicker Kirocker loadNewThemesAndSetCurrent \"" + theme->folderName() + "\"");
		}
	}

	if (kapp->dcopClient()->findObject("kicker", "Kirocker", ""/*"showFullScreen"*/, data, foundApp, foundObj, /*useEventLoop=*/false, NO_TIMOUT)) {

		// These calls don't work (they don't work without an event loop, I suppose):

// 		QByteArray data;
// 		return kapp->dcopClient()->send("kicker", "Kirocker", "showFullScreen", data);//, replyType, replyData, /*useEventLoop=*/false, NO_TIMOUT);
// 		//return app.exec();

//		QByteArray data, replyData;
//		QCString replyType;
//		return kapp->dcopClient()->call("kicker", "Kirocker", "showFullScreen", data, replyType, replyData, /*useEventLoop=*/true, NO_TIMOUT);

		KRun::runCommand("dcop kicker Kirocker showFullScreen");
		return 0;
	} else {
		FullScreen *m_fullScreen = new FullScreen();
		m_fullScreen->update();
		m_fullScreen->setWindowState(m_fullScreen->windowState() & ~Qt::WindowFullScreen);
		m_fullScreen->setWindowState((m_fullScreen->windowState() & ~Qt::WindowMinimized) | Qt::WindowActive | Qt::WindowFullScreen);
		m_fullScreen->show();
		m_fullScreen->setFocus();
		KWin::forceActiveWindow(m_fullScreen->winId());

		app.setMainWidget(m_fullScreen);

		return app.exec();
	}
}
