/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "playerinformation.h"
#include "informationpoller.h"
#include "amarokapi.h"

PlayerInformation *PlayerInformation::s_instance = 0;

PlayerInformation::PlayerInformation()
 : m_status(Stopped), m_url(), m_artist(), m_album(), m_year(), m_track(), m_title(),
   m_coverPixmap(), m_rating(0), m_duration(0), m_position(0), m_lyrics(), m_nextPlaying()
{
//	InformationPoller *poller = new InformationPoller();
//	poller->start();
	m_poller = new InformationPoller();
}

PlayerInformation::~PlayerInformation()
{
}

PlayerInformation *PlayerInformation::instance()
{
	if (s_instance == 0)
		s_instance = new PlayerInformation();
	return s_instance;
}

void PlayerInformation::customEvent(QCustomEvent *event)
{
	if (event->type() == InformationPoller::NEW_INFO_EVENT)
		emit newInformation();
	else if (event->type() == InformationPoller::NEW_RATING_EVENT)
		emit newRating();
	else if (event->type() == InformationPoller::NEW_PROGRESS_EVENT)
		emit newProgress();
	else if (event->type() == InformationPoller::NEW_LYRICS)
		emit newLyrics();
}

void PlayerInformation::changeRating(int rating)
{
	AmarokApi::setRating(rating);
	// Update the GUI now to not have percevied slowness:
	setRating(rating);
	emit newRating();
}

void PlayerInformation::changePosition(int position)
{
	AmarokApi::seek(position);
	// Update the counter, so that another mouse scroll before "Amarok seek, and a few milliseconds layer
	// the PlayerInformation get the new position" to be able to scroll further instead of always seeking
	// to the same position (current position not changed, + 10 seconds) :
	setPosition(position);
	emit newProgress();
}

void PlayerInformation::seekRelative(int deltaSeconds)
{
	// Call Amarok soon, for it to be as fast as possible:
	AmarokApi::seekRelative(deltaSeconds);
	// Update the GUI now to not have percevied slowness:
	m_position += deltaSeconds;
	if (m_position < 0)
		m_position = 0;
	if (m_position >= m_duration)
		m_position = m_duration;
	emit newProgress();
}

void PlayerInformation::emitAboutToChangeTrack(int nextStatus, bool isPrevious)
{
	emit aboutToChangeTrack(nextStatus, isPrevious);
}

void PlayerInformation::suspendPolling()
{
	m_poller->suspendPolling();
}

void PlayerInformation::resumePolling()
{
	m_poller->resumePolling();
}

bool PlayerInformation::isPrevious(const KURL &url)
{
	KURL currentUrl = (m_urls.size() > 0 ? m_urls[m_urls.size() - 1] : "");
	return (!url.isEmpty() && m_urls.contains(url) && url != currentUrl) || // "" or equal to currentPath if paused
	       (url == currentUrl && !isPlaying() && m_urls.size() > 0 && !url.isEmpty()); // Was paused
}

bool PlayerInformation::isLastFm()
{
	return m_url.protocol() == "lastfm";
}

bool PlayerInformation::isStream()
{
	return m_url.protocol() == "lastfm";
}

bool PlayerInformation::canPause()
{
	return !isLastFm();
}

bool PlayerInformation::canSeek()
{
	return !isLastFm() && !isStream() && duration() > 0;
}

void PlayerInformation::setUrl(const KURL &url)
{
	m_url = url;

	if (url.isEmpty()) // Stop!
		m_urls.clear();
	else {
		for (QValueList<KURL>::iterator it = m_urls.find(url); it != m_urls.end(); )
			it = m_urls.remove(it);

		m_urls.append(url);
		if (m_urls.size() > 10)
			m_urls.remove(m_urls.begin());
	}
}

#include "playerinformation.moc"
