/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PLAYERINFORMATION_H
#define PLAYERINFORMATION_H

#include <qobject.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qvaluelist.h>
#include <kurl.h>

class QCustomEvent;

class InformationPoller;

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class PlayerInformation : public QObject
{
  Q_OBJECT
  public:
	static PlayerInformation *instance();

	enum Status { Stopped = 0, Paused = 1, Playing = 2 };

	Status  status()      { return m_status;            }
	bool    isPlaying()   { return m_status == Playing; }
	KURL    url()         { return m_url;               }
	QString artist()      { return m_artist;            }
	QString album()       { return m_album;             }
	QString year()        { return m_year;              }
	QString track()       { return m_track;             }
	QString title()       { return m_title;             }
	QPixmap coverPixmap() { return m_coverPixmap;       }
	int     rating()      { return m_rating;            }
	int     duration()    { return m_duration;          }
	int     position()    { return m_position;          }
	QString lyrics()      { return m_lyrics;            }
	QString nextPlaying() { return m_nextPlaying;       }

	void changeRating(int rating);
	void changePosition(int position);
	void seekRelative(int deltaSeconds);

	bool isLastFm();
	bool isStream();
	bool canPause();
	bool canSeek();

  public slots:
	void suspendPolling();
	void resumePolling();
  private:
	InformationPoller *m_poller;

  protected:
	friend class InformationPoller;
	friend class FullScreen;
	void setStatus(Status status)                   { m_status      = status;      }
	void setUrl(const KURL &url);
	void setArtist(const QString &artist)           { m_artist      = artist;      }
	void setAlbum(const QString &album)             { m_album       = album;       }
	void setYear(const QString &year)               { m_year        = year;        }
	void setTrack(const QString &track)             { m_track       = track;       }
	void setTitle(const QString &title)             { m_title       = title;       }
	void setCoverPixmap(const QPixmap &coverPixmap) { m_coverPixmap = coverPixmap; }
	void setRating(int rating)                      { m_rating      = rating;      }
	void setDuration(int duration)                  { m_duration    = duration;    }
	void setPosition(int position)                  { m_position    = position;    }
	void setLyrics(const QString &lyrics)           { m_lyrics      = lyrics;      }
	void setNextPlaying(const QString &nextPlaying) { m_nextPlaying = nextPlaying; }

	bool isPrevious(const KURL &url);

  signals:
	void newInformation();
	void newRating();
	void newProgress();
	void newLyrics();
	void aboutToChangeTrack(int nextStatus, bool isPrevious);
  protected: // An hack for InformationPoller
	void emitAboutToChangeTrack(int nextStatus, bool isPrevious);

  public:
	~PlayerInformation();
  public:
	void customEvent(QCustomEvent *event);
  private:
	PlayerInformation();

	static PlayerInformation *s_instance;

	Status  m_status;
	KURL    m_url;
	QString m_artist;
	QString m_album;
	QString m_year;
	QString m_track;
	QString m_title;
	QPixmap m_coverPixmap;
	int     m_rating;
	int     m_duration;
	int     m_position;
	QString m_lyrics;
	QString m_nextPlaying;

	QValueList<KURL> m_urls;
};

#endif // PLAYERINFORMATION_H
