/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef PROGRESSBAR_H
#define PROGRESSBAR_H

#include <qwidget.h>
#include <qpixmap.h>
#include <qtimer.h>

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class ProgressBar : public QWidget
{
  Q_OBJECT
  public:
	ProgressBar(QWidget *parent = 0, const char *name = 0);
	~ProgressBar();
	void setTotal(int total);
	void setCurrent(int current);
	void setLeftText(const QString &leftText);
	void setRightText(const QString &rightText);
	void setTextFlickering(bool flicker);
	void removeHighlighting();
	QPixmap progressPixmap(bool underMouse, int total, int current, const QString &leftText, const QString &rightText);
	bool underMouse();
	QString leftText();
	QString rightText();
	bool textFlickering();
	void setColors(const QColor &background, const QColor &bar, const QColor &backgroundText, const QColor &barText);

  signals:
	void changePosition(int position);
  private slots:
	void flickerText();
  protected:
	void paintEvent(QPaintEvent *event);
	void mousePressEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
	void mouseMoveEvent(QMouseEvent *event);
	void enterEvent(QEvent *event);
	void leaveEvent(QEvent *event);
	void changePosition(QMouseEvent *event);
	void drawGlowingGradient(QPainter &painter, const QRect &rect, QColor color);
  private:
	int m_total;
	int m_current;
	QString m_leftText;
	QString m_rightText;
	bool m_underMouse;
	bool m_mousePressed;
	bool m_textFlickering;
	bool m_textShown;
	QTimer m_textFlickeringTimer;

	QColor m_backgroundColor;
	QColor m_barColor;
	QColor m_backgroundTextColor;
	QColor m_barTextColor;
};

#endif // PROGRESSBAR_H
