/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef SHOWANIMATOR_H
#define SHOWANIMATOR_H

#include <qobject.h>
#include <qtimer.h>

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class ShowAnimator : public QObject
{
  Q_OBJECT
  public:
	enum State { NotRunning, MoveForward, MoveBackward };

	ShowAnimator(int duration);
	~ShowAnimator();
	void setRange(int begin, int end);
	void toBegin();
	void toEnd();
	int value();
	State state();
	void setValueAndState(int value, State state);
	bool isInIntermediateState();
	bool atBegin();
	bool atEnd();
  signals:
	void beforeNewValue();
	void newValue(int value);
  private slots:
	void timeout();
  private:
	QTimer m_timer;
	int    m_duration;
	int    m_begin;
	int    m_end;
	State  m_state;
	int    m_value;
};

#endif // SHOWANIMATOR_H
