/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TASKBARWATCHER_H
#define TASKBARWATCHER_H

#include <qobject.h>
#include <qvaluelist.h>
#include <kwinmodule.h>
#include <qpixmap.h>

class TaskBarEntry
{
  public:
	TaskBarEntry();
	TaskBarEntry(WId wid);
	WId     wid;
	QPixmap icon;
	QString title;
	void fetch();
	bool operator==(const TaskBarEntry &entry);
};

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class TaskBarWatcher : public QObject
{
  Q_OBJECT
  public:
	TaskBarWatcher();
	~TaskBarWatcher();

	const QValueList<TaskBarEntry> & entries() { return m_taskBarEntries; }

  private slots:
	void windowAdded(WId wid);
	void windowRemoved(WId wid);
	void windowChanged(WId wid, const unsigned long *properties);
	void emitChanged();
  private:
	TaskBarEntry *getTaskBarEntry(WId wid);
	bool isBlinking(WId wid);

  signals:
	void changed();
  private:
	KWinModule m_module;
	QValueList<TaskBarEntry> m_taskBarEntries;
};

#endif // TASKBARWATCHER_H
