/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "testdisplay.h"
#include "coverdisplay.h"

#include <qslider.h>
#include <qlabel.h>
#include <kapplication.h>
#include <kiconloader.h>

TestDisplay::TestDisplay(QWidget *parent, const char *name)
 : QWidget(parent, name)
{
	setCaption("Test - Kirocker Music Display");
	setIcon(kapp->iconLoader()->loadIcon("kirocker", KIcon::Desktop, 48, KIcon::DefaultState));

	CoverDisplay *display;

	/// Horizontal:

	// Minuscul:
	display = new CoverDisplay(this);
	display->widthForHeight(24);
	display->move(10, 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Small:
	display = new CoverDisplay(this);
	display->widthForHeight(30);
	display->move(10, 10 + 24 + 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Normal:
	display = new CoverDisplay(this);
	display->widthForHeight(46);
	display->move(10, 10 + 24 + 10 + 30 + 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Big:
	display = new CoverDisplay(this);
	display->widthForHeight(58);
	display->move(10, 10 + 24 + 10 + 30 + 10 + 46 + 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Personalized:
	display = new CoverDisplay(this);
	display->widthForHeight(96);
	display->move(10, 10 + 24 + 10 + 30 + 10 + 46 + 10 + 58 + 10);
	display->setPaletteBackgroundColor(Qt::white);

	int x = 10 + display->width() + 10;

	// Resizeable:
	display = new CoverDisplay(this);
	display->widthForHeight(256);
	display->move(10, 10 + 24 + 10 + 30 + 10 + 46 + 10 + 58 + 10 + 96 + 10);
	display->setPaletteBackgroundColor(Qt::white);
	m_horizontalCover = display;

	/// Vertical:

	// Minuscul:
	display = new CoverDisplay(this);
	display->heightForWidth(24);
	display->move(x + 10, 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Small:
	display = new CoverDisplay(this);
	display->heightForWidth(30);
	display->move(x + 10 + 24 + 10, 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Normal:
	display = new CoverDisplay(this);
	display->heightForWidth(46);
	display->move(x + 10 + 24 + 10 + 30 + 10, 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Big:
	display = new CoverDisplay(this);
	display->heightForWidth(58);
	display->move(x + 10 + 24 + 10 + 30 + 10 + 46 + 10, 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Personalized:
	display = new CoverDisplay(this);
	display->heightForWidth(96);
	display->move(x + 10 + 24 + 10 + 30 + 10 + 46 + 10 + 58 + 10, 10);
	display->setPaletteBackgroundColor(Qt::white);

	// Resizeable:
	display = new CoverDisplay(this);
	display->heightForWidth(256);
	display->move(x + 10 + 24 + 10 + 30 + 10 + 46 + 10 + 58 + 10 + 96 + 10, 10);
	display->setPaletteBackgroundColor(Qt::white);
	m_verticalCover = display;

	/// Slider & Label:

	m_sizeLabel = new QLabel(this);
	m_sizeLabel->resize(m_sizeLabel->sizeHint());
	m_sizeLabel->move(x, x - m_sizeLabel->height() - 10);
	m_sizeLabel->setFixedWidth(50);
	m_sizeLabel->setText("256");

	QSlider *slider = new QSlider(/*min=*/24, /*max=*/256, /*step=*/1, /*value=*/256, Qt::Horizontal, this);
	slider->move(x, x);
	slider->setFixedWidth(200);
	connect( slider, SIGNAL(valueChanged(int)), this, SLOT(resizeCovers(int)) );

	resize(x + 10 + 24 + 10 + 30 + 10 + 46 + 10 + 58 + 10 + 96 + 10 + 256 + 10,
	       10 + 24 + 10 + 30 + 10 + 46 + 10 + 58 + 10 + 96 + 10 + 256 + 10);
}

TestDisplay::~TestDisplay()
{
}

void TestDisplay::resizeCovers(int size)
{
	m_horizontalCover->widthForHeight(size);
	m_verticalCover->heightForWidth(size);
	m_sizeLabel->setText(QString::number(size));
}

#include "testdisplay.moc"
