/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef THEMEDIALOGS_H
#define THEMEDIALOGS_H

#include <kdialogbase.h>
#include <qlistbox.h>

#include "framechooser.h"
#include "framemanager.h"

namespace KIO {
	class Job;
}

class ThemeChooserWidget;
class ThemeEditorWidget;
class ThemeExporterWidget;
class ExportAdvisesWidget;

class Theme;

class FrameEditor;

class QListBoxPixmapMargin : public QListBoxPixmap
{
  public:
	QListBoxPixmapMargin(QListBox *listbox, const QPixmap &pix, const QString &text);
	QListBoxPixmapMargin(QListBox *listbox, const QPixmap &pix, const QString &text, QListBoxItem *after);
	int height(const QListBox *lb) const;
};

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class ThemeChooserDialog : public KDialogBase
{
  Q_OBJECT
  public:
	ThemeChooserDialog(int screenWidth, int screenHeight, QWidget *parent = 0);
	~ThemeChooserDialog();
  protected:
	void applyChanges();
	void loadThemes(Theme *themeToSelect);
	Theme *selectedTheme();
	QString getSaveFileName(const QString &dir, const QString &filter, QWidget *parent, const QString &caption, const QString &fileName);
//	void badArchiveFormat();
  protected slots:
	void slotApply();
	void slotOk();
	void editedThemeChanged();
	void goGetMoreThemes();
	void needCancel();
  private slots:
	void selectedThemeChanged();
	void slotNew();
	bool slotEdit(bool isNew = false);
	void slotDelete();
	void slotExport();
	void slotImport();
	void doDeletion();
  private:
	ThemeChooserWidget *m_chooser;
	int m_screenWidth;
	int m_screenHeight;
};

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class ThemeEditorDialog : public KDialogBase
{
  Q_OBJECT
  public:
	ThemeEditorDialog(int screenWidth, int screenHeight, Theme *theme, const QString &title, QWidget *parent = 0);
	~ThemeEditorDialog();
	bool applyOrOkPressed();
  signals:
	void themeChanged();
	void needCancel();
  protected:
	void applyChanges();
	void renameThemeFolderIfPossible();
  protected slots:
	void somethingChanged();
	void setDefaultColors();
	void slotApply();
	void slotOk();
	void aboutTheme();
	void chooseNormalBackgroundImage();
	void removeNormalBackgroundImage();
	void chooseWideBackgroundImage();
	void removeWideBackgroundImage();
	void backgroundImageChanged();
	void recreatePreview();

	void howToCreateCustomFrames();

	void syncCopyAs(const QString &folder, const QString &newFolder);
	void syncMoveAs(const QString &folder, const QString &newFolder);
	void slotCopyingDone(KIO::Job *);

  private:
	Theme *m_theme;
	Theme *m_temporarTheme;
	ThemeEditorWidget *m_editor;
	FrameEditor *m_frameEditors[Frame::SHAPE_COUNT];
	bool m_copyFinished;
	bool m_applyOrOkPressed;
};

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class FrameEditor : public FrameChooser
{
  Q_OBJECT
  public:
	FrameEditor(Theme *theme, Frame::Shape shape, QWidget *parent = 0);
	~FrameEditor();
	void aboutToApplyChanges();
	int getPaddingTop();
	int getPaddingLeft();
	int getPaddingRight();
	int getPaddingBottom();
	Frame *getFrame();
  signals:
	void somethingChanged();
  protected slots:
	void frameChanged(int index);
	void enablePaddings(bool enable);
  protected:
	Frame *frameForIndex(int index);
  private:
	Theme        *m_theme;
	Frame::Shape  m_shape;
};

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class ThemeExportDialog : public KDialogBase
{
  Q_OBJECT
  public:
	ThemeExportDialog(Theme *theme, const QPixmap &preview, QWidget *parent = 0);
	~ThemeExportDialog();
  protected:
	void showEvent(QShowEvent *event);
  protected slots:
	void slotTemplate();
	void slotOk();
  private:
	Theme *m_theme;
	ThemeExporterWidget *m_exporter;
};




/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
class ThemeAdviseDialog : public KDialogBase
{
  Q_OBJECT
  public:
	ThemeAdviseDialog(Theme *theme, QWidget *parent = 0);
	~ThemeAdviseDialog();
  protected slots:
	void slotGoKdeLookOrg();
	void slotCopy();
  private:
	Theme *m_theme;
	ExportAdvisesWidget *m_adviser;
};




#endif // THEMEDIALOGS_H
