/***************************************************************************
 *   Copyright (C) 2007 by Sébastien Laoût                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TOOLS_H
#define TOOLS_H

#include <qimage.h>
#include <qpixmap.h>
#include <qcolor.h>

/**
 * @author Sébastien Laoût <slaout@linux62.org>
 */
namespace Tools
{
	QPixmap addTransparentPixelsOnTop(const QPixmap &source, int nbPixels);
	QPixmap addTransparentPixelsOnLeftRight(const QPixmap &source, int nbPixelsLeft, int nbPixelsRight);

	QImage  reflexionImage(QImage &image);
	QPixmap reflexionPixmap(QImage &image);
	QImage smoothScale(QImage &image, int width, int height);

	QColor mixColors(const QColor &color1, const QColor &color2, double color1Proportion = 0.5);
	bool tooDark(const QColor &color);
	bool isWideScreen(int width, int height);

	QString tagURLs(const QString &text);
	QString tagURLsBBCode(const QString &text);

	QString fileNameForNewFile(const QString &wantedName, const QString &destFolder, const char separator = '-');
	void deleteRecursively(const QString &folderOrFile);
};

#endif // TOOLS_H
