/*
 * klick - an advanced metronome for jack
 *
 * Copyright (C) 2007  Dominic Sacré  <dominic.sacre@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "click_data.h"


// sounds borrowed from ardour

static const sample_t CLICK_1_EMPHASIS_SAMPLES[] = {
    0.011260986, 0.055389404, 0.10488892, 0.14285278, 0.17984009,
    0.20492554, 0.2244873, 0.23187256, 0.23144531, 0.21932983,
    0.19973755, 0.17034912, 0.13473511, 0.09274292, 0.04699707,
    -0.0009765625, -0.048919678, -0.095123291, -0.13772583,
    -0.17495728, -0.20523071, -0.22750854, -0.24038696, -0.24423218,
    -0.23831177, -0.22305298, -0.19918823, -0.16748047, -0.12948608,
    -0.086730957, -0.041015625, 0.0060424805, 0.052276611,
    0.09588623, 0.13513184, 0.16827393, 0.19415283, 0.21182251,
    0.22024536, 0.2194519, 0.20932007, 0.19030762, 0.1633606,
    0.1295166, 0.090118408, 0.046844482, 0.0015563965, -0.0440979,
    -0.088043213, -0.12854004, -0.16415405, -0.19317627,
    -0.21456909, -0.22750854, -0.23141479, -0.22619629, -0.21224976,
    -0.18994141, -0.1602478, -0.12457275, -0.084228516,
    -0.040893555, 0.0035400391, 0.047485352, 0.08895874, 0.12628174,
    0.15808105, 0.1829834, 0.19998169, 0.20849609, 0.2081604,
    0.19891357, 0.18139648, 0.15621948, 0.12438965, 0.087371826,
    0.046569824, 0.0036621094, -0.039489746, -0.081207275,
    -0.11987305, -0.15371704, -0.18154907, -0.20220947, -0.21481323,
    -0.21896362, -0.21453857, -0.20159912, -0.18084717, -0.15319824,
    -0.11959839, -0.081604004, -0.040771484, 0.001373291,
    0.04296875, 0.082275391, 0.11791992, 0.14828491, 0.17214966,
    0.18869019, 0.19711304, 0.19714355, 0.18896484, 0.17272949,
    0.14916992, 0.11941528, 0.084564209, 0.046081543, 0.005645752,
    -0.03527832, -0.074890137, -0.11154175, -0.14389038,
    -0.17053223, -0.19036865, -0.20272827, -0.20709229, -0.20321655,
    -0.19143677, -0.17221069, -0.14624023, -0.11477661,
    -0.079040527, -0.040435791, -0.00064086914, 0.038726807,
    0.076171875, 0.11004639, 0.13900757, 0.16201782, 0.177948,
    0.18634033, 0.18685913, 0.17938232, 0.16436768, 0.14254761,
    0.11459351, 0.081817627, 0.045623779, 0.0073242188,
    -0.031402588, -0.068939209, -0.10388184, -0.13473511,
    -0.16018677, -0.17938232, -0.19143677, -0.19589233, -0.19271851,
    -0.1819458, -0.16400146, -0.13980103, -0.11026001, -0.076507568,
    -0.040130615, -0.0024414062, 0.034973145, 0.070465088,
    0.10275269, 0.13052368, 0.15255737, 0.1680603, 0.17642212,
    0.17718506, 0.17056274, 0.15673828, 0.13626099, 0.1100769,
    0.079284668, 0.045013428, 0.0088195801, -0.027862549,
    -0.06362915, -0.096862793, -0.12631226, -0.15081787,
    -0.16931152, -0.18109131, -0.18579102, -0.18310547, -0.17321777,
    -0.15661621, -0.13391113, -0.10604858, -0.074310303,
    -0.039794922, -0.0040588379, 0.031433105, 0.065338135,
    0.096191406, 0.1227417, 0.14398193, 0.15905762, 0.16726685,
    0.16845703, 0.16247559, 0.14962769, 0.1305542, 0.10595703,
    0.076812744, 0.044494629, 0.010162354, -0.024719238,
    -0.058685303, -0.090423584, -0.11865234, -0.14208984,
    -0.15994263, -0.17150879, -0.1762085, -0.17401123, -0.16500854,
    -0.1494751, -0.12820435, -0.10205078, -0.071990967,
    -0.039398193, -0.0055847168, 0.028198242, 0.060424805,
    0.089782715, 0.11523438, 0.13565063, 0.15014648, 0.1583252,
    0.159729, 0.15438843, 0.14260864, 0.12475586, 0.10162354,
    0.074310303, 0.043762207, 0.011291504, -0.02166748,
    -0.053924561, -0.084136963, -0.1109314, -0.13342285,
    -0.15060425, -0.16177368, -0.16659546, -0.16485596, -0.15655518,
    -0.14221191, -0.12234497, -0.097747803, -0.069519043,
    -0.038818359, -0.0067749023, 0.025115967, 0.055633545,
    0.083618164, 0.1078186, 0.12731934, 0.14138794, 0.14935303,
    0.15097046, 0.14630127, 0.13537598, 0.11877441, 0.097259521,
    0.071563721, 0.04284668, 0.012329102, -0.018859863,
    -0.049346924, -0.077880859, -0.10342407, -0.12484741,
    -0.14126587, -0.15213013, -0.1569519, -0.1555481, -0.14807129,
    -0.13479614, -0.11624146, -0.093322754, -0.066864014,
    -0.03793335, -0.0078735352, 0.022247314, 0.051116943,
    0.077575684, 0.10055542, 0.11920166, 0.13265991, 0.14047241,
    0.14233398, 0.13812256, 0.12814331, 0.11282349, 0.092681885,
    0.068695068, 0.0418396, 0.013122559, -0.016174316, -0.044891357,
    -0.071929932, -0.096038818, -0.11636353, -0.1321106,
    -0.14254761, -0.14733887, -0.14633179, -0.13955688, -0.12728882,
    -0.11016846, -0.088745117, -0.063995361, -0.036987305,
    -0.0087280273, 0.019592285, 0.04675293, 0.071746826,
    0.093536377, 0.11120605, 0.12411499, 0.13171387, 0.13366699,
    0.1300354, 0.12094116, 0.10671997, 0.088104248, 0.065765381,
    0.040588379, 0.013763428, -0.013702393, -0.040740967,
    -0.066101074, -0.088897705, -0.10818481, -0.12310791,
    -0.13314819, -0.13793945, -0.13720703, -0.13113403, -0.11993408,
    -0.10400391, -0.084136963, -0.061126709, -0.035858154,
    -0.0094299316, 0.017059326, 0.042633057, 0.066131592,
    0.086669922, 0.10345459, 0.11572266, 0.12304688, 0.12521362,
    0.12203979, 0.11373901, 0.10070801, 0.083435059, 0.062652588,
    0.039276123, 0.014221191, -0.011505127, -0.036773682,
    -0.060638428, -0.082092285, -0.10025024, -0.11444092,
    -0.12408447, -0.12875366, -0.12835693, -0.1229248, -0.11260986,
    -0.097991943, -0.079620361, -0.058166504, -0.034698486,
    -0.010040283, 0.014770508, 0.038665771, 0.06072998, 0.080108643,
    0.095916748, 0.10760498, 0.11471558, 0.11691284, 0.11419678,
    0.10671997, 0.094726562, 0.078765869, 0.059570312, 0.037811279,
    0.014465332, -0.0094604492, -0.03314209, -0.055480957,
    -0.075592041, -0.09274292, -0.10617065, -0.11532593, -0.1199646,
    -0.11981201, -0.11489868, -0.1055603, -0.092102051,
    -0.075073242, -0.055267334, -0.033447266, -0.010467529,
    0.012634277, 0.035003662, 0.05569458, 0.073822021, 0.088745117,
    0.099853516, 0.10665894, 0.10894775, 0.10665894, 0.099853516,
    0.088897705, 0.07421875, 0.056427002, 0.0362854, 0.01461792,
    -0.0077209473, -0.029754639, -0.050628662, -0.069519043,
    -0.085571289, -0.098236084, -0.10702515, -0.11151123,
    -0.11157227, -0.1072998, -0.098754883, -0.086364746,
    -0.070739746, -0.052368164, -0.032104492, -0.01083374,
    0.01071167, 0.031585693, 0.050872803, 0.067932129, 0.081970215,
    0.092437744, 0.098999023, 0.10134888, 0.099395752, 0.093292236,
    0.083282471, 0.069763184, 0.053375244, 0.034729004, 0.01461792,
    -0.0061035156, -0.026641846, -0.046142578, -0.063751221,
    -0.078857422, -0.090820312, -0.099121094, -0.10351562,
    -0.1038208, -0.099975586, -0.092254639, -0.080932617,
    -0.066497803, -0.049560547, -0.030822754, -0.011016846,
    0.0090026855, 0.028411865, 0.046478271, 0.062408447,
    0.075592041, 0.085571289, 0.091827393, 0.094177246, 0.092590332,
    0.087097168, 0.077941895, 0.065582275, 0.050445557, 0.033203125,
    0.014587402, -0.0046691895, -0.023803711, -0.04196167,
    -0.05847168, -0.072662354, -0.083892822, -0.091827393,
    -0.096099854, -0.0965271, -0.093170166, -0.086181641,
    -0.075775146, -0.062530518, -0.046875, -0.029510498,
    -0.011169434, 0.0074462891, 0.02557373, 0.042419434,
    0.057342529, 0.069793701, 0.079162598, 0.085174561, 0.087585449,
    0.086273193, 0.081329346, 0.073028564, 0.061645508, 0.047668457,
    0.031768799, 0.014465332, -0.0034484863, -0.021209717,
    -0.038208008, -0.053649902, -0.066925049, -0.077575684,
    -0.085113525, -0.089233398, -0.08984375, -0.086914062,
    -0.080535889, -0.071075439, -0.058837891, -0.044342041,
    -0.028289795, -0.011230469, 0.0061340332, 0.023010254,
    0.038787842, 0.05279541, 0.064483643, 0.073394775, 0.079162598,
    0.081542969, 0.080535889, 0.07611084, 0.068481445, 0.058044434,
    0.045166016, 0.03036499, 0.014343262, -0.0023193359,
    -0.018951416, -0.034820557, -0.049285889, -0.061828613,
    -0.071868896, -0.079040527, -0.083099365, -0.083831787,
    -0.081237793, -0.075500488, -0.066772461, -0.055480957,
    -0.042114258, -0.027130127, -0.011230469, 0.0049133301,
    0.020751953, 0.035552979, 0.048706055, 0.059783936, 0.068237305,
    0.073760986, 0.076202393, 0.075408936, 0.07144165, 0.064483643,
    0.054840088, 0.042877197, 0.029174805, 0.014190674,
    -0.0014038086, -0.016937256, -0.031829834, -0.045501709,
    -0.057312012, -0.066864014, -0.073760986, -0.077667236,
    -0.078552246, -0.076293945, -0.071044922, -0.063018799,
    -0.052581787, -0.040100098, -0.026153564, -0.011291504,
    0.00390625, 0.018768311, 0.032714844, 0.045196533, 0.05569458,
    0.063751221, 0.069152832, 0.071563721, 0.070983887, 0.067443848,
    0.061035156, 0.052093506, 0.040985107, 0.028137207, 0.014099121,
    -0.00051879883, -0.015197754, -0.029296875, -0.042205811,
    -0.053466797, -0.062591553, -0.069213867, -0.073120117,
    -0.07409668, -0.072113037, -0.067321777, -0.059906006,
    -0.050140381, -0.038482666, -0.025360107, -0.011322021,
    0.0029907227, 0.017089844, 0.03036499, 0.042236328, 0.052276611,
    0.060089111, 0.0652771, 0.067749023, 0.067382812, 0.064117432,
    0.058227539, 0.04989624, 0.039428711, 0.02734375, 0.014099121,
    0.00021362305, -0.013702393, -0.027099609, -0.039459229,
    -0.050231934, -0.058990479, -0.065429688, -0.069244385,
    -0.0703125, -0.068634033, -0.064208984, -0.057250977,
    -0.048126221, -0.037109375, -0.024688721, -0.011413574,
    0.0021972656, 0.015625, 0.028259277, 0.039642334, 0.049285889,
    0.056793213, 0.061889648, 0.064361572, 0.064117432, 0.061187744,
    0.05569458, 0.047851562, 0.03805542, 0.026611328, 0.014038086,
    0.00088500977, -0.012329102, -0.025146484, -0.03692627,
    -0.047241211, -0.055725098, -0.061920166, -0.065673828,
    -0.066864014, -0.065338135, -0.061279297, -0.05480957,
    -0.046203613, -0.035797119, -0.024078369, -0.011474609,
    0.0014648438, 0.014251709, 0.02633667, 0.037200928, 0.046447754,
    0.053741455, 0.05871582, 0.061157227, 0.061096191, 0.058441162,
    0.053314209, 0.04598999, 0.036712646, 0.025909424, 0.014007568,
    0.0014953613, -0.011138916, -0.02331543, -0.034576416,
    -0.044494629, -0.052612305, -0.058654785, -0.06237793,
    -0.063598633, -0.062316895, -0.058563232, -0.052490234,
    -0.044403076, -0.034606934, -0.023468018, -0.011505127,
    0.00079345703, 0.013000488, 0.024505615, 0.034942627,
    0.04385376, 0.050872803, 0.05569458, 0.058197021, 0.058227539,
    0.055786133, 0.051055908, 0.044158936, 0.035430908, 0.02520752,
    0.013916016, 0.0020141602, -0.009979248, -0.021636963,
    -0.032440186, -0.041931152, -0.04977417, -0.055664062,
    -0.059265137, -0.060577393, -0.05947876, -0.055999756,
    -0.050354004, -0.042724609, -0.033447266, -0.022918701,
    -0.011566162, 0.00018310547, 0.011810303, 0.022827148,
    0.032836914, 0.041381836, 0.048187256, 0.05291748, 0.055389404,
    0.055541992, 0.053344727, 0.048919678, 0.042449951, 0.034210205,
    0.024536133, 0.013793945, 0.0025024414, -0.008972168,
    -0.020080566, -0.030426025, -0.039581299, -0.047149658,
    -0.05279541, -0.056396484, -0.057739258, -0.056793213,
    -0.053619385, -0.048309326, -0.041137695, -0.03237915,
    -0.022369385, -0.011566162, -0.00039672852, 0.01071167,
    0.02130127, 0.030883789, 0.039123535, 0.045684814, 0.050292969,
    0.052764893, 0.053039551, 0.051055908, 0.046936035, 0.040863037,
    0.033081055, 0.023895264, 0.01373291, 0.0029296875,
    -0.0079956055, -0.01864624, -0.028564453, -0.037353516,
    -0.044647217, -0.050170898, -0.05368042, -0.055084229,
    -0.054290771, -0.051361084, -0.046386719, -0.039642334,
    -0.031311035, -0.021820068, -0.011566162, -0.00088500977,
    0.0097351074, 0.019836426, 0.029083252, 0.037017822,
    0.043365479, 0.04788208, 0.050323486, 0.050689697, 0.048919678,
    0.045074463, 0.039367676, 0.032012939, 0.02331543, 0.01361084,
    0.0033569336, -0.0071105957, -0.017303467, -0.026794434,
    -0.035247803, -0.042327881, -0.047668457, -0.051147461,
    -0.052581787, -0.0519104, -0.049224854, -0.044586182,
    -0.03817749, -0.030334473, -0.021331787, -0.011505127,
    -0.0013427734, 0.0088195801, 0.01852417, 0.027374268,
    0.03503418, 0.04119873, 0.045593262, 0.048034668, 0.048492432,
    0.046905518, 0.043334961, 0.037963867, 0.031005859, 0.022735596,
    0.013519287, 0.003692627, -0.0062866211, -0.016021729,
    -0.025177002, -0.033325195, -0.040130615, -0.045349121,
    -0.04876709, -0.050231934, -0.049713135, -0.047210693,
    -0.04284668, -0.036834717, -0.029388428, -0.020812988,
    -0.011474609, -0.001739502, 0.0079650879, 0.017272949,
    0.025787354, 0.033203125, 0.039154053, 0.043457031, 0.045898438,
    0.046417236, 0.04498291, 0.041687012, 0.036621094, 0.030029297,
    0.022186279, 0.013397217, 0.0040588379, -0.0054931641,
    -0.014862061, -0.023651123, -0.031494141, -0.038085938,
    -0.043151855, -0.046508789, -0.048034668, -0.047607422,
    -0.045318604, -0.041259766, -0.035552979, -0.0284729,
    -0.020324707, -0.011413574, -0.0021057129, 0.0071716309,
    0.016113281, 0.02432251, 0.031463623, 0.037231445, 0.041442871,
    0.043884277, 0.044464111, 0.043212891, 0.040100098, 0.035339355,
    0.02911377, 0.021636963, 0.013275146, 0.0043640137,
    -0.0048217773, -0.013763428, -0.022216797, -0.029785156,
    -0.03616333, -0.041107178, -0.044403076, -0.045928955,
    -0.045623779, -0.043548584, -0.039703369, -0.034332275,
    -0.027648926, -0.019866943, -0.011352539, -0.0024719238,
    0.0064697266, 0.015045166, 0.022918701, 0.029815674,
    0.035430908, 0.039520264, 0.04196167, 0.042602539, 0.041473389,
    0.038604736, 0.034118652, 0.02822876, 0.021148682, 0.013153076,
    0.0046081543, -0.0041503906, -0.012756348, -0.020874023,
    -0.028167725, -0.034332275, -0.039154053, -0.042388916,
    -0.043945312, -0.043762207, -0.041809082, -0.038238525,
    -0.033172607, -0.026794434, -0.01940918, -0.011291504,
    -0.0027770996, 0.0057678223, 0.014007568, 0.021636963,
    0.028259277, 0.033691406, 0.037719727, 0.040100098, 0.04083252,
    0.039825439, 0.03717041, 0.032958984, 0.027374268, 0.020599365,
    0.013000488, 0.0048522949, -0.0035400391, -0.011810303,
    -0.019592285, -0.026641846, -0.032623291, -0.03729248,
    -0.040466309, -0.042053223, -0.041931152, -0.04019165,
    -0.036834717, -0.032012939, -0.026000977, -0.018951416,
    -0.011199951, -0.0030517578, 0.0051269531, 0.013061523,
    0.020385742, 0.026794434, 0.032073975, 0.035980225, 0.038360596,
    0.039123535, 0.038238525, 0.035766602, 0.031799316, 0.026489258,
    0.020080566, 0.0128479, 0.0050354004, -0.0029907227,
    -0.010894775, -0.018432617, -0.02520752, -0.030975342,
    -0.035522461, -0.038635254, -0.040222168, -0.04019165,
    -0.038574219, -0.035430908, -0.030914307, -0.025177002,
    -0.018493652, -0.011108398, -0.0032958984, 0.0045471191,
    0.012145996, 0.019195557, 0.025390625, 0.030487061, 0.034301758,
    0.036651611, 0.037475586, 0.036712646, 0.034423828, 0.030670166,
    0.025665283, 0.019592285, 0.012664795, 0.0052185059,
    -0.0024719238, -0.010070801, -0.017272949, -0.023803711,
    -0.029388428, -0.033813477, -0.036865234, -0.038452148,
    -0.038513184, -0.03704834, -0.034118652, -0.029815674,
    -0.024383545, -0.018035889, -0.010955811, -0.0035400391,
    0.0039978027, 0.011291504, 0.018066406, 0.024047852,
    0.028991699, 0.032684326, 0.035003662, 0.035858154, 0.035217285,
    0.033081055, 0.029571533, 0.024810791, 0.019042969, 0.012481689,
    0.0053405762, -0.0020141602, -0.0092773438, -0.016204834,
    -0.022491455, -0.027862549, -0.032165527, -0.03515625,
    -0.036743164, -0.036865234, -0.035552979, -0.032775879,
    -0.028778076, -0.023620605, -0.017547607, -0.01083374,
    -0.0037231445, 0.0034790039, 0.010467529, 0.016967773,
    0.022735596, 0.027526855, 0.03112793, 0.033416748, 0.034301758,
    0.033752441, 0.031768799, 0.0284729, 0.023986816, 0.01852417,
    0.012237549, 0.0054626465, -0.0015563965, -0.0085449219,
    -0.015167236, -0.021209717, -0.026428223, -0.030578613,
    -0.033508301, -0.035095215, -0.03527832, -0.034057617,
    -0.031524658, -0.027709961, -0.022827148, -0.017089844,
    -0.010681152, -0.00390625, 0.0029907227, 0.0096740723,
    0.015960693, 0.021484375, 0.026123047, 0.029632568, 0.031890869,
    0.032806396, 0.032348633, 0.030517578, 0.027435303, 0.023193359,
    0.017974854, 0.012023926, 0.0055847168, -0.001159668,
    -0.0078125, -0.014190674, -0.020019531, -0.025024414,
    -0.029052734, -0.031921387, -0.033477783, -0.033752441,
    -0.032653809, -0.030273438, -0.026702881, -0.022094727,
    -0.016601562, -0.010498047, -0.0040588379, 0.002532959,
    0.008972168, 0.014953613, 0.020324707, 0.024780273, 0.028198242,
    0.030426025, 0.031341553, 0.030975342, 0.029296875, 0.026397705,
    0.022399902, 0.017486572, 0.011810303, 0.005645752,
    -0.00076293945, -0.0071411133, -0.013275146, -0.018859863,
    -0.023681641, -0.027587891, -0.03036499, -0.031951904,
    -0.03225708, -0.03125, -0.029052734, -0.025695801, -0.02130127,
    -0.016113281, -0.010345459, -0.0041503906, 0.0021362305,
    0.0082702637, 0.014068604, 0.019195557, 0.023498535,
    0.026824951, 0.028991699, 0.029937744, 0.029663086, 0.028106689,
    0.025390625, 0.021636963, 0.016967773, 0.011566162,
    0.0057067871, -0.00039672852, -0.0065307617, -0.012359619,
    -0.01776123, -0.022399902, -0.026184082, -0.028900146,
    -0.030456543, -0.030792236, -0.029937744, -0.027862549,
    -0.024688721, -0.020568848, -0.015655518, -0.010131836,
    -0.0042419434, 0.001739502, 0.0076599121, 0.013183594,
    0.018127441, 0.022277832, 0.025512695, 0.027618408, 0.028625488,
    0.028381348, 0.026977539, 0.02444458, 0.020874023, 0.016448975,
    0.011352539, 0.0057373047, -9.1552734e-05, -0.0059204102,
    -0.011535645, -0.016693115, -0.021179199, -0.024841309,
    -0.02746582, -0.029022217, -0.029418945, -0.028625488,
    -0.026702881, -0.023742676, -0.019866943, -0.015197754,
    -0.0099487305, -0.0043334961, 0.0014038086, 0.007019043,
    0.012329102, 0.017089844, 0.021087646, 0.024230957, 0.026306152,
    0.027282715, 0.027130127, 0.025848389, 0.023468018, 0.020111084,
    0.015930176, 0.011077881, 0.0057678223, 0.00021362305,
    -0.0053710938, -0.010742188, -0.015686035, -0.020019531,
    -0.023529053, -0.026123047, -0.027648926, -0.028076172,
    -0.027374268, -0.025604248, -0.022827148, -0.019134521,
    -0.01473999, -0.0097351074, -0.0043945312, 0.0010681152,
    0.0064697266, 0.011535645, 0.016113281, 0.019989014,
    0.023010254, 0.025024414, 0.026031494, 0.025939941, 0.024749756,
    0.02255249, 0.019378662, 0.015411377, 0.01083374, 0.0057678223,
    0.00045776367, -0.0048522949, -0.010009766, -0.01473999,
    -0.018890381, -0.02230835, -0.024810791, -0.02633667,
    -0.026794434, -0.026184082, -0.024536133, -0.021911621,
    -0.018463135, -0.014251709, -0.009552002, -0.0044555664,
    0.00076293945, 0.0059204102, 0.010772705, 0.015167236,
    0.018890381, 0.021820068, 0.023803711, 0.024810791, 0.024749756,
    0.023681641, 0.021606445, 0.01864624, 0.014923096, 0.010559082,
    0.0057373047, 0.0007019043, -0.0043945312, -0.0093078613,
    -0.01385498, -0.017852783, -0.021118164, -0.02355957,
    -0.025054932, -0.025543213, -0.024993896, -0.023498535,
    -0.021057129, -0.01776123, -0.013824463, -0.0093383789,
    -0.004486084, 0.00048828125, 0.0054016113, 0.010040283,
    0.014251709, 0.017852783, 0.020690918, 0.022613525, 0.023620605,
    0.023620605, 0.022644043, 0.020721436, 0.017944336, 0.014404297,
    0.010284424, 0.0057373047, 0.00091552734, -0.0039367676,
    -0.0086364746, -0.013000488, -0.016815186, -0.019989014,
    -0.022338867, -0.023803711, -0.02432251, -0.023864746,
    -0.022460938, -0.020172119, -0.017089844, -0.013366699,
    -0.0090942383, -0.0045166016, 0.00021362305, 0.0049133301,
    0.0093688965, 0.013397217, 0.016845703, 0.019592285,
    0.021484375, 0.022491455, 0.022521973, 0.021636963, 0.019866943,
    0.017242432, 0.013916016, 0.010009766, 0.0056762695,
    0.0010986328, -0.0035095215, -0.0079956055, -0.012176514,
    -0.015838623, -0.018890381, -0.021179199, -0.022613525,
    -0.023162842, -0.022766113, -0.021484375, -0.019348145,
    -0.016418457, -0.012908936, -0.0088806152, -0.0045166016, 0,
    0.0044555664, 0.0087280273, 0.012573242, 0.015899658,
    0.01852417, 0.020385742, 0.021362305, 0.021484375, 0.0206604,
    0.019012451, 0.016571045, 0.013427734, 0.0097045898,
    0.0056152344, 0.0012817383, -0.003112793, -0.0073852539,
    -0.011383057, -0.014923096, -0.017822266, -0.020050049,
    -0.021453857, -0.022003174, -0.021697998, -0.020507812,
    -0.018493652, -0.015777588, -0.012451172, -0.0086364746,
    -0.004486084, -0.00021362305, 0.0040588379, 0.0080871582,
    0.011779785, 0.014984131, 0.01751709, 0.019317627, 0.020294189,
    0.020446777, 0.019714355, 0.018188477, 0.015869141, 0.012908936,
    0.0094299316, 0.0055541992, 0.0014343262, -0.002746582,
    -0.0068359375, -0.010620117, -0.014007568, -0.016815186,
    -0.018981934, -0.020355225, -0.020904541, -0.020629883,
    -0.019561768, -0.017700195, -0.015136719, -0.011993408,
    -0.008392334, -0.0044555664, -0.00039672852, 0.0036621094,
    0.0075073242, 0.011047363, 0.014099121, 0.016540527,
    0.018280029, 0.019256592, 0.01940918, 0.018768311, 0.017364502,
    0.015197754, 0.012420654, 0.0091247559, 0.0054626465,
    0.0015563965, -0.0024108887, -0.0062866211, -0.0099182129,
    -0.013153076, -0.015838623, -0.017913818, -0.019256592,
    -0.019836426, -0.019622803, -0.018615723, -0.016876221,
    -0.01449585, -0.011535645, -0.0081176758, -0.0044250488,
    -0.00057983398, 0.0032958984, 0.0069580078, 0.010314941,
    0.013244629, 0.015594482, 0.017272949, 0.018249512, 0.018432617,
    0.017852783, 0.016540527, 0.014556885, 0.011932373,
    0.0088195801, 0.0053710938, 0.0016784668, -0.0021057129,
    -0.0057678223, -0.0092468262, -0.012329102, -0.014892578,
    -0.016906738, -0.018188477, -0.018768311, -0.018615723,
    -0.017700195, -0.016082764, -0.01385498, -0.011047363,
    -0.0078430176, -0.0043640137, -0.0007019043, 0.0029296875,
    0.006439209, 0.0096435547, 0.012451172, 0.014678955,
    0.016326904, 0.017272949, 0.017486572, 0.016967773, 0.01574707,
    0.013885498, 0.011444092, 0.0085144043, 0.0052490234,
    0.0017700195, -0.0018005371, -0.0053100586, -0.0085754395,
    -0.011535645, -0.014007568, -0.015899658, -0.017181396,
    -0.01776123, -0.01763916, -0.016815186, -0.015319824,
    -0.013214111, -0.0105896, -0.007598877, -0.0042724609,
    -0.00082397461, 0.0026245117, 0.0059509277, 0.0090026855,
    0.011657715, 0.013824463, 0.015380859, 0.016296387, 0.016540527,
    0.016082764, 0.014984131, 0.013244629, 0.010955811,
    0.0082092285, 0.0051269531, 0.0018310547, -0.0015258789,
    -0.0048522949, -0.0079650879, -0.010772705, -0.013122559,
    -0.014953613, -0.016204834, -0.01675415, -0.016693115,
    -0.015930176, -0.014556885, -0.01260376, -0.010131836,
    -0.0072937012, -0.0042114258, -0.00094604492, 0.0023193359,
    0.0054626465, 0.0083618164, 0.010894775, 0.012939453,
    0.014465332, 0.015380859, 0.015625, 0.015228271, 0.014221191,
    0.012573242, 0.010467529, 0.0078735352, 0.0049743652,
    0.0018920898, -0.0012817383, -0.0044250488, -0.0073852539,
    -0.010040283, -0.012298584, -0.014038086, -0.015228271,
    -0.015808105, -0.01574707, -0.015075684, -0.013793945,
    -0.011962891, -0.0096740723, -0.007019043, -0.004119873,
    -0.0010375977, 0.0020446777, 0.0050048828, 0.0077514648,
    0.010162354, 0.012115479, 0.013580322, 0.014465332, 0.01473999,
    0.014373779, 0.013458252, 0.011962891, 0.0099487305,
    0.0075378418, 0.0048522949, 0.0019226074, -0.0010681152,
    -0.0040283203, -0.0068054199, -0.0093383789, -0.011474609,
    -0.013153076, -0.014312744, -0.014862061, -0.014862061,
    -0.014251709, -0.013061523, -0.011352539, -0.0092468262,
    -0.0067443848, -0.0039978027, -0.0011291504, 0.0017700195,
    0.0045776367, 0.0071716309, 0.0094604492, 0.011322021,
    0.012695312, 0.013580322, 0.01385498, 0.013549805, 0.012695312,
    0.011322021, 0.0094604492, 0.007232666, 0.0046691895,
    0.001953125, -0.00085449219, -0.0036621094, -0.0062866211,
    -0.0086669922, -0.010681152, -0.012298584, -0.013397217,
    -0.013946533, -0.013946533, -0.013397217, -0.012329102,
    -0.010772705, -0.0087585449, -0.006439209, -0.00390625,
    -0.0011901855, 0.0015258789, 0.0041809082, 0.0066223145,
    0.0087585449, 0.010559082, 0.011871338, 0.012695312,
    0.013000488, 0.012756348, 0.011962891, 0.010681152, 0.008972168,
    0.0068664551, 0.0045166016, 0.001953125, -0.00067138672,
    -0.0032958984, -0.0057678223, -0.0079956055, -0.0099182129,
    -0.011444092, -0.012512207, -0.013061523, -0.013092041,
    -0.01260376, -0.01159668, -0.010162354, -0.0083007812,
    -0.0061645508, -0.0037536621, -0.0012512207, 0.0013122559,
    0.0037841797, 0.0061035156, 0.0081176758, 0.0097961426,
    0.011077881, 0.011871338, 0.012145996, 0.011932373, 0.011230469,
    0.010070801, 0.0084838867, 0.0065307617, 0.0043334961,
    0.001953125, -0.00051879883, -0.0029602051, -0.005279541,
    -0.0073852539, -0.009185791, -0.010620117, -0.011627197,
    -0.012176514, -0.012237549, -0.011779785, -0.010894775,
    -0.009552002, -0.0078430176, -0.0058288574, -0.0036315918,
    -0.0012817383, 0.0011291504, 0.0034179688, 0.0055847168,
    0.0075073242, 0.0090637207, 0.010284424, 0.011047363,
    0.011322021, 0.011169434, 0.010528564, 0.0094604492,
    0.0079956055, 0.0061950684, 0.0041503906, 0.0019226074,
    -0.00036621094, -0.0026550293, -0.0048217773, -0.0067749023,
    -0.0084838867, -0.0098266602, -0.010803223, -0.011322021,
    -0.011383057, -0.010986328, -0.010192871, -0.0089416504,
    -0.0073852539, -0.0055236816, -0.0034790039, -0.0012817383,
    0.00094604492, 0.0030822754, 0.0050964355, 0.0068969727,
    0.008392334, 0.0095214844, 0.010223389, 0.010528564,
    0.010406494, 0.0098266602, 0.0088500977, 0.0075073242,
    0.0058288574, 0.0039672852, 0.0018920898, -0.00021362305,
    -0.0023498535, -0.0043640137, -0.0061950684, -0.0077819824,
    -0.0090637207, -0.009979248, -0.010467529, -0.010559082,
    -0.010223389, -0.0094909668, -0.0083618164, -0.0069274902,
    -0.0052185059, -0.0032958984, -0.0012817383, 0.00076293945,
    0.0027770996, 0.0046386719, 0.0063171387, 0.0076904297,
    0.0087585449, 0.0094604492, 0.0097351074, 0.0096435547,
    0.0091247559, 0.0082397461, 0.0069885254, 0.0054931641,
    0.0037536621, 0.0018615723, -0.00012207031, -0.0020751953,
    -0.0039367676, -0.005645752, -0.0071411133, -0.0083312988,
    -0.009185791, -0.0096740723, -0.009765625, -0.0094604492,
    -0.0087890625, -0.0077819824, -0.006439209, -0.0048828125,
    -0.0031433105, -0.0012817383, 0.00061035156, 0.0024719238,
    0.0042114258, 0.0057373047, 0.0070495605, 0.008026123,
    0.0086975098, 0.008972168, 0.0088806152, 0.0084228516,
    0.0076293945, 0.0065002441, 0.0051269531, 0.0035400391,
    0.0018005371, 0, -0.0018005371, -0.0035400391, -0.0051269531,
    -0.0065002441, -0.007598877, -0.008392334, -0.0088500977,
    -0.008972168, -0.0086975098, -0.0081176758, -0.0071716309,
    -0.0059814453, -0.0045471191, -0.0029602051, -0.0012512207,
    0.00048828125, 0.0021972656, 0.0037841797, 0.0052185059,
    0.0064086914, 0.0073242188, 0.0079345703, 0.0082092285,
    0.0081481934, 0.0077514648, 0.007019043, 0.0060119629,
    0.0047607422, 0.0032958984, 0.0017089844, 6.1035156e-05,
    -0.0015869141, -0.0031738281, -0.0046081543, -0.0058898926,
    -0.0068969727, -0.0076293945, -0.0080566406, -0.0081787109,
    -0.0079650879, -0.0074157715, -0.0065917969, -0.0055236816,
    -0.0042114258, -0.0027770996, -0.0012207031, 0.00036621094,
    0.0019226074, 0.0033874512, 0.0046691895, 0.0057678223,
    0.0066223145, 0.0072021484, 0.0074768066, 0.0074157715,
    0.0070800781, 0.0064086914, 0.0055236816, 0.0043945312,
    0.0030822754, 0.0016479492, 0.00015258789, -0.001373291,
    -0.0028076172, -0.004119873, -0.005279541, -0.0062255859,
    -0.0068969727, -0.0072937012, -0.0074157715, -0.007232666,
    -0.0067443848, -0.0060119629, -0.0050354004, -0.0038757324,
    -0.0025634766, -0.001159668, 0.0002746582, 0.0016784668,
    0.0029907227, 0.0041809082, 0.0051879883, 0.0059509277,
    0.0064697266, 0.0067443848, 0.0067138672, 0.0064086914,
    0.0058288574, 0.0050048828, 0.0039978027, 0.0028381348,
    0.0015258789, 0.00018310547, -0.001159668, -0.0024719238,
    -0.0036621094, -0.004699707, -0.0055541992, -0.0061645508,
    -0.0065307617, -0.006652832, -0.0065002441, -0.006072998,
    -0.0054321289, -0.0045776367, -0.0035400391, -0.0023498535,
    -0.0010986328, 0.00018310547, 0.0014343262, 0.0026245117,
    0.003692627, 0.0046081543, 0.0053100586, 0.0057678223,
    0.0060119629, 0.0060119629, 0.0057373047, 0.0052185059,
    0.0045166016, 0.0036315918, 0.0025634766, 0.0014343262,
    0.00024414062, -0.0009765625, -0.0021362305, -0.0032043457,
    -0.0041503906, -0.0049133301, -0.0054626465, -0.0057983398,
    -0.0059204102, -0.0057678223, -0.0054321289, -0.0048522949,
    -0.0040893555, -0.0031738281, -0.0021362305, -0.0010375977,
    9.1552734e-05, 0.0012207031, 0.0022583008, 0.0032348633,
    0.0040283203, 0.0046691895, 0.0050964355, 0.0053100586,
    0.0053100586, 0.005065918, 0.0046386719, 0.0039978027,
    0.0032348633, 0.0023193359, 0.0013122559, 0.00024414062,
    -0.00079345703, -0.0018310547, -0.0027770996, -0.0036010742,
    -0.0042724609, -0.0047607422, -0.005065918, -0.0051879883,
    -0.005065918, -0.0047607422, -0.0042724609, -0.0036010742,
    -0.0028076172, -0.0019226074, -0.00094604492, 3.0517578e-05,
    0.0010070801, 0.0019226074, 0.0027770996, 0.0034790039,
    0.0040283203, 0.0043945312, 0.0046081543, 0.0046081543,
    0.0044250488, 0.0040283203, 0.0035095215, 0.0028381348,
    0.0020446777, 0.001159668, 0.0002746582, -0.00064086914,
    -0.0015258789, -0.0023498535, -0.0030517578, -0.0036621094,
    -0.0040893555, -0.0043640137, -0.0044555664, -0.0043640137,
    -0.0040893555, -0.003692627, -0.003112793, -0.0024414062,
    -0.0016784668, -0.00085449219, 0, 0.00082397461, 0.0016174316,
    0.0023193359, 0.0029296875, 0.0034179688, 0.0037536621,
    0.00390625, 0.00390625, 0.0037536621, 0.0034484863,
    0.0029907227, 0.0024414062, 0.0017700195, 0.0010375977,
    0.0002746582, -0.00051879883, -0.0012512207, -0.001953125,
    -0.0025634766, -0.0030517578, -0.0034179688, -0.0036621094,
    -0.0037231445, -0.0036621094, -0.0034484863, -0.003112793,
    -0.0026245117, -0.0020751953, -0.0014343262, -0.00073242188,
    -3.0517578e-05, 0.00067138672, 0.0013122559, 0.0019226074,
    0.0024108887, 0.0028076172, 0.0030822754, 0.0032348633,
    0.0032348633, 0.003112793, 0.0028686523, 0.0025024414,
    0.0020141602, 0.0014648438, 0.00088500977, 0.00024414062,
    -0.00039672852, -0.0010070801, -0.0015563965, -0.0020446777,
    -0.0024719238, -0.0027770996, -0.0029602051, -0.0030212402,
    -0.0029602051, -0.0028076172, -0.0025024414, -0.0021362305,
    -0.0016784668, -0.001159668, -0.00061035156, -6.1035156e-05,
    0.00048828125, 0.0010375977, 0.0014953613, 0.0018920898,
    0.0022277832, 0.0024414062, 0.0025634766, 0.0025634766,
    0.0024719238, 0.0022583008, 0.0019836426, 0.0016174316,
    0.0011901855, 0.0007019043, 0.00021362305, -0.0002746582,
    -0.00076293945, -0.0011901855, -0.0015563965, -0.0018920898,
    -0.0021057129, -0.0022583008, -0.0023193359, -0.0022583008,
    -0.0021362305, -0.0019226074, -0.0016479492, -0.0012817383,
    -0.00091552734, -0.00048828125, -6.1035156e-05, 0.00036621094,
    0.00076293945, 0.0010986328, 0.0014038086, 0.0016479492,
    0.0018005371, 0.0018920898, 0.0018920898, 0.0018005371,
    0.0016479492, 0.0014343262, 0.0011901855, 0.00085449219,
    0.00051879883, 0.00018310547, -0.00018310547, -0.00051879883,
    -0.00082397461, -0.0010986328, -0.0013122559, -0.0014953613,
    -0.0015869141, -0.0016174316, -0.0015869141, -0.0014953613,
    -0.0013427734, -0.0011291504, -0.00088500977, -0.00064086914,
    -0.00033569336, -6.1035156e-05, 0.00021362305, 0.00048828125,
    0.00073242188, 0.00091552734, 0.0010681152, 0.001159668,
    0.0012207031, 0.0012207031, 0.001159668, 0.0010681152,
    0.00091552734, 0.00073242188, 0.00054931641, 0.00033569336,
    0.00012207031, -9.1552734e-05, -0.00030517578, -0.00048828125,
    -0.00064086914, -0.00076293945, -0.00085449219, -0.00091552734,
    -0.00091552734, -0.00088500977, -0.00082397461, -0.00073242188,
    -0.00061035156, -0.00048828125, -0.00033569336, -0.00018310547,
    -3.0517578e-05, 0.00012207031, 0.00024414062, 0.00033569336,
    0.00042724609, 0.00048828125, 0.00054931641, 0.00054931641,
    0.00054931641, 0.00051879883, 0.00045776367, 0.00039672852,
    0.00030517578, 0.00021362305, 0.00012207031, 6.1035156e-05,
    -3.0517578e-05, -9.1552734e-05, -0.00015258789, -0.00018310547,
    -0.00021362305, -0.00024414062, -0.00024414062, -0.00021362305,
    -0.00021362305, -0.00018310547, -0.00012207031, -9.1552734e-05,
    -6.1035156e-05, -3.0517578e-05, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,
};


static const sample_t CLICK_1_NORMAL_SAMPLES[] = {
    0, -0.014312744, -0.03338623, 0.019165039, 0.042541504,
    0.08984375, 0.082611084, 0.13909912, 0.17236328,
    0.19238281, 0.21087646, 0.22238159, 0.23114014,
    0.23321533, 0.23080444, 0.222229, 0.20944214,
    0.19146729, 0.16964722, 0.14352417, 0.11450195,
    0.082489014, 0.049316406, 0.014068604, -0.020507812,
    -0.055969238, -0.089233398, -0.1211853, -0.15036011,
    -0.1763916, -0.19882202, -0.2170105, -0.23062134,
    -0.23916626, -0.24279785, -0.24142456, -0.23483276,
    -0.22357178, -0.2074585, -0.18701172, -0.16308594,
    -0.1355896, -0.10562134, -0.073547363, -0.040100098,
    -0.0061645508, 0.027618408, 0.060394287, 0.091796875,
    0.12072754, 0.14685059, 0.16949463, 0.18804932,
    0.20245361, 0.21212769, 0.21694946, 0.21691895,
    0.21191406, 0.20214844, 0.18786621, 0.16943359,
    0.14706421, 0.12145996, 0.093139648, 0.06262207,
    0.030822754, -0.0018310547, -0.034545898, -0.066467285,
    -0.097076416, -0.12564087, -0.15155029, -0.17422485,
    -0.19326782, -0.20812988, -0.21862793, -0.22457886,
    -0.22567749, -0.22210693, -0.21392822, -0.20120239,
    -0.18438721, -0.16381836, -0.13986206, -0.11315918,
    -0.084289551, -0.053771973, -0.02243042, 0.0090942383,
    0.040252686, 0.07019043, 0.098297119, 0.12408447,
    0.14685059, 0.16616821, 0.18170166, 0.19302368,
    0.19985962, 0.20230103, 0.20007324, 0.19329834,
    0.18231201, 0.16711426, 0.14819336, 0.1260376,
    0.10095215, 0.073608398, 0.044647217, 0.01461792,
    -0.015808105, -0.04586792, -0.075073242, -0.10272217,
    -0.12811279, -0.15084839, -0.17041016, -0.1862793,
    -0.19827271, -0.20602417, -0.20941162, -0.20846558,
    -0.203125, -0.19348145, -0.17990112, -0.16259766,
    -0.14190674, -0.11846924, -0.092651367, -0.065002441,
    -0.0362854, -0.0069885254, 0.022247314, 0.05065918,
    0.077758789, 0.10296631, 0.12561035, 0.14532471,
    0.16171265, 0.17428589, 0.18289185, 0.18737793,
    0.18756104, 0.18353271, 0.17541504, 0.16329956,
    0.14755249, 0.12854004, 0.10656738, 0.082244873,
    0.056091309, 0.028594971, 0.00045776367, -0.027709961,
    -0.055419922, -0.08190918, -0.10665894, -0.12924194,
    -0.14901733, -0.1656189, -0.17877197, -0.18811035,
    -0.19342041, -0.19473267, -0.19189453, -0.18505859,
    -0.17440796, -0.16009521, -0.14245605, -0.12203979,
    -0.099121094, -0.07421875, -0.048034668, -0.020935059,
    0.0063781738, 0.033233643, 0.059234619, 0.083709717,
    0.1060791, 0.12600708, 0.14294434, 0.15655518,
    0.16662598, 0.17288208, 0.1751709, 0.17355347,
    0.16802979, 0.15866089, 0.14581299, 0.12966919,
    0.1105957, 0.089080811, 0.065551758, 0.040466309,
    0.014556885, -0.011779785, -0.037963867, -0.063293457,
    -0.087341309, -0.10958862, -0.12942505, -0.14654541,
    -0.16061401, -0.1711731, -0.17816162, -0.18145752,
    -0.18081665, -0.17642212, -0.16836548, -0.15673828,
    -0.14193726, -0.12426758, -0.10400391, -0.081695557,
    -0.057891846, -0.032928467, -0.0075073242, 0.017791748,
    0.042602539, 0.066192627, 0.088134766, 0.10803223,
    0.12530518, 0.13967896, 0.15087891, 0.15859985,
    0.16265869, 0.16311646, 0.15982056, 0.1529541,
    0.14273071, 0.12921143, 0.11282349, 0.093963623,
    0.072967529, 0.050323486, 0.026580811, 0.002166748,
    -0.022369385, -0.046356201, -0.069458008, -0.091094971,
    -0.11071777, -0.12808228, -0.1427002, -0.15420532,
    -0.16253662, -0.16741943, -0.16867065, -0.16647339,
    -0.1607666, -0.15164185, -0.13946533, -0.12438965,
    -0.10675049, -0.087036133, -0.065582275, -0.042877197,
    -0.019500732, 0.004119873, 0.027496338, 0.049957275,
    0.071228027, 0.090759277, 0.10803223, 0.12283325,
    0.13482666, 0.14364624, 0.14923096, 0.15145874,
    0.150177, 0.14556885, 0.13772583, 0.1267395, 0.11294556,
    0.096679688, 0.078155518, 0.057952881, 0.036499023,
    0.014099121, -0.0085449219, -0.031066895, -0.052978516,
    -0.073730469, -0.092895508, -0.11013794, -0.125,
    -0.13717651, -0.14648438, -0.15264893, -0.15557861,
    -0.15527344, -0.15164185, -0.14486694, -0.13510132,
    -0.12252808, -0.10742188, -0.090240479, -0.07119751,
    -0.05078125, -0.029510498, -0.0077514648, 0.014007568,
    0.035186768, 0.055480957, 0.074401855, 0.091430664,
    0.10638428, 0.11880493, 0.128479, 0.13525391,
    0.13891602, 0.1394043, 0.1368103, 0.13113403,
    0.12246704, 0.11114502, 0.097320557, 0.081268311,
    0.06350708, 0.044281006, 0.024017334, 0.0032958984,
    -0.017578125, -0.038116455, -0.057769775, -0.07623291,
    -0.093109131, -0.10791016, -0.12045288, -0.13046265,
    -0.13763428, -0.14190674, -0.14321899, -0.14141846,
    -0.13674927, -0.12921143, -0.11895752, -0.10629272,
    -0.091491699, -0.074798584, -0.05670166, -0.037536621,
    -0.017700195, 0.0022888184, 0.022033691, 0.04119873,
    0.059234619, 0.075805664, 0.090606689, 0.10324097,
    0.11346436, 0.12112427, 0.12594604, 0.12796021,
    0.12710571, 0.12335205, 0.11682129, 0.10772705,
    0.096191406, 0.082519531, 0.067077637, 0.050079346,
    0.031982422, 0.013244629, -0.0058898926, -0.024902344,
    -0.043334961, -0.060882568, -0.077148438, -0.091674805,
    -0.10430908, -0.11471558, -0.12261963, -0.12799072,
    -0.13061523, -0.13043213, -0.12759399, -0.12203979,
    -0.11392212, -0.10351562, -0.0909729, -0.076568604,
    -0.060699463, -0.043640137, -0.025787354, -0.0075683594,
    0.010650635, 0.028503418, 0.045532227, 0.061431885,
    0.075836182, 0.088409424, 0.098968506, 0.10720825,
    0.11297607, 0.11621094, 0.11682129, 0.11471558,
    0.11010742, 0.10305786, 0.093658447, 0.082214355,
    0.068969727, 0.054138184, 0.038146973, 0.021331787,
    0.0039978027, -0.013397217, -0.030517578, -0.047027588,
    -0.062469482, -0.076568604, -0.089080811, -0.099609375,
    -0.10803223, -0.11419678, -0.1178894, -0.11907959,
    -0.11779785, -0.11398315, -0.1078186, -0.099456787,
    -0.089019775, -0.076751709, -0.063018799, -0.047973633,
    -0.032073975, -0.015655518, 0.0010070801, 0.017456055,
    0.033355713, 0.048431396, 0.062286377, 0.074615479,
    0.085235596, 0.09387207, 0.10031128, 0.10449219,
    0.10629272, 0.10565186, 0.10272217, 0.097442627,
    0.089996338, 0.080566406, 0.069366455, 0.05657959,
    0.042633057, 0.027679443, 0.012115479, -0.003692627,
    -0.01940918, -0.034759521, -0.049316406, -0.062835693,
    -0.075012207, -0.085510254, -0.094238281, -0.10095215,
    -0.10543823, -0.10775757, -0.10778809, -0.10552979,
    -0.10107422, -0.094512939, -0.085968018, -0.075714111,
    -0.063934326, -0.050842285, -0.036834717, -0.022125244,
    -0.0070800781, 0.0079650879, 0.022705078, 0.036865234,
    0.050018311, 0.061981201, 0.072479248, 0.081268311,
    0.088165283, 0.093109131, 0.095855713, 0.096466064,
    0.094940186, 0.091247559, 0.085510254, 0.077911377,
    0.06854248, 0.057678223, 0.045593262, 0.032440186,
    0.018585205, 0.0043640137, -0.010009766, -0.024169922,
    -0.037750244, -0.050567627, -0.062286377, -0.072631836,
    -0.081451416, -0.088500977, -0.093658447, -0.096862793,
    -0.097961426, -0.097015381, -0.094024658, -0.089080811,
    -0.082275391, -0.073791504, -0.063812256, -0.052520752,
    -0.040252686, -0.027191162, -0.013641357, 0,
    0.013580322, 0.026733398, 0.039154053, 0.050628662,
    0.060913086, 0.069702148, 0.076934814, 0.082366943,
    0.085906982, 0.087524414, 0.087158203, 0.08480835,
    0.080627441, 0.074615479, 0.066925049, 0.057800293,
    0.047393799, 0.035888672, 0.023651123, 0.010894775,
    -0.0021362305, -0.015106201, -0.027740479, -0.039825439,
    -0.050994873, -0.061096191, -0.069885254, -0.077148438,
    -0.082763672, -0.086669922, -0.088684082, -0.088806152,
    -0.087097168, -0.083526611, -0.07824707, -0.071350098,
    -0.062957764, -0.053314209, -0.042633057, -0.031066895,
    -0.018981934, -0.0065917969, 0.0058288574, 0.018035889,
    0.029693604, 0.040649414, 0.050628662, 0.059356689,
    0.066741943, 0.072570801, 0.076721191, 0.079162598,
    0.079772949, 0.078613281, 0.075714111, 0.071105957,
    0.064880371, 0.057281494, 0.048400879, 0.038421631,
    0.027618408, 0.016204834, 0.0043945312, -0.0074768066,
    -0.019195557, -0.030548096, -0.041168213, -0.050964355,
    -0.059661865, -0.067047119, -0.072998047, -0.077453613,
    -0.080169678, -0.081237793, -0.080596924, -0.078216553,
    -0.074249268, -0.068725586, -0.061767578, -0.05355835,
    -0.044281006, -0.034088135, -0.023284912, -0.012084961,
    -0.00067138672, 0.010650635, 0.021606445, 0.032043457,
    0.041687012, 0.050292969, 0.057769775, 0.063903809,
    0.06854248, 0.071655273, 0.073120117, 0.072937012,
    0.071166992, 0.067749023, 0.062835693, 0.056549072,
    0.048980713, 0.040313721, 0.030792236, 0.020568848,
    0.0098571777, -0.0010375977, -0.011932373, -0.022613525,
    -0.032745361, -0.042236328, -0.050811768, -0.058288574,
    -0.064544678, -0.069396973, -0.072784424, -0.074645996,
    -0.074890137, -0.073547363, -0.070709229, -0.066375732,
    -0.060638428, -0.05368042, -0.045593262, -0.036590576,
    -0.026916504, -0.016693115, -0.0061950684, 0.0043334961,
    0.014709473, 0.024688721, 0.0340271, 0.042572021,
    0.050109863, 0.05645752, 0.061553955, 0.065246582,
    0.06741333, 0.068115234, 0.067260742, 0.064880371,
    0.061065674, 0.055908203, 0.049468994, 0.04196167,
    0.033508301, 0.024291992, 0.014556885, 0.004486084,
    -0.0057067871, -0.015777588, -0.025512695, -0.034759521,
    -0.043212891, -0.050750732, -0.057250977, -0.062469482,
    -0.066375732, -0.068908691, -0.069915771, -0.069488525,
    -0.067596436, -0.064239502, -0.05960083, -0.053710938,
    -0.046691895, -0.038726807, -0.029998779, -0.020690918,
    -0.011016846, -0.001159668, 0.0086364746, 0.018188477,
    0.027252197, 0.035675049, 0.043243408, 0.04977417,
    0.055175781, 0.059326172, 0.062103271, 0.063537598,
    0.063476562, 0.062011719, 0.059173584, 0.054992676,
    0.049591064, 0.043121338, 0.035675049, 0.027404785,
    0.018554688, 0.0092468262, -0.00024414062,
    -0.0097351074, -0.019042969, -0.027954102, -0.036254883,
    -0.043792725, -0.050415039, -0.055938721, -0.060272217,
    -0.063323975, -0.065032959, -0.065368652, -0.064300537,
    -0.061889648, -0.058197021, -0.053283691, -0.047241211,
    -0.040283203, -0.032470703, -0.024017334, -0.015136719,
    -0.0059814453, 0.0032653809, 0.012329102, 0.021087646,
    0.029327393, 0.036834717, 0.043487549, 0.049133301,
    0.053649902, 0.056945801, 0.058959961, 0.059631348,
    0.058990479, 0.057006836, 0.053741455, 0.049316406,
    0.043762207, 0.037231445, 0.029876709, 0.021881104,
    0.013366699, 0.0045471191, -0.0043640137, -0.013214111,
    -0.021759033, -0.029876709, -0.037353516, -0.044006348,
    -0.049743652, -0.054412842, -0.057922363, -0.060180664,
    -0.061187744, -0.060913086, -0.059295654, -0.056488037,
    -0.052459717, -0.047363281, -0.041290283, -0.034362793,
    -0.026733398, -0.018615723, -0.010131836, -0.0014953613,
    0.0070800781, 0.01550293, 0.023498535, 0.030883789,
    0.037597656, 0.043426514, 0.048217773, 0.051940918,
    0.054473877, 0.055786133, 0.055847168, 0.054656982,
    0.052215576, 0.04864502, 0.04397583, 0.038330078,
    0.031829834, 0.024627686, 0.016845703, 0.0087280273,
    0.00039672852, -0.0079650879, -0.016143799,
    -0.024017334, -0.03137207, -0.038024902, -0.043914795,
    -0.048828125, -0.052703857, -0.055480957, -0.057067871,
    -0.057434082, -0.05657959, -0.05456543, -0.051361084,
    -0.047119141, -0.041900635, -0.035797119, -0.028961182,
    -0.021575928, -0.013763428, -0.0057067871, 0.0023803711,
    0.010406494, 0.018127441, 0.025390625, 0.032073975,
    0.037994385, 0.043029785, 0.047088623, 0.050048828,
    0.0519104, 0.052581787, 0.052093506, 0.050415039,
    0.047637939, 0.043792725, 0.03894043, 0.03326416,
    0.026824951, 0.019775391, 0.012329102, 0.0045776367,
    -0.0032958984, -0.011108398, -0.018676758, -0.025878906,
    -0.032501221, -0.038421631, -0.043548584, -0.047729492,
    -0.05090332, -0.053009033, -0.053955078, -0.053771973,
    -0.052459717, -0.050018311, -0.046539307, -0.042114258,
    -0.036773682, -0.030731201, -0.024047852, -0.016876221,
    -0.0094299316, -0.0018005371, 0.0058288574, 0.013244629,
    0.020324707, 0.026916504, 0.032867432, 0.03805542,
    0.042388916, 0.04574585, 0.048034668, 0.049285889,
    0.049407959, 0.048400879, 0.046356201, 0.043243408,
    0.03918457, 0.034240723, 0.028533936, 0.022216797,
    0.015380859, 0.0082092285, 0.00082397461, -0.0065612793,
    -0.013824463, -0.020812988, -0.02734375, -0.033294678,
    -0.038543701, -0.042938232, -0.046478271, -0.048980713,
    -0.050445557, -0.050842285, -0.050170898, -0.048431396,
    -0.045684814, -0.041992188, -0.037384033, -0.032073975,
    -0.026062012, -0.01953125, -0.012634277, -0.0055236816,
    0.0016784668, 0.0087890625, 0.015655518, 0.022125244,
    0.028076172, 0.033355713, 0.037902832, 0.041534424,
    0.044250488, 0.045959473, 0.046630859, 0.046264648,
    0.04486084, 0.042419434, 0.039093018, 0.034851074,
    0.029846191, 0.024200439, 0.018005371, 0.011383057,
    0.0045166016, -0.0024719238, -0.0093994141,
    -0.016143799, -0.022521973, -0.0284729, -0.033752441,
    -0.038360596, -0.042144775, -0.045013428, -0.046936035,
    -0.047851562, -0.04776001, -0.046630859, -0.044555664,
    -0.041534424, -0.037628174, -0.032989502, -0.027618408,
    -0.021728516, -0.015411377, -0.0087585449,
    -0.0020141602, 0.0047607422, 0.011383057, 0.017700195,
    0.023590088, 0.028930664, 0.033569336, 0.037475586,
    0.040527344, 0.042633057, 0.043792725, 0.04397583,
    0.043151855, 0.041381836, 0.038696289, 0.035125732,
    0.030792236, 0.025756836, 0.020172119, 0.014099121,
    0.0077514648, 0.0011901855, -0.0053710938, -0.01184082,
    -0.018066406, -0.023925781, -0.02923584, -0.033966064,
    -0.037963867, -0.041107178, -0.043426514, -0.044799805,
    -0.045196533, -0.044677734, -0.043182373, -0.040802002,
    -0.037567139, -0.033538818, -0.028808594, -0.023498535,
    -0.017730713, -0.01159668, -0.005279541, 0.0011291504,
    0.0074768066, 0.013580322, 0.019378662, 0.024719238,
    0.02947998, 0.033538818, 0.036865234, 0.039306641,
    0.040893555, 0.041564941, 0.041290283, 0.040100098,
    0.038024902, 0.035064697, 0.031341553, 0.026947021,
    0.021942139, 0.016418457, 0.0105896, 0.0044555664,
    -0.001739502, -0.0079345703, -0.013946533, -0.019683838,
    -0.024963379, -0.029754639, -0.033905029, -0.03729248,
    -0.039916992, -0.041687012, -0.042572021, -0.042541504,
    -0.041625977, -0.039794922, -0.03717041, -0.033752441,
    -0.029632568, -0.024902344, -0.019683838, -0.014038086,
    -0.0081787109, -0.0021362305, 0.00390625, 0.0097961426,
    0.015472412, 0.020751953, 0.025512695, 0.029724121,
    0.033233643, 0.036010742, 0.037963867, 0.039031982,
    0.039245605, 0.038574219, 0.03704834, 0.034698486,
    0.031585693, 0.027740479, 0.02331543, 0.018341064,
    0.012969971, 0.0073242188, 0.0014953613, -0.0043640137,
    -0.010162354, -0.015716553, -0.020965576, -0.025756836,
    -0.029968262, -0.033569336, -0.036468506, -0.038543701,
    -0.039825439, -0.040283203, -0.039825439, -0.038574219,
    -0.036499023, -0.033630371, -0.030090332, -0.025939941,
    -0.021240234, -0.016113281, -0.010681152, -0.0050354004,
    0.00067138672, 0.0063171387, 0.011810303, 0.016998291,
    0.021759033, 0.026031494, 0.029724121, 0.032684326,
    0.034942627, 0.036407471, 0.03704834, 0.036865234,
    0.035858154, 0.0340271, 0.031463623, 0.028198242,
    0.024291992, 0.019866943, 0.014984131, 0.0097961426,
    0.0043640137, -0.0011901855, -0.0066833496,
    -0.012054443, -0.017181396, -0.021942139, -0.0262146,
    -0.029937744, -0.03302002, -0.035400391, -0.037017822,
    -0.037841797, -0.037872314, -0.037109375, -0.035552979,
    -0.033233643, -0.03024292, -0.026611328, -0.02243042,
    -0.017791748, -0.012817383, -0.0075683594,
    -0.0022277832, 0.0031433105, 0.0084228516, 0.013458252,
    0.018188477, 0.022491455, 0.026245117, 0.029418945,
    0.031921387, 0.033691406, 0.034729004, 0.034973145,
    0.034423828, 0.033111572, 0.031066895, 0.028320312,
    0.024932861, 0.021026611, 0.01663208, 0.011871338,
    0.0068664551, 0.0016784668, -0.0035400391,
    -0.0086669922, -0.013641357, -0.018310547, -0.022613525,
    -0.026428223, -0.029632568, -0.032226562, -0.03414917,
    -0.035339355, -0.035766602, -0.035430908, -0.034362793,
    -0.032531738, -0.030059814, -0.026947021, -0.023284912,
    -0.019134521, -0.014587402, -0.009765625, -0.0047912598,
    0.00030517578, 0.0053405762, 0.010192871, 0.014831543,
    0.019104004, 0.022918701, 0.0262146, 0.028930664,
    0.030944824, 0.032318115, 0.032928467, 0.032806396,
    0.031951904, 0.030395508, 0.028137207, 0.025268555,
    0.021850586, 0.017944336, 0.013641357, 0.0090332031,
    0.0042114258, -0.0007019043, -0.0056152344,
    -0.010406494, -0.014953613, -0.019195557, -0.023040771,
    -0.026367188, -0.029144287, -0.031280518, -0.032775879,
    -0.033538818, -0.033630371, -0.032958984, -0.031646729,
    -0.029632568, -0.027008057, -0.023803711, -0.020141602,
    -0.016052246, -0.011627197, -0.007019043, -0.0022583008,
    0.0025024414, 0.0072021484, 0.011688232, 0.015899658,
    0.019744873, 0.023132324, 0.025970459, 0.02822876,
    0.029846191, 0.030792236, 0.031036377, 0.030609131,
    0.02947998, 0.027679443, 0.025299072, 0.022338867,
    0.018890381, 0.015045166, 0.01083374, 0.0063781738,
    0.0018005371, -0.0028381348, -0.0073852539,
    -0.011810303, -0.015991211, -0.019805908, -0.023193359,
    -0.026092529, -0.028442383, -0.030181885, -0.031280518,
    -0.031677246, -0.031433105, -0.030517578, -0.028961182,
    -0.026794434, -0.024078369, -0.020843506, -0.017181396,
    -0.013183594, -0.0089416504, -0.0045166016,
    -3.0517578e-05, 0.0044555664, 0.0087890625, 0.012908936,
    0.016723633, 0.020141602, 0.023071289, 0.025512695,
    0.02734375, 0.028564453, 0.029174805, 0.02911377,
    0.028381348, 0.027038574, 0.025085449, 0.022583008,
    0.019561768, 0.016143799, 0.012329102, 0.0082702637,
    0.0040283203, -0.00033569336, -0.0046691895,
    -0.0089111328, -0.012969971, -0.01675415, -0.020172119,
    -0.023162842, -0.025634766, -0.027557373, -0.028930664,
    -0.029663086, -0.029754639, -0.02923584, -0.028076172,
    -0.02633667, -0.024047852, -0.021240234, -0.018005371,
    -0.014434814, -0.010528564, -0.006439209, -0.0022583008,
    0.0019836426, 0.0061340332, 0.010101318, 0.01385498,
    0.017272949, 0.020294189, 0.022857666, 0.024871826,
    0.02633667, 0.02722168, 0.027496338, 0.027130127,
    0.026184082, 0.024658203, 0.02255249, 0.019989014,
    0.016967773, 0.013549805, 0.0098571777, 0.0059509277,
    0.0018920898, -0.0021972656, -0.0062561035,
    -0.010162354, -0.01385498, -0.017272949, -0.020294189,
    -0.022888184, -0.024993896, -0.026550293, -0.027557373,
    -0.027954102, -0.027770996, -0.027008057, -0.025665283,
    -0.023773193, -0.021392822, -0.018585205, -0.015380859,
    -0.01184082, -0.0080871582, -0.0042114258,
    -0.00021362305, 0.0037231445, 0.0075378418, 0.011199951,
    0.014587402, 0.01763916, 0.020263672, 0.02243042,
    0.024108887, 0.025238037, 0.025756836, 0.025756836,
    0.025146484, 0.023986816, 0.02230835, 0.020141602,
    0.017486572, 0.01449585, 0.011169434, 0.0075683594,
    0.0038146973, 0, -0.0038452148, -0.007598877,
    -0.011169434, -0.014526367, -0.017578125, -0.020233154,
    -0.022460938, -0.024200439, -0.025421143, -0.026123047,
    -0.026245117, -0.025787354, -0.024810791, -0.02331543,
    -0.021331787, -0.018890381, -0.016052246, -0.012908936,
    -0.0094909668, -0.0058898926, -0.0021972656,
    0.0015258789, 0.0051879883, 0.0087280273, 0.012054443,
    0.015075684, 0.01776123, 0.020019531, 0.021850586,
    0.023193359, 0.023986816, 0.024261475, 0.023986816,
    0.023162842, 0.021850586, 0.020050049, 0.017791748,
    0.015136719, 0.012176514, 0.0089111328, 0.0054931641,
    0.0019226074, -0.0016784668, -0.0052490234,
    -0.0087280273, -0.011993408, -0.014984131, -0.017700195,
    -0.019989014, -0.021881104, -0.023284912, -0.024200439,
    -0.024597168, -0.024475098, -0.023834229, -0.022674561,
    -0.021026611, -0.018981934, -0.01651001, -0.013702393,
    -0.010620117, -0.0073242188, -0.00390625,
    -0.00042724609, 0.0030517578, 0.006439209, 0.0096740723,
    0.012664795, 0.015350342, 0.017700195, 0.019622803,
    0.021118164, 0.022125244, 0.022644043, 0.022674561,
    0.022155762, 0.021179199, 0.019714355, 0.017822266,
    0.015563965, 0.012908936, 0.010009766, 0.0068664551,
    0.0036010742, 0.00021362305, -0.0031433105,
    -0.0064697266, -0.0096130371, -0.012573242,
    -0.015258789, -0.01763916, -0.019592285, -0.021148682,
    -0.022277832, -0.022888184, -0.023040771, -0.022674561,
    -0.021850586, -0.020568848, -0.018829346, -0.016723633,
    -0.014251709, -0.011505127, -0.0085144043,
    -0.0053710938, -0.0021362305, 0.001159668, 0.0043640137,
    0.0074768066, 0.010406494, 0.013061523, 0.015441895,
    0.017456055, 0.019073486, 0.020263672, 0.020996094,
    0.021270752, 0.021057129, 0.020385742, 0.019226074,
    0.017669678, 0.01574707, 0.013427734, 0.01083374,
    0.008026123, 0.0050048828, 0.0018920898, -0.0012512207,
    -0.0043945312, -0.0074462891, -0.010314941,
    -0.012969971, -0.015350342, -0.01739502, -0.019073486,
    -0.020324707, -0.021148682, -0.021514893, -0.02142334,
    -0.020874023, -0.019897461, -0.018493652, -0.016723633,
    -0.014587402, -0.012145996, -0.0094604492,
    -0.0065917969, -0.0036010742, -0.00054931641,
    0.0025024414, 0.0054626465, 0.0083007812, 0.010925293,
    0.013305664, 0.015380859, 0.017089844, 0.0184021,
    0.019317627, 0.019805908, 0.019836426, 0.019439697,
    0.018585205, 0.017333984, 0.015716553, 0.01373291,
    0.011444092, 0.0089111328, 0.0061950684, 0.003326416,
    0.00039672852, -0.0025634766, -0.0054321289,
    -0.0082092285, -0.010803223, -0.013183594, -0.015258789,
    -0.016998291, -0.018371582, -0.019378662, -0.019958496,
    -0.020080566, -0.019805908, -0.019104004, -0.018005371,
    -0.01651001, -0.014709473, -0.012573242, -0.010162354,
    -0.007598877, -0.0048522949, -0.0020141602,
    0.00082397461, 0.0036315918, 0.0063476562, 0.0089111328,
    0.011260986, 0.013336182, 0.015106201, 0.016571045,
    0.017608643, 0.018280029, 0.01852417, 0.018371582,
    0.017791748, 0.016845703, 0.01550293, 0.013824463,
    0.01184082, 0.0096130371, 0.0071411133, 0.0045471191,
    0.0018310547, -0.00091552734, -0.0036315918,
    -0.0062866211, -0.0087890625, -0.011108398,
    -0.013214111, -0.015014648, -0.016479492, -0.017578125,
    -0.018341064, -0.018676758, -0.018615723, -0.018188477,
    -0.017333984, -0.016143799, -0.01461792, -0.012786865,
    -0.010681152, -0.0083618164, -0.005859375,
    -0.0032958984, -0.00064086914, 0.0020141602,
    0.0045776367, 0.0070495605, 0.0093383789, 0.011413574,
    0.013214111, 0.01473999, 0.015899658, 0.016723633,
    0.017150879, 0.017211914, 0.016876221, 0.016174316,
    0.015106201, 0.01373291, 0.012023926, 0.010070801,
    0.0078735352, 0.0055236816, 0.0030517578, 0.00051879883,
    -0.0020446777, -0.0045471191, -0.0069580078,
    -0.0092163086, -0.011260986, -0.013061523, -0.014587402,
    -0.015808105, -0.016693115, -0.017211914, -0.017364502,
    -0.017150879, -0.016540527, -0.015625, -0.014343262,
    -0.012786865, -0.010955811, -0.0089111328,
    -0.0066833496, -0.0043334961, -0.0018920898,
    0.00057983398, 0.0029907227, 0.0053405762, 0.0075683594,
    0.0096130371, 0.011413574, 0.012969971, 0.014221191,
    0.015167236, 0.01574707, 0.015991211, 0.015869141,
    0.015411377, 0.014587402, 0.013458252, 0.012023926,
    0.010345459, 0.0084228516, 0.0063171387, 0.0040588379,
    0.001739502, -0.00061035156, -0.0029602051,
    -0.0052490234, -0.0074157715, -0.0094299316,
    -0.011230469, -0.012786865, -0.014068604, -0.015045166,
    -0.015716553, -0.016021729, -0.015991211, -0.015655518,
    -0.014953613, -0.013946533, -0.012634277, -0.011077881,
    -0.0092773438, -0.0072937012, -0.0051574707,
    -0.0029602051, -0.00067138672, 0.0015869141,
    0.0038146973, 0.0059204102, 0.0079040527, 0.0097045898,
    0.011260986, 0.012573242, 0.01361084, 0.014312744,
    0.014709473, 0.014770508, 0.01449585, 0.013916016,
    0.013031006, 0.01184082, 0.010406494, 0.0087585449,
    0.0068969727, 0.0048828125, 0.0027770996, 0.00061035156,
    -0.0015869141, -0.0037231445, -0.0057983398,
    -0.0077514648, -0.0094909668, -0.011077881,
    -0.012390137, -0.013427734, -0.014221191, -0.014678955,
    -0.014801025, -0.014648438, -0.014160156, -0.013366699,
    -0.012329102, -0.010986328, -0.0094604492,
    -0.0077209473, -0.0058288574, -0.0038146973,
    -0.001739502, 0.00036621094, 0.0024414062, 0.0044250488,
    0.0063476562, 0.0080871582, 0.0096435547, 0.010986328,
    0.012054443, 0.0128479, 0.013397217, 0.01361084,
    0.013519287, 0.013153076, 0.012481689, 0.011505127,
    0.010314941, 0.0088806152, 0.0072631836, 0.0054931641,
    0.0036010742, 0.0016174316, -0.00039672852,
    -0.0023803711, -0.0043334961, -0.0061645508,
    -0.0079040527, -0.0094299316, -0.010772705,
    -0.011871338, -0.01272583, -0.013275146, -0.013580322,
    -0.013580322, -0.013275146, -0.012695312, -0.011871338,
    -0.010772705, -0.0094604492, -0.0079650879,
    -0.0062866211, -0.004486084, -0.0026245117,
    -0.0007019043, 0.0012207031, 0.003112793, 0.0049133301,
    0.0065917969, 0.0080871582, 0.0094299316, 0.010559082,
    0.011413574, 0.012054443, 0.012390137, 0.012451172,
    0.012268066, 0.011779785, 0.011047363, 0.010070801,
    0.0088500977, 0.0074768066, 0.0059204102, 0.0042114258,
    0.0024414062, 0.00061035156, -0.0012207031,
    -0.0030212402, -0.0047607422, -0.0064086914,
    -0.0079040527, -0.0092163086, -0.010345459,
    -0.011260986, -0.011901855, -0.012298584, -0.012451172,
    -0.012298584, -0.011901855, -0.011260986, -0.010406494,
    -0.0093078613, -0.008026123, -0.0065612793,
    -0.0049743652, -0.0032958984, -0.0015563965,
    0.00018310547, 0.0019226074, 0.0036010742, 0.0052185059,
    0.0066833496, 0.0079956055, 0.0091247559, 0.010040283,
    0.01071167, 0.011169434, 0.011352539, 0.011322021,
    0.010986328, 0.010437012, 0.0096740723, 0.0086669922,
    0.0075073242, 0.0061645508, 0.0046691895, 0.003112793,
    0.0014648438, -0.00021362305, -0.0018920898,
    -0.0035095215, -0.0050354004, -0.0064697266,
    -0.0077514648, -0.0088806152, -0.0098266602,
    -0.010528564, -0.011016846, -0.011260986, -0.011260986,
    -0.011047363, -0.0105896, -0.0098876953, -0.0090026855,
    -0.0079040527, -0.0066833496, -0.005279541,
    -0.0038146973, -0.0022583008, -0.00067138672,
    0.00091552734, 0.0024719238, 0.0039672852, 0.0053710938,
    0.0066223145, 0.0077514648, 0.0086669922, 0.0093994141,
    0.0099182129, 0.010223389, 0.010314941, 0.010131836,
    0.009765625, 0.0091552734, 0.0083618164, 0.0073852539,
    0.0062255859, 0.0049438477, 0.0035705566, 0.0021057129,
    0.00061035156, -0.00088500977, -0.0023803711,
    -0.0038146973, -0.0051574707, -0.0064086914,
    -0.0075073242, -0.0084228516, -0.009185791,
    -0.0097351074, -0.010070801, -0.010192871, -0.010101318,
    -0.0097961426, -0.0092773438, -0.0085449219,
    -0.0076599121, -0.0066223145, -0.0054321289,
    -0.0041503906, -0.0027770996, -0.001373291,
    6.1035156e-05, 0.0014953613, 0.0028686523, 0.0041809082,
    0.0053710938, 0.006439209, 0.0073852539, 0.0081481934,
    0.0086975098, 0.0090942383, 0.0092468262, 0.0092163086,
    0.008972168, 0.0085449219, 0.0079040527, 0.0071105957,
    0.0061645508, 0.005065918, 0.0038757324, 0.0025939941,
    0.0012817383, -9.1552734e-05, -0.0014343262,
    -0.002746582, -0.0039978027, -0.0051574707,
    -0.0062255859, -0.0071105957, -0.0078735352,
    -0.0084533691, -0.0088806152, -0.0090637207,
    -0.0090942383, -0.0089111328, -0.0085449219,
    -0.0079956055, -0.0072937012, -0.006439209,
    -0.0054321289, -0.0043334961, -0.0031433105,
    -0.0018920898, -0.00061035156, 0.00067138672,
    0.0019226074, 0.003112793, 0.0042419434, 0.0052490234,
    0.0061645508, 0.0069274902, 0.0075073242, 0.0079345703,
    0.0081787109, 0.0082397461, 0.0081176758, 0.0078125,
    0.0073547363, 0.0067138672, 0.0059509277, 0.0050354004,
    0.0040283203, 0.0029296875, 0.0017700195, 0.00057983398,
    -0.00064086914, -0.0018310547, -0.0029602051,
    -0.0040283203, -0.0050354004, -0.0058898926,
    -0.006652832, -0.007232666, -0.0076904297,
    -0.0079650879, -0.0080566406, -0.0079956055,
    -0.0077514648, -0.0073547363, -0.0068054199,
    -0.0061035156, -0.005279541, -0.0043334961,
    -0.003326416, -0.0022583008, -0.0011291504, 0,
    0.0010986328, 0.0021972656, 0.0032348633, 0.0041809082,
    0.0050354004, 0.0057678223, 0.0063476562, 0.0068054199,
    0.0071105957, 0.007232666, 0.007232666, 0.0070495605,
    0.0067138672, 0.0062255859, 0.0056152344, 0.0048522949,
    0.0040283203, 0.0030822754, 0.0021057129, 0.0010681152,
    0, -0.0010375977, -0.0020751953, -0.0030517578,
    -0.0039367676, -0.0047607422, -0.0054626465,
    -0.006072998, -0.0065307617, -0.0068359375,
    -0.007019043, -0.007019043, -0.0068969727,
    -0.0066223145, -0.0061950684, -0.005645752,
    -0.0049743652, -0.0042114258, -0.0033874512,
    -0.0024719238, -0.0014953613, -0.00051879883,
    0.00045776367, 0.0014038086, 0.0023193359, 0.0032043457,
    0.0039672852, 0.0046691895, 0.0052490234, 0.0057067871,
    0.0060424805, 0.0062255859, 0.0062866211, 0.0061950684,
    0.0059814453, 0.0056152344, 0.0051269531, 0.0045471191,
    0.0038757324, 0.003112793, 0.0022888184, 0.0014038086,
    0.00048828125, -0.00042724609, -0.0013122559,
    -0.002166748, -0.0029907227, -0.0037231445,
    -0.0043945312, -0.0049438477, -0.0054016113,
    -0.0057373047, -0.0059509277, -0.0060424805,
    -0.0059814453, -0.0057983398, -0.0054931641,
    -0.0050964355, -0.0045776367, -0.0039672852,
    -0.0032653809, -0.002532959, -0.001739502,
    -0.00088500977, -6.1035156e-05, 0.00076293945,
    0.0015869141, 0.0023498535, 0.0030517578, 0.0036621094,
    0.0042114258, 0.0046386719, 0.0050048828, 0.0052185059,
    0.0053100586, 0.0053100586, 0.0051879883, 0.0049133301,
    0.0045776367, 0.004119873, 0.0036010742, 0.0029602051,
    0.0022888184, 0.0015869141, 0.00082397461,
    6.1035156e-05, -0.0007019043, -0.0014343262,
    -0.002166748, -0.0028076172, -0.0033874512, -0.00390625,
    -0.0043334961, -0.0046691895, -0.0049133301,
    -0.0050354004, -0.0050354004, -0.0049438477,
    -0.0047302246, -0.0044555664, -0.0040588379,
    -0.0035705566, -0.0030517578, -0.0024414062,
    -0.0018005371, -0.0010986328, -0.00042724609,
    0.0002746582, 0.00094604492, 0.0016174316, 0.0022277832,
    0.0027770996, 0.0032653809, 0.0036621094, 0.0039978027,
    0.0042114258, 0.0043334961, 0.0043945312, 0.0043334961,
    0.0041809082, 0.0039367676, 0.0036010742, 0.0031738281,
    0.0027160645, 0.002166748, 0.0016174316, 0.0010070801,
    0.00039672852, -0.00024414062, -0.00085449219,
    -0.0014343262, -0.0020141602, -0.0025024414,
    -0.0029602051, -0.0033569336, -0.0036621094,
    -0.0038757324, -0.0040283203, -0.0040588379,
    -0.0040283203, -0.00390625, -0.0037231445,
    -0.0034484863, -0.0030822754, -0.0026855469,
    -0.0022277832, -0.0017089844, -0.0011901855,
    -0.00064086914, -6.1035156e-05, 0.00048828125,
    0.0010070801, 0.0014953613, 0.0019836426, 0.0023803711,
    0.002746582, 0.0030212402, 0.0032348633, 0.0033874512,
    0.0034484863, 0.0034484863, 0.0033569336, 0.0032043457,
    0.0029602051, 0.0026855469, 0.0023193359, 0.0019226074,
    0.0014953613, 0.0010375977, 0.00054931641,
    6.1035156e-05, -0.00039672852, -0.00088500977,
    -0.0013122559, -0.001739502, -0.0021057129,
    -0.0024108887, -0.0026855469, -0.0028991699,
    -0.0030212402, -0.003112793, -0.003112793,
    -0.0030517578, -0.0029296875, -0.0027160645,
    -0.0025024414, -0.0021972656, -0.0018615723,
    -0.0014953613, -0.0010986328, -0.0007019043,
    -0.0002746582, 0.00015258789, 0.00054931641,
    0.00094604492, 0.0012817383, 0.0016174316, 0.0018920898,
    0.0021362305, 0.0023193359, 0.0024414062, 0.002532959,
    0.002532959, 0.0025024414, 0.0024108887, 0.0022583008,
    0.0020751953, 0.0018310547, 0.0015563965, 0.0012512207,
    0.00091552734, 0.00057983398, 0.00024414062,
    -0.00012207031, -0.00045776367, -0.00076293945,
    -0.0010681152, -0.0013427734, -0.0015869141,
    -0.0018005371, -0.001953125, -0.0020751953,
    -0.0021362305, -0.002166748, -0.0021362305,
    -0.0020751953, -0.001953125, -0.0018005371,
    -0.0016174316, -0.0014038086, -0.001159668,
    -0.00088500977, -0.00061035156, -0.00033569336,
    -6.1035156e-05, 0.00021362305, 0.00048828125,
    0.00073242188, 0.00094604492, 0.001159668, 0.0013122559,
    0.0014648438, 0.0015563965, 0.0016174316, 0.0016479492,
    0.0016174316, 0.0015563965, 0.0014953613, 0.001373291,
    0.0012207031, 0.0010681152, 0.00088500977,
    0.00067138672, 0.00045776367, 0.0002746582,
    6.1035156e-05, -0.00015258789, -0.00036621094,
    -0.00054931641, -0.0007019043, -0.00085449219,
    -0.0009765625, -0.0010986328, -0.001159668,
    -0.0012207031, -0.0012207031, -0.0012207031,
    -0.0011901855, -0.0011291504, -0.0010375977,
    -0.00094604492, -0.00082397461, -0.00067138672,
    -0.00054931641, -0.00039672852, -0.00024414062,
    -9.1552734e-05, 3.0517578e-05, 0.00018310547,
    0.00030517578, 0.00042724609, 0.00051879883,
    0.00057983398, 0.00064086914, 0.0007019043,
    0.00073242188, 0.00073242188, 0.00073242188,
    0.0007019043, 0.00067138672, 0.00061035156,
    0.00054931641, 0.00045776367, 0.00039672852,
    0.00030517578, 0.00021362305, 0.00015258789,
    6.1035156e-05, -3.0517578e-05, -9.1552734e-05,
    -0.00015258789, -0.00021362305, -0.00024414062,
    -0.0002746582, -0.00030517578, -0.00030517578,
    -0.00030517578, -0.00030517578, -0.0002746582,
    -0.0002746582, -0.00024414062, -0.00021362305,
    -0.00018310547, -0.00015258789, -9.1552734e-05,
    -9.1552734e-05, -6.1035156e-05, -3.0517578e-05, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
};



// sound borrowed from gtick

static const sample_t CLICK_2_EMPHASIS_SAMPLES[] = {
    0.001183, -0.019712, 0.003825, -0.018132, 0.010064, -0.014016, 0.013574, -0.017686,
    0.022975, -0.040437, 0.141915, 0.230670, -0.330087, 0.098787, 0.183140, -0.282263,
    -0.363895, -0.141961, -0.259863, 0.251225, 0.235571, 0.071770, 0.314631, -0.234663,
    -0.314937, 0.306290, 0.000589, -0.223435, 0.379939, -0.265711, -0.292597, 0.210270,
    -0.260571, -0.050190, 0.428541, -0.158347, -0.320959, -0.190254, -0.184287, -0.155636,
    0.165355, 0.340281, 0.374996, -0.102800, -0.242371, 0.304974, -0.250225, -0.177713,
    0.339392, -0.055387, 0.101036, 0.470735, 0.065494, 0.140076, -0.106774, -0.359013,
    -0.143055, 0.049878, 0.180157, 0.390572, 0.025037, -0.339674, 0.176548, -0.037336,
    0.179173, 0.307325, 0.030823, -0.293458, -0.343709, -0.167828, -0.207021, 0.149159,
    0.320379, 0.355244, 0.008944, -0.280096, -0.243746, 0.060117, 0.104650, 0.232269,
    0.121556, -0.070358, -0.108414, 0.038992, 0.318387, 0.309286, 0.028494, -0.217756,
    0.207445, 0.289599, 0.247214, -0.063718, -0.255952, -0.274372, -0.046208, 0.378482,
    0.312983, 0.159256, -0.049993, -0.134000, 0.238603, 0.166597, 0.154414, -0.217179,
    -0.448311, -0.287269, -0.146845, 0.182688, 0.257833, 0.186694, -0.098861, -0.419955,
    -0.154652, 0.229815, 0.102345, 0.178449, -0.265800, -0.363710, -0.076726, 0.041672,
    -0.007804, 0.122450, -0.182355, -0.090116, -0.051030, -0.297753, 0.307806, -0.247854,
    -0.195966, 0.248029, -0.326315, 0.090671, 0.268076, -0.372324, -0.062699, -0.077423,
    -0.299905, 0.232699, 0.303325, -0.020956, -0.198141, -0.341086, -0.086532, 0.158502,
    0.111772, 0.248459, -0.102461, -0.452938, -0.026984, 0.305944, 0.020768, 0.078032,
    -0.055723, -0.436135, -0.211252, 0.246105, 0.254975, 0.096219, 0.087168, -0.338942,
    -0.203759, 0.003718, -0.157863, 0.137923, -0.181630, -0.401954, -0.258728, -0.409815,
    -0.099841, 0.296030, 0.085785, -0.018126, -0.303781, -0.427072, -0.248325, -0.254131,
    0.194638, 0.251986, 0.065455, -0.143863, 0.035298, 0.182910, 0.059339, -0.262622,
    -0.453903, -0.354443, -0.229768, 0.053853, 0.245712, 0.099270, -0.230990, -0.276109,
    -0.099163, 0.180887, 0.070467, -0.361085, -0.083965, -0.022519, -0.329544, 0.117464,
    0.074925, -0.457265, -0.339261, -0.289384, -0.002874, 0.148091, 0.007840, -0.217767,
    -0.402541, -0.312154, -0.136641, 0.021390, 0.070056, 0.280637, -0.046932, -0.151109,
    -0.154090, 0.010574, -0.179563, -0.128473, 0.021042, -0.359690, -0.209806, 0.127402,
    -0.091734, 0.112702, 0.031561, -0.401469, 0.018992, -0.019044, -0.035272, -0.114792,
    -0.225728, -0.040914, 0.183682, 0.185665, 0.154471, 0.003796, -0.445872, -0.370773,
    -0.290971, -0.115712, 0.291180, 0.185383, -0.189543, -0.331179, -0.228539, -0.125964,
    0.219999, 0.212167, 0.134634, 0.020737, -0.080125, -0.098767, -0.145974, -0.027911,
    -0.114724, -0.073710, 0.047778, 0.028014, -0.234236, -0.126185, -0.001880, -0.060666,
    0.144803, 0.133565, -0.061699, -0.095472, -0.193570, -0.058410, 0.060265, 0.011245,
    0.071124, -0.081511, -0.053827, -0.119238, -0.237720, -0.119231, 0.070541, 0.201672,
    0.222236, 0.016065, -0.116976, -0.036761, -0.025433, 0.052405, 0.179807, 0.084807,
    0.047312, -0.152604, -0.065044, 0.145023, 0.018312, 0.048001, -0.010490, -0.092705,
    -0.208680, -0.072068, -0.058837, -0.123766, -0.042867, -0.042872, -0.054814, 0.104534,
    0.246038, 0.134790, 0.047848, -0.051468, -0.013567, -0.080577, -0.104209, 0.037252,
    -0.051173, -0.004920, 0.078677, 0.056439, 0.153664, 0.225984, -0.000063, -0.102344,
    -0.049490, -0.024257, -0.035126, 0.139343, 0.127493, -0.083350, -0.037346, -0.030902,
    0.061754, 0.195826, 0.050128, -0.054224, -0.064412, -0.142454, -0.025784, 0.016902,
    -0.052919, -0.082635, -0.033953, 0.063907, 0.274597, 0.255934, 0.140866, 0.040872,
    -0.151000, -0.251824, -0.066510, 0.011443, 0.039895, 0.167100, 0.097399, 0.057815,
    0.008424, 0.084089, 0.085537, 0.031983, 0.061935, 0.049874, -0.054075, -0.070521,
    0.021114, 0.006904, 0.018733, 0.076719, 0.061384, 0.068601, 0.033460, -0.051139,
    -0.032901, 0.032927, -0.015496, 0.053925, 0.044214, -0.040134, 0.055724, 0.032670,
    0.048025, 0.039300, -0.011100, -0.004363, -0.059466, -0.026536, 0.051978, 0.022989,
    0.064737, 0.138873, 0.113982, 0.092643, 0.102009, -0.013204, -0.011843, 0.008578,
    -0.027060, -0.030816, -0.050895, -0.053454, 0.006395, 0.099612, 0.086153, 0.067940,
    0.044571, -0.015599, -0.057085, -0.046643, 0.013493, 0.031090, -0.005622, 0.046987,
    0.067710, 0.029473, 0.042692, 0.107225, 0.054429, 0.040778, -0.039160, -0.150042,
    -0.098152, -0.019886, 0.076435, 0.135535, 0.178873, 0.157651, 0.019426, -0.033452,
    0.023933, -0.025244, -0.058933, -0.007588, -0.054479, -0.032747, 0.028201, 0.034138,
    0.052327, 0.095770, 0.035060, -0.044308, -0.009525, -0.069774, -0.045804, 0.031197,
    0.065764, 0.030392, 0.030714, 0.066002, 0.113004, 0.034976, 0.012427, 0.042626,
    -0.059364, -0.035617, 0.041749, 0.020133, 0.000241, -0.002422, -0.007281, 0.031288,
    0.049451, 0.057619, 0.020008, -0.016795, -0.026683, -0.001711, -0.003403, 0.050681,
    0.061471, 0.055860, -0.003163, -0.025733, 0.020605, -0.044641, -0.087124, -0.042582,
    0.001759, -0.063092, -0.009397, 0.069881, 0.040167, 0.000000,
};


static const sample_t CLICK_2_NORMAL_SAMPLES[] = {
    -0.006081, -0.004875, -0.004250, -0.004036, -0.003677, -0.003510, -0.003243, -0.002403,
    -0.001007, -0.000618, -0.000031, -0.000916, -0.000191, -0.001183, 0.001144, -0.002106,
    0.003624, -0.004280, 0.003174, -0.018906, 0.067965, 0.139088, 0.132313, -0.016533,
    -0.224494, -0.099635, 0.107303, 0.096149, 0.053179, 0.052889, -0.189184, -0.204550,
    -0.161191, -0.118198, -0.073748, -0.112018, -0.107112, -0.055986, 0.114498, 0.221976,
    0.126354, -0.032876, 0.074412, 0.153424, 0.099322, 0.088687, -0.128941, -0.210463,
    -0.143475, -0.025544, 0.183294, 0.134709, 0.020707, -0.162404, -0.130657, 0.125477,
    0.156194, 0.079981, -0.124523, -0.228927, -0.136555, -0.026910, 0.151936, 0.035669,
    -0.174177, -0.165677, -0.005989, 0.206526, 0.121532, 0.124378, -0.017830, -0.230369,
    -0.166738, -0.092730, -0.084468, -0.112300, -0.100711, -0.070307, -0.089030, -0.013398,
    0.093997, 0.114208, 0.210479, 0.188978, 0.132916, 0.148701, -0.027520, -0.212485,
    -0.113620, 0.041620, 0.209616, 0.018349, -0.181951, -0.102046, -0.092990, 0.002625,
    0.206542, 0.165098, -0.079096, -0.115482, 0.123920, 0.225356, 0.158300, 0.132763,
    0.119282, -0.010033, -0.006066, 0.147580, -0.069346, -0.204360, -0.147053, -0.116321,
    -0.106098, -0.019585, 0.080317, -0.004036, 0.082827, 0.221793, 0.137532, 0.139378,
    0.062708, -0.153989, -0.183996, -0.065645, 0.126179, 0.103214, -0.089434, -0.016373,
    0.154851, 0.150388, 0.107356, 0.106197, 0.049631, -0.080004, -0.170209, -0.187773,
    -0.144581, -0.119808, -0.111896, -0.084277, -0.097392, -0.032098, 0.073618, 0.107425,
    0.207984, 0.173124, 0.140316, 0.124569, 0.041459, -0.107234, -0.176328, -0.126102,
    -0.090258, -0.080302, 0.002701, 0.109088, 0.047380, 0.038133, 0.130810, 0.139027,
    0.037400, 0.008927, -0.046747, -0.047502, -0.028596, -0.061228, 0.013260, 0.103175,
    0.192709, 0.145299, 0.125584, 0.158177, 0.003868, -0.106159, -0.114910, 0.005333,
    0.118778, 0.105739, 0.171674, 0.144398, 0.121570, 0.041749, -0.023225, -0.073740,
    -0.160382, -0.140202, -0.114612, -0.097026, -0.063684, 0.107898, 0.225951, 0.175520,
    0.138272, 0.130169, 0.097659, 0.008202, -0.021195, -0.058679, -0.087168, 0.032075,
    0.123486, 0.120556, 0.090220, 0.072497, 0.058824, 0.037019, -0.098415, -0.241966,
    -0.209632, -0.171896, -0.147130, -0.131512, -0.071116, 0.026849, 0.074473, 0.129902,
    0.141865, 0.103092, 0.093104, 0.054239, -0.056322, -0.164220, -0.197157, -0.165914,
    -0.109516, 0.043573, 0.163434, 0.060999, 0.035249, 0.088092, 0.083056, 0.040414,
    -0.170736, -0.233245, -0.113529, -0.131817, -0.070307, 0.026116, 0.030412, 0.028069,
    -0.066355, 0.048936, 0.111156, -0.022027, -0.120869, -0.099368, -0.008873, -0.018853,
    -0.032067, -0.104030, -0.167508, -0.008972, 0.194525, 0.053415, -0.123012, -0.196318,
    -0.110263, 0.063364, 0.149556, 0.009392, -0.221641, -0.120891, 0.079478, 0.177282,
    0.095714, -0.041551, -0.134060, -0.201155, -0.052690, 0.080004, -0.057939, -0.154889,
    -0.136296, -0.044359, 0.131985, 0.182081, 0.135731, 0.086489, -0.022813, -0.055589,
    -0.089000, -0.168157, -0.155393, -0.125301, -0.059946, 0.040368, 0.104068, 0.047876,
    0.049310, 0.113727, 0.087695, 0.115963, -0.047258, -0.245682, -0.162244, -0.151723,
    -0.072108, 0.156598, 0.160787, 0.064135, 0.024079, 0.005135, 0.011010, 0.071581,
    -0.009278, -0.193991, -0.207823, -0.146840, -0.150349, -0.010590, 0.187521, 0.142483,
    0.100932, 0.081744, 0.065012, 0.052835, 0.035867, -0.056108, -0.150670, -0.201155,
    -0.118442, 0.023789, -0.013703, -0.064386, -0.064913, -0.011437, 0.052927, 0.054842,
    -0.077303, -0.233589, -0.188910, -0.119953, -0.147000, -0.200476, -0.163572, -0.158185,
    -0.099956, 0.114261, 0.157094, 0.096416, 0.053697, -0.006874, -0.007302, -0.036172,
    -0.172315, -0.237396, -0.182066, -0.159673, -0.144162, -0.129917, -0.117229, -0.039766,
    0.102687, 0.144871, 0.128666, 0.096858, 0.004082, -0.023011, -0.040284, -0.081065,
    0.006188, 0.106380, 0.085444, 0.061426, 0.025643, -0.030206, -0.120701, -0.225845,
    -0.224166, -0.197584, -0.173673, -0.158757, -0.130047, -0.026078, 0.023019, 0.075869,
    0.138905, 0.091304, 0.072069, -0.037523, -0.152600, -0.119953, -0.117748, -0.137524,
    -0.056856, 0.058588, 0.079531, 0.087565, 0.041063, -0.075190, -0.186438, -0.171407,
    -0.024285, 0.030023, -0.016037, -0.109554, -0.183454, -0.076708, 0.090617, 0.076952,
    0.044008, -0.091639, -0.250000, -0.232719, -0.157857, -0.141003, -0.151379, -0.104328,
    0.004830, 0.077700, 0.065729, 0.038064, 0.005882, -0.038057, -0.107135, -0.180128,
    -0.206069, -0.176008, -0.152577, -0.134342, -0.064493, -0.007149, 0.013451, 0.000000,
    0.027223, 0.128819, 0.122311, 0.079150, -0.011063, -0.089892, -0.068880, -0.072718,
    -0.082652, -0.041795, 0.008690, -0.009880, -0.095218, -0.125698, -0.062288, 0.021470,
    0.006996, -0.095019, -0.168180, -0.185644, -0.114750, 0.005089, 0.075541, 0.024850,
    -0.059542, -0.032952, 0.067377, 0.098292, 0.014641, -0.141942, -0.195784, -0.112888,
    0.006722, 0.040780, -0.014008, -0.029115, -0.022698, -0.012169, -0.059877, -0.104999,
    -0.107135, -0.083750, -0.024827, 0.052507, 0.093745, 0.091700, 0.101154, 0.088794,
    0.065096, 0.054636, 0.028871, -0.124134, -0.247597, -0.216468, -0.182203, -0.156247,
    -0.148526, -0.120174, -0.063608, 0.049028, 0.165136, 0.138180, 0.094859, 0.008957,
    -0.108348, -0.149396, -0.162755, -0.144749, -0.112949, -0.098292, -0.061441, 0.012223,
    0.118519, 0.141598, 0.095218, 0.074740, 0.078036, 0.048311, 0.001518, -0.020646,
    -0.040147, -0.041932, -0.044130, -0.074236, -0.078867, -0.032952, -0.012040, -0.037080,
    -0.052965, -0.054506, -0.047205, -0.002495, 0.029794, 0.033731, 0.012864, -0.051355,
    -0.116512, -0.120197, -0.064943, -0.006493, 0.000542, -0.028275, -0.028916, 0.010437,
    0.073641, 0.099322, 0.064928, 0.006493, -0.027337, -0.037820, -0.055292, -0.071757,
    -0.088504, -0.089030, -0.034097, 0.029656, 0.030190, 0.004143, 0.005821, 0.035119,
    0.029710, -0.001213, -0.031976, -0.051714, -0.031892, -0.017937, -0.061022, -0.103458,
    -0.120602, -0.101482, -0.050653, -0.018738, 0.032464, 0.077944, 0.105525, 0.110164,
    0.105983, 0.083033, 0.007530, -0.055506, -0.052950, -0.033197, -0.027436, -0.009613,
    -0.008820, -0.008385, 0.028069, 0.069872, 0.085330, 0.075282, 0.047090, 0.024293,
    0.022401, -0.010216, -0.075739, -0.098369, -0.031610, 0.053453, 0.069018, 0.037606,
    0.011551, 0.013031, 0.023064, 0.016007, -0.007179, -0.021622, -0.044305, -0.085131,
    -0.103435, -0.083964, -0.035981, -0.006401, -0.037812, -0.057634, -0.052004, -0.049059,
    -0.024346, -0.011498, -0.018220, -0.033387, -0.030839, 0.003754, 0.056352, 0.097720,
    0.122036, 0.108707, 0.065027, 0.038514, 0.028031, -0.000824, -0.031060, -0.020905,
    -0.006081, -0.011040, -0.038568, -0.067614, -0.051508, -0.008286, 0.017556, 0.005943,
    -0.025590, -0.032678, -0.000580, 0.030709, 0.036775, 0.031014, 0.031770, 0.042863,
    0.072565, 0.114505, 0.112522, 0.066736, 0.001389, -0.047838, -0.049707, -0.035203,
    -0.027337, -0.018220, -0.006813, -0.018693, -0.021981, 0.018189, 0.069613, 0.096408,
    0.063478, -0.000824, -0.042276, -0.037980, -0.017083, -0.014306, -0.015908, -0.003327,
    0.032220, 0.073107, 0.097575, 0.078120, 0.026719, -0.019715, -0.029595, -0.017457,
    -0.030854, -0.063021, -0.073397, -0.043519, -0.013932, 0.005852, 0.008621, -0.003563,
    -0.026322, -0.044778, -0.039018, -0.030511, -0.015191, -0.000351, 0.023431, 0.093753,
    0.144749, 0.135578, 0.133862, 0.101070, 0.065317, 0.049509, 0.016938, -0.014061,
    -0.077578, -0.129666, -0.113010, -0.089869, -0.042032, 0.008080, 0.007714, -0.000618,
    0.016945, 0.061602, 0.084971, 0.072108, 0.047693, 0.034822, 0.031854, 0.014489,
    0.000580, 0.019669, 0.041719, 0.051271, 0.047182, 0.022492, 0.011345, 0.027093,
    0.032579, 0.026780, 0.028428, 0.006127, -0.032029, -0.045412, -0.029366, -0.011216,
    0.004631, 0.018853, 0.005013, -0.008354, 0.013878, 0.031243, 0.030816, 0.038644,
    0.035798, 0.026650, 0.030755, 0.037027, 0.018647, -0.013482, -0.022874, -0.025315,
    -0.020920, 0.003098, 0.021882, 0.006478, -0.013550, 0.003410, 0.030038, 0.035928,
    0.023476, -0.006844, -0.024796, 0.002510, 0.032510, 0.026605, 0.013565, 0.017556,
    0.024125, 0.026154, 0.021867, 0.004219, -0.008049, -0.002380, -0.001801, -0.013062,
    -0.029595, -0.034822, -0.010727, 0.014336, 0.022637, 0.021149, 0.013703, 0.014878,
    0.028382, 0.057161, 0.072092, 0.065279, 0.057520, 0.047357, 0.045770, 0.053323,
    0.052217, 0.024911, -0.006584, -0.018647, -0.005196, 0.008019, 0.001465, -0.005135,
    -0.012444, -0.016579, -0.014679, -0.018189, -0.027581, -0.028802, -0.024339, -0.018433,
    0.002678, 0.030084, 0.049951, 0.054483, 0.040506, 0.034005, 0.037606, 0.032273,
    0.017876, 0.008301, -0.003693, -0.022309, -0.031404, -0.029176, -0.018792, -0.012345,
    0.002678, 0.021966, 0.017678, -0.000389, -0.003845, 0.010422, 0.022225, 0.032479,
    0.035409, 0.025750, 0.013153, 0.012139, 0.021622, 0.039491, 0.055750, 0.045450,
    0.025323, 0.019639, 0.021722, 0.009728, -0.019051, -0.056215, -0.076273, -0.066477,
    -0.049760, -0.030625, -0.009331, 0.014908, 0.037294, 0.055078, 0.069910, 0.077708,
    0.088549, 0.093722, 0.078768, 0.046457, 0.010308, -0.014878, -0.018136, 0.000145,
    0.011986, 0.006325, -0.012421, -0.028756, -0.030824, -0.014275, -0.002800, -0.012169,
    -0.026536, -0.031732, -0.016167, 0.003433, 0.014771, 0.014977, 0.016961, 0.021722,
    0.025628, 0.035180, 0.049432, 0.045755, 0.013276, -0.011437, -0.018693, -0.014924,
    -0.005654, -0.013031, -0.037179, -0.039262, -0.019570, -0.004402, 0.015152, 0.030900,
    0.030610, 0.026292, 0.017212, 0.009087, 0.014985, 0.024812, 0.032334, 0.045610,
    0.058679, 0.045122, 0.016068, -0.000336, 0.006874, 0.022744, 0.020386, -0.002663,
    -0.029962, -0.034631, -0.018189, 0.006157, 0.021058, 0.020684, 0.009362, 0.001030,
    0.002045, -0.000244, -0.001747, -0.003433, -0.004372, 0.003693, 0.018075, 0.021783,
    0.021661, 0.029733, 0.031243, 0.019425, 0.008469, 0.002289, -0.008019, -0.016343,
    -0.012726, -0.004845, -0.001816, -0.002174, -0.001778, 0.009819, 0.025445, 0.032334,
    0.030953, 0.028542, 0.028184, 0.018937, -0.003082, -0.015923, -0.011315, 0.000191,
    0.011437, 0.000481, -0.024346, -0.038942, -0.041719, -0.037378, -0.023263, -0.002472,
    0.001740, -0.014435, -0.032067, -0.029458, -0.004143, 0.024094, 0.032983, 0.029305,
    0.023675, 0.013062, 0.010575, 0.017617, 
};



// sounds borrowed from freepats

static const short CLICK_3_EMPHASIS_SAMPLES[] = {
    -33, -97, -73, -126, -238, 146, 1459, 2788,
    1915, -3029, -10736, -16344, -14667, -4746, 8478, 16834,
    15627, 7100, -1850, -4917, -999, 5587, 8388, 4640,
    -3223, -7791, -7045, -2702, 2665, 8057, 10359, 7321,
    -923, -8965, -11843, -9247, 5535, 19976, 18254, -615,
    -20289, -26275, -16897, -6109, 7429, 21731, 28636, 21966,
    10522, 4007, -10565, -19121, -17947, -14712, -2980, 1951,
    -4335, -11208, -3540, 11016, 19366, 24621, 26352, 20194,
    2447, -16848, -26293, -22446, -16228, -7953, -5069, -11993,
    -20924, -25190, -22050, -16164, -3286, 9481, 18418, 27598,
    20077, -4751, -31115, -32767, -22477, -11644, 1931, 6127,
    5045, 1958, 1210, -5552, -9695, 907, 17198, 28917,
    29775, 25774, 12634, 965, -2910, -5601, -6479, -2278,
    9959, 14463, 14120, 10819, -2097, -4735, -829, 869,
    -2737, -1067, 2631, -3342, -4079, 3197, 15483, 21676,
    19573, 5163, -17419, -29729, -28186, -16347, 130, 20956,
    32089, 25498, 9084, -1599, -2153, -1455, -3638, -10870,
    -15367, -9280, -4693, -5023, -8343, -14207, -11455, -573,
    10360, 10684, 3609, -5516, -13793, -7919, 5460, 11477,
    -1039, -15188, -20935, -21814, -14499, -3983, 9087, 22301,
    24216, 10124, -10548, -19810, -18035, -10966, -2768, 9037,
    16854, 15255, 8639, 3462, 3176, 6731, 8136, 12472,
    16552, 12517, 3281, -4260, -6066, -6287, -685, 7242,
    11752, 6049, -4664, -15999, -23955, -19823, -3852, 13152,
    15870, 9461, 1043, -6399, -12353, -14744, -10178, 1579,
    9478, 10431, 7791, 5082, 4643, 6434, 9209, 11232,
    10947, 7960, 4065, 13, -1455, 1459, 7491, 14069,
    17623, 15140, 5247, -7087, -15047, -14986, -5423, 6217,
    11710, 9108, 1887, -5794, -11874, -15352, -14793, -10381,
    -4763, -2764, -4880, -7980, -9975, -3599, 9986, 21026,
    22305, 12395, -1678, -8327, -9795, -5967, 2838, 8665,
    9962, 6451, -1042, -8898, -14091, -13983, -8831, 28,
    6655, 6335, 5374, 2439, -1563, -1639, -423, 2700,
    5058, 903, -9610, -18969, -17872, -10112, 2727, 12036,
    7301, -125, -4912, -5844, 13, 5081, 7955, 11525,
    15327, 15998, 11664, 4639, -2380, -5476, -1095, 8575,
    20848, 26387, 17161, 4238, -6991, -12586, -10091, -2928,
    3116, 2920, -2023, -10241, -15548, -11583, -6011, -627,
    2239, -2983, -8583, -11401, -12835, -9895, -6461, -2696,
    3959, 4895, 619, -5445, -10605, -14888, -14464, -5228,
    5658, 16338, 21074, 13728, 1675, -8105, -10301, -2758,
    5165, 6620, 2479, -4527, -8671, -8179, -5871, 747,
    7217, 7972, 1419, -6607, -11856, -12203, -6827, 3093,
    10547, 9298, -707, -7209, -3335, 3409, 5384, 5903,
    12157, 15243, 11327, 2782, -1922, -4693, -3158, 4433,
    10713, 12767, 7922, -3759, -9051, -8883, -6607, 935,
    11639, 19763, 17185, 2732, -13313, -18036, -7501, 3366,
    9375, 11190, 8295, 193, -9347, -14184, -10329, -4203,
    -707, 943, 2060, 607, -4072, -5515, -4087, 302,
    7624, 15711, 19113, 14180, 2415, -4580, -3766, 1251,
    5828, 7423, 3942, -5087, -14389, -18531, -15147, -7516,
    1771, 7615, 6344, -1615, -11094, -16507, -15724, -9332,
    -2144, 1602, 2241, -183, -2893, -3767, -5887, -3736,
    3439, 10011, 7170, -1387, -7215, -8985, -1403, 10464,
    18245, 22068, 18664, 9793, 2223, -1911, 819, 9631,
    20630, 22532, 15351, 6467, -2991, -8566, -7505, -1622,
    4878, 5785, -809, -7310, -14701, -19118, -15249, -3953,
    8534, 14865, 13512, 2941, -8609, -13240, -9872, -1699,
    8068, 17286, 17177, 10207, 975, -7659, -11742, -8720,
    -135, 7016, 9081, 6635, 2876, 2332, 2007, 171,
    -1159, 305, 711, -4384, -12383, -16803, -14399, -8692,
    -403, 5154, 4573, -1119, -9033, -15041, -16186, -11603,
    -4335, 1411, 2310, -182, -5283, -10021, -9721, -3848,
    3063, 5491, 3804, -1051, -6191, -8047, -5802, 1199,
    10780, 17313, 15454, 6047, -4078, -7994, -5052, 1059,
    6024, 11061, 13035, 8593, -621, -8376, -10623, -8602,
    -3688, 815, 2344, -709, -5880, -10046, -9887, -4191,
    4888, 11650, 11230, 6131, -851, -6847, -8995, -4485,
    4980, 13767, 16805, 13171, 6972, 3047, 1830, 3343,
    7263, 11549, 13740, 11133, 4270, -829, -1663, 1499,
    6127, 9031, 8034, 2855, -4160, -11400, -15418, -13570,
    -6047, 1455, 3863, 1027, -4698, -9939, -12202, -9835,
    -3943, 3324, 8523, 8296, 3509, -1655, -2969, -1391,
    2261, 6601, 9905, 7903, 599, -7157, -9536, -6100,
    141, 6557, 8205, 3591, -5083, -13689, -17557, -15284,
    -9261, -1054, 5018, 6143, 3527, -1247, -5054, -5036,
    34, 6083, 8652, 6193, -543, -7983, -11965, -10008,
    -3327, 4481, 9200, 8094, 2255, -4821, -9186, -7838,
    -1343, 7146, 13053, 14534, 10826, 3575, -1271, -1643,
    1282, 4797, 5365, 2655, -1827, -6276, -8979, -7922,
    -2351, 4829, 9706, 9377, 3809, -4427, -10841, -11603,
    -6243, 2759, 10239, 11853, 7235, 305, -4250, -4164,
    468, 6398, 9626, 7515, 1355, -5562, -9659, -9527,
    -4516, 3319, 9405, 10519, 6744, 1179, -3239, -3409,
    945, 7407, 12043, 12089, 6929, -1459, -8340, -9539,
    -4544, 1323, 5327, 5774, 1730, -4954, -11190, -13635,
    -10890, -5071, 210, 2011, -567, -5956, -10769, -11537,
    -7772, -757, 5967, 8073, 4211, -3247, -9681, -11798,
    -8274, -1159, 4687, 7412, 5284, -711, -5555, -6160,
    -2093, 4164, 9666, 11187, 7874, 1879, -3504, -5147,
    -2200, 3468, 8716, 10630, 7893, 1998, -4346, -7860,
    -6469, -923, 4526, 5841, 3022, -2428, -7407, -9073,
    -5322, 1899, 8735, 12349, 11152, 6115, 138, -2749,
    -1411, 3481, 9346, 12452, 10167, 3559, -2711, -5279,
    -3188, 1946, 7468, 10298, 8479, 2079, -4939, -8743,
    -7429, -2183, 3965, 6995, 4498, -1675, -8234, -11938,
    -11207, -7103, -1682, 2198, 1614, -2751, -7663, -9718,
    -7682, -2493, 3473, 7107, 6648, 1375, -6351, -11256,
    -9949, -3335, 4197, 9606, 10146, 5645, -1038, -6465,
    -7487, -3512, 2636, 7084, 7549, 4458, -372, -3653,
    -3117, 597, 5864, 9336, 8400, 3468, -3004, -7251,
    -6404, -1107, 5519, 9713, 8219, 2399, -4730, -9826,
    -9632, -3961, 4350, 10618, 12232, 8486, 1639, -3857,
    -5354, -2415, 2981, 7267, 8196, 5247, -148, -4741,
    -5657, -2248, 2745, 6604, 6900, 2911, -3343, -8178,
    -8163, -2917, 4906, 10964, 12011, 7444, -132, -6976,
    -10153, -8467, -3233, 2344, 4705, 2272, -3351, -8627,
    -10602, -7792, -1522, 5034, 8281, 6624, 1547, -4136,
    -6048, -2949, 2759, 7150, 8214, 5514, -406, -5825,
    -7985, -5695, -639, 5038, 7825, 5353, -821, -6571,
    -8078, -4973, 1103, 6770, 8849, 5868, -479, -6604,
    -9073, -5857, 677, 6200, 7761, 4707, -1271, -7027,
    -9547, -7346, -1591, 4428, 7922, 7125, 2837, -2134,
    -4328, -2598, 1615, 5540, 7451, 6239, 1815, -3703,
    -6744, -4989, 244, 5837, 8309, 6110, 231, -6381,
    -10441, -9859, -4751, 2184, 7212, 7836, 3856, -2129,
    -6317, -6718, -2967, 2535, 6065, 5828, 2030, -3188,
    -6894, -5919, -535, 5604, 8941, 7420, 1818, -4484,
    -9106, -9161, -3823, 3492, 8912, 9651, 5858, -460,
    -4981, -4977, -1723, 3295, 6610, 5600, 915, -4845,
    -8593, -7944, -2647, 4452, 9129, 8324, 2613, -4560,
    -9013, -9226, -4554, 2966, 8961, 11231, 8541, 2559,
    -2752, -4176, -1503, 2638, 6088, 6188, 2639, -2165,
    -5787, -5678, -1467, 4623, 8788, 8465, 3984, -2375,
    -7150, -7725, -3727, 2664, 8013, 9343, 5960, -681,
    -6993, -9563, -7273, -2297, 2140, 4144, 2240, -1891,
    -5289, -5400, -2141, 2854, 7320, 8199, 5105, -247,
    -5058, -6346, -3044, 3111, 8703, 10282, 6832, 341,
    -5764, -8708, -7058, -1379, 4475, 7220, 5503, 47,
    -5460, -7359, -4708, 933, 5948, 7237, 4586, -1038,
    -6879, -9719, -7577, -1582, 4719, 7984, 5663, -351,
    -5946, -8149, -5652, -188, 5428, 8562, 7658, 3512,
    -1231, -3133, -1059, 3473, 7439, 8927, 6898, 1875,
    -3873, -6945, -5314, -394, 4559, 6658, 4860, -91,
    -5784, -8895, -7385, -1959, 4606, 8876, 8906, 4895,
    -723, -4818, -5145, -1826, 2751, 5608, 4648, 571,
    -4031, -6127, -4654, -469, 4316, 6943, 5647, 1103,
    -3863, -6457, -5338, -1215, 4015, 7951, 8403, 4911,
    -785, -5471, -6325, -3030, 1715, 4812, 4415, 253,
    -5249, -9286, -9890, -6312, -549, 4041, 4674, 1218,
    -3873, -7020, -5679, -448, 6026, 10368, 10207, 5503,
    -1198, -6431, -7164, -3383, 2055, 6351, 7456, 5055,
    685, -3207, -4306, -1751, 2975, 6772, 7269, 4320,
    -242, -4008, -4813, -1950, 2847, 6677, 7123, 3412,
    -2191, -6829, -8290, -6218, -1355, 3908, 6049, 3846,
    -1251, -5928, -7209, -4328, 855, 5436, 7199, 5488,
    1366, -2966, -4508, -1882, 3360, 7679, 8324, 4655,
    -1642, -6975, -8904, -6524, -959, 4846, 7486, 5253,
    156, -4748, -6644, -4559, 196, 4872, 6755, 4961,
    607, -3719, -5567, -3607, 358, 3969, 5522, 4339,
    316, -4752, -6877, -4772, 737, 6629, 9911, 8247,
    2604, -3133, -6412, -5181, -250, 5471, 8582, 7615,
    3487, -1906, -5706, -5752, -2027, 2737, 5359, 4105,
    -225, -5163, -7627, -6100, -1683, 3055, 5647, 4829,
    919, -4081, -7317, -6571, -1975, 3896, 7562, 7227,
    2999, -2724, -6530, -6257, -2175, 3365, 7309, 7525,
    3880, -1607, -5345, -5011, -983, 4089, 7728, 7343,
    2487, -4153, -8639, -8407, -4221, 925, 4192, 3829,
    513, -4617, -8193, -7182, -2671, 2480, 5548, 5576,
    1999, -3054, -6555, -6557, -2639, 2934, 6658, 6146,
    1847, -3741, -7485, -7306, -3316, 2393, 6766, 7763,
    4819, -504, -4926, -5732, -2535, 2657, 6704, 7551,
    5061, 431, -3687, -4930, -2583, 1946, 5627, 5941,
    2485, -2277, -6063, -7004, -3857, 2096, 7668, 9416,
    6639, 1318, -3319, -4921, -2145, 3039, 7467, 8844,
    6666, 1859, -3496, -6081, -4164, 931, 5327, 6425,
    3591, -1311, -5264, -5903, -2807, 2255, 7006, 8617,
    6138, 1135, -3056, -4259, -2425, 1291, 4867, 6159,
    3896, -767, -5329, -7155, -5136, -779, 3308, 4906,
    3415, -434, -4732, -6863, -5173, -332, 4752, 6825,
    4867, 59, -5024, -7359, -5835, -1515, 3167, 5915,
    4844, 313, -5263, -8447, -7539, -3484, 1359, 4620,
    4721, 1338, -3079, -5596, -4357, -210, 4217, 6245,
    4666, 21, -5236, -8129, -6986, -2406, 2873, 5909,
    4916, 343, -5012, -7819, -6290, -1523, 3928, 7426,
    7261, 3697, -967, -3551, -2575, 1059, 4991, 7261,
    6415, 2492, -2748, -6275, -5931, -1795, 3316, 6715,
    6911, 3791, -739, -4022, -4111, -829, 4077, 7568,
    7521, 3657, -1631, -5252, -5387, -2207, 2503, 6021,
    5340, 1131, -4078, -7522, -7392, -3617, 1919, 6172,
    6927, 3815, -1163, -4888, -5186, -1935, 2743, 6601,
    7529, 4929, 260, -3638, -4751, -2808, 857, 4085,
    4682, 1674, -3023, -6594, -6912, -3918, 1259, 5685,
    6718, 3924, -957, -5101, -6479, -4168, 405, 4431,
    5743, 3327, -1470, -5881, -7572, -5839, -1751, 2726,
    4929, 3735, 138, -3393, -4571, -2159, 2973, 7621,
    9091, 6692, 1818, -3225, -5743, -4269, 57, 4533,
    6114, 3759, -1319, -6206, -7934, -5967, -1271, 3623,
    5967, 4689, 783, -3287, -5055, -3215, 1150, 5394,
    6960, 5066, 567, -4331, -6735, -5120, -419, 4425,
    6933, 5840, 1834, -2695, -5225, -4063, 450, 6074,
    9374, 8307, 3636, -1455, -4163, -3377, 305, 4757,
    7390, 6495, 2295, -3089, -6690, -6418, -2831, 1622,
    4287, 3549, 18, -4385, -7132, -6317, -2161, 3167,
    6655, 6421, 2801, -2047, -5311, -5310, -2351, 1651,
    4542, 4352, 933, -3703, -6621, -6004, -2247, 2617,
    5921, 5743, 1971, -2876, -5967, -5571, -2063, 3062,
    6879, 6874, 2863, -2616, -6403, -6756, -3631, 1251,
    5102, 5759, 2489, -2697, -6299, -6435, -2928, 2272,
    6335, 7021, 3990, -911, -4751, -5215, -1907, 3055,
    6747, 6782, 3015, -2166, -6111, -6749, -3804, 891,
    4893, 5917, 3279, -1455, -5259, -5535, -2111, 2999,
    6944, 7707, 5044, 352, -3857, -5419, -3343, 1027,
    4729, 5410, 2383, -2564, -6459, -7182, -4229, 875,
    5518, 7215, 5301, 1282, -2328, -3382, -1319, 2629,
    6114, 7203, 4866, -126, -4799, -6403, -4001, 763,
    5108, 6485, 4105, -667, -5197, -6888, -4705, 131,
    5006, 7322, 5883, 1659, -2881, -5130, -3831, 165,
    4399, 6010, 3871, -973, -5834, -7713, -5455, -583,
    3985, 5983, 4704, 1163, -2774, -4788, -3199, 1515,
    6685, 9319, 7940, 3512, -1579, -4624, -4147, -805,
    3044, 5016, 3711, -484, -5427, -8255, -7020, -2709,
    2153, 5055, 4653, 1427, -2540, -4792, -3727, 160,
    4701, 7237, 6063, 1663, -3608, -6648, -6000, -2169,
    2726, 5742, 5096, 1235, -3492, -6346, -5576, -1563,
    3345, 6705, 6754, 3215, -1567, -5038, -5359, -2166,
    2465, 5808, 5906, 2536, -2671, -6817, -7423, -4361,
    397, 4049, 4418, 1423, -2982, -6011, -5458, -1403,
    3876, 7405, 7243, 3687, -1055, -4372, -4991, -2591,
    1438, 4272, 3996, 607, -3863, -7017, -7051, -3668,
    1550, 5835, 6971, 4504, 202, -3519, -4398, -1586,
    3180, 7187, 8224, 5796, 1323, -2852, -4714, -3460,
    -82, 3104, 3983, 1795, -2183, -5555, -6014, -2998,
    1987, 6494, 8092, 5899, 1199, -3329, -5114, -3184,
    1306, 5730, 7487, 5549, 859, -3759, -5881, -4499,
    -577, 3565, 5391, 3652, -342, -4226, -5646, -3436,
    1195, 5697, 7662, 5903, 1290, -3575, -5828, -4100,
    219, 4591, 6587, 4734, 31, -5007, -7647, -6499,
    -2181, 2863, 5780, 5119, 1667, -2327, -4222, -2681,
    1362, 5712, 7763, 6154, 1567, -3509, -6253, -5103,
    -779, 3671, 5836, 4757, 863, -3679, -6427, -5727,
    -1955, 2669, 5537, 5035, 1603, -2607, -5101, -4240,
    -571, 3679, 6127, 5331, 1618, -3148, -6575, -6580,
    -3183, 1423, 4464, 4319, 1223, -3045, -5953, -5427,
    -1538, 3456, 6799, 6658, 3183, -1491, -5032, -5524,
    -2670, 1771, 5087, 5138, 1987, -2574, -5920, -6176,
    -2927, 1903, 5531, 6000, 3125, -1291, -4718, -5033,
    -1995, 2689, 6337, 6819, 3616, -1494, -5573, -6474,
    -3844, 591, 4202, 4938, 2333, -2183, -5806, -6318,
    -3367, 1335, 5240, 6191, 3679, -689, -4361, -5214,
    -2733, 1402, 4799, 5457, 2791, -1815, -5690, -6469,
    -3561, 1287, 5423, 6769, 4447, -250, -4683, -6187,
    -3765, 1119, 5621, 7418, 5518, 1063, -3317, -5160,
    -3551, 266, 3744, 4767, 2631, -1511, -5424, -6794,
    -4573, 40, 4420, 6185, 4479, 474, -3559, -5236,
    -3541, 793, 5118, 6736, 4863, 446, -4178, -6482,
    -4927, -711, 3428, 5084, 3504, -495, -4779, -6926,
    -5407, -977, 3726, 6225, 5322, 1771, -2384, -4787,
    -3934, -400, 3504, 5362, 3932, -178, -4463, -6591,
    -5217, -945, 3775, 6432, 5425, 1471, -2924, -5323,
    -4226, -52, 4937, 7997, 7397, 3729, -935, -4127,
    -4265, -1531, 2221, 4511, 3718, 194, -4023, -6383,
    -5247, -1286, 3407, 6376, 6159, 2857, -1850, -4972,
    -4511, -665, 4235, 7374, 7138, 3657, -1347, -5275,
    -5966, -3064, 1438, 4863, 5122, 1970, -2609, -5844,
    -5683, -2118, 2911, 6685, 7044, 3940, -561, -3796,
    -3837, -605, 3751, 6522, 6283, 2817, -2257, -6207,
    -6927, -4013, 737, 4316, 4836, 2167, -2085, -5563,
    -6127, -3281, 1355, 5368, 6463, 4005, -555, -4497,
    -5536, -3199, 833, 4045, 4408, 1519, -3111, -6993,
    -7760, -4864, 81, 4437, 5930, 4007, 135, -3429,
    -4562, -2327, 2019, 6027, 7258, 4911, 228, -4354,
    -6226, -4431, -278, 3472, 4704, 2748, -1299, -4907,
    -5849, -3316, 1390, 5585, 7008, 5039, 953, -2926,
    -4536, -3030, 981, 5119, 6698, 4557, -57, -4670,
    -6815, -5419, -1611, 2423, 4475, 3385, -60, -3871,
    -5717, -4095, 147, 4510, 6542, 5108, 1139, -3103,
    -5531, -4680, -989, 3279, 5584, 4478, 446, -4084,
    -6377, -5183, -1135, 3488, 6286, 5875, 2447, -1887,
    -4409, -3520, 122, 4286, 6496, 5506, 1759, -2751,
    -5521, -5082, -1711, 2408, 4681, 3647, 37, -4212,
    -6880, -6270, -2534, 2361, 5551, 5282, 1803, -2607,
    -5356, -4732, -1138, 3105, 5794, 5293, 1811, -2927,
    -6256, -6121, -2791, 1759, 4961, 5041, 2223, -1818,
    -4636, -4419, -1179, 3319, 6523, 6653, 3585, -909,
    -4286, -4836, -2313, 1714, 4693, 4751, 1578, -3116,
    -6593, -6760, -3469, 1471, 5295, 5886, 3151, -1143,
    -4456, -4879, -2071, 2279, 5805, 6382, 3572, -917,
    -4800, -5913, -3653, 521, 4097, 4897, 2367, -1962,
    -5519, -6223, -3598, 1027, 5055, 6192, 3928, -254,
    -3951, -5114, -2991, 1067, 4542, 5359, 2783, -1883,
    -6030, -7455, -5323, -855, 3284, 5088, 3662, -129,
    -3932, -5465, -3607, 621, 4768, 6313, 4367, 200,
    -3741, -5208, -3343, 701, 4517, 5754, 3559, -1015,
    -5547, -7385, -5410, -811, 3871, 6178, 4992, 1255,
    -2749, -4618, -3200, 659, 4716, 6666, 5340, 1327,
    -3111, -5465, -4440, -775, 3166, 5058, 3799, 138,
    -3841, -5950, -4698, -583, 4222, 7088, 6420, 2644,
    -1795, -4453, -3991, -685, 3311, 5515, 4410, 449,
    -4303, -7178, -6593, -2863, 1802, 4731, 4272, 731,
    -3649, -6239, -5215, -1167, 3591, 6529, 5948, 2265,
    -2367, -5520, -5346, -2084, 2111, 5010, 4763, 1319,
    -3335, -6411, -6159, -2825, 1674, 4816, 4975, 2199,
    -1803, -4680, -4495, -1254, 3252, 6480, 6413, 3031,
    -1895, -5792, -6674, -4041, 260, 3503, 3862, 1095,
    -3141, -6415, -6452, -3079, 1899, 5821, 6721, 4233,
    -164, -3769, -4456, -1811, 2471, 5774, 6080, 3118,
    -1567, -5327, -6024, -3404, 863, 4271, 4987, 2613,
    -1371, -4671, -5210, -2396, 2093, 5749, 6517, 3975,
    -342, -4181, -5504, -3487, 659, 4308, 5248, 2951,
    -1391, -5360, -6613, -4300, 256, 4344, 5914, 4120,
    -1, -3822, -5103, -3069, 1050, 4969, 6398, 4504,
    228, -4087, -6078, -4639, -815, 3007, 4515, 2743,
    -1074, -4861, -6309, -4400, -99, 4256, 6159, 4548,
    597, -3327, -5140, -3720, 65, 4040, 5744, 4015,
    -197, -4605, -6755, -5453, -1514, 2767, 5102, 4205,
    689, -3375, -5440, -4314, -581, 3572, 5770, 4859,
    1218, -2999, -5364, -4556, -1203, 2725, 4859, 3751,
    -152, -4649, -7128, -6015, -2046, 2527, 5409, 5141,
    1891, -2356, -5066, -4575, -1067, 3345, 6068, 5422,
    1831, -2647, -5685, -5576, -2550, 1475, 4188, 3953,
    873, -3207, -5727, -5103, -1559, 2929, 5924, 5809,
    2719, -1415, -4357, -4322, -1243, 2998, 5967, 5810,
    2438, -2312, -5949, -6508, -3721, 695, 4209, 5068,
    2751, -1266, -4337, -4515, -1634, 2655, 5966, 6233,
    3416, -911, -4318, -4863, -2253, 1907, 5099, 5340,
    2265, -2376, -6069, -6693, -3791, 1063, 5243, 6417,
    4093, -139, -3869, -4914, -2540, 1723, 5342, 6242,
    3879, -479, -4594, -6193, -4273, -297, 3297, 4370,
    2272, -1727, -5439, -6453, -4031, 487, 4682, 6319,
    4556, 529, -3433, -5061, -3383, 547, 4333, 5627,
    3581, -803, -5043, -6802, -5136, -1067, 2991, 4724,
    3102, -851, -4714, -6089, -4111, 235, 4592, 6624,
    5244, 1211, -3193, -5586, -4627, -967, 2972, 4751,
    3263, -667, -4853, -6847, -5473, -1427, 3141, 5628,
    4793, 1295, -2744, -4905, -3824, -178, 3919, 6015,
    4765, 819, -3550, -6063, -5359, -1867, 2319, 4719,
    3877, 274, -4056, -6524, -5551, -1619, 3105, 5987,
    5453, 2079, -2069, -4664, -4206, -915, 3295, 5909,
    5215, 1587, -2975, -6001, -5748, -2486, 1823, 4655,
    4485, 1527, -2521, -5170, -4733, -1320, 3121, 6126,
    5989, 2679, -1767, -4975, -5181, -2185, 1954, 4790,
    4705, 1515, -2879, -6047, -6165, -2970, 1651, 5016,
    5365, 2654, -1423, -4447, -4712, -1952, 2151, 5247,
    5439, 2572, -1672, -5062, -5667, -3245, 671, 3720,
    4038, 1452, -2656, -5935, -6243, -3333, 1331, 5233,
    6241, 3876, -378, -4007, -4977, -2652, 1471, 4975,
    5779, 3263, -1104, -5049, -6366, -4302, -182, 3543,
    4687, 2799, -855, -4026, -4715, -2367, 1812, 5488,
    6558, 4367, 172, -3752, -5306, -3663, 102, 3775,
    5103, 3191, -945, -5023, -6678, -4952, -731, 3542,
    5535, 4302, 675, -3038, -4541, -2881, 1021, 4902,
    6408, 4429, 249, -3806, -5733, -4476, -845, 3007,
    4772, 3335, -549, -4642, -6501, -5004, -943, 3453,
    5858, 4998, 1619, -2330, -4569, -3703, -285, 3674,
    5704, 4473, 473, -3982, -6478, -5635, -1980, 2327,
    4847, 4186, 807, -3226, -5464, -4472, -733, 3737,
    6466, 5905, 2358, -2100, -4954, -4725, -1643, 2271,
    4641, 3920, 509, -3741, -6555, -6182, -2870, 1540,
    4696, 4735, 1803, -2186, -4814, -4353, -995, 3230,
    6072, 5856, 2519, -1944, -5213, -5485, -2686, 1347,
    4255, 4255, 1247, -2903, -5832, -5754, -2525, 1922,
    5249, 5770, 3103, -1072, -4367, -4799, -2175, 1879,
    4873, 5021, 2063, -2514, -6181, -6901, -4274, -26,
    3416, 4207, 1898, -2128, -5486, -6008, -3239, 1324,
    5124, 6054, 3672, -500, -4114, -5213, -3132, 783,
    4143, 4900, 2604, -1439, -4980, -5985, -3680, 506,
    4210, 5453, 3553, -218, -3596, -4564, -2460, 1475,
    4956, 5906, 3615, -591, -4543, -6094, -4259, -256,
    3423, 4655, 2716, -1334, -5087, -6305, -4258, -24,
    4122, 6004, 4641, 863, -2975, -4672, -3308, 397,
    4108, 5584, 3894, -137, -4223, -6064, -4612, -829,
    3033, 4841, 3652, 145, -3647, -5416, -3984, -95,
    3983, 5961, 4752, 1052, -3095, -5300, -4296, -841,
    2918, 4825, 3638, 9, -3984, -6198, -5290, -1719,
    2442, 4859, 4260, 1005, -2884, -5086, -4246, -837,
    3141, 5391, 4597, 1024, -3421, -6302, -6019, -2866,
    1111, 3615, 3186, 136, -3775, -6235, -5541, -2035,
    2348, 5226, 5089, 2126, -1879, -4546, -4317, -1355,
    2581, 5128, 4680, 1408, -2965, -6070, -6092, -3000,
    1288, 4380, 4644, 2018, -1819, -4556, -4507, -1478,
    2826, 5962, 6127, 3271, -933, -4166, -4700, -2293,
    1528, 4417, 4550, 1716, -2538, -5755, -6069, -3281,
    1095, 4571, 5371, 3178, -643, -3728, -4207, -1647,
    2454, 5754, 6312, 3663, -581, -4160, -5158, -3018,
    853, 4096, 4755, 2425, -1515, -4848, -5601, -3135,
    1160, 4957, 6351, 4536, 655, -2896, -4143, -2382,
    1287, 4614, 5567, 3375, -865, -4856, -6460, -4739,
    -791, 3033, 4597, 2974, -731, -4238, -5446, -3505,
    589, 4467, 5983, 4351, 441, -3528, -5369, -4020,
    -414, 3241, 4728, 3072, -845, -4901, -6655, -5122,
    -1215, 2954, 5097, 4047, 645, -3032, -4774, -3366,
    392, 4265, 6153, 4884, 1086, -3140, -5561, -4728,
    -1379, 2341, 4335, 3335, -35, -3868, -5920, -4783,
    -935, 3404, 5893, 5275, 1891, -2199, -4623, -3952,
    -637, 3382, 5731, 4908, 1303, -3074, -5870, -5622,
    -2490, 1603, 4256, 3951, 1017, -2721, -5100, -4504,
    -1118, 3116, 5790, 5349, 2095, -2081, -4868, -4697,
    -1794, 2064, 4642, 4347, 1243, -2950, -5836, -5695,
    -2559, 1666, 4767, 5038, 2409, -1364, -4080, -4046,
    -1200, 2788, 5615, 5524, 2495, -1811, -5021, -5390,
    -2831, 1126, 4034, 4275, 1639, -2327, -5238, -5504,
    -2799, 1364, 4726, 5436, 3114, -707, -3824, -4395,
    -2043, 1668, 4627, 5096, 2610, -1488, -4905, -5699,
    -3506, 385, 3767, 4661, 2634, -1051, -4243, -4959,
    -2604, 1490, 5041, 6096, 4040, 103, -3560, -4891,
    -3159, 366, 3508, 4428, 2415, -1411, -4801, -5887,
    -3836, 248, 3892, 5277, 3725, 206, -3191, -4404,
    -2618, 1104, 4603, 5859, 4112, 224, -3622, -5337,
    -3991, -487, 3106, 4653, 3175, -407, -4029, -5519,
    -3943, -143, 3760, 5648, 4502, 1079, -2615, -4528,
    -3372, 18, 3527, 5087, 3682, 13, -3959, -5987,
    -4897, -1414, 2445, 4501, 3622, 448, -3148, -4956,
    -3735, -91, 3938, 6192, 5372, 1966, -2043, -4447,
    -3916, -891, 2748, 4780, 3975, 647, -3278, -5588,
    -4985, -1731, 2378, 5039, 4786, 1935, -1743, -4012,
    -3548, -583, 3196, 5588, 5087, 1954, -2087, -4840,
    -4755, -1951, 1824, 4304, 3996, 1084, -2706, -5301,
    -5026, -1871, 2349, 5395, 5566, 2847, -981, -3822,
    -4007, -1391, 2367, 5049, 4993, 2055, -2066, -5110,
    -5449, -2878, 1067, 4012, 4399, 2036, -1643, -4366,
    -4454, -1758, 2281, 5480, 5948, 3460, -607, -3941,
    -4734, -2598, 1031, 3962, 4463, 2146, -1698, -4954,
    -5642, -3376, 539, 3967, 5032, 3216, -308, -3399,
    -4176, -2063, 1784, 5112, 5970, 3733, -389, -4117,
    -5461, -3674, 46, 3425, 4510, 2621, -1040, -4369,
    -5419, -3396, 593, 4333, 5833, 4255, 675, -2754,
    -4102, -2527, 1023, 4415, 5602, 3741, -196, -4071,
    -5832, -4460, -807, 2988, 4751, 3540, 152, -3349,
    -4788, -3271, 399, 4257, 6069, 4782, 1270, -2496,
    -4465, -3502, -321, 3044, 4571, 3263, -255, -3992,
    -5814, -4561, -943, 2980, 5177, 4432, 1292, -2360,
    -4307, -3298, 28, 3813, 5894, 4971, 1562, -2463,
    -4873, -4431, -1499, 2087, 4095, 3413, 384, -3205,
    -5288, -4533, -1255, 2727, 5225, 4837, 1888, -1815,
    -4144, -3669, -821, 2724, 4934, 4315, 1147, -2934,
    -5619, -5396, -2559, 1280, 3956, 3888, 1251, -2280,
    -4642, -4333, -1367, 2551, 5291, 5268, 2551, -1231,
    -4079, -4368, -1895, 1711, 4242, 4159, 1403, -2472,
    -5260, -5343, -2682, 1318, 4374, 4878, 2668, -931,
    -3681, -3919, -1455, 2261, 5051, 5289, 2761, -1151,
    -4303, -4958, -2815, 767, 3652, 4177, 2007, -1643,
    -4621, -5120, -2702, 1295, 4633, 5507, 3534, -105,
    -3199, -4001, -2102, 1355, 4306, 4984, 2794, -1026,
    -4447, -5555, -3623, 48, 3349, 4488, 2789, -599,
    -3655, -4595, -2645, 1099, 4499, 5753, 4063, 440,
    -3018, -4475, -3063, 250, 3432, 4576, 2861, -743,
    -4155, -5516, -3949, -355, 3234, 4888, 3642, 416,
    -2855, -4234, -2837, 583, 4112, 5589, 4171, 659,
    -3090, -5091, -4146, -953, 2479, 4150, 3021, -189,
    -3644, -5300, -3952, -379, 3413, 5509, 4656, 1507,
    -2088, -4136, -3383, -342, 3191, 5071, 4072, 667,
    -3225, -5507, -4942, -1856, 1851, 4104, 3650, 779,
    -2639, -4591, -3806, -617, 3231, 5585, 5071, 2012,
    -1816, -4302, -4052, -1304, 2169, 4293, 3734, 741,
    -3114, -5644, -5276, -2268, 1672, 4449, 4584, 2088,
    -1488, -3950, -3759, -971, 2783, 5327, 5116, 2241,
    -1663, -4565, -4849, -2412, 1163, 3780, 3865, 1358,
    -2230, -4895, -4917, -2169, 1827, 4943, 5458, 3175,
    -510, -3423, -3919, -1691, 1883, 4650, 4888, 2301,
    -1620, -4795, -5489, -3303, 421, 3503, 4196, 2194,
    -1235, -4065, -4466, -2050, 1759, 4966, 5724, 3622,
    -92, -3378, -4383, -2622, 705, 3591, 4285, 2199,
    -1404, -4652, -5621, -3525, 234, 3604, 4886, 3359,
    29, -3042, -4010, -2226, 1267, 4508, 5552, 3732,
    69, -3425, -4873, -3489, -208, 2976, 4168, 2610,
    -733, -3920, -5107, -3461, 182, 3786, 5376, 4143,
    927, -2374, -3863, -2652, 525, 3725, 5017, 3505,
    -37, -3663, -5430, -4357, -1079, 2470, 4179, 3214,
    244, -3045, -4600, -3298, 131, 3749, 5603, 4665,
    1487, -2145, -4177, -3466, -605, 2640, 4334, 3335,
    191, -3342, -5309, -4530, -1315, 2452, 4634, 4140,
    1350, -1994, -3953, -3284, -313, 3255, 5324, 4660,
    1532, -2257, -4607, -4381, -1710, 1779, 3964, 3512,
    785, -2695, -4948, -4458, -1451, 2314, 4846, 4857,
    2326, -1182, -3609, -3520, -985, 2408, 4693, 4361,
    1563, -2159, -4879, -5032, -2503, 1079, 3702, 3918,
    1576, -1775, -4171, -4092, -1415, 2290, 5034, 5297,
    2880, -831, -3693, -4137, -2019, 1358, 3936, 4139,
    1740, -1894, -4710, -5141, -2855, 841, 3890, 4638,
    2710, -637, -3378, -3879, -1723, 1806, 4700, 5269,
    3055, -653, -3870, -4880, -3106, 281, 3199, 3962,
    2135, -1268, -4255, -5020, -2991, 729, 4023, 5151,
    3524, 189, -2930, -4015, -2412, 847, 3823, 4693,
    2847, -727, -4097, -5410, -3906, -479, 2789, 4115,
    2765, -441, -3513, -4614, -2962, 561, 4009, 5492,
    4170, 779, -2653, -4291, -3273, -271, 2868, 4192,
    2853, -425, -3876, -5465, -4207, -805, 2798, 4641,
    3805, 863, -2414, -4065, -2961, 244, 3634, 5343,
    4271, 979, -2704, -4798, -4155, -1270, 2127, 3970,
    3136, 202, -3197, -5048, -4125, -939, 2847, 5091,
    4616, 1850, -1635, -3792, -3319, -515, 2873, 4799,
    4064, 979, -2767, -5156, -4866, -2074, 1534, 3925,
    3753, 1203, -2111, -4229, -3737, -851, 2832, 5263,
    5042, 2375, -1252, -3817, -3870, -1484, 1808, 4018,
    3730, 1080, -2477, -5022, -4973, -2300, 1367, 4076,
    4392, 2135, -1155, -3560, -3616, -1199, 2262, 4804,
    4879, 2391, -1323, -4175, -4670, -2615, 737, 3310,
    3641, 1484, -1862, -4438, -4689, -2330, 1335, 4296,
    4930, 2982, -353, -3114, -3696, -1772, 1455, 4071,
    4468, 2287, -1302, -4395, -5238, -3352, 108, 3079,
    3928, 2255, -881, -3613, -4260, -2245, 1283, 4338,
    5286, 3538, 132, -2998, -4186, -2726, 390, 3204,
    4057, 2319, -1028, -4093, -5135, -3524, -77, 3178,
    4500, 3272, 236, -2676, -3780, -2326, 925, 4058,
    5209, 3692, 315, -3039, -4586, -3542, -521, 2564,
    3885, 2655, -381, -3470, -4770, -3380, -89, 3345,
    5058, 4081, 1098, -2103, -3711, -2769, 116, 3196,
    4652, 3524, 339, -3135, -5036, -4287, -1328, 2027,
    3870, 3204, 472, -2609, -4268, -3381, -320, 3158,
    5097, 4448, 1619, -1827, -3967, -3589, -969, 2164,
    3958, 3269, 407, -2988, -5062, -4516, -1667, 1875,
    4216, 4009, 1548, -1635, -3668, -3245, -603, 2744,
    4893, 4511, 1751, -1835, -4352, -4369, -2010, 1258,
    3549, 3399, 939, -2343, -4593, -4415, -1762, 1840,
    4443, 4699, 2479, -873, -3396, -3575, -1347, 1908,
    4266, 4236, 1751, -1800, -4531, -4937, -2791, 649,
    3352, 3799, 1783, -1352, -3805, -4065, -1734, 1802,
    4605, 5129, 3038, -447, -3351, -4081, -2305, 855,
    3489, 3919, 1890, -1532, -4463, -5170, -3190, 355,
    3405, 4386, 2848, -239, -3016, -3770, -1904, 1410,
    4287, 5064, 3208, -246, -3497, -4738, -3298, -166,
    2752, 3750, 2201, -967, -3922, -4874, -3143, 294,
    3591, 4972, 3700, 581, -2511, -3831, -2573, 473,
    3449, 4577, 3047, -331, -3677, -5194, -4048, -925,
    2310, 3815, 2833, -32, -3052, -4268, -2943, 230,
    3561, 5162, 4089, 1009, -2306, -4047, -3266, -484,
    2519, 3967, 2897, -130, -3437, -5139, -4193, -1150,
    2269, 4209, 3641, 1009, -2074, -3783, -2951, -105,
    3120, 4879, 4123, 1178, -2357, -4449, -4042, -1510,
    1627, 3524, 3025, 358, -2831, -4639, -4008, -1135,
    2364, 4593, 4348, 1839, -1383, -3450, -3194, -773,
    2352, 4296, 3826, 1116, -2335, -4703, -4634, -2206,
    1130, 3480, 3468, 1223, -1846, -3974, -3738, -1139,
    2274, 4655, 4678, 2359, -1026, -3565, -3814, -1712,
    1359, 3567, 3554, 1195, -2118, -4580, -4739, -2447,
    965, 3615, 4095, 2182, -853, -3207, -3476, -1379,
    1862, 4376, 4654, 2468, -965, -3761, -4469, -2716,
    391, 2977, 3479, 1631, -1482, -4095, -4538, -2468,
    933, 3839, 4699, 3070, -70, -2816, -3583, -1951,
    1063, 3661, 4250, 2431, -883, -3909, -4920, -3368,
    -217, 2701, 3733, 2327, -567, -3255, -4080, -2437,
    795, 3828, 4926, 3535, 393, -2671, -3964, -2837,
    24, 2799, 3836, 2414, -729, -3754, -4968, -3639,
    -508, 2682, 4192, 3215, 415, -2461, -3687, -2520,
    445, 3471, 4812, 3662, 569, -2742, -4441, -3632,
    -925, 2060, 3557, 2657, -92, -3111, -4634, -3612,
    -579, 2782, 4636, 3993, 1339, -1759, -3530, -2912,
    -314, 2716, 4330, 3476, 581, -2773, -4774, -4331,
    -1682, 1567, 3551, 3196, 715, -2276, -4039, -3420,
    -673, 2673, 4821, 4436, 1820, -1488, -3719, -3575,
    -1291, 1740, 3712, 3327, 775, -2558, -4783, -4588,
    -2035, 1383, 3808, 3929, 1794, -1275, -3416, -3300,
    -919, 2319, 4552, 4478, 2055, -1371, -3965, -4333,
    -2285, 843, 3176, 3313, 1167, -1959, -4318, -4360,
    -2042, 1406, 4127, 4606, 2679, -466, -2998, -3494,
    -1595, 1491, 3895, 4171, 2011, -1424, -4229, -4859,
    -2989, 219, 2927, 3632, 1987, -1056, -3559, -3975,
    -1975, 1363, 4162, 4896, 3150, -100, -2970, -3879,
    -2410, 508, 3072, 3680, 1947, -1207, -4049, -4896,
    -3232, 4, 2981, 4080, 2807, -32, -2711, -3580,
    -2080, 951, 3784, 4718, 3200, -2, -3111, -4403,
    -3279, -465, 2354, 3492, 2191, -721, -3508, -4564,
    -3158, -26, 3133, 4580, 3544, 739, -2177, -3506,
    -2455, 289, 3057, 4228, 2990, 1, -3156, -4741,
    -3852, -1070, 2011, 3618, 2806, 207, -2609, -3992,
    -2935, -15, 3118, 4768, 3970, 1243, -1903, -3744,
    -3207, -679, 2159, 3646, 2833, 98, -2993, -4713,
    -4070, -1335, 1936, 3892, 3553, 1171, -1727, -3434,
    -2912, -408, 2673, 4516, 3966, 1303, -1951, -4078,
    -3946, -1683, 1315, 3247, 2932, 623, -2375, -4318,
    -3908, -1375, 1891, 4171, 4190, 2020, -1044, -3199,
    -3174, -989, 1967, 3959, 3742, 1331, -1938, -4316,
    -4463, -2326, 843, 3175, 3374, 1423, -1474, -3641,
    -3662, -1400, 1836, 4268, 4521, 2492, -689, -3216,
    -3703, -1923, 981, 3261, 3496, 1442, -1743, -4225,
    -4614, -2655, 597, 3276, 3953, 2325, -587, -2967,
    -3412, -1575, 1455, 3975, 4485, 2638, -557, -3420,
    -4316, -2820, 80, 2658, 3400, 1846, -1090, -3701,
    -4413, -2654, 553, 3436, 4489, 3151, 281, -2456,
    -3484, -2136, 679, 3337, 4166, 2544, -549, -3514,
    -4742, -3479, -549, 2328, 3568, 2431, -286, -2924,
    -3919, -2584, 433, 3447, 4751, 3634, 717, -2302,
    -3748, -2863, -316, 2447, 3641, 2508, -304, -3337,
    -4780, -3792, -909, 2258, 3954, 3295, 783, -2087,
    -3506, -2612, 100, 3090, 4591, 3728, 911, -2310,
    -4220, -3741, -1238, 1671, 3353, 2703, 146, -2774,
    -4431, -3706, -921, 2372, 4374, 4042, 1638, -1408,
    -3277, -2937, -607, 2366, 4090, 3535, 867, -2426,
    -4537, -4351, -1959, 1203, 3280, 3159, 1015, -1903,
    -3775, -3385, -901, 2319, 4498, 4397, 2073, -1124,
    -3401, -3494, -1440, 1399, 3365, 3242, 949, -2184,
    -4409, -4418, -2142, 1044, 3439, 3774, 1878, -987,
    -3113, -3199, -1103, 1951, 4153, 4269, 2150, -1063,
    -3614, -4120, -2345, 543, 2842, 3157, 1283, -1655,
    -3904, -4143, -2122, 1068, 3695, 4303, 2620, -284,
    -2686, -3261, -1647, 1183, 3511, 3910, 2052, -1060,
    -3773, -4538, -2937, -28, 2608, 3424, 2000, -713,
    -3138, -3732, -2024, 1036, 3712, 4559, 3103, 164,
    -2623, -3688, -2423, 274, 2743, 3519, 2008, -891,
    -3582, -4594, -3230, -234, 2650, 3897, 2821, 170,
    -2399, -3399, -2159, 611, 3372, 4438, 3146, 223,
    -2720, -4168, -3271, -667, 2022, 3271, 2254, -361,
    -3111, -4300, -3128, -265, 2737, 4267, 3518, 969,
    -1882, -3346, -2551, -41, 2690, 4008, 3052, 278,
    -2790, -4485, -3838, -1262, 1679, 3367, 2793, 449,
    -2229, -3753, -2985, -340, 2690, 4431, 3924, 1455,
    -1596, -3510, -3194, -939, 1811, 3454, 2901, 414,
    -2598, -4436, -4015, -1578, 1526, 3609, 3532, 1395,
    -1411, -3188, -2919, -635, 2335, 4216, 3926, 1603,
    -1538, -3799, -3879, -1892, 987, 3037, 2966, 899,
    -1990, -4039, -3942, -1624, 1558, 3869, 4112, 2205,
    -691, -2927, -3165, -1275, 1576, 3701, 3727, 1544,
    -1575, -3998, -4395, -2517, 457, 2857, 3343, 1579,
    -1195, -3350, -3556, -1635, 1434, 3952, 4460, 2713,
    -327, -2895, -3577, -2077, 635, 2967, 3405, 1647,
    -1306, -3879, -4544, -2855, 170, 2925, 3846, 2516,
    -185, -2671, -3354, -1804, 1098, 3671, 4410, 2846,
    -171, -3039, -4185, -2954, -237, 2341, 3271, 1956,
    -799, -3407, -4302, -2855, 160, 3114, 4355, 3277,
    609, -2129, -3300, -2249, 367, 3021, 4034, 2745,
    -191, -3169, -4578, -3610, -895, 1967, 3394, 2565,
    53, -2589, -3728, -2636, 155, 3100, 4543, 3713,
    1007, -1966, -3534, -2897, -486, 2154, 3466, 2577,
    -42, -2920, -4495, -3730, -1067, 1930, 3684, 3231,
    941, -1759, -3263, -2604, -127, 2725, 4314, 3649,
    1080, -1955, -3887, -3599, -1366, 1388, 3085, 2664,
    371, -2431, -4065, -3541, -1096, 1995, 3997, 3833,
    1668, -1155, -2993, -2833, -697, 2047, 3760, 3386,
    1076, -1979, -4138, -4082, -1967, 919, 2997, 3055,
    1136, -1568, -3450, -3271, -1058, 1947, 4107, 4204,
    2159, -813, -3086, -3397, -1580, 1140, 3121, 3124,
    1091, -1815, -4022, -4239, -2266, 769, 3146, 3634,
    1975, -723, -2834, -3127, -1295, 1575, 3805, 4090,
    2223, -777, -3292, -3960, -2447, 269, 2588, 3080,
    1466, -1267, -3597, -4024, -2232, 761, 3327, 4097,
    2711, -22, -2457, -3189, -1803, 867, 3199, 3775,
    2178, -747, -3426, -4370, -3032, -247, 2341, 3272,
    2074, -428, -2831, -3628, -2188, 659, 3328, 4336,
    3159, 390, -2354, -3516, -2525, -28, 2428, 3408,
    2176, -583, -3257, -4369, -3250, -541, 2303, 3681,
    2895, 463, -2093, -3230, -2265, 317, 2985, 4211,
    3222, 549, -2350, -3925, -3271, -929, 1735, 3141,
    2362, -28, -2732, -4115, -3237, -573, 2375, 4046,
    3558, 1251, -1518, -3161, -2641, -357, 2332, 3822,
    3090, 551, -2415, -4232, -3857, -1530, 1335, 3110,
    2841, 695, -1994, -3558, -3015, -661, 2296, 4194,
    3948, 1695, -1260, -3242, -3190, -1227, 1443, 3225,
    2916, 697, -2201, -4213, -4055, -1859, 1118, 3337,
    3484, 1636, -1055, -3007, -2975, -897, 1974, 3986,
    3990, 1863, -1184, -3535, -3882, -2085, 663, 2746,
    2956, 1082, -1674, -3790, -3972, -1908, 1178, 3601,
    4088, 2430, -370, -2663, -3077, -1454, 1247, 3431,
    3689, 1812, -1239, -3730, -4340, -2756, 87, 2544,
    3222, 1792, -853, -3103, -3513, -1795, 1128, 3623,
    4335, 2852, -5, -2607, -3464, -2170, 386, 2680,
    3295, 1775, -1021, -3548, -4369, -2912, -53, 2580,
    3642, 2545, 33, -2358, -3174, -1906, 779, 3320,
    4164, 2829, 43, -2658, -3903, -2919, -424, 2019,
    3064, 2004, -575, -3055, -4004, -2830, -58, 2719,
    4024, 3172, 689, -1870, -3090, -2239, 176, 2633,
    3712, 2665, 34, -2775, -4245, -3456, -1011, 1683,
    3142, 2485, 241, -2258, -3529, -2648, -77, 2705,
    4202, 3551, 1144, -1644, -3327, -2895, -685, 1839,
    3223, 2551, 153, -2604, -4186, -3671, -1275, 1616,
    3420, 3153, 1047, -1495, -3077, -2621, -409, 2310,
    3973, 3535, 1231, -1683, -3615, -3564, -1571, 1075,
    2837, 2628, 587, -2079, -3833, -3527, -1275, 1651,
    3655, 3703, 1827, -887, -2839, -2864, -979, 1659,
    3478, 3336, 1238, -1676, -3836, -3993, -2112, 631,
    2751, 2990, 1258, -1264, -3199, -3264, -1311, 1551,
    3742, 4038, 2276, -569, -2844, -3312, -1751, 799,
    2817, 3079, 1307, -1478, -3717, -4115, -2422, 426,
    2826, 3497, 2143, -444, -2573, -3026, -1510, 1199,
    3461, 3945, 2367, -431, -2984, -3830, -2549, -36,
    2287, 2999, 1644, -953, -3289, -3959, -2423, 423,
    2984, 3944, 2804, 272, -2153, -3087, -1987, 487,
    2887, 3680, 2278, -474, -3092, -4194, -3170, -573,
    2010, 3111, 2180, -198, -2559, -3506, -2366, 290,
    2985, 4192, 3231, 675, -1995, -3348, -2625, -352,
    2103, 3215, 2238, -238, -2934, -4266, -3394, -895,
    1920, 3485, 2932, 723, -1799, -3095, -2400, 11,
    2661, 4038, 3319, 843, -2012, -3751, -3374, -1163,
    1430, 2889, 2401, 190, -2415, -3937, -3353, -929,
    2014, 3863, 3582, 1476, -1204, -2924, -2654, -605,
    1994, 3613, 3156, 803, -2109, -4031, -3895, -1808,
    949, 2872, 2839, 933, -1650, -3336, -3032, -861,
    1995, 3935, 3888, 1911, -945, -2999, -3129, -1375,
    1184, 2983, 2888, 871, -1890, -3886, -3952, -1963,
    879, 3013, 3360, 1726, -827, -2735, -2853, -1082,
    1632, 3677, 3790, 1924, -897, -3170, -3686, -2137,
    413, 2465, 2829, 1176, -1431, -3463, -3720, -1947,
    869, 3216, 3832, 2383, -203, -2360, -2929, -1540,
    973, 3084, 3492, 1847, -901, -3319, -4055, -2681,
    -106, 2250, 3025, 1823, -599, -2773, -3336, -1870,
    837, 3266, 4066, 2772, 173, -2303, -3293, -2208,
    162, 2376, 3103, 1842, -747, -3184, -4102, -2927,
    -284, 2268, 3450, 2535, 187, -2094, -3018, -1967,
    476, 2944, 3927, 2822, 250, -2375, -3668, -2919,
    -661, 1747, 2896, 2035, -273, -2711, -3840, -2841,
    -299, 2391, 3782, 3135, 901, -1628, -2948, -2341,
    -123, 2336, 3525, 2717, 312, -2399, -3991, -3461,
    -1182, 1419, 2922, 2527, 452, -1963, -3310, -2705,
    -375, 2335, 3916, 3518, 1326, -1388, -3066, -2849,
    -923, 1531, 3032, 2601, 414, -2260, -3905, -3599,
    -1479, 1284, 3173, 3143, 1291, -1207, -2825, -2624,
    -635, 1979, 3704, 3511, 1476, -1307, -3364, -3484,
    -1731, 787, 2647, 2673, 833, -1747, -3574, -3536,
    -1500, 1298, 3377, 3671, 2006, -565, -2583, -2842,
    -1202, 1323, 3239, 3311, 1408, -1340, -3504, -3932,
    -2318, 351, 2476, 2900, 1439, -1007, -2951, -3216,
    -1542, 1200, 3463, 3966, 2436, -248, -2551, -3209,
    -1910, 461, 2556, 3017, 1498, -1127, -3441, -4044,
    -2588, 57, 2543, 3407, 2261, -106, -2321, -2970,
    -1667, 885, 3194, 3880, 2554, -106, -2681, -3718,
    -2695, -279, 2007, 2860, 1755, -665, -2969, -3856,
    -2602, 45, 2671, 3864, 2937, 561, -1884, -2950,
    -2063, 259, 2620, 3538, 2478, -121, -2791, -4053,
    -3256, -875, 1671, 2964, 2286, 91, -2274, -3351,
    -2402, 65, 2674, 3999, 3286, 933, -1710, -3146,
    -2613, -506, 1847, 3053, 2290, -5, -2575, -4001,
    -3367, -1050, 1660, 3246, 2876, 885, -1523, -2878,
    -2357, -211, 2349, 3815, 3262, 997, -1667, -3423,
    -3239, -1279, 1163, 2703, 2359, 358, -2128, -3591,
    -3156, -1035, 1692, 3514, 3413, 1487, -999, -2629,
    -2536, -699, 1736, 3286, 3012, 991, -1715, -3640,
    -3644, -1795, 747, 2623, 2737, 1035, -1350, -3032,
    -2949, -1017, 1659, 3584, 3695, 1954, -699, -2724,
    -3010, -1470, 947, 2695, 2799, 1055, -1554, -3526,
    -3784, -2061, 595, 2758, 3231, 1767, -611, -2504,
    -2785, -1211, 1307, 3316, 3639, 2003, -641, -2873,
    -3503, -2223, 149, 2233, 2719, 1339, -1079, -3146,
    -3564, -2039, 595, 2898, 3624, 2442, 35, -2137,
    -2830, -1664, 689, 2800, 3352, 1967, -585, -3000,
    -3879, -2735, -297, 1991, 2889, 1920, -353, -2469,
    -3166, -1998, 473, 2921, 3884, 2815, 403, -2039,
    -3111, -2281, -134, 2111, 2999, 1940, -481, -2863,
    -3904, -2969, -561, 1975, 3247, 2583, 460, -1828,
    -2886, -2047, 233, 2602, 3725, 2877, 503, -2103,
    -3498, -2967, -905, 1487, 2757, 2151, 9, -2407,
    -3663, -2928, -585, 2053, 3573, 3144, 1123, -1299,
    -2754, -2388, -408, 2010, 3343, 2758, 527, -2085,
    -3734, -3461, -1420, 1110, 2708, 2518, 653, -1712,
    -3132, -2743, -673, 1979, 3692, 3500, 1539, -1063,
    -2871, -2888, -1143, 1207, 2807, 2606, 681, -1923,
    -3748, -3650, -1735, 915, 2905, 3087, 1475, -907,
    -2639, -2639, -865, 1667, 3487, 3529, 1702, -991,
    -3089, -3473, -1932, 533, 2384, 2586, 999, -1439,
    -3343, -3536, -1770, 947, 3164, 3634, 2180, -280,
    -2324, -2764, -1387, 1043, 2999, 3261, 1663, -1032,
    -3278, -3868, -2513, 12, 2198, 2848, 1624, -713,
    -2732, -3137, -1655, 905, 3169, 3824, 2528, 25,
    -2266, -3071, -1996, 281, 2295, 2888, 1628, -855,
    -3116, -3894, -2626, -105, 2238, 3199, 2253, 51,
    -2071, -2831, -1739, 611, 2885, 3709, 2540, 82,
    -2314, -3471, -2657, -459, 1751, 2710, 1799, -464,
    -2680, -3538, -2553, -174, 2360, 3591, 2834, 645,
    -1631, -2724, -2034, 69, 2293, 3288, 2413, 101,
    -2424, -3753, -3101, -983, 1422, 2760, 2244, 269,
    -1955, -3116, -2392, -155, 2335, 3695, 3161, 1074,
    -1435, -2913, -2581, -675, 1591, 2822, 2273, 193,
    -2226, -3688, -3294, -1211, 1355, 3000, 2825, 989,
    -1288, -2693, -2362, -417, 2000, 3504, 3174, 1127,
    -1435, -3151, -3158, -1455, 891, 2503, 2341, 569,
    -1800, -3401, -3159, -1198, 1376, 3216, 3305, 1651,
    -739, -2480, -2559, -919, 1423, 3056, 2973, 1167,
    -1391, -3375, -3608, -1951, 527, 2400, 2686, 1191,
    -1086, -2785, -2870, -1231, 1279, 3313, 3607, 2047,
    -439, -2472, -2917, -1608, 637, 2504, 2770, 1204,
    -1264, -3263, -3655, -2185, 304, 2477, 3130, 1930,
    -335, -2263, -2720, -1367, 1019, 3021, 3511, 2146,
    -349, -2639, -3410, -2298, -85, 1983, 2661, 1511,
    -797, -2878, -3494, -2189, 306, 2604, 3505, 2527,
    309, -1871, -2732, -1799, 387, 2521, 3261, 2066,
    -332, -2661, -3728, -2839, -539, 1722, 2748, 1999,
    -121, -2210, -3087, -2144, 200, 2600, 3724, 2927,
    657, -1734, -2940, -2357, -374, 1804, 2861, 2039,
    -151, -2534, -3782, -3039, -839, 1659, 3094, 2631,
    695, -1550, -2741, -2158, -57, 2320, 3583, 2998,
    831, -1732, -3320, -3023, -1095, 1207, 2568, 2167,
    205, -2103, -3486, -3034, -877, 1715, 3384, 3221,
    1366, -1038, -2600, -2397, -599, 1730, 3184, 2831,
    783, -1835, -3575, -3484, -1671, 779, 2503, 2528,
    859, -1443, -2927, -2744, -859, 1687, 3470, 3477,
    1730, -799, -2641, -2824, -1271, 1003, 2570, 2584,
    849, -1646, -3441, -3567, -1843, 695, 2638, 2983,
    1562, -681, -2426, -2570, -1034, 1360, 3238, 3396,
    1731, -757, -2781, -3303, -1959, 300, 2158, 2501,
    1079, -1219, -3063, -3287, -1778, 679, 2834, 3400,
    2150, -123, -2086, -2607, -1392, 809, 2695, 3076,
    1676, -739, -2943, -3598, -2406, -154, 1950, 2688,
    1647, -492, -2407, -2968, -1727, 683, 2849, 3598,
    2511, 200, -2011, -2906, -2042, 77, 2072, 2737,
    1659, -605, -2761, -3650, -2647, -345, 1954, 3047,
    2272, 205, -1843, -2711, -1788, 373, 2545, 3455,
    2551, 287, -2077, -3255, -2639, -653, 1494, 2537,
    1834, -193, -2373, -3408, -2568, -353, 2039, 3334,
    2798, 833, -1406, -2625, -2116, -155, 2012, 3113,
    2437, 315, -2117, -3550, -3105, -1107, 1199, 2584,
    2247, 423, -1703, -2916, -2430, -426, 1986, 3484,
    3159, 1186, -1175, -2733, -2594, -889, 1296, 2655,
    2301, 422, -1962, -3480, -3254, -1391, 1068, 2768,
    2797, 1176, -1046, -2502, -2366, -623, 1710, 3262,
    3137, 1339, -1176, -2983, -3124, -1615, 621, 2304,
    2393, 779, -1495, -3162, -3173, -1408, 1082, 2959,
    3230, 1800, -465, -2272, -2543, -1131, 1099, 2844,
    2934, 1288, -1123, -3109, -3536, -2116, 193, 2132,
    2594, 1323, -853, -2604, -2866, -1454, 967, 3021,
    3502, 2191, -172, -2223, -2863, -1774, 338, 2231,
    2672, 1354, -955, -3031, -3629, -2369, -14, 2175,
    3002, 2014, -118, -2063, -2649, -1523, 721, 2775,
    3444, 2295, -66, -2360, -3337, -2436, -314, 1711,
    2534, 1568, -571, -2632, -3439, -2374, -48, 2309,
    3408, 2608, 523, -1635, -2646, -1879, 138, 2255,
    3138, 2199, -98, -2458, -3629, -2954, -847, 1424,
    2620, 2031, 66, -1999, -2974, -2221, -31, 2294,
    3514, 2927, 875, -1479, -2783, -2381, -539, 1554,
    2660, 2072, 14, -2279, -3565, -3055, -999, 1394,
    2820, 2544, 801, -1342, -2598, -2161, -287, 1995,
    3341, 2889, 913, -1475, -3069, -2928, -1204, 961,
    2337, 2101, 337, -1852, -3178, -2887, -1019, 1431,
    3079, 3015, 1376, -853, -2357, -2301, -723, 1452,
    2885, 2663, 897, -1508, -3244, -3294, -1711, 565,
    2276, 2409, 955, -1175, -2704, -2676, -991, 1391,
    3138, 3272, 1727, -595, -2434, -2721, -1391, 713,
    2356, 2481, 933, -1339, -3151, -3439, -1936, 418,
    2346, 2813, 1600, -519, -2248, -2522, -1175, 1059,
    2892, 3213, 1816, -549, -2534, -3136, -2048, 49,
    1923, 2404, 1187, -919, -2782, -3245, -1888, 457,
    2519, 3191, 2174, 55, -1919, -2552, -1523, 551,
    2447, 2972, 1778, -486, -2638, -3454, -2476, -315,
    1750, 2575, 1716, -273, -2160, -2841, -1832, 359,
    2543, 3464, 2557, 410, -1747, -2746, -2044, -138,
    1816, 2657, 1787, -335, -2512, -3445, -2616, -575,
    1712, 2901, 2336, 454, -1579, -2530, -1836, 155,
    2274, 3300, 2598, 529, -1803, -3063, -2625, -821,
    1278, 2463, 1959, 63, -2039, -3202, -2600, -541,
    1776, 3154, 2863, 1096, -1103, -2412, -2116, -392,
    1767, 2981, 2496, 563, -1771, -3279, -3068, -1296,
    945, 2429, 2297, 655, -1443, -2745, -2440, -615,
    1735, 3289, 3159, 1423, -873, -2455, -2529, -1051,
    1063, 2532, 2388, 679, -1611, -3244, -3199, -1546,
    775, 2600, 2814, 1398, -759, -2312, -2319, -791,
    1491, 3146, 3215, 1619, -771, -2662, -3047, -1718,
    472, 2138, 2351, 977, -1199, -2888, -3079, -1558,
    811, 2809, 3303, 1991, -165, -1975, -2420, -1210,
    911, 2678, 2975, 1567, -835, -2832, -3338, -2190,
    -36, 1972, 2581, 1499, -547, -2324, -2727, -1451,
    815, 2816, 3464, 2368, 142, -1906, -2655, -1747,
    256, 2064, 2637, 1527, -663, -2678, -3397, -2327,
    -111, 1984, 2878, 2119, 157, -1739, -2434, -1511,
    545, 2586, 3358, 2335, 176, -1984, -2989, -2301,
    -412, 1574, 2452, 1660, -292, -2255, -3097, -2244,
    -124, 2106, 3199, 2592, 687, -1359, -2386, -1799,
    52, 2022, 2967, 2236, 185, -2054, -3248, -2748,
    -869, 1274, 2465, 2072, 316, -1670, -2695, -2119,
    -159, 2044, 3305, 2873, 1017, -1188, -2522, -2276,
    -659, 1372, 2526, 2071, 250, -1896, -3239, -2911,
    -1086, 1171, 2671, 2551, 965, -1082, -2367, -2106,
    -403, 1770, 3098, 2830, 1068, -1211, -2764, -2809,
    -1311, 771, 2206, 2103, 571, -1516, -2970, -2794,
    -1079, 1203, 2821, 2932, 1519, -613, -2175, -2272,
    -861, 1231, 2703, 2673, 1067, -1226, -2950, -3192,
    -1763, 424, 2100, 2378, 1095, -893, -2445, -2561,
    -1111, 1084, 2894, 3238, 1839, -338, -2143, -2599,
    -1444, 535, 2189, 2437, 1115, -1059, -2853, -3209,
    -1959, 215, 2166, 2799, 1754, -256, -1964, -2410,
    -1239, 865, 2658, 3127, 1940, -277, -2256, -2974,
    -2110, -123, 1736, 2362, 1371, -669, -2534, -3106,
    -1975, 201, 2264, 3098, 2274, 325, -1634, -2430,
    -1631, 289, 2192, 2852, 1874, -251, -2364, -3308,
    -2554, -581, 1451, 2431, 1783, -72, -1966, -2759,
    -1956, 105, 2268, 3244, 2599, 619, -1511, -2628,
    -2141, -380, 1543, 2511, 1811, -104, -2218, -3357,
    -2737, -813, 1395, 2701, 2338, 635, -1375, -2445,
    -1954, -121, 1984, 3133, 2640, 765, -1499, -2927,
    -2722, -1043, 1023, 2254, 1940, 203, -1835, -3101,
    -2725, -831, 1443, 2974, 2850, 1199, -887, -2268,
    -2159, -599, 1472, 2784, 2528, 725, -1582, -3134,
    -3093, -1548, 609, 2191, 2225, 791, -1224, -2590,
    -2465, -813, 1428, 3025, 3061, 1547, -675, -2321,
    -2503, -1167, 813, 2225, 2300, 769, -1431, -3041,
    -3180, -1682, 555, 2285, 2613, 1411, -585, -2143,
    -2311, -963, 1155, 2829, 3015, 1558, -631, -2461,
    -2905, -1775, 194, 1876, 2198, 989, -1035, -2660,
    -2943, -1656, 543, 2452, 3000, 1923, -95, -1831,
    -2341, -1303, 625, 2328, 2749, 1503, -625, -2575,
    -3234, -2218, -190, 1674, 2340, 1491, -413, -2144,
    -2626, -1586, 515, 2471, 3159, 2233, 208, -1755,
    -2581, -1859, -38, 1762, 2428, 1487, -513, -2438,
    -3263, -2409, -375, 1682, 2655, 2016, 213, -1627,
    -2415, -1638, 244, 2188, 3040, 2255, 275, -1810,
    -2896, -2399, -657, 1255, 2225, 1635, -148, -2090,
    -3042, -2341, -374, 1732, 2900, 2471, 763, -1231,
    -2329, -1930, -227, 1710, 2708, 2188, 304, -1864,
    -3135, -2813, -1074, 997, 2231, 1991, 417, -1492,
    -2602, -2189, -445, 1679, 3020, 2773, 1070, -1032,
    -2405, -2311, -869, 1071, 2327, 2038, 368, -1715,
    -3066, -2898, -1307, 859, 2423, 2480, 1074, -911,
    -2223, -2158, -627, 1451, 2830, 2761, 1207, -1009,
    -2622, -2791, -1496, 489, 1979, 2086, 713, -1319,
    -2815, -2854, -1322, 897, 2575, 2848, 1603, -398,
    -2010, -2293, -1075, 905, 2454, 2583, 1156, -977,
    -2740, -3154, -1943, 94, 1843, 2289, 1171, -747,
    -2294, -2570, -1334, 791, 2612, 3088, 1955, -141,
    -1971, -2558, -1628, 238, 1926, 2348, 1215, -825,
    -2671, -3247, -2159, -89, 1864, 2639, 1799, -64,
    -1807, -2359, -1422, 559, 2416, 3045, 2054, -4,
    -2044, -2937, -2215, -360, 1479, 2223, 1419, -464,
    -2287, -3031, -2145, -107, 1979, 2994, 2325, 479,
    -1423, -2336, -1718, 75, 1938, 2761, 1986, -47,
    -2128, -3180, -2639, -817, 1195, 2271, 1811, 116,
    -1719, -2620, -1983, -87, 1979, 3092, 2602, 801,
    -1294, -2471, -2161, -547, 1343, 2328, 1851, 46,
    -2022, -3170, -2735, -947, 1144, 2446, 2277, 737,
    -1162, -2295, -1959, -297, 1711, 2951, 2581, 813,
    -1291, -2697, -2624, -1160, 791, 2064, 1867, 325,
    -1614, -2845, -2591, -967, 1179, 2701, 2692, 1247,
    -733, -2092, -2090, -709, 1223, 2534, 2402, 841,
    -1311, -2881, -2958, -1558, 466, 1983, 2141, 875,
    -1044, -2397, -2398, -937, 1183, 2765, 2934, 1583,
    -486, -2138, -2441, -1291, 581, 2055, 2191, 857,
    -1156, -2780, -3064, -1767, 306, 2076, 2534, 1436,
    -446, -1976, -2254, -1071, 899, 2535, 2855, 1643,
    -443, -2239, -2815, -1875, -22, 1651, 2124, 1091,
    -775, -2433, -2871, -1763, 307, 2200, 2850, 1960,
    75, -1664, -2278, -1427, 436, 2106, 2623, 1624,
    -414, -2343, -3111, -2282, -341, 1499, 2271, 1531,
    -238, -1915, -2551, -1687, 242, 2213, 3058, 2255,
    354, -1546, -2480, -1899, -218, 1571, 2342, 1572,
    -285, -2202, -3089, -2436, -585, 1455, 2543, 2098,
    403, -1407, -2279, -1728, 48, 1959, 2910, 2327,
    478, -1595, -2746, -2429, -839, 1051, 2148, 1736,
    43, -1859, -2895, -2404, -585, 1527, 2772, 2530,
    963, -987, -2207, -1980, -431, 1483, 2605, 2206,
    495, -1598, -2966, -2822, -1274, 741, 2087, 2018,
    577, -1302, -2489, -2263, -673, 1442, 2881, 2817,
    1296, -785, -2255, -2341, -1026, 845, 2166, 2095,
    605, -1454, -2960, -2965, -1494, 603, 2234, 2465,
    1251, -697, -2109, -2151, -809, 1207, 2709, 2804,
    1408, -723, -2413, -2778, -1654, 293, 1827, 2062,
    849, -1087, -2638, -2822, -1502, 607, 2431, 2903,
    1750, -179, -1823, -2255, -1163, 715, 2294, 2615,
    1375, -767, -2557, -3100, -2095, -132, 1670, 2263,
    1324, -529, -2134, -2535, -1427, 607, 2430, 3025,
    2074, 83, -1783, -2469, -1699, 88, 1759, 2311,
    1324, -629, -2439, -3144, -2205, -194, 1679, 2518,
    1871, 115, -1616, -2295, -1487, 360, 2199, 2951,
    2087, 111, -1822, -2767, -2206, -493, 1308, 2111,
    1450, -303, -2078, -2846, -2137, -260, 1779, 2813,
    2311, 605, -1255, -2207, -1720, -60, 1723, 2610,
    1962, 141, -1870, -3015, -2557, -875, 1031, 2142,
    1806, 264, -1523, -2471, -1975, -233, 1783, 2936,
    2575, 907, -1087, -2311, -2126, -699, 1155, 2223,
    1842, 232, -1722, -2920, -2685, -1115, 965, 2353,
    2278, 863, -979, -2153, -1950, -461, 1490, 2767,
    2569, 991, -1084, -2525, -2575, -1263, 599, 1947,
    1896, 487, -1390, -2685, -2600, -1094, 985, 2514,
    2655, 1375, -545, -1987, -2125, -849, 1035, 2357,
    2396, 997, -1086, -2684, -2924, -1671, 298, 1843,
    2122, 991, -821, -2223, -2361, -1099, 911, 2559,
    2876, 1643, -305, -1944, -2389, -1380, 399, 1919,
    2184, 991, -959, -2574, -2962, -1851, 107, 1895,
    2481, 1574, -204, -1780, -2212, -1192, 697, 2335,
    2770, 1739, -228, -2057, -2745, -1944, -193, 1486,
    2103, 1242, -569, -2257, -2814, -1868, 114, 1987,
    2749, 2078, 311, -1487, -2247, -1543, 187, 1911,
    2567, 1695, -209, -2105, -2973, -2329, -605, 1263,
    2170, 1611, -41, -1759, -2513, -1791, 36, 1947,
    2894, 2359, 593, -1340, -2370, -1984, -422, 1322,
    2232, 1664, -83, -1994, -3031, -2534, -789, 1183,
    2370, 2119, 591, -1227, -2188, -1787, -211, 1731,
    2806, 2376, 715, -1336, -2615, -2481, -987, 875,
    1966, 1747, 238, -1640, -2765, -2453, -847, 1238,
    2631, 2568, 1123, -785, -2052, -1966, -603, 1244,
    2472, 2269, 683, -1371, -2786, -2828, -1459, 498,
    1922, 1999, 729, -1086, -2318, -2236, -775, 1230,
    2663, 2751, 1426, -555, -2057, -2273, -1114, 677,
    1988, 2039, 685, -1215, -2696, -2894, -1558, 444,
    1995, 2330, 1299, -483, -1895, -2084, -921, 995,
    2496, 2674, 1443, -521, -2191, -2625, -1631, 131,
    1644, 1970, 917, -901, -2375, -2646, -1507, 428,
    2143, 2673, 1727, -49, -1599, -2102, -1230, 537,
    2060, 2440, 1396, -531, -2263, -2879, -2026, -233,
    1456, 2087, 1344, -317, -1891, -2360, -1454, 371,
    2159, 2838, 2028, 238, -1543, -2312, -1668, -59,
    1535, 2159, 1359, -415, -2133, -2870, -2162, -393,
    1467, 2374, 1826, 212, -1414, -2135, -1506, 178,
    1919, 2704, 2054, 283, -1588, -2545, -2135, -621,
    1091, 1967, 1466, -113, -1831, -2674, -2114, -416,
    1500, 2584, 2232, 717, -1068, -2061, -1714, -220,
    1495, 2420, 1963, 313, -1595, -2746, -2503, -999,
    841, 1988, 1806, 404, -1274, -2308, -1988, -429,
    1459, 2666, 2478, 999, -867, -2124, -2077, -801,
    925, 2042, 1851, 393, -1474, -2689, -2610, -1198,
    721, 2122, 2207, 979, -765, -1939, -1894, -583,
    1231, 2487, 2480, 1115, -837, -2296, -2479, -1343,
    391, 1743, 1871, 669, -1107, -2436, -2496, -1196,
    769, 2263, 2553, 1504, -312, -1746, -2007, -969,
    775, 2151, 2311, 1090, -811, -2378, -2778, -1740,
    60, 1607, 2039, 1082, -621, -2010, -2279, -1215,
    665, 2310, 2749, 1764, -81, -1710, -2265, -1471,
    182, 1699, 2104, 1115, -679, -2311, -2871, -1956,
    -115, 1631, 2356, 1630, -29, -1595, -2104, -1303,
    409, 2103, 2713, 1859, 27, -1766, -2576, -2012,
    -360, 1314, 1964, 1283, -363, -2023, -2689, -1932,
    -153, 1735, 2650, 2094, 475, -1224, -2069, -1551,
    4, 1683, 2457, 1783, 8, -1858, -2823, -2361,
    -785, 999, 2018, 1638, 133, -1515, -2320, -1799,
    -113, 1731, 2724, 2340, 749, -1111, -2183, -1944,
    -508, 1167, 2038, 1626, 88, -1703, -2767, -2447,
    -887, 997, 2153, 2043, 713, -1001, -2007, -1751,
    -310, 1491, 2584, 2301, 787, -1098, -2381, -2327,
    -1052, 667, 1818, 1679, 325, -1407, -2479, -2303,
    -887, 1017, 2361, 2394, 1151, -603, -1840, -1854,
    -643, 1038, 2231, 2135, 779, -1126, -2505, -2598,
    -1431, 353, 1732, 1908, 809, -851, -2088, -2121,
    -879, 975, 2415, 2591, 1443, -381, -1854, -2152,
    -1183, 479, 1810, 1944, 775, -965, -2394, -2672,
    -1590, 213, 1824, 2240, 1299, -326, -1699, -1988,
    -991, 749, 2226, 2542, 1483, -351, -1931, -2477,
    -1683, -28, 1435, 1875, 987, -689, -2141, -2528,
    -1560, 248, 1900, 2528, 1782, 99, -1454, -2012,
    -1262, 346, 1830, 2309, 1462, -304, -2016, -2703,
    -2027, -353, 1303, 2000, 1367, -163, -1666, -2239,
    -1502, 173, 1895, 2653, 2034, 373, -1335, -2178,
    -1678, -203, 1350, 2052, 1410, -219, -1899, -2708,
    -2159, -549, 1240, 2228, 1843, 398, -1210, -1999,
    -1523, -4, 1670, 2536, 2072, 467, -1363, -2404,
    -2122, -759, 889, 1875, 1527, 108, -1566, -2494,
    -2125, -579, 1302, 2404, 2242, 901, -811, -1894,
    -1742, -404, 1263, 2274, 1978, 473, -1372, -2572,
    -2462, -1162, 599, 1831, 1802, 543, -1099, -2164,
    -1991, -615, 1222, 2503, 2464, 1184, -639, -1963,
    -2052, -917, 721, 1888, 1834, 561, -1215, -2527,
    -2585, -1332, 495, 1934, 2184, 1131, -575, -1828,
    -1891, -763, 991, 2335, 2476, 1290, -583, -2089,
    -2428, -1474, 214, 1571, 1799, 773, -921, -2265,
    -2487, -1364, 490, 2084, 2549, 1594, -112, -1552,
    -1963, -1071, 567, 1998, 2287, 1231, -603, -2199,
    -2698, -1852, -156, 1419, 1970, 1195, -423, -1820,
    -2210, -1288, 491, 2094, 2671, 1854, 124, -1496,
    -2148, -1486, 43, 1516, 2016, 1163, -490, -2065,
    -2687, -1956, -232, 1438, 2180, 1662, 146, -1387,
    -1983, -1299, 281, 1886, 2552, 1847, 169, -1531,
    -2383, -1938, -477, 1122, 1854, 1291, -243, -1790,
    -2484, -1891, -258, 1500, 2429, 2015, 553, -1088,
    -1914, -1515, -115, 1475, 2255, 1734, 134, -1634,
    -2575, -2256, -839, 869, 1858, 1598, 263, -1294,
    -2137, -1751, -297, 1462, 2519, 2269, 829, -915,
    -1983, -1878, -647, 963, 1926, 1615, 212, -1459,
    -2535, -2365, -1009, 787, 2020, 1970, 759, -831,
    -1867, -1731, -447, 1259, 2381, 2226, 873, -909,
    -2178, -2269, -1151, 469, 1659, 1662, 467, -1199,
    -2332, -2271, -1003, 795, 2160, 2322, 1227, -434,
    -1700, -1843, -765, 851, 2027, 2098, 907, -903,
    -2296, -2533, -1495, 233, 1588, 1847, 901, -665,
    -1903, -2061, -991, 747, 2200, 2497, 1475, -240,
    -1683, -2086, -1243, 303, 1639, 1915, 909, -781,
    -2206, -2566, -1651, 49, 1628, 2175, 1418, -147,
    -1508, -1922, -1066, 575, 1995, 2444, 1555, -165,
    -1739, -2360, -1719, -208, 1284, 1850, 1095, -441,
    -1915, -2455, -1655, 64, 1688, 2405, 1844, 302,
    -1239, -1916, -1351, 123, 1639, 2239, 1527, -134,
    -1774, -2567, -2066, -551, 1074, 1886, 1430, -2,
    -1494, -2160, -1586, -12, 1686, 2566, 2100, 555,
    -1114, -2042, -1723, -374, 1150, 1959, 1475, -9,
    -1675, -2604, -2228, -739, 1015, 2088, 1879, 541,
    -1043, -1891, -1574, -198, 1483, 2433, 2143, 685,
    -1132, -2245, -2154, -905, 731, 1720, 1547, 227,
    -1374, -2380, -2158, -765, 1051, 2311, 2281, 1028,
    -639, -1735, -1718, -547, 1076, 2160, 2018, 651,
    -1147, -2402, -2463, -1287, 398, 1678, 1794, 681,
    -893, -1998, -1984, -713, 1054, 2314, 2437, 1300,
    -452, -1783, -1991, -1001, 543, 1731, 1812, 649,
    -1001, -2295, -2497, -1400, 372, 1755, 2066, 1171,
    -398, -1631, -1832, -829, 825, 2151, 2378, 1307,
    -427, -1864, -2292, -1463, 95, 1443, 1744, 829,
    -737, -2046, -2322, -1355, 341, 1866, 2380, 1579,
    0, -1387, -1826, -1058, 419, 1790, 2165, 1274,
    -417, -1958, -2481, -1774, -240, 1267, 1867, 1207,
    -233, -1615, -2063, -1290, 320, 1864, 2489, 1835,
    271, -1307, -2018, -1475, -87, 1356, 1912, 1211,
    -311, -1828, -2521, -1927, -374, 1258, 2090, 1643,
    247, -1203, -1866, -1318, 117, 1651, 2406, 1855,
    292, -1343, -2226, -1907, -593, 945, 1767, 1342,
    -60, -1572, -2326, -1871, -396, 1299, 2295, 2016,
    681, -901, -1786, -1539, -251, 1299, 2124, 1776,
    323, -1376, -2378, -2208, -913, 737, 1752, 1608,
    413, -1087, -2007, -1758, -422, 1271, 2351, 2228,
    947, -731, -1855, -1843, -719, 809, 1803, 1632,
    386, -1255, -2359, -2301, -1083, 619, 1858, 1967,
    911, -645, -1703, -1703, -565, 1079, 2216, 2212,
    1023, -721, -2012, -2206, -1231, 327, 1535, 1658,
    625, -927, -2134, -2246, -1098, 639, 1960, 2271,
    1340, -244, -1528, -1803, -897, 651, 1899, 2068,
    1005, -681, -2093, -2469, -1586, 10, 1419, 1818,
    985, -509, -1735, -2031, -1107, 545, 2016, 2448,
    1599, -29, -1476, -1998, -1319, 136, 1467, 1875,
    1024, -581, -2034, -2521, -1743, -133, 1438, 2087,
    1474, 13, -1379, -1843, -1176, 336, 1835, 2370,
    1682, 62, -1543, -2277, -1787, -331, 1115, 1734,
    1147, -300, -1747, -2372, -1742, -173, 1502, 2344,
    1883, 452, -1051, -1815, -1367, -13, 1475, 2168,
    1596, 45, -1619, -2479, -2110, -717, 885, 1790,
    1479, 151, -1316, -2046, -1614, -177, 1487, 2431,
    2106, 709, -953, -1926, -1716, -488, 977, 1827,
    1488, 131, -1476, -2438, -2183, -821, 855, 1908,
    1811, 639, -813, -1759, -1551, -276, 1283, 2269,
    2063, 743, -937, -2071, -2057, -967, 547, 1594,
    1510, 335, -1195, -2174, -2049, -817, 863, 2087,
    2137, 1034, -497, -1599, -1646, -601, 891, 1964,
    1919, 713, -953, -2184, -2311, -1283, 287, 1500,
    1691, 761, -713, -1824, -1872, -809, 813, 2112,
    2311, 1322, -286, -1608, -1899, -1055, 395, 1587,
    1730, 737, -839, -2104, -2354, -1447, 165, 1595,
    1987, 1188, -260, -1467, -1770, -913, 619, 1930,
    2249, 1335, -265, -1679, -2197, -1514, -81, 1244,
    1670, 927, -565, -1887, -2231, -1428, 159, 1654,
    2234, 1584, 131, -1247, -1772, -1175, 244, 1611,
    2040, 1319, -232, -1747, -2385, -1823, -360, 1114,
    1747, 1216, -118, -1459, -1999, -1360, 118, 1638,
    2344, 1807, 347, -1146, -1907, -1526, -233, 1170,
    1808, 1268, -159, -1640, -2388, -1928, -531, 1050,
    1958, 1642, 392, -1038, -1775, -1379, -56, 1464,
    2257, 1839, 439, -1191, -2120, -1916, -723, 765,
    1647, 1352, 98, -1363, -2215, -1907, -531, 1111,
    2109, 1991, 813, -703, -1683, -1558, -412, 1071,
    1998, 1744, 443, -1182, -2250, -2197, -1063, 504,
    1602, 1594, 507, -943, -1920, -1790, -581, 1040,
    2197, 2191, 1071, -533, -1702, -1828, -855, 589,
    1651, 1650, 515, -1079, -2223, -2295, -1223, 395,
    1691, 1928, 1005, -469, -1587, -1700, -713, 863,
    2049, 2190, 1171, -474, -1827, -2159, -1310, 182,
    1371, 1607, 719, -771, -2006, -2222, -1242, 390,
    1820, 2228, 1422, -63, -1364, -1743, -979, 457,
    1734, 2048, 1135, -499, -1932, -2404, -1651, -154,
    1231, 1743, 1083, -336, -1607, -1971, -1180, 372,
    1824, 2351, 1667, 132, -1326, -1903, -1344, -1,
    1302, 1787, 1059, -408, -1811, -2406, -1763, -228,
    1252, 1928, 1464, 153, -1179, -1771, -1203, 206,
    1639, 2257, 1651, 172, -1338, -2108, -1735, -462,
    955, 1635, 1174, -158, -1540, -2180, -1678, -268,
    1299, 2143, 1792, 529, -891, -1678, -1347, -118,
    1272, 2012, 1555, 159, -1392, -2273, -2003, -741,
    745, 1643, 1439, 262, -1114, -1890, -1574, -284,
    1268, 2217, 2034, 765, -785, -1740, -1652, -589,
    823, 1691, 1451, 235, -1262, -2242, -2096, -923,
    667, 1771, 1755, 719, -681, -1624, -1546, -433,
    1082, 2089, 1980, 821, -751, -1899, -2015, -1019,
    406, 1450, 1488, 453, -999, -2035, -2019, -909,
    677, 1903, 2068, 1118, -355, -1476, -1623, -731,
    717, 1811, 1859, 819, -747, -2002, -2256, -1339,
    175, 1375, 1642, 821, -549, -1663, -1839, -911,
    627, 1919, 2213, 1350, -147, -1418, -1815, -1123,
    245, 1438, 1699, 843, -657, -1915, -2285, -1492,
    20, 1411, 1907, 1268, -86, -1312, -1682, -979,
    456, 1774, 2183, 1430, -105, -1520, -2095, -1548,
    -200, 1124, 1639, 985, -364, -1668, -2156, -1466,
    35, 1492, 2129, 1652, 306, -1087, -1694, -1206,
    82, 1435, 1979, 1362, -57, -1543, -2269, -1826,
    -517, 931, 1679, 1287, 37, -1274, -1895, -1404,
    -41, 1463, 2266, 1864, 537, -941, -1788, -1538,
    -381, 1007, 1746, 1327, 8, -1480, -2281, -1956,
    -669, 871, 1843, 1695, 539, -879, -1656, -1395,
    -197, 1294, 2156, 1903, 627, -951, -1978, -1923,
    -821, 625, 1527, 1395, 257, -1180, -2089, -1903,
    -693, 913, 2034, 2026, 947, -521, -1520, -1515,
    -499, 915, 1908, 1800, 607, -973, -2098, -2161,
    -1163, 327, 1496, 1599, 645, -749, -1750, -1734,
    -661, 883, 2047, 2190, 1184, -353, -1536, -1752,
    -907, 460, 1526, 1612, 625, -855, -2018, -2214,
    -1259, 299, 1519, 1835, 1055, -307, -1399, -1592,
    -733, 697, 1888, 2111, 1198, -329, -1622, -2003,
    -1303, 52, 1260, 1575, 791, -607, -1755, -2022,
    -1219, 269, 1635, 2098, 1426, 47, -1198, -1614,
    -951, 361, 1575, 1938, 1151, -317, -1687, -2200,
    -1588, -230, 1094, 1662, 1134, -169, -1394, -1799,
    -1171, 242, 1640, 2224, 1663, 259, -1135, -1775,
    -1339, -99, 1188, 1704, 1119, -242, -1611, -2222,
    -1724, -380, 1091, 1859, 1476, 243, -1017, -1634,
    -1192, 94, 1458, 2111, 1642, 293, -1156, -1960,
    -1694, -551, 807, 1555, 1200, -6, -1367, -2063,
    -1667, -376, 1112, 2007, 1795, 641, -771, -1575,
    -1378, -261, 1131, 1871, 1560, 320, -1163, -2100,
    -1974, -817, 599, 1535, 1447, 375, -931, -1763,
    -1539, -399, 1071, 2074, 1967, 861, -611, -1630,
    -1635, -669, 685, 1583, 1467, 364, -1079, -2054,
    -2043, -987, 513, 1634, 1755, 833, -533, -1476,
    -1496, -523, 893, 1952, 1988, 937, -589, -1751,
    -1967, -1127, 260, 1343, 1483, 577, -787, -1863,
    -1991, -1007, 517, 1732, 2027, 1219, -185, -1347,
    -1583, -819, 535, 1662, 1815, 923, -565, -1839,
    -2161, -1414, -45, 1230, 1614, 893, -431, -1532,
    -1788, -995, 439, 1747, 2156, 1430, 3, -1284,
    -1771, -1187, 78, 1271, 1644, 933, -484, -1772,
    -2233, -1587, -163, 1219, 1835, 1324, 59, -1200,
    -1651, -1054, 268, 1603, 2102, 1514, 113, -1347,
    -2015, -1592, -322, 959, 1520, 1043, -227, -1487,
    -2094, -1575, -179, 1298, 2049, 1682, 437, -899,
    -1591, -1246, -39, 1271, 1907, 1446, 81, -1375,
    -2167, -1891, -663, 753, 1560, 1335, 170, -1126,
    -1807, -1440, -179, 1283, 2144, 1892, 675, -809,
    -1672, -1527, -472, 845, 1624, 1331, 137, -1263,
    -2142, -1928, -733, 721, 1671, 1596, 597, -671,
    -1552, -1404, -285, 1114, 2007, 1839, 683, -793,
    -1807, -1831, -865, 472, 1404, 1362, 313, -1026,
    -1911, -1815, -747, 733, 1836, 1896, 965, -401,
    -1403, -1472, -569, 775, 1728, 1707, 685, -811,
    -1911, -2058, -1175, 247, 1330, 1512, 699, -615,
    -1591, -1652, -749, 709, 1879, 2062, 1215, -237,
    -1423, -1670, -957, 332, 1402, 1551, 681, -679,
    -1830, -2095, -1288, 130, 1395, 1762, 1075, -185,
    -1284, -1559, -803, 535, 1706, 1995, 1231, -196,
    -1471, -1927, -1355, -91, 1107, 1499, 839, -471,
    -1626, -1968, -1275, 113, 1447, 1980, 1423, 156,
    -1088, -1559, -1044, 197, 1402, 1815, 1187, -167,
    -1506, -2097, -1612, -339, 949, 1570, 1124, -54,
    -1234, -1747, -1186, 95, 1435, 2087, 1643, 368,
    -981, -1664, -1332, -227, 1030, 1636, 1156, -103,
    -1420, -2086, -1718, -482, 921, 1734, 1507, 385,
    -885, -1536, -1211, -71, 1268, 1996, 1652, 431,
    -993, -1843, -1699, -649, 657, 1452, 1219, 131,
    -1171, -1959, -1696, -527, 943, 1863, 1780, 777,
    -621, -1496, -1380, -390, 935, 1782, 1579, 418,
    -1003, -1978, -1960, -947, 435, 1418, 1436, 483,
    -809, -1668, -1579, -531, 893, 1911, 1958, 977,
    -446, -1486, -1628, -785, 494, 1450, 1459, 476,
    -915, -1950, -2054, -1126, 325, 1479, 1707, 931,
    -383, -1387, -1475, -647, 721, 1815, 1959, 1079,
    -397, -1603, -1927, -1211, 102, 1199, 1443, 651,
    -649, -1722, -1963, -1151, 313, 1582, 1964, 1276,
    -33, -1178, -1534, -887, 388, 1543, 1791, 1005,
    -396, -1686, -2122, -1518, -209, 1070, 1544, 989,
    -256, -1386, -1716, -1051, 289, 1595, 2087, 1487,
    157, -1146, -1692, -1203, -27, 1120, 1571, 959,
    -335, -1579, -2116, -1600, -245, 1079, 1695, 1303,
    160, -1013, -1560, -1091, 150, 1443, 1975, 1471,
    179, -1167, -1871, -1548, -424, 805, 1435, 1046,
    -125, -1360, -1948, -1514, -282, 1099, 1884, 1599,
    488, -787, -1486, -1203, -156, 1087, 1771, 1386,
    159, -1206, -1988, -1798, -709, 615, 1423, 1266,
    282, -983, -1687, -1406, -287, 1098, 1927, 1791,
    721, -689, -1571, -1487, -575, 683, 1494, 1295,
    223, -1095, -1979, -1882, -841, 561, 1551, 1556,
    653, -583, -1444, -1368, -404, 917, 1836, 1771,
    743, -649, -1668, -1783, -959, 299, 1279, 1319,
    413, -881, -1784, -1790, -833, 559, 1648, 1827,
    1007, -288, -1304, -1455, -679, 593, 1563, 1634,
    741, -635, -1735, -1991, -1216, 108, 1194, 1475,
    739, -471, -1452, -1627, -821, 519, 1684, 1970,
    1220, -88, -1264, -1635, -1001, 183, 1239, 1507,
    753, -559, -1678, -2020, -1351, -26, 1216, 1684,
    1123, -68, -1136, -1515, -885, 361, 1515, 1915,
    1271, -75, -1338, -1838, -1383, -211, 961, 1423,
    893, -294, -1459, -1904, -1343, -49, 1263, 1868,
    1466, 286, -961, -1508, -1084, 29, 1228, 1735,
    1215, -49, -1358, -2000, -1663, -515, 801, 1459,
    1123, 56, -1106, -1694, -1292, -90, 1248, 1982,
    1671, 484, -829, -1579, -1376, -351, 837, 1502,
    1186, 39, -1284, -2026, -1782, -645, 723, 1599,
    1480, 471, -769, -1480, -1260, -236, 1079, 1867,
    1684, 585, -807, -1735, -1714, -765, 468, 1335,
    1242, 226, -1015, -1838, -1707, -653, 759, 1759,
    1772, 839, -430, -1335, -1363, -476, 775, 1656,
    1594, 555, -845, -1858, -1939, -1063, 248, 1274,
    1400, 581, -653, -1547, -1555, -635, 729, 1787,
    1911, 1058, -317, -1379, -1566, -837, 357, 1315,
    1422, 551, -739, -1794, -1983, -1159, 202, 1320,
    1602, 931, -253, -1262, -1455, -705, 563, 1623,
    1852, 1075, -286, -1439, -1816, -1204, -3, 1064,
    1366, 689, -555, -1583, -1831, -1130, 179, 1399,
    1823, 1255, 34, -1076, -1438, -887, 280, 1335,
    1667, 1021, -298, -1499, -1986, -1459, -248, 919,
    1423, 935, -170, -1255, -1627, -1075, 141, 1402,
    1914, 1451, 235, -1038, -1591, -1212, -140, 981,
    1468, 985, -209, -1419, -1983, -1564, -400, 909,
    1579, 1299, 244, -919, -1474, -1110, 15, 1243,
    1856, 1431, 253, -1023, -1779, -1527, -513, 655,
    1335, 1059, -10, -1216, -1847, -1530, -388, 925,
    1724, 1594, 589, -667, -1412, -1246, -283, 923,
    1634, 1368, 279, -1034, -1878, -1784, -795, 478,
    1327, 1263, 329, -831, -1563, -1404, -407, 921,
    1799, 1732, 761, -513, -1427, -1478, -631, 557,
    1380, 1287, 320, -943, -1826, -1836, -917, 412,
    1419, 1531, 741, -447, -1335, -1360, -501, 735,
    1667, 1726, 845, -523, -1548, -1740, -1017, 160,
    1143, 1310, 505, -679, -1656, -1780, -957, 392,
    1511, 1770, 1084, -163, -1207, -1415, -753, 433,
    1435, 1599, 807, -491, -1603, -1935, -1276, -61,
    1056, 1414, 791, -368, -1346, -1599, -925, 331,
    1515, 1907, 1276, 21, -1126, -1567, -1055, 41,
    1092, 1463, 849, -409, -1559, -1963, -1420, -177,
    1042, 1604, 1187, 59, -1047, -1450, -969, 216,
    1394, 1838, 1352, 118, -1163, -1791, -1439, -375,
    781, 1372, 945, -184, -1315, -1838, -1394, -201,
    1122, 1818, 1495, 403, -779, -1411, -1115, -79,
    1086, 1670, 1283, 85, -1222, -1919, -1683, -635,
    625, 1379, 1170, 173, -985, -1602, -1278, -188,
    1086, 1866, 1670, 595, -693, -1468, -1356, -432,
    703, 1431, 1172, 121, -1098, -1883, -1738, -715,
    603, 1460, 1432, 547, -587, -1359, -1254, -266,
    941, 1738, 1627, 621, -673, -1586, -1639, -805,
    390, 1214, 1175, 293, -877, -1687, -1643, -689,
    623, 1586, 1675, 865, -337, -1227, -1300, -531,
    629, 1511, 1508, 603, -695, -1672, -1820, -1064,
    151, 1147, 1323, 599, -527, -1416, -1471, -671,
    587, 1603, 1799, 1083, -187, -1236, -1467, -861,
    269, 1227, 1372, 629, -581, -1611, -1844, -1147,
    92, 1204, 1547, 985, -139, -1107, -1368, -753,
    428, 1479, 1775, 1095, -164, -1256, -1691, -1203,
    -115, 941, 1335, 745, -389, -1407, -1747, -1150,
    62, 1243, 1748, 1267, 147, -935, -1383, -959,
    126, 1207, 1611, 1064, -114, -1298, -1855, -1442,
    -345, 811, 1391, 995, -39, -1084, -1547, -1099,
    31, 1247, 1823, 1450, 344, -839, -1492, -1228,
    -231, 887, 1431, 1043, -60, -1246, -1843, -1538,
    -470, 783, 1523, 1319, 354, -753, -1368, -1106,
    -88, 1075, 1743, 1495, 397, -865, -1630, -1523,
    -595, 555, 1263, 1087, 141, -1001, -1712, -1523,
    -494, 795, 1634, 1591, 699, -527, -1298, -1228,
    -359, 809, 1543, 1411, 398, -851, -1723, -1748,
    -875, 340, 1231, 1266, 434, -701, -1455, -1399,
    -503, 759, 1690, 1754, 881, -371, -1292, -1436,
    -709, 407, 1279, 1327, 468, -779, -1694, -1803,
    -1013, 255, 1292, 1515, 847, -297, -1210, -1320,
    -605, 609, 1583, 1728, 973, -306, -1384, -1672,
    -1090, 26, 1051, 1302, 601, -533, -1511, -1734,
    -1019, 240, 1387, 1750, 1167, 17, -1011, -1352,
    -793, 322, 1338, 1604, 923, -339, -1460, -1863,
    -1339, -187, 931, 1371, 879, -208, -1195, -1514,
    -947, 237, 1387, 1842, 1335, 169, -977, -1472,
    -1078, -27, 989, 1396, 877, -251, -1351, -1859,
    -1402, -257, 905, 1511, 1171, 156, -907, -1356,
    -945, 101, 1239, 1740, 1330, 204, -987, -1646,
    -1378, -400, 697, 1271, 929, -79, -1162, -1696,
    -1328, -252, 969, 1664, 1451, 463, -663, -1275,
    -1066, -122, 959, 1559, 1259, 185, -1036, -1743,
    -1592, -653, 513, 1260, 1131, 248, -853, -1480,
    -1240, -279, 969, 1738, 1630, 679, -561, -1344,
    -1279, -481, 603, 1315, 1178, 248, -927, -1700,
    -1650, -747, 492, 1364, 1411, 635, -464, -1219,
    -1191, -352, 809, 1615, 1595, 713, -525, -1427,
    -1550, -827, 292, 1130, 1199, 425, -727, -1527,
    -1554, -733, 507, 1478, 1651, 943, -202, -1086,
    -1246, -585, 531, 1411, 1487, 703, -475, -1472,
    -1727, -1054, 96, 1078, 1348, 705, -356, -1247,
    -1391, -699, 467, 1490, 1771, 1138, -38, -1051,
    -1395, -871, 187, 1138, 1375, 741, -409, -1399,
    -1712, -1155, -1, 1103, 1548, 1083, 14, -955,
    -1283, -739, 354, 1383, 1747, 1199, 35, -1103,
    -1572, -1182, -169, 891, 1308, 837, -170, -1211,
    -1623, -1148, -17, 1174, 1699, 1378, 355, -763,
    -1275, -919, 68, 1128, 1606, 1150, 46, -1106,
    -1703, -1408, -416, 721, 1347, 1083, 122, -897,
    -1408, -1095, -41, 1147, 1799, 1551, 517, -649,
    -1323, -1172, -281, 783, 1398, 1146, 140, -1046,
    -1719, -1512, -539, 685, 1482, 1375, 545, -565,
    -1240, -1063, -157, 1011, 1712, 1562, 619, -641,
    -1464, -1442, -649, 460, 1234, 1168, 290, -807,
    -1551, -1467, -547, 709, 1599, 1642, 829, -310,
    -1103, -1134, -365, 739, 1520, 1491, 603, -655,
    -1571, -1666, -893, 276, 1180, 1320, 615, -486,
    -1271, -1314, -505, 693, 1622, 1772, 1024, -173,
    -1126, -1320, -693, 366, 1215, 1324, 579, -557,
    -1502, -1698, -975, 202, 1210, 1495, 909, -141,
    -1062, -1212, -567, 529, 1487, 1703, 1023, -135,
    -1151, -1548, -1050, 23, 989, 1268, 689, -390,
    -1291, -1558, -957, 201, 1274, 1680, 1174, 104,
    -855, -1207, -755, 247, 1215, 1544, 981, -171,
    -1234, -1675, -1263, -200, 859, 1315, 907, -40,
    -1015, -1383, -899, 167, 1279, 1767, 1359, 289,
    -837, -1344, -1024, -87, 929, 1360, 935, -93,
    -1156, -1678, -1339, -314, 845, 1463, 1214, 284,
    -729, -1254, -933, 47, 1110, 1675, 1356, 311,
    -827, -1478, -1315, -446, 621, 1243, 991, 67,
    -985, -1559, -1295, -328, 853, 1578, 1439, 583,
    -509, -1167, -1063, -234, 865, 1479, 1263, 340,
    -819, -1591, -1522, -677, 430, 1222, 1176, 370,
    -653, -1336, -1215, -333, 813, 1611, 1595, 733,
    -401, -1208, -1263, -529, 517, 1250, 1194, 366,
    -771, -1579, -1580, -791, 371, 1275, 1398, 715,
    -326, -1106, -1162, -457, 653, 1526, 1571, 791,
    -393, -1311, -1503, -879, 180, 1055, 1199, 517,
    -525, -1395, -1522, -803, 362, 1354, 1594, 985,
    -70, -991, -1226, -655, 395, 1294, 1463, 775,
    -372, -1351, -1654, -1112, -45, 945, 1282, 759,
    -252, -1135, -1376, -793, 315, 1366, 1710, 1191,
    94, -937, -1363, -939, 50, 981, 1311, 789,
    -302, -1315, -1703, -1239, -160, 945, 1444, 1095,
    115, -871, -1247, -843, 182, 1231, 1659, 1240,
    175, -989, -1530, -1239, -336, 711, 1239, 869,
    -114, -1100, -1594, -1227, -201, 987, 1628, 1364,
    420, -627, -1202, -979, -63, 977, 1512, 1183,
    133, -1019, -1668, -1475, -553, 557, 1227, 1079,
    211, -815, -1360, -1106, -169, 971, 1675, 1514,
    599, -557, -1267, -1186, -408, 621, 1278, 1078,
    171, -899, -1614, -1503, -627, 517, 1331, 1303,
    537, -488, -1183, -1058, -240, 849, 1583, 1480,
    601, -547, -1354, -1408, -705, 341, 1099, 1076,
    314, -733, -1450, -1411, -609, 537, 1403, 1511,
    809, -258, -1051, -1136, -459, 573, 1344, 1354,
    585, -579, -1442, -1580, -941, 145, 1030, 1187,
    573, -430, -1218, -1283, -609, 509, 1431, 1623,
    991, -113, -1071, -1306, -761, 208, 1067, 1238,
    573, -490, -1392, -1643, -1036, 67, 1067, 1395,
    909, -76, -949, -1215, -683, 348, 1284, 1574,
    999, -106, -1087, -1475, -1060, -85, 861, 1175,
    687, -303, -1216, -1507, -1013, 51, 1099, 1543,
    1159, 172, -809, -1210, -853, 73, 1055, 1435,
    943, -67, -1143, -1647, -1266, -323, 701, 1238,
    921, 7, -917, -1352, -975, 18, 1086, 1616,
    1315, 350, -715, -1282, -1059, -211, 763, 1275,
    953, -12, -1040, -1591, -1347, -424, 691, 1359,
    1199, 347, -633, -1166, -969, -113, 957, 1570,
    1343, 416, -711, -1390, -1318, -533, 474, 1128,
    977, 167, -833, -1479, -1302, -420, 723, 1475,
    1423, 657, -393, -1099, -1059, -341, 717, 1395,
    1259, 408, -705, -1482, -1518, -773, 305, 1088,
    1158, 442, -557, -1247, -1219, -431, 677, 1514,
    1576, 837, -272, -1095, -1234, -605, 371, 1136,
    1198, 471, -641, -1462, -1555, -867, 245, 1158,
    1383, 809, -227, -1035, -1140, -517, 557, 1414,
    1567, 897, -223, -1191, -1450, -933, 30, 945,
    1192, 569, -412, -1259, -1494, -871, 227, 1243,
    1588, 1087, 80, -831, -1151, -677, 289, 1198,
    1470, 877, -231, -1228, -1604, -1151, -156, 833,
    1246, 837, -119, -983, -1276, -811, 230, 1251,
    1678, 1254, 213, -797, -1243, -939, -42, 891,
    1270, 811, -175, -1139, -1604, -1220, -229, 821,
    1379, 1088, 202, -729, -1136, -807, 116, 1115,
    1591, 1243, 231, -809, -1387, -1178, -337, 635,
    1160, 887, -15, -969, -1443, -1172, -230, 871,
    1504, 1315, 459, -525, -1095, -929, -117, 853,
    1392, 1159, 232, -855, -1482, -1387, -555, 479,
    1139, 1043, 267, -685, -1258, -1102, -236, 845,
    1526, 1438, 625, -441, -1159, -1124, -439, 531,
    1167, 1063, 245, -781, -1475, -1456, -675, 406,
    1196, 1255, 571, -393, -1067, -1055, -333, 687,
    1438, 1419, 641, -428, -1242, -1374, -739, 239,
    995, 1039, 382, -603, -1339, -1371, -659, 414,
    1287, 1471, 849, -169, -961, -1107, -537, 431,
    1235, 1326, 625, -412, -1315, -1528, -957, 13,
    909, 1176, 637, -290, -1088, -1270, -667, 371,
    1291, 1552, 979, -34, -927, -1262, -815, 104,
    955, 1195, 623, -384, -1263, -1559, -1075, -69,
    927, 1319, 919, -3, -859, -1162, -743, 216,
    1172, 1502, 1042, 9, -1001, -1427, -1114, -221,
    703, 1115, 733, -168, -1090, -1488, -1071, -93,
    939, 1451, 1155, 266, -709, -1166, -883, -30,
    937, 1363, 969, 19, -997, -1571, -1315, -436,
    561, 1135, 917, 58, -851, -1316, -1032, -126,
    921, 1524, 1319, 424, -607, -1223, -1108, -341,
    601, 1160, 927, 57, -965, -1570, -1407, -551,
    502, 1212, 1183, 401, -575, -1136, -1021, -239,
    803, 1446, 1315, 491, -615, -1376, -1364, -673,
    308, 1013, 965, 198, -771, -1424, -1376, -591,
    529, 1340, 1391, 677, -316, -1023, -1087, -443,
    551, 1258, 1239, 469, -637, -1443, -1552, -891,
    133, 949, 1087, 476, -488, -1183, -1222, -549,
    503, 1343, 1488, 845, -205, -1047, -1239, -727,
    198, 995, 1107, 446, -523, -1367, -1560, -969,
    54, 985, 1256, 753, -173, -983, -1155, -595,
    381, 1247, 1435, 849, -165, -1091, -1414, -969,
    -48, 801, 1060, 557, -391, -1200, -1442, -923,
    87, 1055, 1419, 983, 65, -797, -1116, -767,
    123, 1015, 1300, 825, -188, -1136, -1527, -1151,
    -249, 681, 1100, 755, -86, -955, -1260, -873,
    54, 1044, 1495, 1147, 224, -755, -1232, -983,
    -178, 739, 1136, 793, -120, -1063, -1536, -1248,
    -352, 663, 1239, 1024, 215, -671, -1131, -869,
    -37, 905, 1414, 1155, 258, -745, -1347, -1227,
    -455, 481, 1031, 819, 27, -901, -1411, -1195,
    -341, 689, 1344, 1263, 490, -491, -1075, -989,
    -281, 675, 1275, 1084, 259, -737, -1435, -1398,
    -685, 311, 1027, 1003, 311, -599, -1192, -1111,
    -363, 671, 1392, 1368, 633, -367, -1099, -1152,
    -525, 390, 1055, 1021, 309, -693, -1395, -1435,
    -761, 261, 1072, 1215, 615, -323, -999, -1059,
    -464, 527, 1304, 1354, 691, -346, -1163, -1351,
    -825, 109, 879, 1013, 442, -498, -1283, -1383,
    -769, 254, 1148, 1391, 853, -68, -895, -1107,
    -597, 290, 1091, 1275, 671, -327, -1200, -1502,
    -1030, -90, 783, 1111, 667, -240, -997, -1220,
    -749, 229, 1144, 1487, 1050, 76, -819, -1203,
    -857, -10, 827, 1130, 681, -246, -1172, -1539,
    -1123, -181, 781, 1247, 959, 96, -773, -1102,
    -771, 109, 1047, 1451, 1080, 129, -879, -1376,
    -1130, -344, 583, 1074, 755, -103, -979, -1428,
    -1114, -210, 817, 1394, 1186, 372, -565, -1082,
    -889, -105, 811, 1296, 1026, 113, -897, -1500,
    -1326, -521, 435, 1052, 929, 176, -729, -1212,
    -1024, -227, 809, 1443, 1323, 504, -503, -1116,
    -1080, -422, 500, 1108, 933, 139, -809, -1447,
    -1364, -603, 386, 1122, 1135, 451, -445, -1067,
    -963, -263, 673, 1339, 1282, 517, -484, -1216,
    -1286, -675, 239, 925, 945, 268, -673, -1286,
    -1268, -597, 419, 1206, 1310, 705, -235, -923,
    -1013, -468, 432, 1155, 1203, 510, -517, -1294,
    -1420, -863, 82, 881, 1031, 506, -369, -1080,
    -1162, -581, 394, 1232, 1411, 851, -107, -941,
    -1170, -721, 123, 897, 1087, 519, -422, -1232,
    -1459, -963, -1, 893, 1192, 775, -84, -853,
    -1071, -607, 274, 1107, 1379, 871, -79, -963,
    -1330, -977, -150, 711, 1011, 591, -242, -1082,
    -1379, -933, 0, 933, 1340, 1023, 166, -707,
    -1040, -773, 27, 905, 1255, 859, -52, -981,
    -1451, -1174, -339, 585, 1067, 783, 6, -801,
    -1208, -885, -19, 927, 1415, 1159, 309, -629,
    -1139, -963, -224, 639, 1086, 823, -18, -937,
    -1411, -1196, -396, 559, 1154, 1050, 311, -571,
    -1036, -887, -142, 809, 1347, 1179, 358, -649,
    -1248, -1188, -513, 378, 983, 869, 143, -763,
    -1320, -1187, -442, 559, 1267, 1239, 569, -364,
    -997, -951, -323, 589, 1191, 1119, 372, -633,
    -1319, -1358, -729, 220, 935, 1001, 390, -487,
    -1107, -1099, -420, 567, 1292, 1363, 731, -248,
    -981, -1115, -579, 280, 963, 1011, 395, -561,
    -1311, -1403, -805, 154, 977, 1179, 695, -200,
    -927, -1009, -481, 423, 1207, 1358, 779, -186,
    -1047, -1295, -861, -18, 799, 1023, 502, -364,
    -1155, -1346, -807, 141, 1051, 1376, 957, 63,
    -785, -1052, -621, 213, 1027, 1255, 763, -199,
    -1095, -1419, -1043, -182, 693, 1074, 723, -119,
    -897, -1168, -781, 122, 1046, 1446, 1096, 176,
    -717, -1115, -867, -100, 747, 1098, 697, -132,
    -1001, -1443, -1118, -262, 661, 1183, 937, 171,
    -651, -1043, -757, 40, 947, 1376, 1070, 208,
    -709, -1240, -1070, -337, 531, 1013, 785, -9,
    -841, -1271, -1055, -229, 737, 1306, 1150, 403,
    -464, -963, -855, -165, 711, 1214, 1013, 189,
    -761, -1316, -1226, -529, 370, 979, 911, 251,
    -603, -1112, -979, -246, 721, 1323, 1260, 559,
    -377, -1024, -1027, -430, 416, 1027, 937, 219,
    -671, -1318, -1298, -629, 326, 1047, 1119, 519,
    -338, -937, -951, -320, 581, 1227, 1248, 593,
    -366, -1091, -1218, -683, 163, 857, 929, 354,
    -525, -1187, -1227, -621, 313, 1103, 1284, 761,
    -120, -837, -985, -506, 340, 1060, 1171, 581,
    -361, -1151, -1344, -885, -5, 793, 1017, 555,
    -246, -945, -1110, -615, 295, 1118, 1391, 907,
    -1, -797, -1099, -733, 71, 853, 1040, 575,
    -302, -1107, -1359, -957, -68, 827, 1186, 847,
    20, -739, -1007, -671, 180, 1031, 1326, 935,
    41, -849, -1235, -955, -187, 627, 995, 659,
    -131, -963, -1292, -929, -93, 823, 1308, 1039,
    270, -571, -1015, -767, -29, 825, 1207, 893,
    57, -845, -1332, -1143, -395, 473, 1011, 845,
    106, -701, -1130, -901, -101, 819, 1367, 1199,
    420, -487, -1055, -957, -283, 551, 1043, 841,
    105, -789, -1343, -1199, -480, 429, 1088, 1066,
    426, -451, -973, -857, -207, 701, 1307, 1204,
    463, -479, -1147, -1166, -575, 279, 917, 891,
    226, -601, -1203, -1179, -488, 483, 1196, 1255,
    651, -221, -887, -931, -355, 488, 1147, 1135,
    452, -499, -1211, -1323, -773, 145, 889, 995,
    464, -370, -1007, -1063, -494, 435, 1215, 1355,
    801, -122, -883, -1055, -613, 186, 897, 1005,
    438, -420, -1147, -1347, -835, 63, 871, 1148,
    723, -92, -811, -969, -511, 341, 1127, 1314,
    795, -115, -907, -1204, -845, -30, 729, 967,
    539, -281, -1005, -1239, -803, 90, 933, 1275,
    933, 108, -659, -955, -649, 103, 917, 1184,
    759, -103, -955, -1312, -995, -200, 609, 995,
    715, -27, -789, -1095, -757, 71, 923, 1330,
    1047, 251, -601, -1043, -833, -139, 643, 1038,
    731, -57, -865, -1295, -1083, -304, 607, 1103,
    939, 234, -529, -953, -751, -10, 837, 1276,
    1060, 281, -619, -1138, -1044, -401, 428, 937,
    755, 69, -739, -1203, -1032, -293, 605, 1192,
    1140, 465, -386, -903, -841, -236, 597, 1135,
    995, 289, -625, -1228, -1196, -593, 274, 913,
    911, 300, -489, -1039, -955, -298, 591, 1243,
    1235, 611, -271, -943, -981, -454, 354, 963,
    933, 311, -557, -1192, -1235, -647, 235, 969,
    1100, 589, -225, -849, -913, -383, 472, 1156,
    1231, 661, -257, -985, -1162, -715, 84, 791,
    945, 422, -399, -1083, -1190, -677, 192, 1031,
    1251, 795, -10, -755, -943, -547, 250, 975,
    1136, 629, -251, -1026, -1307, -907, -100, 693,
    1019, 615, -175, -839, -1071, -665, 199, 1015,
    1327, 957, 95, -699, -1051, -751, -12, 739,
    1026, 629, -179, -997, -1335, -985, -172, 673,
    1122, 861, 127, -641, -963, -675, 65, 927,
    1298, 961, 155, -729, -1199, -979, -291, 513,
    969, 687, -52, -831, -1247, -985, -187, 741,
    1259, 1090, 364, -471, -951, -767, -76, 719,
    1174, 957, 146, -757, -1278, -1147, -462, 397,
    967, 867, 193, -613, -1055, -901, -194, 723,
    1291, 1198, 497, -398, -949, -905, -347, 442,
    993, 863, 166, -689, -1263, -1182, -531, 358,
    1017, 1015, 445, -354, -895, -835, -245, 609,
    1196, 1175, 509, -380, -1021, -1096, -571, 209,
    845, 883, 280, -527, -1099, -1116, -517, 379,
    1087, 1187, 659, -157, -779, -879, -408, 391,
    1031, 1059, 489, -380, -1082, -1223, -739, 66,
    779, 947, 486, -281, -913, -987, -491, 340,
    1092, 1267, 791, -50, -793, -997, -621, 118,
    803, 987, 486, -335, -1023, -1248, -829, 11,
    805, 1076, 719, -16, -701, -935, -527, 260,
    1005, 1246, 811, -16, -803, -1138, -839, -112,
    637, 933, 567, -187, -905, -1155, -801, 13,
    849, 1227, 945, 175, -577, -913, -663, 36,
    793, 1135, 787, -11, -857, -1234, -993, -307,
    515, 963, 733, 43, -695, -1035, -747, -22,
    837, 1264, 1031, 316, -508, -971, -815, -189,
    567, 983, 759, 32, -759, -1218, -1063, -353,
    510, 1054, 959, 320, -457, -901, -767, -124,
    723, 1227, 1076, 368, -527, -1070, -1023, -453,
    330, 889, 797, 160, -617, -1128, -1036, -373,
    498, 1134, 1134, 523, -274, -831, -831, -276,
    519, 1074, 1015, 353, -486, -1115, -1183, -629,
    185, 835, 927, 368, -397, -945, -953, -373,
    488, 1160, 1219, 675, -160, -809, -967, -513,
    258, 883, 935, 384, -439, -1115, -1220, -691,
    140, 881, 1074, 641, -126, -767, -885, -424,
    376, 1083, 1239, 723, -126, -885, -1115, -745,
    0, 727, 933, 473, -271, -933, -1150, -707,
    156, 945, 1236, 891, 99, -647, -885, -535,
    187, 925, 1155, 721, -136, -893, -1214, -925,
    -154, 635, 973, 687, -20, -731, -995, -677,
    122, 947, 1310, 1007, 214, -587, -969, -747,
    -64, 673, 1001, 673, -90, -873, -1235, -947,
    -204, 629, 1079, 875, 201, -539, -889, -637,
    67, 855, 1236, 991, 246, -581, -1059, -921,
    -293, 458, 921, 725, 23, -705, -1103, -917,
    -197, 669, 1179, 1067, 428, -367, -825, -721,
    -132, 655, 1106, 913, 231, -605, -1124, -1058,
    -458, 341, 897, 847, 262, -490, -951, -819,
    -197, 619, 1202, 1163, 531, -290, -857, -869,
    -352, 392, 923, 873, 241, -547, -1102, -1114,
    -525, 317, 955, 1011, 490, -249, -807, -811,
    -279, 519, 1131, 1146, 561, -275, -915, -1040,
    -579, 166, 789, 841, 353, -401, -997, -1058,
    -553, 298, 1013, 1179, 729, -58, -701, -837,
    -437, 306, 981, 1075, 549, -254, -981, -1160,
    -739, -3, 719, 947, 525, -180, -809, -953,
    -503, 283, 1003, 1232, 831, 36, -683, -941,
    -605, 86, 767, 975, 567, -218, -909, -1171,
    -825, -38, 727, 1070, 785, 73, -599, -849,
    -559, 162, 917, 1206, 867, 70, -709, -1060,
    -845, -180, 571, 913, 629, -64, -801, -1104,
    -807, -65, 741, 1183, 967, 292, -467, -865,
    -647, -11, 739, 1091, 847, 90, -705, -1150,
    -997, -329, 431, 911, 775, 147, -569, -961,
    -769, -84, 737, 1211, 1072, 398, -398, -887,
    -813, -251, 477, 945, 775, 122, -651, -1151,
    -1059, -424, 399, 999, 947, 372, -343, -813,
    -743, -181, 609, 1167, 1099, 446, -398, -987,
    -1001, -499, 231, 821, 831, 235, -503, -1032,
    -1039, -438, 426, 1067, 1140, 605, -168, -741,
    -809, -314, 439, 1013, 1021, 444, -405, -1051,
    -1147, -679, 124, 789, 881, 439, -296, -849,
    -901, -427, 384, 1070, 1211, 751, -85, -751,
    -909, -551, 171, 805, 917, 424, -342, -1011,
    -1159, -709, 46, 777, 1028, 657, -48, -683,
    -849, -446, 321, 989, 1170, 753, -39, -761,
    -1055, -735, -23, 635, 869, 517, -200, -835,
    -1062, -681, 73, 831, 1151, 829, 139, -529,
    -823, -563, 113, 813, 1070, 705, -58, -785,
    -1123, -881, -180, 557, 913, 667, 9, -657,
    -903, -633, 44, 827, 1216, 963, 266, -484,
    -899, -711, -106, 581, 955, 703, 1, -725,
    -1119, -923, -244, 535, 1023, 871, 236, -446,
    -837, -669, -14, 743, 1158, 973, 279, -481,
    -963, -903, -324, 405, 849, 721, 138, -599,
    -1021, -905, -283, 555, 1090, 1038, 461, -289,
    -753, -725, -189, 547, 1024, 919, 299, -489,
    -1050, -1027, -499, 246, 841, 853, 325, -379,
    -869, -811, -259, 531, 1100, 1136, 589, -209,
    -797, -847, -370, 328, 869, 875, 322, -445,
    -1003, -1067, -565, 224, 869, 1013, 573, -152,
    -703, -781, -336, 421, 1031, 1123, 623, -188,
    -841, -1003, -633, 73, 723, 843, 408, -289,
    -915, -1031, -569, 189, 907, 1135, 747, 35,
    -619, -797, -448, 257, 893, 1030, 601, -163,
    -863, -1104, -771, -83, 627, 913, 581, -88,
    -705, -933, -553, 196, 913, 1218, 889, 136,
    -569, -877, -663, -21, 677, 917, 585, -105,
    -823, -1136, -837, -135, 621, 1009, 803, 154,
    -529, -815, -571, 84, 813, 1175, 885, 180,
    -591, -1015, -847, -240, 461, 861, 657, 4,
    -671, -1060, -853, -148, 655, 1123, 987, 361,
    -374, -803, -675, -84, 651, 1054, 861, 155,
    -613, -1060, -983, -401, 358, 855, 775, 218,
    -494, -889, -769, -171, 629, 1154, 1099, 487,
    -327, -821, -795, -314, 399, 891, 783, 174,
    -567, -1072, -1017, -458, 314, 907, 929, 423,
    -263, -759, -737, -190, 553, 1080, 1047, 481,
    -288, -881, -949, -495, 195, 731, 779, 284,
    -429, -933, -957, -443, 333, 969, 1072, 625,
    -87, -661, -783, -354, 370, 925, 963, 458,
    -299, -909, -1072, -653, 80, 695, 863, 481,
    -193, -755, -855, -440, 308, 983, 1154, 737,
    0, -653, -855, -517, 128, 729, 895, 470,
    -249, -877, -1087, -709, 16, 691, 989, 691,
    12, -603, -815, -479, 227, 903, 1112, 769,
    28, -667, -967, -715, -86, 561, 833, 543,
    -116, -777, -1003, -707, -18, 747, 1091, 853,
    206, -467, -765, -561, 43, 729, 1032, 735,
    37, -709, -1051, -851, -256, 463, 891, 699,
    76, -569, -881, -643, -15, 737, 1155, 959,
    313, -421, -829, -699, -161, 517, 871, 687,
    84, -643, -1043, -901, -313, 444, 943, 867,
    313, -357, -755, -659, -104, 629, 1092, 973,
    360, -411, -903, -887, -396, 314, 793, 737,
    188, -517, -961, -883, -311, 431, 1019, 1035,
    508, -190, -699, -705, -232, 444, 979, 945,
    351, -396, -961, -1009, -531, 176, 755, 853,
    371, -307, -781, -799, -305, 434, 1035, 1122,
    643, -103, -691, -839, -467, 226, 791, 837,
    375, -356, -945, -1055, -631, 123, 787, 955,
    595, -64, -635, -751, -386, 318, 961, 1111,
    669, -83, -753, -973, -663, -14, 617, 839,
    459, -222, -827, -1005, -623, 116, 829, 1091,
    787, 106, -537, -777, -498, 162, 799, 1013,
    655, -102, -779, -1067, -809, -138, 561, 853,
    605, -5, -645, -881, -605, 76, 827, 1163,
    891, 215, -486, -831, -651, -77, 571, 895,
    611, -58, -745, -1075, -837, -204, 533, 961,
    781, 194, -451, -773, -573, 43, 759, 1096,
    881, 223, -510, -933, -799, -255, 390, 777,
    639, 53, -611, -953, -799, -189, 555, 1028,
    937, 353, -313, -737, -665, -120, 557, 969,
    819, 213, -519, -989, -943, -419, 282, 779,
    735, 237, -401, -819, -747, -211, 535, 1051,
    1019, 479, -229, -743, -771, -316, 327, 809,
    791, 238, -455, -961, -989, -476, 238, 811,
    909, 446, -217, -695, -739, -277, 450, 977,
    1009, 517, -237, -795, -901, -515, 127, 671,
    765, 323, -355, -857, -923, -499, 246, 889,
    1032, 631, -40, -607, -739, -390, 252, 833,
    943, 503, -218, -859, -1031, -675, -21, 619,
    843, 479, -143, -707, -839, -456, 223, 881,
    1090, 743, 59, -595, -835, -539, 45, 635,
    831, 500, -161, -793, -1034, -743, -82, 619,
    947, 689, 73, -521, -745, -515, 118, 815,
    1059, 759, 84, -603, -913, -763, -181, 489,
    787, 553, -43, -683, -963, -723, -92, 635,
    1026, 845, 256, -384, -745, -589, -36, 615,
    987, 749, 83, -597, -1011, -895, -311, 363,
    797, 703, 133, -495, -833, -685, -106, 627,
    1063, 953, 364, -333, -763, -739, -256, 401,
    821, 699, 130, -559, -1021, -931, -372, 334,
    865, 855, 352, -309, -719, -663, -171, 531,
    1015, 957, 413, -326, -863, -877, -450, 204,
    727, 719, 213, -422, -897, -909, -410, 352,
    939, 991, 545, -120, -661, -731, -309, 362,
    881, 897, 412, -332, -909, -1005, -587, 85,
    659, 783, 415, -229, -747, -803, -379, 330,
    941, 1088, 677, -47, -639, -783, -483, 127,
    709, 811, 388, -283, -875, -1015, -629, 24,
    693, 925, 583, -28, -575, -717, -396, 266,
    867, 1031, 661, -27, -673, -915, -645, -59,
    543, 771, 464, -171, -737, -921, -619, 42,
    729, 1017, 759, 135, -475, -743, -501, 85,
    711, 949, 623, -24, -701, -999, -797, -214,
    470, 795, 577, 19, -571, -833, -587, 30,
    715, 1063, 845, 241, -436, -791, -633, -113,
    493, 827, 607, -12, -635, -991, -835, -244,
    437, 887, 785, 236, -386, -755, -607, -42,
    633, 1007, 857, 265, -429, -861, -811, -311,
    302, 713, 641, 114, -527, -903, -807, -266,
    463, 949, 891, 405, -240, -683, -649, -187,
    457, 901, 807, 277, -429, -935, -917, -455,
    203, 721, 755, 276, -355, -779, -725, -245,
    438, 977, 997, 517, -158, -691, -755, -350,
    248, 721, 747, 297, -374, -881, -953, -521,
    177, 753, 885, 498, -135, -641, -725, -310,
    347, 907, 979, 543, -139, -723, -883, -583,
    40, 629, 759, 375, -248, -795, -911, -529,
    156, 787, 989, 663, 24, -537, -701, -411,
    178, 753, 937, 535, -122, -721, -977, -697,
    -74, 535, 779, 525, -61, -615, -797, -525,
    129, 813, 1063, 779, 149, -495, -809, -597,
    -26, 585, 823, 533, -89, -719, -987, -769,
    -160, 541, 899, 701, 152, -439, -717, -515,
    59, 715, 1039, 813, 172, -513, -887, -761,
    -225, 404, 765, 585, 16, -605, -937, -745,
    -143, 569, 987, 889, 340, -307, -705, -613,
    -79, 577, 931, 763, 170, -521, -943, -879,
    -358, 296, 725, 693, 214, -420, -775, -681,
    -160, 549, 1013, 971, 445, -250, -699, -695,
    -267, 335, 783, 703, 174, -464, -935, -913,
    -411, 272, 801, 837, 393, -227, -661, -655,
    -195, 471, 941, 947, 458, -244, -781, -837,
    -432, 172, 639, 699, 269, -363, -799, -833,
    -400, 280, 845, 953, 563, -75, -581, -679,
    -315, 291, 821, 867, 419, -237, -795, -935,
    -603, 22, 611, 765, 415, -161, -661, -757,
    -392, 252, 867, 1021, 645, 18, -577, -761,
    -470, 74, 621, 791, 421, -196, -747, -945,
    -641, -26, 593, 883, 607, 12, -521, -711,
    -436, 185, 787, 973, 667, 12, -583, -849,
    -653, -90, 467, 713, 485, -97, -661, -887,
    -633, -11, 647, 959, 733, 185, -391, -699,
    -513, 16, 609, 909, 645, 37, -611, -923,
    -759, -235, 405, 767, 609, 84, -483, -761,
    -575, -34, 635, 999, 851, 293, -361, -745,
    -655, -168, 431, 771, 621, 74, -561, -921,
    -797, -291, 374, 825, 753, 297, -298, -685,
    -603, -105, 549, 959, 837, 325, -339, -803,
    -793, -366, 233, 677, 655, 169, -456, -875,
    -787, -296, 362, 881, 899, 461, -169, -631,
    -659, -245, 376, 853, 835, 321, -333, -839,
    -893, -482, 129, 633, 725, 337, -275, -715,
    -749, -323, 358, 897, 983, 573, -88, -635,
    -761, -404, 182, 685, 733, 341, -293, -825,
    -927, -579, 81, 685, 839, 523, -56, -577,
    -689, -344, 267, 839, 973, 601, -50, -659,
    -859, -591, -17, 535, 743, 431, -183, -739,
    -885, -551, 66, 713, 989, 713, 114, -465,
    -705, -456, 114, 697, 903, 599, -64, -681,
    -937, -717, -133, 461, 747, 551, 0, -549,
    -767, -519, 81, 729, 1021, 811, 215, -432,
    -731, -569, -65, 506, 787, 547, -19, -627,
    -917, -735, -196, 461, 853, 711, 192, -387,
    -681, -517, 23, 655, 973, 791, 214, -436,
    -809, -703, -239, 336, 685, 589, 88, -504,
    -827, -693, -169, 479, 911, 841, 349, -248,
    -641, -579, -115, 482, 853, 735, 220, -431,
    -845, -817, -382, 261, 713, 673, 240, -337,
    -705, -647, -189, 469, 933, 925, 452, -183,
    -639, -669, -289, 274, 717, 711, 241, -383,
    -829, -843, -423, 206, 727, 819, 432, -150,
    -611, -641, -230, 392, 883, 907, 468, -165,
    -667, -791, -468, 85, 589, 701, 319, -285,
    -749, -803, -442, 203, 791, 909, 573, 2,
    -521, -665, -342, 225, 739, 855, 461, -169,
    -721, -883, -583, -15, 545, 753, 448, -106,
    -603, -733, -407, 198, 783, 971, 667, 73,
    -495, -727, -504, 41, 569, 735, 467, -106,
    -679, -899, -637, -59, 551, 823, 631, 92,
    -449, -665, -455, 104, 707, 937, 681, 113,
    -506, -807, -675, -163, 424, 701, 508, -22,
    -585, -847, -655, -82, 561, 913, 767, 239,
    -326, -667, -539, -20, 539, 859, 671, 99,
    -519, -885, -759, -290, 308, 703, 611, 142,
    -424, -753, -625, -85, 571, 949, 863, 346,
    -280, -683, -659, -227, 361, 741, 637, 146,
    -478, -865, -821, -377, 296, 763, 763, 349,
    -246, -637, -597, -153, 464, 913, 873, 384,
    -264, -729, -769, -400, 188, 627, 647, 234,
    -375, -801, -789, -361, 287, 817, 921, 504,
    -108, -561, -647, -288, 319, 785, 815, 382,
    -271, -769, -891, -535, 62, 581, 711, 378,
    -173, -627, -707, -345, 282, 833, 961, 605,
    0, -525, -695, -420, 113, 621, 733, 360,
    -211, -737, -879, -561, 15, 609, 827, 545,
    11, -490, -647, -353, 227, 777, 933, 603,
    4, -573, -803, -557, -46, 483, 689, 424,
    -113, -611, -805, -533, 68, 665, 917, 699,
    149, -396, -625, -433, 83, 639, 857, 595,
    19, -577, -837, -673, -165, 427, 715, 571,
    75, -464, -683, -487, 35, 651, 983, 795,
    256, -327, -651, -527, -92, 457, 765, 587,
    61, -527, -829, -683, -192, 412, 799, 723,
    250, -292, -603, -481, 8, 595, 933, 821,
    288, -313, -681, -681, -272, 323, 685, 605,
    161, -414, -739, -667, -208, 444, 877, 851,
    425, -136, -551, -541, -115, 446, 825, 779,
    306, -311, -743, -755, -364, 211, 667, 705,
    325, -231, -631, -599, -184, 423, 909, 937,
    525, -77, -559, -627, -293, 261, 695, 727,
    331, -264, -705, -775, -398, 207, 695, 817,
    500, -33, -482, -567, -230, 351, 865, 931,
    559, -51, -573, -703, -449, 79, 585, 707,
    392, -154, -635, -739, -413, 162, 733, 929,
    647, 100, -397, -579, -320, 224, 719, 881,
    543, -49, -601, -801, -557, -29, 525, 751,
    527, 10, -494, -665, -400, 175, 765, 993,
    755, 193, -361, -627, -459, 30, 557, 781,
    543, -2, -559, -803, -611, -94, 521, 835,
    671, 204, -329, -595, -407, 97, 679, 981,
    769, 231, -364, -709, -611, -174, 394, 713,
    581, 100, -462, -747, -583, -87, 529, 937,
    845, 357, -187, -553, -486, -31, 537, 859,
    715, 225, -376, -773, -729, -268, 294, 687,
    673, 246, -298, -625, -543, -100, 519, 943,
    887, 440, -160, -583, -593, -220, 338, 741,
    663, 215, -349, -763, -747, -344, 259, 739,
    759, 397, -125, -545, -543, -140, 421, 863,
    871, 424, -162, -621, -689, -349, 158, 595,
    663, 280, -268, -663, -709, -356, 278, 799,
    883, 545, -10, -462, -567, -246, 289, 741,
    791, 425, -171, -663, -779, -499, 42, 543,
    695, 415, -110, -553, -623, -309, 245, 767,
    923, 613, 49, -464, -653, -412, 99, 563,
    699, 416, -132, -649, -811, -547, -3, 529,
    789, 573, 46, -421, -599, -363, 161, 695,
    877, 619, 56, -477, -743, -579, -86, 417,
    663, 463, -55, -553, -745, -549, -24, 577,
    853, 685, 193, -341, -599, -448, 24, 549,
    811, 597, 69, -502, -791, -657, -210, 349,
    679, 561, 96, -403, -675, -531, -25, 547,
    889, 779, 288, -277, -635, -575, -144, 382,
    679, 577, 104, -468, -789, -705, -242, 319,
    713, 695, 282, -234, -579, -517, -93, 474,
    849, 759, 310, -258, -677, -685, -317, 213,
    607, 585, 182, -367, -729, -693, -288, 314,
    779, 813, 417, -132, -543, -575, -197, 333,
    731, 741, 302, -296, -751, -783, -427, 102,
    569, 635, 307, -210, -627, -653, -285, 311,
    779, 865, 513, -59, -523, -653, -369, 142,
    585, 673, 325, -250, -721, -817, -507, 49,
    599, 755, 466, -27, -485, -613, -317, 217,
    729, 863, 531, -18, -569, -755, -527, -34,
    457, 627, 364, -148, -631, -785, -503, 42,
    599, 861, 629, 97, -386, -615, -411, 87,
    595, 781, 521, -44, -579, -821, -643, -150,
    373, 661, 492, 2, -482, -683, -490, 38,
    615, 885, 705, 188, -367, -669, -533, -65,
    429, 681, 488, -12, -571, -827, -665, -209,
    375, 737, 613, 159, -326, -603, -492, -8,
    553, 845, 699, 191, -380, -723, -647, -239,
    268, 585, 505, 66, -445, -729, -653, -201,
    401, 779, 741, 306, -226, -571, -535, -133,
    401, 741, 633, 196, -373, -751, -747, -375,
    186, 571, 569, 210, -294, -649, -607, -180,
    375, 811, 797, 384, -157, -587, -619, -286,
    221, 605, 591, 198, -348, -761, -763, -396,
    159, 605, 687, 383, -138, -543, -587, -235,
    328, 753, 789, 417, -153, -615, -735, -444,
    55, 511, 587, 260, -243, -657, -709, -399,
    155, 671, 789, 498, -1, -463, -601, -325,
    168, 625, 733, 405, -142, -647, -785, -539,
    -42, 453, 633, 412, -82, -533, -663, -392,
    148, 653, 859, 591, 56, -418, -635, -451,
    15, 483, 659, 417, -98, -585, -795, -577,
    -70, 455, 721, 557, 90, -392, -597, -410,
    71, 599, 823, 611, 105, -451, -709, -587,
    -155, 363, 607, 454, 0, -517, -741, -555,
    -94, 455, 797, 677, 219, -288, -585, -484,
    -52, 456, 747, 585, 85, -453, -777, -693,
    -272, 269, 605, 541, 144, -363, -667, -569,
    -106, 472, 831, 761, 317, -237, -617, -591,
    -207, 298, 617, 551, 122, -425, -753, -731,
    -353, 226, 665, 665, 299, -207, -569, -543,
    -140, 377, 781, 763, 337, -227, -655, -683,
    -359, 139, 537, 561, 206, -330, -709, -687,
    -327, 215, 705, 809, 439, -70, -491, -583,
    -259, 242, 671, 725, 345, -234, -679, -781,
    -477, 30, 487, 617, 331, -162, -581, -655,
    -337, 225, 721, 833, 521, -11, -483, -651,
    -410, 91, 527, 633, 320, -200, -653, -779,
    -517, -10, 517, 707, 465, -1, -438, -593,
    -339, 164, 643, 825, 531, -7, -494, -705,
    -513, -53, 396, 589, 381, -107, -569, -739,
    -521, -3, 555, 777, 587, 132, -356, -569,
    -401, 34, 531, 715, 485, 0, -521, -759,
    -629, -191, 327, 595, 470, 33, -431, -663,
    -489, 5, 531, 821, 661, 204, -305, -613,
    -523, -129, 355, 623, 480, 31, -494, -775,
    -643, -211, 328, 653, 593, 197, -278, -573,
    -485, -58, 468, 765, 663, 234, -312, -679,
    -657, -283, 213, 551, 495, 102, -394, -675,
    -619, -243, 324, 723, 697, 323, -157, -531,
    -529, -159, 335, 681, 625, 228, -315, -713,
    -721, -385, 126, 527, 573, 238, -246, -591,
    -595, -231, 311, 721, 775, 418, -106, -517,
    -611, -309, 181, 557, 581, 236, -266, -667,
    -737, -444, 98, 559, 659, 405, -82, -481,
    -557, -263, 248, 687, 745, 438, -90, -539,
    -669, -477, 13, 466, 573, 308, -177, -603,
    -699, -427, 83, 589, 777, 523, 42, -388,
    -579, -356, 130, 569, 723, 432, -93, -569,
    -749, -541, -88, 389, 603, 417, -35, -480,
    -647, -434, 73, 605, 811, 627, 129, -377,
    -601, -478, -48, 407, 613, 428, -47, -529,
    -745, -601, -150, 387, 669, 555, 141, -337,
    -575, -430, 23, 515, 785, 629, 162, -365,
    -671, -585, -199, 284, 567, 461, 37, -448,
    -705, -569, -132, 391, 763, 695, 269, -201,
    -523, -475, -89, 399, 693, 605, 163, -377,
    -709, -687, -307, 206, 557, 547, 173, -292,
    -599, -561, -141, 399, 773, 745, 359, -163,
    -559, -577, -239, 245, 575, 553, 184, -347,
    -703, -703, -353, 165, 583, 647, 315, -146,
    -497, -525, -181, 325, 713, 731, 354, -170,
    -577, -673, -382, 98, 475, 543, 227, -258,
    -637, -677, -346, 192, 649, 725, 438, -30,
    -422, -527, -267, 201, 607, 671, 343, -162,
    -593, -721, -479, 7, 443, 571, 353, -100,
    -513, -615, -335, 180, 647, 783, 523, 33,
    -427, -603, -404, 43, 460, 601, 358, -129,
    -593, -735, -499, -41, 439, 661, 485, 46,
    -391, -559, -344, 119, 593, 753, 543, 62,
    -428, -673, -531, -96, 363, 567, 383, -43,
    -491, -671, -502, -56, 470, 739, 585, 163,
    -291, -547, -421, -6, 457, 691, 504, 61,
    -435, -713, -599, -193, 282, 567, 486, 89,
    -364, -619, -488, -43, 462, 763, 673, 246,
    -254, -561, -523, -150, 310, 585, 493, 83,
    -409, -693, -641, -259, 271, 619, 617, 234,
    -219, -517, -480, -91, 405, 741, 651, 264,
    -243, -597, -613, -311, 170, 517, 513, 153,
    -328, -643, -611, -261, 247, 683, 717, 375,
    -99, -480, -510, -192, 273, 623, 631, 280,
    -236, -635, -691, -384, 80, 479, 565, 280,
    -171, -539, -581, -260, 267, 685, 775, 475,
    -30, -459, -577, -332, 110, 509, 593, 302,
    -210, -609, -703, -448, 49, 515, 671, 441,
    -6, -429, -543, -267, 206, 645, 775, 486,
    -15, -480, -643, -455, -39, 400, 575, 349,
    -104, -533, -667, -440, 35, 543, 781, 581,
    113, -318, -519, -345, 87, 531, 725, 510,
    -7, -506, -739, -597, -152, 350, 595, 461,
    33, -427, -625, -435, 40, 557, 811, 649,
    209, -296, -599, -488, -67, 384, 623, 455,
    0, -476, -737, -599, -175, 343, 663, 583,
    200, -276, -545, -432, -9, 480, 779, 663,
    203, -310, -655, -603, -214, 246, 547, 482,
    80, -403, -685, -595, -168, 361, 703, 675,
    307, -179, -502, -471, -117, 355, 663, 597,
    195, -322, -669, -663, -329, 168, 533, 533,
    209, -250, -571, -553, -169, 345, 733, 757,
    378, -132, -503, -557, -251, 214, 537, 549,
    214, -285, -667, -679, -354, 135, 555, 653,
    368, -95, -467, -523, -209, 302, 707, 719,
    405, -98, -547, -663, -402, 57, 453, 541,
    270, -198, -583, -651, -383, 129, 603, 721,
    471, 11, -417, -539, -297, 146, 551, 661,
    391, -110, -587, -717, -493, -42, 414, 585,
    360, -80, -468, -599, -357, 116, 585, 791,
    561, 79, -389, -591, -416, 5, 425, 593,
    390, -78, -549, -743, -555, -94, 413, 657,
    508, 91, -349, -547, -377, 52, 543, 747,
    549, 95, -399, -665, -563, -155, 317, 555,
    406, 4, -455, -677, -535, -99, 413, 723,
    625, 211, -255, -537, -443, -49, 399, 661,
    537, 105, -392, -703, -617, -238, 223, 541,
    506, 141, -324, -609, -525, -118, 416, 755,
    683, 308, -205, -553, -539, -204, 246, 557,
    523, 140, -373, -689, -659, -308, 218, 587,
    613, 300, -175, -510, -501, -139, 351, 715,
    709, 329, -185, -567, -627, -356, 124, 497,
    535, 204, -283, -629, -659, -312, 212, 635,
    753, 427, -65, -428, -510, -239, 231, 603,
    653, 334, -195, -627, -733, -464, 22, 448,
    561, 323, -125, -513, -587, -290, 201, 649,
    763, 494, 18, -423, -585, -365, 89, 478,
    579, 328, -155, -593, -699, -464, -5, 459,
    645, 438, 20, -382, -537, -302, 149, 583,
    759, 511, 13, -433, -641, -481, -52, 374,
    545, 362, -72, -515, -671, -465, 3, 483,
    707, 559, 142, -287, -513, -364, 37, 464,
    667, 474, 28, -455, -675, -557, -169, 298,
    549, 442, 71, -357, -587, -432, -4, 480,
    751, 627, 206, -268, -557, -473, -87, 327,
    569, 459, 50, -414, -683, -581, -188, 284,
    601, 563, 211, -236, -505, -429, -52, 421,
    707, 629, 236, -253, -589, -579, -256, 197,
    517, 474, 114, -340, -639, -583, -202, 296,
    663, 655, 332, -113, -470, -468, -138, 283,
    605, 603, 235, -270, -627, -629, -339, 112,
    509, 549, 246, -206, -533, -535, -211, 285,
    685, 729, 402, -77, -466, -549, -284, 153,
    502, 545, 237, -234, -613, -683, -398, 91,
    510, 627, 382, -44, -414, -513, -244, 225,
    659, 729, 431, -59, -505, -661, -445, 13,
    423, 559, 325, -141, -549, -651, -398, 97,
    563, 747, 521, 78, -353, -545, -339, 121,
    537, 663, 432, -54, -533, -701, -508, -93,
    359, 571, 421, -9, -444, -609, -392, 75,
    559, 787, 595, 152, -337, -597, -461, -41,
    399, 589, 416, -25, -489, -703, -573, -153,
    357, 633, 535, 138, -319, -541, -410, 10,
    493, 751, 593, 165, -336, -657, -589, -208,
    268, 533, 441, 37, -417, -685, -589, -159,
    345, 719, 667, 255, -209, -517, -466, -89,
    374, 661, 581, 159, -346, -685, -673, -314,
    176, 527, 515, 173, -268, -579, -531, -142,
    368, 739, 723, 341, -153, -521, -543, -228,
    212, 543, 525, 171, -318, -657, -659, -342,
    153, 557, 613, 322, -126, -473, -499, -165,
    307, 681, 719, 361, -139, -543, -631, -363,
    88, 477, 533, 235, -222, -595, -641, -325,
    176, 601, 723, 449, -13, -392, -495, -254,
    183, 571, 641, 356, -134, -563, -665, -462,
    0, 439, 561, 353, -69, -468, -567, -298,
    167, 615, 771, 523, 58, -386, -549, -357,
    60, 453, 571, 358, -101, -537, -699, -496,
    -20, 427, 635, 490, 73, -342, -511, -328,
    111, 557, 721, 533, 78, -392, -623, -503,
    -94, 347, 547, 395, -14, -447, -643, -490,
    -27, 452, 687, 581, 194, -258, -497, -381,
    1, 426, 653, 507, 84, -405, -669, -561,
    -205, 269, 553, 465, 112, -326, -561, -448,
    -41, 435, 749, 667, 232, -226, -510, -479,
    -138, 300, 565, 476, 96, -366, -675, -613,
    -228, 255, 587, 575, 244, -188, -484, -457,
    -95, 381, 703, 635, 269, -195, -567, -597,
    -293, 166, 493, 482, 177, -285, -613, -599,
    -248, 238, 643, 693, 365, -77, -437, -483,
    -180, 252, 591, 623, 298, -210, -601, -665,
    -400, 75, 467, 539, 267, -143, -497, -547,
    -243, 225, 633, 721, 444, -18, -428, -549,
    -314, 108, 462, 547, 292, -178, -567, -665,
    -441, 17, 468, 625, 423, 0, -385, -507,
    -283, 166, 599, 725, 469, -6, -455, -637,
    -463, -39, 365, 531, 332, -98, -507, -659,
    -440, 29, 498, 711, 543, 118, -311, -493,
    -350, 47, 480, 647, 448, 2, -462, -687,
    -543, -124, 316, 543, 412, 41, -372, -587,
    -408, 26, 502, 743, 601, 192, -278, -541,
    -438, -84, 331, 565, 434, 23, -443, -663,
    -551, -176, 309, 589, 529, 190, -244, -487,
    -393, -10, 433, 693, 609, 207, -281, -593,
    -555, -208, 237, 500, 430, 85, -356, -619,
    -537, -173, 312, 643, 621, 301, -157, -459,
    -442, -119, 326, 601, 539, 183, -288, -637,
    -637, -318, 134, 478, 499, 194, -232, -517,
    -502, -167, 308, 683, 701, 358, -103, -489,
    -547, -265, 169, 523, 527, 201, -265, -643,
    -693, -382, 116, 509, 601, 359, -84, -466,
    -503, -200, 252, 629, 669, 377, -94, -521,
    -631, -385, 40, 410, 513, 256, -182, -561,
    -661, -374, 112, 537, 685, 471, 19, -379,
    -505, -301, 135, 529, 619, 383, -84, -533,
    -675, -494, -61, 381, 555, 364, -50, -446,
    -569, -349, 104, 539, 731, 547, 90, -355,
    -553, -407, 2, 416, 561, 369, -59, -494,
    -701, -535, -92, 379, 615, 486, 108, -324,
    -529, -367, 45, 485, 707, 551, 111, -366,
    -625, -533, -158, 292, 529, 408, 16, -415,
    -661, -529, -85, 399, 673, 603, 246, -224,
    -498, -424, -57, 379, 639, 527, 122, -356,
    -673, -627, -253, 213, 517, 486, 133, -280,
    -547, -489, -100, 379, 699, 667, 302, -173,
    -511, -513, -197, 229, 529, 500, 135, -338,
    -635, -661, -322, 185, 539, 587, 274, -152,
    -467, -478, -141, 314, 677, 677, 335, -156,
    -571, -627, -348, 105, 453, 493, 192, -262,
    -605, -637, -318, 165, 597, 691, 410, -40,
    -421, -495, -230, 194, 559, 621, 315, -157,
    -573, -691, -448, 2, 430, 545, 308, -121,
    -493, -553, -282, 179, 615, 723, 461, 26,
    -391, -549, -351, 57, 447, 561, 311, -140,
    -567, -679, -470, -28, 420, 603, 433, 17,
    -369, -513, -308, 131, 541, 703, 484, 33,
    -420, -635, -483, -79, 322, 503, 338, -65,
    -480, -649, -444, -18, 432, 671, 531, 127,
    -291, -494, -372, 22, 431, 617, 449, 8,
    -428, -665, -569, -176, 270, 505, 410, 46,
    -344, -565, -439, -11, 439, 711, 597, 194,
    -246, -527, -460, -120, 284, 529, 430, 39,
    -413, -667, -585, -209, 257, 561, 527, 198,
    -225, -485, -420, -82, 364, 651, 581, 214,
    -242, -565, -575, -255, 171, 460, 456, 129,
    -317, -603, -573, -204, 273, 609, 631, 318,
    -122, -440, -465, -158, 283, 581, 569, 234,
    -248, -605, -635, -337, 100, 449, 517, 230,
    -191, -505, -513, -200, 255, 619, 677, 399,
    -69, -433, -523, -282, 136, 466, 535, 248,
    -210, -579, -651, -392, 64, 468, 597, 372,
    -41, -391, -481, -235, 196, 577, 663, 416,
    -28, -461, -611, -396, 8, 386, 502, 291,
    -130, -513, -619, -389, 65, 484, 655, 473,
    68, -324, -498, -314, 102, 485, 613, 397,
    -45, -477, -649, -515, -99, 329, 515, 399,
    3, -397, -557, -374, 58, 497, 701, 549,
    143, -290, -521, -419, -51, 350, 539, 391,
    -10, -449, -673, -555, -165, 311, 581, 505,
    143, -280, -485, -376, 8, 442, 667, 565,
    171, -305, -587, -533, -196, 236, 488, 414,
    61, -381, -625, -533, -143, 336, 659, 627,
    267, -179, -479, -439, -97, 342, 611, 541,
    161, -334, -663, -641, -307, 151, 495, 493,
    173, -261, -549, -504, -158, 335, 669, 669,
    335, -148, -496, -521, -226, 188, 510, 507,
    170, -287, -641, -657, -324, 137, 517, 585,
    311, -119, -442, -461, -182, 262, 631, 671,
    340, -129, -503, -615, -365, 73, 414, 475,
    223, -193, -549, -609, -335, 135, 545, 673,
    429, -15, -381, -478, -251, 157, 521, 607,
    332, -133, -547, -671, -455, -13, 393, 523,
    328, -91, -456, -537, -315, 120, 543, 691,
    497, 55, -375, -535, -372, 29, 403, 521,
    321, -103, -517, -691, -499, -55, 372, 587,
    435, 49, -331, -499, -338, 59, 480, 677,
    484, 42, -378, -613, -503, -96, 283, 484,
    352, -37, -432, -635, -478, -59, 396, 643,
    537, 163, -255, -484, -391, -35, 381, 595,
    479, 76, -399, -647, -581, -223, 227, 500,
    441, 94, -322, -547, -450, -64, 392, 651,
    607, 247, -224, -515, -483, -159, 258, 513,
    445, 93, -353, -659, -599, -237, 202, 525,
    531, 232, -189, -465, -440, -117, 317, 619,
    605, 260, -212, -551, -567, -298, 126, 442,
    456, 168, -262, -593, -585, -240, 206, 567,
    619, 353, -74, -425, -472, -203, 221, 541,
    567, 265, -203, -579, -655, -393, 51, 421,
    504, 266, -138, -475, -527, -254, 209, 583,
    677, 429, -25, -408, -523, -313, 93, 438,
    521, 286, -158, -551, -653, -433, 15, 430,
    577, 394, 0, -375, -488, -275, 137, 537,
    673, 465, 3, -431, -599, -443, -50, 343,
    495, 315, -85, -487, -625, -425, -10, 451,
    669, 508, 120, -293, -480, -346, 31, 433,
    613, 447, 2, -448, -673, -553, -156, 285,
    499, 399, 42, -356, -535, -401, 2, 442,
    683, 569, 165, -262, -515, -438, -93, 291,
    519, 405, 18, -424, -663, -569, -172, 280,
    547, 500, 158, -227, -459, -382, -32, 390,
    647, 555, 184, -266, -567, -533, -209, 193,
    463, 403, 86, -324, -599, -531, -180, 278,
    597, 585, 270, -140, -437, -429, -124, 283,
    561, 515, 169, -264, -597, -607, -301, 116,
    435, 474, 204, -218, -493, -478, -171, 271,
    605, 643, 356, -90, -433, -503, -256, 169,
    467, 468, 192, -233, -581, -629, -351, 101,
    461, 555, 321, -80, -397, -458, -200, 216,
    553, 617, 345, -82, -446, -591, -384, 28,
    378, 463, 227, -157, -497, -589, -344, 89,
    496, 637, 426, 22, -338, -462, -278, 112,
    476, 569, 332, -80, -478, -635, -457, -59,
    338, 513, 340, -43, -396, -533, -333, 91,
    495, 673, 507, 90, -325, -521, -376, -6,
    341, 495, 341, -44, -448, -633, -488, -87,
    331, 567, 458, 92, -301, -510, -358, 32,
    436, 657, 533, 116, -343, -599, -527, -161,
    263, 481, 383, 18, -396, -615, -505, -106,
    358, 625, 567, 225, -211, -478, -412, -65,
    365, 601, 484, 117, -336, -631, -595, -249,
    193, 482, 460, 134, -276, -531, -476, -112,
    338, 639, 629, 289, -159, -468, -477, -194,
    221, 497, 470, 151, -319, -633, -615, -301,
    147, 510, 559, 280, -132, -444, -451, -149,
    299, 625, 629, 318, -148, -508, -577, -330,
    98, 433, 473, 192, -222, -555, -599, -298,
    179, 563, 653, 414, -14, -376, -452, -236,
    175, 533, 591, 321, -140, -543, -661, -416,
    8, 392, 510, 301, -86, -451, -531, -275,
    154, 563, 701, 466, 34, -364, -505, -341,
    47, 417, 515, 302, -114, -513, -657, -452,
    -22, 397, 581, 411, 37, -326, -477, -298,
    122, 505, 655, 484, 44, -393, -581, -436,
    -72, 309, 490, 341, -59, -433, -593, -442,
    -11, 418, 637, 533, 157, -243, -450, -339,
    27, 406, 587, 455, 34, -397, -619, -531,
    -166, 250, 508, 428, 72, -315, -515, -397,
    -20, 417, 667, 567, 211, -206, -491, -431,
    -111, 274, 513, 412, 70, -353, -637, -567,
    -199, 242, 535, 502, 191, -205, -453, -397,
    -60, 347, 607, 555, 225, -208, -545, -547,
    -243, 151, 444, 430, 116, -296, -577, -541,
    -200, 237, 559, 595, 300, -116, -416, -446,
    -166, 245, 525, 527, 224, -224, -575, -619,
    -332, 83, 421, 485, 223, -171, -479, -505,
    -208, 222, 563, 637, 378, -64, -415, -498,
    -276, 105, 424, 490, 222, -200, -549, -627,
    -389, 39, 429, 557, 357, -43, -379, -472,
    -256, 171, 510, 609, 403, -43, -452, -587,
    -399, -8, 350, 469, 267, -108, -475, -605,
    -381, 43, 448, 617, 466, 79, -313, -478,
    -322, 66, 432, 553, 370, -34, -461, -637,
    -487, -104, 294, 486, 356, 0, -363, -525,
    -376, 19, 454, 659, 521, 129, -296, -510,
    -413, -67, 317, 497, 369, 1, -432, -639,
    -529, -150, 287, 543, 469, 122, -255, -465,
    -363, -12, 398, 625, 527, 156, -283, -551,
    -513, -200, 205, 461, 386, 51, -337, -571,
    -508, -163, 293, 589, 579, 260, -159, -432,
    -415, -93, 306, 551, 499, 164, -294, -589,
    -581, -298, 128, 438, 460, 181, -229, -497,
    -464, -157, 284, 615, 615, 309, -106, -430,
    -483, -218, 174, 448, 455, 155, -265, -569,
    -603, -321, 107, 464, 537, 284, -99, -405,
    -436, -172, 237, 559, 591, 321, -104, -471,
    -547, -327, 56, 380, 448, 203, -175, -498,
    -563, -297, 127, 493, 589, 378, -3, -330,
    -435, -243, 139, 468, 551, 315, -118, -474,
    -597, -433, -21, 347, 463, 305, -65, -428,
    -523, -305, 103, 493, 655, 466, 51, -349,
    -521, -360, 0, 361, 513, 300, -97, -498,
    -655, -458, -63, 336, 535, 423, 61, -319,
    -479, -331, 53, 458, 627, 464, 68, -366,
    -585, -469, -126, 266, 459, 341, -19, -409,
    -597, -464, -74, 351, 597, 513, 159, -225,
    -459, -386, -29, 349, 561, 452, 73, -366,
    -625, -557, -205, 199, 454, 411, 87, -296,
    -517, -427, -63, 352, 607, 589, 237, -208,
    -474, -454, -158, 226, 477, 427, 93, -320,
    -607, -577, -258, 170, 496, 507, 225, -161,
    -441, -428, -114, 302, 585, 571, 250, -191,
    -521, -555, -296, 105, 423, 419, 138, -240,
    -553, -571, -263, 168, 519, 579, 330, -77,
    -412, -458, -224, 187, 500, 515, 244, -193,
    -557, -625, -393, 12, 368, 463, 233, -152,
    -457, -533, -284, 158, 525, 611, 387, -21,
    -394, -521, -338, 57, 382, 465, 246, -171,
    -521, -651, -441, -17, 377, 535, 362, -8,
    -352, -471, -293, 110, 488, 609, 409, -17,
    -426, -597, -449, -88, 276, 458, 286, -99,
    -470, -613, -431, -10, 404, 601, 480, 96,
    -293, -470, -350, 14, 391, 553, 394, -3,
    -433, -651, -533, -166, 233, 458, 360, 29,
    -340, -539, -394, -28, 384, 639, 533, 158,
    -266, -513, -444, -104, 261, 463, 362, 0,
    -395, -619, -551, -193, 230, 499, 468, 151,
    -236, -455, -383, -54, 339, 585, 521, 167,
    -265, -535, -509, -234, 154, 416, 372, 68,
    -315, -571, -529, -180, 240, 541, 545, 251,
    -140, -420, -409, -129, 240, 523, 490, 166,
    -263, -567, -591, -315, 102, 402, 432, 181,
    -188, -474, -482, -186, 240, 557, 595, 324,
    -85, -426, -478, -238, 119, 422, 450, 176,
    -218, -549, -603, -348, 67, 419, 517, 309,
    -78, -393, -450, -207, 198, 517, 575, 341,
    -73, -440, -561, -364, 21, 345, 425, 231,
    -142, -477, -577, -341, 86, 446, 581, 400,
    25, -332, -455, -277, 88, 443, 533, 337,
    -60, -453, -613, -465, -64, 317, 457, 307,
    -28, -375, -507, -326, 56, 444, 613, 465,
    82, -291, -473, -365, -27, 316, 483, 322,
    -44, -419, -607, -484, -117, 298, 504, 428,
    108, -276, -463, -342, 7, 391, 597, 470,
    107, -298, -547, -484, -161, 219, 436, 339,
    25, -346, -565, -474, -127, 298, 551, 498,
    206, -190, -435, -387, -79, 308, 517, 443,
    94, -328, -585, -545, -249, 131, 416, 404,
    121, -250, -489, -437, -121, 286, 575, 569,
    261, -149, -431, -452, -197, 180, 441, 407,
    127, -272, -577, -581, -297, 123, 453, 507,
    253, -132, -411, -417, -161, 234, 533, 557,
    289, -147, -475, -545, -336, 52, 369, 428,
    202, -217, -557, -587, -309, 124, 503, 593,
    368, -21, -369, -457, -246, 149, 469, 551,
    294, -160, -517, -639, -439, -32, 342, 459,
    261, -105, -444, -533, -293, 115, 499, 631,
    424, 11, -365, -501, -342, 12, 345, 470,
    278, -126, -509, -647, -464, -55, 346, 505,
    377, 14, -336, -470, -302, 73, 440, 603,
    411, 23, -386, -587, -452, -112, 261, 430,
    279, -78, -425, -579, -441, -56, 347, 571,
    460, 114, -251, -459, -356, -29, 341, 527,
    387, 22, -392, -619, -529, -193, 212, 440,
    361, 54, -303, -515, -422, -51, 351, 585,
    515, 193, -235, -480, -414, -144, 222, 441,
    365, 46, -350, -609, -551, -213, 192, 464,
    457, 174, -193, -438, -412, -102, 296, 549,
    511, 195, -221, -513, -521, -253, 122, 376,
    368, 94, -273, -527, -533, -221, 191, 494,
    549, 292, -112, -409, -420, -178, 201, 481,
    488, 209, -225, -539, -589, -347, 59, 365,
    433, 212, -165, -463, -478, -200, 186, 502,
    581, 347, -51, -393, -484, -279, 64, 377,
    449, 208, -181, -517, -601, -380, 26, 383,
    501, 325, -35, -355, -455, -240, 143, 473,
    577, 364, -24, -401, -553, -384, -40, 295,
    415, 258, -110, -463, -557, -368, 22, 388,
    551, 409, 74, -287, -444, -304, 48, 395,
    513, 363, -11, -409, -601, -477, -113, 251,
    425, 335, 10, -353, -492, -358, 7, 399,
    591, 479, 126, -251, -467, -381, -71, 273,
    454, 344, 1, -386, -589, -492, -155, 248,
    486, 430, 130, -225, -429, -355, -35, 349,
    579, 491, 160, -256, -519, -494, -211, 164,
    406, 369, 57, -312, -539, -490, -153, 253,
    527, 521, 235, -160, -412, -374, -107, 252,
    495, 458, 140, -261, -549, -549, -284, 117,
    422, 408, 155, -200, -444, -439, -155, 243,
    531, 553, 284, -97, -397, -451, -222, 141,
    399, 410, 147, -233, -521, -563, -308, 83,
    405, 483, 263, -64, -349, -391, -151, 205,
    503, 561, 311, -90, -405, -505, -313, 47,
    340, 407, 193, -170, -457, -501, -288, 98,
    456, 565, 361, 13, -288, -381, -212, 124,
    431, 511, 299, -78, -410, -539, -381, -23,
    312, 449, 304, -38, -338, -446, -263, 124,
    470, 601, 446, 89, -272, -417, -285, 24,
    334, 460, 320, -31, -390, -529, -386, -30,
    336, 502, 401, 102, -231, -390, -252, 81,
    434, 587, 443, 110, -265, -463, -372, -62,
    271, 435, 336, 28, -319, -484, -367, -49,
    311, 551, 489, 201, -145, -350, -280, 3,
    337, 523, 447, 124, -263, -505, -452, -145,
    216, 447, 408, 124, -213, -415, -342, -28,
    331, 579, 537, 247, -109, -373, -364, -105,
    240, 470, 425, 147, -244, -499, -466, -199,
    206, 502, 517, 253, -103, -333, -332, -61,
    305, 565, 573, 289, -116, -403, -451, -218,
    134, 409, 443, 205, -163, -441, -448, -192,
    208, 537, 589, 361, 0, -296, -337, -123,
    210, 497, 539, 283, -98, -422, -498, -284,
    68, 391, 482, 285, -53, -334, -386, -186,
    179, 529, 639, 442, 50, -289, -389, -235,
    103, 423, 513, 303, -72, -412, -521, -329,
    38, 401, 533, 402, 67, -266, -368, -201,
    141, 476, 615, 439, 63, -301, -484, -344,
    -8, 316, 457, 313, -11, -365, -495, -344,
    11, 402, 587, 481, 155, -188, -376, -264,
    61, 390, 539, 419, 66, -331, -519, -422,
    -103, 255, 450, 379, 78, -259, -427, -333,
    7, 393, 587, 511, 192, -176, -401, -364,
    -74, 263, 453, 383, 55, -326, -527, -469,
    -159, 225, 479, 450, 170, -161, -374, -313,
    -24, 321, 551, 507, 194, -190, -443, -452,
    -185, 179, 392, 372, 98, -257, -483, -455,
    -158, 226, 506, 506, 248, -99, -354, -356,
    -105, 231, 467, 453, 176, -191, -475, -515,
    -273, 99, 371, 400, 179, -161, -406, -399,
    -152, 223, 508, 539, 303, -67, -345, -408,
    -232, 101, 395, 421, 170, -181, -477, -531,
    -301, 71, 387, 480, 283, -58, -328, -390,
    -193, 164, 458, 523, 312, -58, -391, -495,
    -328, 2, 299, 392, 212, -120, -408, -501,
    -320, 52, 383, 509, 357, 19, -281, -400,
    -253, 68, 366, 469, 291, -53, -401, -549,
    -405, -75, 257, 403, 282, -35, -339, -450,
    -312, 34, 398, 549, 405, 81, -273, -452,
    -335, -46, 264, 412, 282, -38, -388, -547,
    -426, -116, 237, 457, 379, 82, -242, -401,
    -309, -12, 336, 513, 408, 77, -277, -473,
    -448, -163, 193, 374, 296, 13, -329, -495,
    -433, -131, 253, 470, 443, 178, -171, -383,
    -345, -98, 249, 460, 397, 103, -271, -519,
    -504, -230, 123, 365, 342, 99, -226, -448,
    -403, -119, 242, 494, 492, 233, -124, -394,
    -430, -208, 123, 365, 361, 102, -248, -513,
    -527, -290, 79, 381, 420, 200, -125, -364,
    -388, -150, 189, 457, 479, 232, -123, -436,
    -508, -306, 21, 304, 363, 142, -192, -468,
    -510, -279, 93, 393, 484, 309, -32, -327,
    -404, -224, 101, 392, 431, 224, -125, -452,
    -559, -393, -35, 267, 374, 232, -85, -374,
    -467, -272, 84, 390, 501, 341, 6, -308,
    -437, -323, -11, 295, 383, 210, -114, -431,
    -545, -393, -75, 267, 416, 303, 6, -301,
    -405, -270, 37, 348, 477, 345, 26, -320,
    -496, -398, -115, 195, 349, 244, -57, -370,
    -508, -380, -62, 267, 468, 382, 93, -226,
    -399, -311, -34, 278, 425, 326, 6, -354,
    -553, -504, -199, 147, 350, 298, 25, -289,
    -457, -387, -100, 276, 484, 425, 140, -221,
    -438, -411, -151, 175, 374, 302, 24, -317,
    -549, -506, -226, 128, 375, 371, 131, -188,
    -403, -372, -115, 224, 453, 418, 160, -201,
    -462, -483, -260, 72, 303, 301, 61, -265,
    -501, -496, -232, 129, 412, 440, 220, -107,
    -368, -405, -191, 145, 387, 386, 148, -204,
    -482, -543, -335, 9, 275, 345, 156, -155,
    -407, -441, -212, 124, 398, 482, 284, -73,
    -361, -436, -266, 41, 304, 348, 149, -180,
    -464, -543, -353, -15, 292, 413, 249, -57,
    -336, -427, -235, 85, 361, 449, 277, -48,
    -368, -499, -382, -69, 228, 338, 195, -122,
    -414, -511, -353, -15, 314, 447, 331, 53,
    -270, -425, -287, 11, 302, 420, 273, -54,
    -395, -545, -438, -132, 189, 353, 263, -28,
    -320, -435, -335, -32, 306, 482, 401, 82,
    -261, -425, -368, -114, 205, 359, 257, -11,
    -357, -557, -470, -163, 177, 383, 352, 92,
    -231, -397, -329, -66, 252, 463, 405, 115,
    -249, -480, -443, -197, 111, 316, 288, 40,
    -297, -500, -449, -173, 184, 415, 426, 195,
    -147, -375, -362, -124, 197, 419, 376, 103,
    -241, -496, -510, -272, 76, 305, 317, 122,
    -187, -410, -411, -157, 192, 449, 480, 250,
    -87, -366, -409, -199, 107, 329, 341, 139,
    -215, -473, -488, -281, 58, 331, 389, 217,
    -87, -324, -358, -170, 153, 415, 464, 256,
    -87, -377, -468, -306, 10, 273, 337, 154,
    -156, -410, -474, -294, 51, 348, 441, 286,
    -17, -284, -380, -220, 76, 329, 394, 221,
    -92, -404, -507, -359, -60, 231, 352, 214,
    -67, -330, -426, -275, 40, 356, 483, 334,
    30, -269, -415, -319, -30, 244, 349, 228,
    -66, -386, -513, -378, -88, 228, 406, 310,
    30, -244, -374, -275, 5, 315, 457, 334,
    37, -275, -449, -394, -121, 168, 319, 237,
    -24, -321, -481, -391, -98, 248, 430, 370,
    121, -184, -366, -313, -65, 228, 399, 333,
    46, -303, -485, -453, -210, 109, 317, 297,
    66, -231, -415, -355, -107, 224, 444, 415,
    170, -152, -379, -382, -154, 137, 330, 310,
    56, -268, -479, -465, -223, 93, 349, 368,
    144, -143, -355, -342, -122, 182, 401, 411,
    182, -154, -408, -450, -255, 37, 283, 313,
    98, -202, -431, -459, -225, 99, 357, 404,
    237, -50, -312, -369, -202, 113, 350, 373,
    176, -153, -423, -495, -325, -13, 257, 333,
    179, -120, -373, -412, -236, 84, 363, 458,
    293, -21, -307, -409, -267, 2, 266, 344,
    181, -114, -404, -510, -362, -51, 263, 389,
    266, -8, -285, -378, -245, 49, 349, 474,
    324, 1, -325, -481, -382, -99, 196, 324,
    211, -82, -368, -498, -368, -39, 273, 440,
    357, 86, -240, -389, -282, -19, 265, 406,
    295, -2, -343, -515, -433, -168, 160, 332,
    271, 10, -278, -420, -340, -46, 273, 471,
    408, 126, -193, -390, -356, -113, 169, 353,
    293, 7, -311, -486, -449, -187, 153, 365,
    352, 116, -179, -360, -329, -79, 232, 433,
    392, 129, -197, -425, -428, -199, 96, 311,
    290, 61, -235, -445, -429, -192, 158, 399,
    418, 208, -113, -328, -347, -127, 167, 368,
    378, 138, -192, -446, -482, -265, 46, 290,
    335, 139, -153, -368, -381, -165, 146, 408,
    443, 242, -64, -333, -382, -226, 71, 302,
    328, 134, -173, -425, -488, -294, 25, 308,
    387, 229, -50, -300, -360, -190, 116, 387,
    428, 246, -55, -347, -440, -299, -19, 233,
    321, 175, -112, -379, -449, -291, 16, 324,
    448, 306, 32, -244, -373, -227, 46, 311,
    407, 265, -36, -346, -484, -364, -75, 214,
    355, 249, -14, -282, -387, -269, 11, 310,
    464, 356, 63, -227, -374, -302, -47, 227,
    353, 239, -40, -332, -475, -391, -112, 194,
    374, 311, 69, -199, -364, -286, -14, 280,
    428, 341, 75, -227, -421, -393, -150, 144,
    319, 253, 12, -277, -445, -387, -114, 201,
    399, 378, 136, -149, -332, -307, -95, 207,
    381, 325, 92, -232, -460, -444, -220, 82,
    293, 296, 98, -186, -377, -349, -123, 189,
    409, 421, 202, -110, -343, -371, -185, 104,
    320, 311, 98, -224, -451, -452, -252, 62,
    311, 354, 188, -94, -322, -336, -149, 148,
    381, 415, 218, -111, -357, -427, -283, 15,
    257, 314, 133, -162, -390, -438, -247, 71,
    345, 414, 263, -11, -278, -350, -191, 83,
    326, 373, 209, -87, -378, -469, -329, -43,
    220, 332, 195, -78, -311, -391, -245, 62,
    342, 435, 308, 21, -257, -372, -264, -1,
    246, 332, 189, -81, -353, -475, -345, -55,
    236, 372, 280, 19, -245, -331, -235, 21,
    304, 427, 317, 33, -264, -418, -334, -86,
    176, 305, 213, -44, -310, -424, -341, -61,
    239, 394, 347, 93, -184, -326, -267, -29,
    230, 373, 293, 21, -263, -439, -398, -156,
    131, 304, 264, 49, -215, -365, -303, -55,
    232, 402, 379, 153, -153, -339, -326, -113,
    162, 318, 274, 48, -252, -430, -397, -173,
    121, 327, 334, 127, -126, -308, -289, -83,
    189, 396, 375, 163, -135, -357, -384, -207,
    70, 275, 271, 74, -189, -384, -381, -176,
    125, 362, 391, 218, -69, -271, -292, -135,
    140, 335, 347, 162, -132, -364, -426, -254,
    32, 263, 306, 151, -91, -307, -347, -169,
    125, 376, 422, 264, -32, -283, -359, -226,
    51, 284, 335, 152, -123, -370, -451, -289,
    11, 282, 371, 248, -5, -242, -335, -193,
    89, 337, 418, 270, -20, -300, -412, -294,
    -40, 211, 316, 189, -73, -322, -411, -285,
    -8, 282, 416, 297, 53, -200, -326, -240,
    17, 287, 369, 254, -7, -304, -441, -358,
    -112, 162, 315, 243, 0, -244, -369, -286,
    -19, 276, 421, 350, 102, -194, -342, -290,
    -61, 195, 326, 260, 16, -284, -437, -369,
    -135, 163, 348, 316, 99, -167, -316, -270,
    -43, 246, 419, 355, 110, -192, -380, -373,
    -166, 123, 289, 260, 44, -228, -409, -376,
    -139, 158, 374, 375, 186, -96, -316, -300,
    -105, 164, 359, 326, 100, -193, -408, -430,
    -237, 47, 273, 302, 111, -143, -335, -347,
    -138, 168, 383, 411, 220, -77, -309, -354,
    -187, 86, 284, 291, 105, -168, -395, -436,
    -253, 41, 272, 341, 191, -75, -275, -324,
    -162, 127, 353, 386, 212, -71, -314, -401,
    -266, 0, 223, 282, 135, -126, -345, -393,
    -243, 36, 297, 382, 255, -1, -241, -321,
    -207, 49, 273, 342, 212, -76, -340, -428,
    -320, -54, 206, 296, 184, -44, -276, -364,
    -236, 28, 286, 406, 296, 55, -214, -362,
    -266, -30, 211, 308, 197, -54, -303, -433,
    -347, -78, 189, 329, 263, 34, -206, -322,
    -234, 0, 256, 396, 295, 46, -234, -388,
    -335, -118, 134, 265, 210, -13, -268, -403,
    -334, -84, 188, 368, 334, 97, -155, -308,
    -265, -50, 201, 343, 283, 51, -233, -415,
    -394, -173, 95, 279, 261, 52, -192, -344,
    -305, -92, 190, 381, 353, 150, -126, -323,
    -312, -129, 121, 288, 270, 69, -195, -398,
    -397, -186, 94, 288, 301, 150, -113, -292,
    -288, -107, 163, 351, 353, 170, -106, -340,
    -379, -225, 34, 240, 259, 94, -151, -361,
    -376, -198, 76, 318, 366, 218, -32, -256,
    -313, -161, 91, 300, 331, 157, -109, -351,
    -408, -266, -15, 221, 296, 158, -84, -288,
    -331, -198, 64, 317, 397, 264, -5, -243,
    -344, -240, 10, 226, 301, 162, -89, -339,
    -430, -296, -36, 214, 320, 242, 11, -225,
    -311, -202, 45, 287, 379, 271, 14, -252,
    -384, -300, -65, 170, 278, 184, -52, -291,
    -399, -309, -38, 232, 370, 308, 73, -176,
    -305, -243, -21, 231, 345, 254, 16, -257,
    -413, -345, -130, 124, 285, 219, 21, -214,
    -347, -269, -39, 225, 384, 336, 115, -158,
    -320, -287, -100, 146, 285, 225, 10, -245,
    -401, -369, -159, 115, 301, 287, 109, -132,
    -302, -271, -63, 193, 352, 333, 117, -151,
    -344, -368, -168, 73, 253, 256, 54, -193,
    -363, -334, -133, 126, 341, 370, 174, -86,
    -270, -289, -122, 135, 316, 312, 116, -168,
    -378, -407, -234, 38, 245, 281, 121, -118,
    -309, -331, -148, 118, 346, 382, 212, -55,
    -272, -325, -194, 48, 242, 284, 113, -147,
    -355, -422, -259, 22, 246, 326, 201, -40,
    -257, -305, -173, 84, 308, 350, 214, -50,
    -285, -381, -275, -32, 189, 271, 145, -104,
    -323, -385, -263, 6, 261, 362, 263, 9,
    -220, -310, -213, 21, 249, 328, 207, -45,
    -298, -405, -328, -85, 170, 272, 207, -16,
    -256, -334, -238, 3, 260, 374, 290, 60,
    -198, -335, -277, -59, 180, 297, 212, -28,
    -279, -403, -330, -102, 162, 307, 264, 70,
    -183, -303, -229, -27, 226, 370, 301, 74,
    -193, -352, -338, -136, 107, 255, 224, 28,
    -222, -366, -322, -106, 154, 332, 317, 120,
    -112, -283, -274, -86, 160, 313, 287, 83,
    -192, -377, -368, -184, 65, 250, 249, 74,
    -147, -322, -306, -113, 155, 353, 354, 172,
    -84, -287, -304, -155, 74, 264, 264, 80,
    -162, -369, -391, -205, 57, 262, 306, 164,
    -74, -247, -275, -128, 124, 329, 357, 186,
    -74, -289, -355, -222, 9, 210, 265, 115,
    -122, -316, -356, -204, 57, 290, 357, 235,
    -2, -226, -288, -171, 59, 269, 338, 183,
    -93, -318, -390, -283, -34, 191, 280, 187,
    -51, -263, -326, -199, 46, 287, 372, 256,
    10, -212, -305, -233, -11, 198, 277, 162,
    -60, -301, -395, -281, -57, 181, 301, 230,
    25, -198, -306, -211, 24, 250, 348, 267,
    25, -226, -346, -287, -85, 128, 253, 183,
    -24, -256, -361, -270, -63, 199, 343, 294,
    77, -156, -271, -231, -36, 182, 303, 242,
    29, -218, -374, -326, -121, 110, 255, 222,
    42, -178, -307, -262, -50, 191, 337, 312,
    127, -117, -284, -279, -105, 115, 252, 229,
    38, -209, -375, -343, -154, 94, 280, 269,
    105, -94, -259, -264, -72, 162, 321, 309,
    126, -124, -307, -327, -176, 44, 213, 223,
    62, -158, -331, -326, -157, 95, 287, 306,
    176, -49, -244, -266, -133, 94, 283, 283,
    114, -124, -305, -359, -234, 0, 193, 250,
    127, -93, -267, -298, -157, 88, 291, 347,
    208, -22, -227, -293, -183, 25, 211, 262,
    138, -92, -296, -348, -236, -10, 210, 288,
    205, 3, -209, -270, -164, 55, 260, 330,
    229, -11, -241, -332, -249, -43, 164, 247,
    153, -43, -262, -355, -237, -17, 211, 319,
    249, 44, -172, -265, -198, 1, 206, 294,
    206, -17, -249, -355, -301, -100, 134, 255,
    192, 1, -201, -312, -227, -15, 204, 331,
    281, 79, -155, -283, -248, -72, 143, 255,
    209, 0, -229, -348, -325, -127, 121, 275,
    261, 82, -133, -280, -246, -45, 188, 339,
    294, 90, -154, -320, -322, -144, 90, 225,
    209, 42, -191, -346, -316, -121, 127, 306,
    307, 139, -74, -250, -265, -91, 137, 286,
    271, 94, -163, -341, -358, -205, 44, 212,
    240, 103, -122, -293, -296, -112, 128, 309,
    333, 179, -50, -246, -296, -156, 51, 223,
    248, 87, -134, -328, -373, -221, 22, 229,
    284, 161, -49, -230, -265, -137, 89, 292,
    327, 190, -53, -273, -340, -225, -6, 177,
    240, 107, -103, -291, -341, -204, 22, 237,
    308, 218, 2, -205, -259, -162, 44, 234,
    281, 175, -49, -280, -374, -273, -52, 160,
    245, 155, -31, -232, -307, -201, 12, 240,
    340, 241, 26, -189, -288, -224, -37, 160,
    251, 166, -44, -258, -365, -301, -69, 152,
    266, 224, 30, -174, -279, -214, 1, 207,
    306, 248, 33, -190, -325, -280, -107, 99,
    227, 179, -2, -219, -342, -274, -78, 151,
    299, 266, 95, -129, -258, -229, -56, 162,
    277, 228, 43, -195, -352, -330, -152, 72,
    230, 209, 44, -149, -285, -264, -73, 150,
    302, 292, 127, -100, -274, -262, -121, 81,
    234, 219, 59, -169, -330, -336, -174, 64,
    233, 258, 119, -92, -238, -239, -93, 112,
    287, 301, 134, -92, -280, -326, -185, 23,
    187, 229, 78, -137, -301, -323, -173, 52,
    249, 301, 179, -27, -212, -269, -140, 82,
    239, 269, 140, -84, -283, -355, -242, -29,
    176, 240, 132, -71, -250, -283, -164, 63,
    251, 329, 224, 0, -195, -285, -206, 0,
    182, 237, 144, -58, -287, -360, -257, -39,
    182, 274, 192, 0, -188, -267, -188, 27,
    245, 313, 218, 2, -214, -312, -257, -62,
    134, 229, 162, -33, -234, -331, -250, -32,
    185, 304, 257, 76, -138, -250, -192, -20,
    176, 284, 216, 14, -204, -327, -289, -106,
    110, 231, 199, 34, -165, -278, -237, -42,
    182, 319, 282, 112, -114, -271, -248, -80,
    115, 238, 200, 16, -197, -328, -300, -132,
    88, 247, 237, 95, -106, -240, -223, -57,
    160, 288, 281, 107, -123, -283, -283, -143,
    58, 202, 202, 50, -160, -282, -279, -125,
    106, 278, 283, 144, -55, -213, -223, -96,
    101, 264, 247, 94, -111, -302, -316, -180,
    22, 197, 225, 106, -76, -237, -261, -111,
    105, 274, 306, 180, -37, -208, -263, -150,
    50, 201, 228, 102, -108, -275, -323, -216,
    8, 208, 264, 155, -32, -198, -241, -131,
    61, 239, 303, 191, -16, -212, -296, -215,
    -22, 148, 208, 121, -65, -243, -303, -202,
    1, 203, 288, 205, 21, -156, -241, -164,
    30, 202, 266, 168, -25, -222, -326, -258,
    -60, 132, 230, 171, -12, -202, -284, -210,
    0, 208, 306, 241, 46, -148, -261, -221,
    -48, 142, 238, 161, -14, -225, -328, -266,
    -98, 123, 254, 223, 61, -141, -251, -203,
    -20, 179, 290, 241, 60, -159, -295, -269,
    -116, 89, 209, 185, 14, -186, -304, -287,
    -94, 123, 273, 270, 110, -92, -237, -234,
    -76, 122, 252, 234, 59, -157, -311, -310,
    -166, 44, 196, 200, 66, -124, -255, -258,
    -105, 118, 271, 277, 135, -71, -243, -254,
    -136, 46, 202, 201, 61, -137, -305, -326,
    -184, 32, 214, 245, 133, -54, -219, -241,
    -115, 86, 257, 283, 139, -70, -253, -307,
    -197, 0, 162, 197, 86, -95, -256, -303,
    -183, 29, 218, 281, 177, -8, -186, -249,
    -153, 42, 204, 258, 153, -80, -254, -312,
    -236, -49, 136, 211, 134, -39, -220, -269,
    -167, 22, 228, 300, 218, 17, -183, -264,
    -200, -22, 152, 216, 128, -49, -244, -319,
    -250, -54, 145, 242, 187, 19, -157, -241,
    -168, 0, 188, 285, 216, 28, -177, -281,
    -245, -82, 105, 189, 146, -15, -202, -293,
    -237, -48, 152, 257, 225, 68, -115, -223,
    -189, -25, 149, 244, 193, 22, -173, -303,
    -279, -113, 83, 198, 178, 47, -142, -250,
    -212, -54, 141, 269, 260, 109, -98, -236,
    -219, -87, 80, 200, 186, 39, -152, -288,
    -290, -137, 77, 220, 214, 98, -73, -210,
    -208, -75, 130, 251, 240, 125, -89, -248,
    -265, -150, 36, 167, 181, 60, -121, -258,
    -268, -136, 65, 225, 254, 139, -40, -195,
    -218, -110, 66, 212, 228, 94, -99, -263,
    -307, -179, 1, 149, 200, 104, -71, -223,
    -249, -138, 56, 223, 266, 170, -17, -186,
    -246, -167, 5, 158, 206, 107, -75, -243,
    -307, -206, -11, 157, 230, 155, -7, -168,
    -227, -140, 29, 204, 262, 175, -10, -197,
    -274, -217, -48, 120, 196, 112, -53, -220,
    -287, -203, -23, 170, 252, 195, 30, -138,
    -220, -174, -8, 157, 239, 170, -11, -201,
    -295, -244, -90, 92, 203, 157, 3, -173,
    -252, -196, -29, 160, 261, 228, 64, -123,
    -243, -214, -68, 95, 202, 154, 0, -193,
    -303, -263, -104, 85, 208, 201, 57, -121,
    -225, -193, -55, 135, 258, 222, 75, -129,
    -260, -256, -128, 52, 169, 157, 26, -145,
    -268, -255, -112, 89, 241, 243, 110, -67,
    -199, -209, -92, 86, 214, 210, 70, -126,
    -281, -285, -164, 18, 166, 170, 67, -93,
    -234, -239, -107, 78, 229, 250, 135, -51,
    -203, -237, -128, 37, 161, 184, 72, -120,
    -271, -294, -179, 14, 161, 200, 120, -42,
    -191, -218, -118, 55, 211, 250, 146, -43,
    -208, -260, -188, -24, 137, 177, 85, -75,
    -240, -282, -184, 0, 176, 243, 173, 0,
    -169, -227, -153, 5, 179, 220, 125, -44,
    -231, -305, -227, -57, 115, 188, 127, -25,
    -191, -250, -166, 3, 181, 269, 189, 27,
    -155, -247, -191, -44, 126, 197, 122, -30,
    -214, -306, -236, -69, 114, 212, 169, 30,
    -143, -226, -171, -17, 161, 252, 205, 39,
    -146, -250, -230, -95, 80, 182, 134, -7,
    -186, -277, -230, -70, 117, 242, 220, 73,
    -95, -210, -180, -51, 110, 222, 187, 32,
    -141, -263, -264, -135, 56, 182, 171, 43,
    -122, -234, -209, -65, 116, 241, 235, 111,
    -73, -217, -217, -94, 64, 192, 180, 41,
    -137, -260, -269, -136, 46, 183, 215, 102,
    -66, -195, -201, -88, 89, 226, 240, 117,
    -80, -228, -261, -161, 18, 152, 168, 68,
    -100, -242, -257, -135, 52, 207, 251, 152,
    -21, -164, -206, -116, 53, 192, 225, 114,
    -59, -219, -284, -196, -15, 149, 195, 110,
    -50, -203, -235, -138, 38, 214, 268, 182,
    7, -165, -237, -159, -1, 134, 189, 119,
    -53, -226, -289, -221, -35, 138, 214, 158,
    2, -142, -210, -152, 13, 181, 248, 181,
    7, -164, -249, -215, -64, 99, 179, 122,
    -27, -193, -278, -214, -36, 149, 240, 199,
    52, -106, -204, -173, -22, 137, 221, 166,
    9, -170, -270, -240, -106, 66, 181, 153,
    15, -142, -227, -189, -42, 135, 246, 216,
    72, -102, -213, -198, -74, 79, 184, 161,
    11, -160, -263, -258, -115, 64, 182, 178,
    64, -89, -202, -179, -55, 105, 224, 206,
    76, -97, -223, -238, -134, 32, 152, 150,
    33, -128, -243, -237, -114, 60, 195, 215,
    106, -51, -178, -192, -84, 66, 183, 186,
    77, -89, -237, -262, -162, 1, 139, 165,
    68, -72, -197, -217, -105, 63, 199, 223,
    133, -30, -175, -215, -132, 17, 141, 169,
    75, -87, -233, -263, -170, -6, 140, 193,
    122, -32, -163, -199, -120, 42, 178, 216,
    136, -27, -184, -245, -180, -32, 111, 160,
    91, -55, -195, -249, -174, 0, 152, 208,
    156, 20, -129, -193, -144, -1, 147, 203,
    127, -21, -181, -259, -196, -59, 85, 167,
    114, -10, -147, -216, -163, -6, 149, 224,
    179, 42, -117, -206, -176, -44, 101, 167,
    130, -13, -177, -248, -216, -75, 82, 183,
    167, 40, -102, -189, -157, -27, 120, 219,
    190, 39, -123, -217, -210, -92, 50, 148,
    133, 14, -142, -238, -212, -83, 93, 195,
    194, 86, -79, -181, -170, -64, 83, 185,
    177, 44, -117, -241, -242, -121, 25, 139,
    151, 49, -91, -195, -188, -85, 80, 208,
    205, 101, -49, -175, -200, -109, 33, 150,
    164, 52, -114, -243, -255, -154, 9, 150,
    193, 106, -55, -170, -190, -94, 53, 186,
    213, 105, -46, -195, -237, -153, -10, 124,
    153, 64, -83, -214, -244, -153, 20, 164,
    209, 142, 0, -149, -195, -118, 17, 157,
    197, 107, -41, -191, -254, -190, -47, 97,
    171, 113, -34, -169, -218, -146, 17, 163,
    218, 163, 26, -138, -207, -152, -25, 122,
    177, 107, -32, -180, -254, -199, -42, 105,
    183, 143, 17, -116, -184, -135, 2, 149,
    212, 157, 19, -136, -216, -185, -75, 70,
    150, 110, -19, -157, -228, -187, -47, 106,
    198, 172, 47, -94, -182, -160, -35, 101,
    180, 143, 13, -136, -246, -221, -99, 47,
    150, 128, 24, -110, -202, -175, -55, 99,
    205, 197, 71, -83, -191, -189, -73, 57,
    151, 136, 17, -131, -227, -226, -118, 39,
    153, 162, 59, -69, -168, -176, -64, 81,
    185, 191, 74, -80, -201, -221, -124, 19,
    125, 134, 43, -100, -213, -221, -113, 46,
    172, 190, 102, -32, -148, -179, -90, 46,
    163, 174, 72, -73, -202, -238, -154, -4,
    118, 148, 75, -58, -176, -196, -102, 42,
    170, 208, 125, -20, -141, -195, -136, 5,
    116, 155, 74, -70, -195, -234, -166, -30,
    114, 184, 116, -14, -132, -182, -113, 16,
    147, 197, 133, 0, -154, -214, -171, -39,
    87, 148, 96, -45, -172, -219, -164, -22,
    127, 191, 153, 29, -112, -178, -139, -15,
    125, 185, 127, -7, -154, -233, -194, -69,
    68, 150, 123, 5, -128, -195, -162, -28,
    115, 200, 173, 46, -88, -179, -163, -54,
    76, 151, 112, 0, -143, -235, -205, -91,
    58, 162, 163, 58, -86, -171, -152, -43,
    99, 188, 173, 59, -90, -202, -197, -101,
    30, 133, 128, 18, -108, -206, -206, -87,
    61, 184, 189, 89, -40, -153, -164, -63,
    66, 166, 160, 55, -98, -213, -219, -134,
    10, 121, 140, 60, -69, -174, -181, -78,
    53, 177, 204, 105, -31, -152, -180, -109,
    20, 133, 149, 55, -79, -196, -222, -142,
    0, 130, 162, 92, -33, -141, -168, -89,
    42, 156, 193, 106, -32, -152, -205, -152,
    -22, 92, 130, 68, -57, -177, -208, -135,
    0, 134, 186, 119, 2, -120, -167, -109,
    5, 126, 170, 98, -37, -163, -220, -176,
    -46, 81, 137, 91, -11, -138, -197, -127,
    -1, 130, 194, 150, 19, -115, -178, -147,
    -30, 83, 137, 96, -28, -160, -222, -189,
    -53, 82, 151, 128, 15, -102, -167, -131,
    -20, 108, 183, 148, 24, -117, -197, -177,
    -72, 50, 132, 103, -4, -121, -198, -176,
    -51, 84, 168, 156, 53, -71, -158, -139,
    -38, 86, 161, 144, 33, -109, -208, -200,
    -99, 22, 127, 125, 33, -90, -180, -164,
    -59, 73, 185, 188, 76, -64, -166, -178,
    -89, 44, 131, 127, 27, -111, -214, -214,
    -117, 14, 128, 153, 70, -54, -156, -159,
    -79, 50, 167, 167, 77, -58, -179, -204,
    -127, -1, 106, 125, 39, -89, -194, -207,
    -117, 21, 141, 174, 109, -23, -138, -166,
    -96, 23, 130, 152, 74, -58, -186, -221,
    -153, -30, 94, 136, 78, -40, -155, -186,
    -119, 18, 142, 187, 128, 0, -124, -175,
    -131, -16, 98, 138, 80, -47, -176, -226,
    -167, -46, 88, 157, 106, -3, -118, -171,
    -118, 9, 124, 179, 130, 3, -124, -199,
    -164, -57, 58, 125, 85, -22, -144, -205,
    -168, -40, 90, 162, 150, 36, -91, -152,
    -133, -23, 96, 155, 127, 14, -123, -206,
    -185, -80, 49, 126, 117, 20, -104, -164,
    -143, -32, 99, 181, 168, 60, -71, -162,
    -145, -55, 54, 138, 123, 18, -111, -194,
    -181, -77, 45, 144, 144, 56, -61, -143,
    -129, -34, 84, 167, 162, 66, -64, -162,
    -166, -89, 23, 113, 121, 34, -83, -173,
    -179, -82, 53, 161, 184, 104, -25, -116,
    -120, -56, 50, 148, 155, 63, -62, -163,
    -181, -108, 11, 116, 135, 64, -46, -135,
    -137, -72, 44, 163, 184, 114, -2, -116,
    -144, -76, 29, 118, 140, 67, -46, -155,
    -179, -112, 2, 119, 161, 109, 0, -105,
    -134, -66, 46, 150, 179, 118, 1, -122,
    -163, -116, -11, 89, 127, 83, -18, -126,
    -169, -103, 13, 121, 180, 136, 28, -80,
    -132, -89, 14, 122, 167, 118, 3, -113,
    -168, -133, -29, 80, 141, 110, 7, -95,
    -143, -107, 0, 125, 194, 166, 53, -65,
    -127, -110, -17, 88, 142, 111, 14, -106,
    -170, -142, -42, 77, 148, 140, 51, -57,
    -113, -95, -9, 107, 181, 157, 49, -67,
    -141, -135, -47, 63, 133, 122, 32, -86,
    -156, -134, -35, 80, 156, 166, 92, -29,
    -116, -114, -30, 79, 156, 149, 60, -59,
    -148, -154, -77, 36, 130, 132, 59, -41,
    -127, -118, -39, 76, 167, 179, 107, -11,
    -107, -123, -58, 45, 126, 132, 62, -55,
    -146, -151, -85, 25, 133, 156, 93, -10,
    -94, -117, -61, 63, 153, 172, 109, -10,
    -114, -147, -96, 0, 98, 128, 67, -39,
    -132, -151, -89, 20, 130, 171, 117, 9,
    -86, -113, -71, 21, 114, 151, 94, -21,
    -128, -169, -126, -18, 87, 126, 84, -6,
    -102, -137, -83, 12, 122, 171, 123, 30,
    -82, -136, -100, -12, 83, 130, 88, -18,
    -127, -172, -133, -32, 69, 133, 113, 18,
    -79, -126, -90, 0, 109, 163, 123, 25,
    -94, -162, -135, -40, 54, 110, 87, -7,
    -112, -162, -133, -35, 81, 151, 135, 49,
    -56, -125, -110, -29, 82, 141, 113, 24,
    -90, -166, -158, -71, 34, 111, 105, 21,
    -81, -139, -123, -34, 78, 149, 145, 63,
    -54, -127, -127, -63, 41, 115, 106, 18,
    -88, -164, -170, -78, 35, 114, 122, 53,
    -49, -120, -122, -45, 57, 130, 139, 66,
    -48, -144, -159, -89, 7, 82, 103, 35,
    -76, -150, -158, -85, 27, 116, 137, 73,
    -26, -108, -125, -74, 29, 115, 118, 53,
    -51, -145, -174, -118, -8, 83, 103, 57,
    -38, -126, -139, -84, 23, 119, 146, 93,
    -5, -107, -144, -98, -5, 83, 112, 49,
    -46, -141, -181, -125, -19, 73, 120, 82,
    -9, -100, -136, -90, 2, 97, 143, 95,
    -13, -113, -158, -129, -43, 51, 93, 61,
    -29, -126, -167, -128, -18, 82, 130, 103,
    19, -83, -129, -98, -18, 74, 119, 88,
    -8, -117, -176, -151, -63, 37, 93, 74,
    -6, -101, -147, -118, -27, 71, 138, 118,
    28, -76, -137, -121, -46, 40, 100, 80,
    -5, -108, -176, -157, -71, 31, 111, 100,
    23, -68, -128, -122, -42, 61, 123, 118,
    39, -78, -156, -152, -83, 15, 85, 83,
    8, -90, -151, -155, -77, 32, 107, 122,
    56, -42, -117, -125, -65, 36, 108, 105,
    31, -75, -154, -168, -104, -4, 74, 88,
    33, -54, -138, -141, -71, 23, 113, 130,
    70, -26, -118, -143, -83, 0, 77, 90,
    30, -61, -151, -168, -112, -15, 74, 107,
    60, -31, -110, -122, -75, 15, 98, 131,
    73, -29, -125, -157, -109, -20, 63, 86,
    40, -47, -126, -145, -100, -9, 80, 119,
    81, 0, -90, -123, -81, -3, 76, 109,
    66, -22, -113, -160, -130, -42, 50, 94,
    63, -15, -101, -132, -98, -10, 84, 127,
    99, 11, -85, -128, -103, -23, 49, 92,
    64, -19, -113, -161, -134, -51, 43, 101,
    82, 9, -73, -124, -101, -16, 65, 115,
    96, 9, -83, -144, -132, -60, 23, 75,
    64, -9, -102, -151, -135, -49, 48, 111,
    102, 30, -51, -110, -109, -40, 40, 97,
    87, 9, -82, -146, -142, -73, 16, 78,
    78, 19, -70, -127, -124, -52, 42, 111,
    113, 44, -42, -117, -120, -64, 16, 77,
    81, 20, -74, -142, -146, -86, 5, 79,
    92, 39, -41, -102, -113, -59, 28, 99,
    114, 54, -43, -118, -138, -92, -5, 62,
    71, 25, -53, -128, -137, -80, 7, 79,
    105, 66, -15, -89, -111, -67, 5, 72,
    92, 41, -41, -117, -143, -104, -27, 46,
    73, 40, -29, -97, -119, -78, 0, 75,
    107, 74, -3, -86, -118, -89, -21, 46,
    78, 43, -34, -112, -142, -110, -36, 50,
    89, 59, -4, -76, -111, -79, -4, 70,
    101, 74, 0, -84, -127, -107, -42, 26,
    65, 47, -18, -92, -126, -102, -34, 44,
    92, 77, 18, -52, -101, -89, -23, 42,
    78, 66, 0, -76, -125, -119, -57, 12,
    60, 54, -2, -63, -103, -90, -33, 39,
    93, 80, 21, -47, -93, -91, -43, 17,
    61, 53, 0, -73, -116, -106, -56, 9,
    63, 63, 20, -40, -86, -84, -34, 30,
    77, 76, 23, -43, -94, -102, -58, 1,
    46, 46, 6, -52, -98, -98, -50, 14,
    68, 75, 34, -21, -69, -75, -40, 16,
    59, 61, 20, -39, -88, -100, -59, -6,
    39, 56, 22, -28, -74, -83, -48, 11,
    57, 72, 44, -12, -66, -82, -55, -3,
    41, 52, 19, -33, -79, -91, -62, -11,
    37, 60, 34, -11, -55, -69, -45, 2,
    49, 66, 40, -10, -62, -78, -59, -16,
    27, 43, 22, -16, -62, -83, -56, -8,
    34, 58, 44, 0, -43, -63, -48, -3,
    35, 52, 33, -8, -57, -82, -64, -23,
    16, 43, 32, -5, -45, -66, -52, -7,
    34, 57, 47, 8, -32, -59, -51, -15,
    21, 42, 32, -1, -46, -70, -59, -24,
    17, 45, 41, 8, -29, -50, -44, -12,
    27, 50, 43, 11, -30, -56, -52, -27,
    10, 35, 30, 1, -33, -57, -51, -21,
    15, 40, 41, 17, -16, -42, -42, -17,
    13, 37, 35, 8, -28, -53, -54, -31,
    1, 25, 32, 9, -22, -43, -41, -21,
    9, 37, 42, 20, -10, -34, -40, -24,
    0, 26, 28, 6, -20, -43, -49, -33,
    0, 26, 32, 15, -8, -30, -34, -18,
    8, 30, 35, 18, -8, -33, -39, -27,
    -2, 16, 21, 10, -12, -33, -39, -24,
    0, 22, 31, 19, 0, -21, -29, -19,
    0, 20, 27, 16, -5, -28, -35, -27,
    -6, 11, 19, 11, -4, -22, -27, -19,
    0, 17, 25, 18, 1, -15, -26, -20,
    -3, 10, 17, 10, -4, -20, -28, -22,
    -6, 7, 16, 12, 0, -12, -20, -15,
    0, 11, 18, 13, 0, -11, -21, -18,
    -5, 4, 10, 8, 0, -12, -19, -16,
    -5, 5, 13, 11, 2, -6, -12, -11,
    -3, 5, 10, 8, 0, -8, -14, -13,
    -6, 0, 6, 6, 0, -6, -10, -9,
    -2, 3, 8, 7, 2, -2, -7, -6,
    -2, 0, 4, 3, 0, -2, -4, -4,
    -1, 0, 2, 2, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0,
    0, 0,
};


static const short CLICK_3_NORMAL_SAMPLES[] = {
    4, -33, -17, -80, -157, -254, -270, -268,
    -370, -428, -455, -353, -133, -8, 170, 359,
    539, 549, 523, 448, 294, 294, 233, 0,
    -114, 759, 1982, 2863, 2423, 2927, 2717, -3,
    -4227, -6673, -6816, -5324, -2121, 4383, 12126, 11516,
    11501, 10546, 2965, -9509, -17660, -18320, -13451, -12627,
    -4748, 14578, 29940, 27845, 16375, 14388, 5734, -3602,
    -13015, -29642, -31105, -23175, -13862, -2942, 14811, 29923,
    30076, 26135, 23308, 18505, 3769, -13394, -23961, -24462,
    -25854, -23763, -20228, -21709, -23427, -21316, -12442, -3589,
    7040, 11179, 5070, 5429, 2310, -8249, -18108, -20785,
    -16982, -13778, -16349, -14103, -3220, 6470, 13405, 4581,
    -9240, -5242, 10380, 25984, 31716, 32767, 23063, 10856,
    5309, -1143, -6792, -7529, 2277, 6454, 8255, 14061,
    8886, 8389, 6703, -4749, -19700, -17935, -274, 7514,
    12648, 16900, 21146, 19071, 12122, -1848, -21119, -27418,
    -22040, -13155, -7812, 3940, 18553, 26187, 24453, 17830,
    9477, -2548, -11686, -17565, -19784, -14750, -13704, -14207,
    -9113, -6003, -2711, -73, 2589, 3981, 6677, 7425,
    -3271, -10006, -7965, -3793, -12016, -19923, -18386, -14865,
    -5045, 4245, 9922, 14140, 10835, -143, -11086, -9460,
    -3514, -2506, -5894, -1999, 6559, 11347, 12600, 12950,
    13508, 13245, 7283, 4792, 7891, 7458, 4371, 2454,
    4262, 2103, 1146, 1283, 379, -5004, -8923, -8976,
    -9939, -7483, -1435, 3808, -595, -4777, -1927, 3080,
    2138, -5711, -12469, -9237, -3559, 865, 5676, 10920,
    15650, 17504, 15985, 12294, 8184, 4578, 3041, 2797,
    4671, 9033, 12930, 14029, 11489, 6643, 633, -4030,
    -6198, -7770, -6196, -2810, -675, 134, 553, 147,
    -2369, -7220, -11807, -14066, -13992, -13415, -11804, -6934,
    -2423, 4644, 13508, 17682, 14773, 6512, -1730, -1732,
    -943, -1887, -285, 498, 1379, 1700, -328, -3344,
    -5979, -6842, -6568, -4886, -3774, -5091, 305, 7848,
    10152, 8530, 1583, -4674, -6661, -9105, -14653, -19096,
    -13906, -4629, 5887, 11203, 1195, -8555, -8715, -1463,
    11516, 17547, 13602, 7601, 5313, 6944, 9332, 10600,
    8449, 3799, 1503, 3398, 11231, 18595, 14623, 8762,
    3444, -1747, -4704, -6257, -6736, -7524, -6893, -7295,
    -8448, -5005, -4412, -5796, -6639, -12524, -15286, -12155,
    -8466, -3706, -3487, -7387, -6184, -5397, -4352, -1804,
    -281, -4127, -10219, -8848, -3279, 7123, 17579, 17843,
    11245, 2492, -4613, -5341, -4751, -6356, -7251, -6529,
    -3228, 362, -1107, -1775, -446, 365, -1331, -2846,
    -3343, -3847, -3610, -420, 2591, 473, -6835, -7889,
    3334, 14260, 13481, 4761, 3295, 4422, 4920, 4006,
    6507, 6380, 3832, 4804, 5292, 5363, 3988, -2326,
    -2297, 611, -805, -1005, 3486, 10724, 12588, 4313,
    -7384, -11785, -3713, 1814, 1531, 1435, 2446, 2092,
    -547, -3255, -2817, -3831, -8332, -10305, -6069, 691,
    3375, 5024, 3048, -739, -1326, 4136, 11817, 15429,
    10784, 6051, 4041, 2055, -517, -2230, -2817, -4952,
    -7438, -8832, -8309, -7876, -6070, -3465, -2132, -3586,
    -6513, -9077, -11310, -12003, -12096, -11998, -8520, -2780,
    3312, 7990, 4037, -1403, -1884, 1428, 879, -1962,
    -493, 1539, 7522, 13890, 14231, 13526, 11500, 8247,
    7803, 7701, 9108, 12261, 16898, 15455, 9021, 6274,
    4484, 3351, 3020, 2341, 907, -3036, -9886, -11241,
    -11241, -11755, -9385, -3917, 1999, 4127, 4041, -781,
    -5665, -5535, -2318, 1035, 3919, 9717, 11579, 10620,
    8988, 4625, -1254, -5315, -5021, -2927, -381, 3039,
    7049, 12109, 11807, 3228, -7772, -12711, -11596, -10478,
    -10345, -9120, -5888, -4939, -3820, -3032, -3476, -4124,
    -4843, -5937, -7807, -9177, -10077, -10222, -10020, -7380,
    -4351, -3278, -2431, -1279, -1240, -4297, -6586, -6137,
    -3040, 1932, 5716, 8394, 11037, 12342, 9437, 3312,
    -1127, 76, 4055, 5743, 2761, 1299, 2487, 2685,
    607, -1432, -2317, -4586, -6795, -8077, -7333, -5665,
    -3104, -755, 903, 2455, 4466, 5336, 2564, 415,
    -143, -438, -1344, -981, 1834, 5343, 7434, 8020,
    9198, 12382, 14013, 12177, 9040, 6864, 7098, 8161,
    7754, 8640, 9880, 9436, 6528, 1899, -2453, -5458,
    -6259, -7273, -9113, -10485, -9324, -7441, -6912, -6319,
    -4905, -2952, -2082, -2333, -3052, -2469, 161, 2724,
    4398, 5454, 6763, 5595, 2002, -1302, -1223, -605,
    -1559, -2692, -1724, 258, 837, 1180, 35, -2527,
    -5398, -7800, -8735, -8518, -8855, -7699, -5089, -2069,
    1534, 3600, 3290, 1118, -111, -731, -1766, -2553,
    -3333, -3745, -3559, -2449, -877, 671, 1930, 2223,
    1831, 1182, 379, 161, 663, 2173, 3957, 6440,
    8482, 7904, 7042, 5914, 3455, -36, -4079, -6342,
    -5302, -1959, 679, 1532, 2117, 2516, 2849, 2727,
    1735, -447, -3180, -4981, -5148, -3031, 117, 2375,
    2945, 2858, 3477, 4189, 4562, 4050, 2654, 346,
    -1331, -1512, -435, 16, 239, 1219, 2023, 2316,
    2525, 3525, 4108, 4329, 4312, 4041, 3517, 3020,
    2290, 637, -757, -767, 787, 437, -1086, -1831,
    -2096, -2313, -3330, -5263, -7100, -8595, -9628, -9542,
    -8526, -7246, -6254, -5256, -4758, -3946, -2289, -1087,
    -943, -1642, -2117, -2248, -1951, -1178, -1215, -525,
    461, 413, 1142, 2285, 3076, 2759, 1991, 1179,
    663, 1030, 2089, 3311, 3967, 3849, 3356, 3246,
    3519, 4041, 3912, 2734, 1151, -26, -1215, -3217,
    -4434, -4271, -3151, -2217, -769, 761, 1659, 2672,
    4143, 5791, 6662, 7296, 7149, 6426, 6091, 6228,
    5865, 4642, 4351, 4787, 4865, 3740, 2117, 929,
    302, -863, -1771, -2103, -2159, -2190, -2138, -2284,
    -3133, -3512, -3190, -2852, -3137, -4626, -6109, -6238,
    -5996, -5328, -3997, -2263, -1335, -1735, -2578, -3132,
    -2844, -2879, -4145, -4894, -3866, -1488, 357, 2394,
    4312, 5149, 4963, 3554, 1606, 165, -571, -745,
    -370, 977, 2446, 3396, 3713, 2656, 1250, 329,
    -380, -507, -243, 376, 1922, 3445, 4222, 4133,
    2293, 253, -995, -1920, -1876, -671, 1338, 2898,
    3986, 4239, 3377, 2374, 1368, 360, -309, -591,
    121, 1728, 3060, 3844, 3965, 3604, 2351, 909,
    -133, -899, -1556, -1810, -1135, 341, 2128, 3257,
    3232, 1971, 297, -1411, -3313, -4986, -5594, -4753,
    -3173, -1867, -1264, -1171, -1747, -2408, -2452, -1450,
    118, 1443, 2043, 1295, 787, 845, 685, -312,
    -1090, -673, -480, -3, 282, 179, -295, 35,
    1138, 1374, 465, -152, 293, 677, 807, 535,
    -17, -995, -2168, -2983, -3060, -1766, -271, 117,
    -457, -1210, -1496, -1178, -799, -453, 55, 310,
    1035, 2028, 2866, 3290, 3613, 3373, 1896, -549,
    -2044, -1731, -783, -201, 145, 961, 1554, 1748,
    1438, 719, -136, -987, -1867, -2797, -3055, -2215,
    -637, 1046, 1828, 1343, 194, -1475, -2925, -3415,
    -3327, -2350, -865, 349, 789, 1454, 2662, 3356,
    3194, 2175, 735, -50, -1202, -2344, -1931, -673,
    849, 1870, 2337, 1792, 1051, 945, -14, -787,
    -1235, -1923, -2070, -1663, -835, 184, 1648, 3180,
    3718, 2391, 19, -2023, -2729, -3132, -2789, -1144,
    589, 2767, 4306, 4427, 3786, 3111, 2349, 771,
    -276, -587, -265, 1013, 2340, 3318, 3857, 4014,
    3144, 1280, -529, -1768, -2168, -1875, -1202, -499,
    277, 883, 1064, 399, -839, -2007, -2642, -3136,
    -3679, -2873, -1576, -31, 1700, 3079, 3264, 2015,
    787, -475, -1231, -1148, -863, -281, 743, 1807,
    2640, 2852, 2335, 1632, 877, -6, -903, -789,
    -179, 434, 975, 581, -144, -350, -292, -251,
    -783, -1982, -2676, -2940, -3246, -3600, -3120, -1779,
    -260, 1231, 1223, 352, 109, 396, 903, 1102,
    1103, 1340, 1891, 2529, 2983, 3630, 4024, 3583,
    1987, 531, 137, 365, 420, 565, 1252, 1707,
    1394, 619, -23, -453, -849, -1299, -1306, -899,
    -157, 875, 1963, 2534, 2365, 1351, -48, -1320,
    -2159, -2314, -2050, -1248, 85, 1960, 3143, 3060,
    2169, 993, -133, -833, -611, 107, 459, -23,
    -553, -395, 581, 1526, 1511, 707, -287, -943,
    -1415, -1820, -1843, -1794, -1692, -1867, -2709, -3479,
    -3534, -3026, -2704, -2662, -2562, -1860, -391, 1299,
    2584, 3166, 3037, 2189, 1003, 0, -1, 539,
    779, 1082, 1755, 3033, 4261, 4447, 3533, 2153,
    923, -84, -687, -627, 137, 891, 1064, 891,
    498, 129, -97, -453, -441, -215, -378, -1354,
    -1982, -1367, -428, 120, -4, -417, -783, -1055,
    -1439, -1707, -1426, -329, 1147, 1907, 2240, 2652,
    3151, 3152, 2368, 1099, -201, -745, -999, -1256,
    -1095, -320, 385, 137, -260, -605, -855, -1063,
    -1355, -1655, -1716, -1159, -130, 1103, 1947, 2353,
    1594, 134, -673, -34, 945, 751, 713, 737,
    1071, 1679, 2373, 2214, 925, -1, -725, -995,
    -635, 344, 1410, 2376, 3408, 3570, 2681, 1211,
    -15, -627, -927, -1243, -1466, -1487, -1295, -1175,
    -1496, -2309, -3061, -2967, -2285, -1707, -1511, -1302,
    -699, 399, 1382, 2220, 2602, 2249, 1532, 883,
    539, 495, 803, 1296, 1503, 919, 337, -37,
    -191, -353, -114, 129, -551, -1726, -2398, -2098,
    -1388, -1176, -1488, -1835, -1367, -1312, -1447, -593,
    -106, -555, -1824, -2408, -2541, -2401, -1892, -1470,
    -869, -303, -179, -659, -1271, -1319, -689, 230,
    1071, 1658, 1895, 2189, 2293, 1803, 1001, 390,
    38, -270, -653, -621, 120, 977, 1448, 1314,
    861, 589, 272, -160, -563, -127, 663, 757,
    793, 1571, 2759, 3142, 2810, 2050, 1411, 761,
    699, 953, 1060, 1376, 2077, 2689, 2117, 1031,
    597, 1115, 1291, 861, 293, 26, 393, 1228,
    1906, 1831, 1707, 1375, 753, 289, 639, 1363,
    1247, 384, -557, -947, -901, -545, -89, 321,
    603, 335, -480, -1182, -1163, -685, -482, -827,
    -1210, -1199, -941, -1096, -1496, -1791, -2042, -1811,
    -1419, -1163, -947, -298, 472, 523, -227, -1075,
    -1742, -2359, -2674, -2264, -1108, -361, -158, -169,
    -154, -284, -685, -1371, -1812, -2116, -2300, -1992,
    -1343, -575, 107, 500, 324, -428, -1222, -1274,
    -709, -80, 291, 481, 663, 887, 1104, 1723,
    2474, 2648, 1738, 845, 671, 839, 777, 681,
    991, 1598, 1787, 1707, 1819, 2089, 2286, 2080,
    1572, 949, 589, 443, 374, -37, -340, -103,
    190, 352, 409, 615, -73, -1013, -1276, -941,
    -474, -67, 399, 615, 651, 437, 0, -190,
    -72, 79, -177, -202, 308, 1071, 1731, 2212,
    2239, 1454, 205, -673, -953, -1210, -1155, -837,
    -317, -271, -307, -318, -681, -1062, -1279, -1238,
    -1383, -1559, -1623, -1558, -1131, -713, -381, -150,
    -274, -871, -1755, -1791, -1175, -185, 933, 1663,
    1810, 1694, 1906, 1919, 1671, 1315, 1152, 799,
    234, -84, -132, 48, 110, -84, -613, -877,
    -621, -611, -691, -719, -763, -587, -249, 118,
    445, 583, 401, 4, -631, -895, -681, -513,
    -183, 370, 1111, 1454, 1624, 1888, 2092, 2287,
    2113, 1728, 1580, 2040, 2543, 2439, 1715, 1211,
    1232, 1128, 781, 494, 667, 1175, 1455, 1211,
    625, 118, -409, -1003, -1514, -1766, -1619, -1432,
    -1411, -1584, -1679, -1371, -1039, -711, -348, -119,
    76, -97, -705, -1388, -1432, -943, -449, -17,
    413, 729, 659, 360, 2, -331, -951, -1251,
    -1166, -957, -1021, -749, -141, 38, -317, -695,
    -681, -563, -563, -409, 165, 765, 771, 227,
    -20, -163, -191, -89, 13, 37, -69, -249,
    -411, -282, 179, 591, 853, 599, 26, -202,
    -8, 322, 384, 286, 321, 462, 395, 49,
    -157, 139, 663, 919, 687, 366, 329, 498,
    585, 308, 41, 0, -44, -317, -739, -985,
    -717, -111, 407, 685, 949, 1019, 1120, 1500,
    1903, 2214, 1994, 1286, 412, -28, -4, -187,
    -278, 30, 765, 1423, 1627, 1330, 793, 291,
    -73, -254, -227, -86, 117, 321, 451, 487,
    327, 38, -229, -424, -453, -617, -935, -1248,
    -1347, -839, 129, 945, 969, 525, 401, 787,
    1216, 1335, 1434, 1784, 2164, 2353, 2169, 1868,
    1511, 1115, 673, 190, -350, -789, -893, -1046,
    -1258, -1352, -1168, -983, -1001, -1155, -1135, -687,
    -61, 418, 655, 707, 629, 299, -227, -729,
    -1027, -711, -182, 220, 625, 737, 478, 110,
    -39, 76, 311, 483, 368, 183, 140, -42,
    -204, -377, -695, -907, -825, -468, -55, 223,
    101, -375, -753, -991, -1095, -1080, -1106, -1132,
    -1015, -707, -39, 761, 1123, 919, 169, -406,
    -342, 344, 707, 327, -103, -891, -1716, -2117,
    -1719, -885, -146, 297, 669, 817, 823, 845,
    979, 1035, 875, 889, 989, 1152, 1415, 1766,
    2294, 2662, 2271, 1087, -271, -1199, -1576, -1371,
    -803, -78, 681, 1207, 1368, 1296, 1231, 1067,
    691, 359, 82, -48, 99, 486, 1087, 1619,
    1806, 1803, 1492, 1007, 338, -105, -216, -314,
    -202, 35, 275, 413, 384, 300, 245, 190,
    -23, -293, -273, 81, 515, 795, 1032, 961,
    539, -34, -651, -1127, -1259, -919, -480, -92,
    359, 687, 1050, 1307, 1207, 983, 793, 545,
    242, -95, -122, 341, 967, 1098, 813, 689,
    641, 511, 101, -450, -989, -1311, -1356, -1292,
    -1027, -679, -392, -53, 96, -45, -207, -66,
    239, 370, 24, -417, -667, -741, -781, -717,
    -486, -391, -525, -659, -537, -252, -69, -18,
    -17, 35, -26, -435, -863, -783, -323, 76,
    461, 695, 641, 313, 114, 52, 103, 132,
    165, 106, -130, -405, -595, -475, -174, 228,
    391, 136, -215, -455, -567, -579, -420, -100,
    189, 121, -44, -201, -388, -587, -701, -665,
    -579, -523, -457, -422, -453, -637, -825, -797,
    -589, -420, -212, 261, 829, 1302, 1575, 1690,
    1534, 981, 66, -659, -923, -757, -267, 300,
    715, 859, 685, 388, 114, -213, -647, -899,
    -797, -474, -121, 109, 247, 341, 307, 165,
    -8, -9, -48, -223, -397, -353, -216, -281,
    -252, -176, -199, -303, -80, 173, 161, -62,
    -182, -155, -230, -549, -783, -795, -727, -627,
    -370, 55, 300, 212, -108, -486, -849, -1103,
    -1150, -977, -499, 132, 697, 1156, 1456, 1475,
    1172, 767, 494, 355, 313, 495, 795, 1180,
    1403, 1539, 1622, 1396, 719, -89, -703, -1062,
    -1114, -887, -326, 340, 1059, 1391, 1171, 827,
    687, 621, 184, -190, -179, 159, 587, 793,
    951, 1174, 1035, 585, 11, -278, -198, 131,
    465, 565, 435, 308, 370, 440, 545, 669,
    595, 409, 343, 579, 1068, 1456, 1387, 859,
    437, 212, 18, -183, -251, -183, -26, -141,
    -417, -563, -603, -659, -863, -1098, -1232, -1021,
    -649, -355, -300, -331, -234, -187, -366, -721,
    -1039, -1290, -1427, -1399, -1215, -871, -535, -248,
    -56, 136, 363, 529, 424, 236, 219, 382,
    579, 681, 617, 234, -86, -174, -204, -300,
    -351, -355, -232, 62, 462, 901, 1136, 941,
    505, 148, 85, 255, 340, 178, 195, 476,
    685, 537, 219, -26, -182, -342, -643, -921,
    -889, -657, -301, -106, -204, -315, -325, -339,
    -464, -541, -485, -301, -287, -479, -569, -256,
    242, 549, 537, 409, 360, 338, 366, 424,
    661, 987, 1119, 893, 533, 407, 271, 57,
    -171, -155, 11, 184, 315, 324, 299, 129,
    -229, -655, -889, -871, -921, -1179, -1264, -1039,
    -863, -857, -1070, -1186, -1031, -597, -187, -141,
    -95, -9, 112, 54, -64, 15, 76, 162,
    206, 222, 355, 569, 681, 603, 486, 343,
    140, 106, 186, 278, 374, 256, 43, -130,
    -295, -311, -395, -577, -621, -477, -121, 231,
    335, 178, -81, -224, -235, -230, -224, -292,
    -267, -146, -78, 48, 131, 71, -75, -138,
    -108, -59, -169, -218, -182, -180, -221, -257,
    -289, -413, -559, -571, -427, -345, -373, -496,
    -655, -811, -943, -1054, -1063, -981, -849, -681,
    -565, -243, 211, 486, 415, 63, -331, -567,
    -711, -855, -907, -803, -422, 106, 597, 859,
    741, 388, 60, -370, -731, -729, -444, -78,
    167, 277, 357, 407, 429, 395, 286, 74,
    -127, -161, 19, 266, 439, 603, 715, 699,
    423, 109, -31, 79, 302, 434, 429, 349,
    457, 669, 779, 609, 456, 338, 49, -271,
    -531, -707, -795, -811, -807, -755, -705, -605,
    -444, -306, -389, -655, -921, -953, -709, -383,
    -188, -229, -435, -673, -743, -713, -611, -439,
    -405, -169, 85, 118, -18, -61, 8, -100,
    -334, -553, -633, -490, -339, -235, -106, -92,
    13, 216, 253, 139, -117, -525, -1003, -1239,
    -1203, -1111, -945, -817, -807, -899, -799, -504,
    -176, 153, 468, 579, 451, 294, 158, 170,
    355, 465, 432, 379, 242, 267, 461, 549,
    472, 211, -70, -209, -169, -55, 59, 181,
    195, 11, -249, -446, -455, -329, -389, -356,
    -221, -39, 76, 99, 62, -4, -83, -67,
    81, 142, 158, 85, -106, -290, -340, -355,
    -436, -369, -212, -20, 57, -18, -166, -290,
    -373, -430, -480, -651, -593, -395, -296, -229,
    -150, -138, -312, -657, -819, -681, -502, -391,
    -361, -306, -303, -386, -468, -519, -430, -265,
    -165, -91, 10, 125, 158, 87, -88, -348,
    -673, -995, -1142, -1094, -945, -705, -430, -215,
    -260, -399, -490, -569, -769, -941, -871, -571,
    -315, -238, -176, -67, -37, -188, -477, -707,
    -731, -637, -521, -479, -446, -314, -157, -168,
    -309, -472, -593, -569, -413, -168, 120, 371,
    385, 239, -36, -333, -472, -402, -183, -36,
    131, 261, 324, 352, 291, 158, -58, -318,
    -589, -631, -389, 82, 495, 633, 675, 603,
    393, 73, -207, -472, -579, -452, -128, 200,
    426, 533, 492, 275, -105, -336, -438, -342,
    -77, 291, 623, 729, 567, 315, 26, -259,
    -417, -496, -521, -461, -273, -102, -102, -265,
    -402, -505, -587, -693, -679, -555, -501, -395,
    -348, -326, -293, -325, -317, -289, -312, -400,
    -523, -565, -575, -555, -479, -417, -359, -285,
    -251, -326, -406, -515, -737, -937, -929, -805,
    -703, -597, -494, -322, -180, -163, -292, -531,
    -721, -753, -705, -641, -573, -521, -438, -391,
    -388, -381, -267, -132, -58, -33, -130, -229,
    -342, -523, -593, -653, -715, -711, -629, -515,
    -430, -377, -267, -122, -77, -183, -419, -637,
    -703, -563, -369, -260, -268, -314, -314, -290,
    -328, -311, -174, 71, 189, 159, 110, 90,
    57, -36, -42, -103, -119, -70, -132, -168,
    -224, -293, -243, -213, -274, -358, -468, -527,
    -496, -339, -207, -139, -11, -40, -106, -174,
    -212, -119, -1, 37, -110, -243, -267, -300,
    -413, -508, -639, -725, -753, -693, -450, -226,
    -75, -84, -234, -446, -633, -687, -703, -631,
    -563, -517, -331, -147, -59, -103, -215, -362,
    -469, -408, -289, -127, 15, 93, 145, 87,
    -66, -202, -240, -248, -314, -290, -97, 219,
    406, 467, 398, 164, -108, -262, -289, -243,
    -226, -282, -287, -193, -75, 24, 48, -45,
    -260, -414, -395, -282, -105, 40, 120, 145,
    148, 98, 73, 46, -69, -306, -381, -193,
    19, 103, 46, -53, -103, -177, -293, -409,
    -442, -464, -491, -471, -414, -270, -105, 0,
    8, -92, -219, -194, -111, -77, -146, -246,
    -224, -177, -139, -67, -20, -53, -144, -194,
    -202, -202, -188, -119, -51, -9, -37, -103,
    -119, -141, -201, -259, -334, -424, -388, -292,
    -263, -344, -490, -519, -457, -435, -453, -417,
    -318, -202, -116, -99, -83, -62, -70, -40,
    13, 35, -12, -64, -100, -149, -187, -201,
    -180, -95, -108, -227, -329, -347, -307, -323,
    -329, -290, -307, -372, -435, -422, -413, -422,
    -463, -510, -515, -513, -533, -543, -504, -585,
    -691, -737, -775, -657, -504, -397, -334, -265,
    -160, -141, -165, -124, -92, -73, 82, 236,
    326, 296, 212, 161, 63, -61, -121, -89,
    -12, 33, 29, -64, -246, -345, -373, -369,
    -356, -276, -171, -64, 37, 0, -138, -257,
    -331, -333, -281, -271, -229, -141, -39, -1,
    -56, -94, -165, -163, -125, -100, -11, 35,
    66, 134, 225, 217, 93, 0, -37, -81,
    -113, -165, -224, -259, -304, -337, -381, -391,
    -380, -325, -232, -163, -157, -144, -103, -61,
    18, 44, -18, -174, -290, -307, -315, -380,
    -409, -413, -420, -482, -571, -615, -539, -477,
    -549, -627, -695, -731, -719, -659, -589, -507,
    -449, -435, -386, -377, -384, -362, -377, -362,
    -300, -267, -245, -221, -199, -235, -245, -204,
    -238, -240, -229, -191, -53, 29, 88, 150,
    190, 164, 70, 52, 48, 35, 10, 2,
    55, 84, 48, 2, -34, -45, -66, -80,
    -89, -92, -86, -88, -17, 18, 19, 60,
    107, 123, 107, 123, 153, 184, 194, 154,
    176, 228, 275, 299, 318, 260, 148, 59,
    48, 90, 87, 59, 55, 110, 178, 242,
    299, 313, 225, 131, 54, -1, -18, 7,
    -3, -100, -193, -234, -252, -230, -166, -205,
    -227, -245, -263, -229, -190, -256, -306, -326,
    -311, -285, -339, -287, -234, -187, -150, -168,
    -240, -267, -246, -235, -256, -213, -185, -226,
    -205, -187, -169, -100, -69, -66, -59, -44,
    -22, -45, -12, 0, -56, -102, -143, -172,
    -125, -84, -89, -73, -44, -28, -34, -72,
    -138, -168, -190, -201, -121, -22, 49, 126,
    170, 106, -6, -83, -117, -161, -171, -161,
    -144, -113, -121, -135, -143, -158, -230, -304,
    -373, -373, -295, -198, -108, -70, -40, 22,
    43, 18, -51, -83, -56, -29, -17, -23,
    -12, -29, -28, -6, 0, -6, -33, -149,
    -179, -158, -172, -108, -36, -15, 18, 13,
    -48, -92, -99, -125, -193, -227, -221, -226,
    -212, -183, -177, -149, -128, -124, -138, -121,
    -51, 5, 40, 52, 68, 49, 33, 15,
    -8, -29, -89, -108, -127, -88, -44, -3,
    18, -9, -31, -77, -88, -117, -191, -147,
    -99, -78, -15, 13, 59, 104, 88, 54,
    37, 29, 4, -4, 0, 8, -8, -9,
    10, 30, 30, 11, 51, 63, 98, 131,
    109, 70, 48, 68, 41, 4, -17, -22,
    -1, -3, 0, 0,
};


const AudioChunkStaticFloat CLICK_1_EMPHASIS_DATA(CLICK_1_EMPHASIS_SAMPLES, 48000);
const AudioChunkStaticFloat CLICK_1_NORMAL_DATA(CLICK_1_NORMAL_SAMPLES, 48000);

const AudioChunkStaticFloat CLICK_2_EMPHASIS_DATA(CLICK_2_EMPHASIS_SAMPLES, 44100, 0.8f);
const AudioChunkStaticFloat CLICK_2_NORMAL_DATA(CLICK_2_NORMAL_SAMPLES, 44100, 0.8f);

const AudioChunkStaticInt16 CLICK_3_EMPHASIS_DATA(CLICK_3_EMPHASIS_SAMPLES, 44100, 0.3f);
const AudioChunkStaticInt16 CLICK_3_NORMAL_DATA(CLICK_3_NORMAL_SAMPLES, 44100, 0.3f);
