/***************************************************************************
 * accidentals.h: definition of Accidentals class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef ACCIDENTALS_H
#define ACCIDENTALS_H

#include <header.h>

/*!
	class Accidentals -- given note pitch, handle all accidentals
	
	use as follows:
	setKeySig()
	foreach measure
	resetToKeySig()
	foreach chord in measure:
		- startChord()
		- foreach note in chord:
		- addPitch()
		- calcChord()
		- foreach note in chord:
		- getNote()
	
	Note: two opinions about accidental handling can be found:
	- accidentals apply to a single octave
	- accidentals apply to all octaves
	Class Accidentals assumes accidentals apply to all octaves
*/
class Accidentals
{
public:
	/*!
		I DON'T KNOW
	*/
	enum Accid { None, Natural, Sharp, Flat };
	
	/*!
		I DON'T KNOW
	*/
	Accidentals();
	
	/*!
		I DON'T KNOW
	*/
	void addPitch(int pitch);
	
	/*!
		I DON'T KNOW
	*/
	void calcChord();
	
	/*!
		I DON'T KNOW
	*/
	void countAccPrnt(QString& stp, Accid& acc);
	
	/*!
		I DON'T KNOW
	*/
	int getAccPrnt(QString& stp);
	
	/*!
		I DON'T KNOW
	*/
	int getKeySig();
	
	/*!
		I DON'T KNOW
	*/
	bool getNote(int pitch, QString& stp, int& alt, int& oct, Accid& acc);
	
	/*!
		I DON'T KNOW
	*/
	void resetToKeySig();
	
	/*!
		I DON'T KNOW
	*/
	int  sao2Pitch(const QString& stp, int alt, int oct);
	
	/*!
		I DON'T KNOW
	*/
	void setKeySig(int sig);
	
	/*!
		I DON'T KNOW
	*/
	void startChord();
private:
	void markInUse(int i, int nlh, Accid a);
	bool mustPrntAllAcc(int nn);
	bool naGet(const QString& stp, int oct);
	void naReset(const QString& stp, int oct);
	void naResetAll();
	void naSetAll(const QString& stp);
	int naSo2i(const QString& stp, int oct);
	int  normalize(int pitch);
	static const int stPerOct = 12;	// # semitones (half steps) per octave
	int accPrnt[7];					// # accidentals printed for each note
	int keySig;						// key signature in # sharps or flats
	bool notes_av[stPerOct];		// notes available
	bool notes_req[stPerOct];		// notes requested for this chord
	Accid old_acc_state[stPerOct];	// accidental state for all notes, before
	Accid new_acc_state[stPerOct];	// and after calcChord
	int out_root_note[stPerOct];	// notes to be printed
	Accid out_accidental[stPerOct];	// accidentals to be printed
	bool needs_acc[77];				// which notes need an accidental
	bool printAllAccInChrd;			// print acc on all notes in chord
	bool printAccAllInst;			// print acc for all instances same note
};

#endif
