#include "settings.h"
#include "timiditylauncher.h"

TimidityLauncher::TimidityLauncher(QWidget* parent, const char* name)
: QProcess(parent, name)
{
}

TimidityLauncher::~TimidityLauncher()
{
}

bool TimidityLauncher::launchTimidity()
{
	result = error = "";
	
	if (!Settings::midiTimidity())
		return false;
	
	setupTimidity();
	
	if (start() == false)
		return false;
	
	while (result.isEmpty() && error.isEmpty())
		kapp->processEvents();
	
	return error.isEmpty();
}

void TimidityLauncher::setupTimidity()
{
	clearArguments();
	
	addArgument(Settings::timidityPath());
	addArgument("-iA");
	
	QString buffer;
	buffer.setNum(Settings::timidityBuffer());
	QString fragment;
	fragment.setNum(Settings::timidityFragment());
	addArgument("-B" + buffer + "," + fragment);
	
	addArgument("-O" + Settings::timidityOutput());
	addArgument("-EFchorus=" + Settings::timidityChorus());
	addArgument("-EFdelay=" + Settings::timidityDelay());
	
	QString noise;
	noise.setNum(Settings::timidityNoise());
	addArgument("-EFns=" + noise);
	
	addArgument("-EFresamp=" + Settings::timidityResamp());
	addArgument("-EFreverb=" + Settings::timidityReverb());
	addArgument("-EFvlpf=" + Settings::timidityVlpf());
	
	QString realtime;
	
	if (Settings::timidityRealTimeEnable()) {
		realtime.setNum(Settings::timidityRealTime());
		addArgument("--realtime-priority=" + realtime);
	} else realtime = "no realtime enabled";
	
	QString frequency;
	frequency.setNum(Settings::timidityFrequency());
	addArgument("-s " + frequency);
	
	connect(this, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()));
	connect(this, SIGNAL(readyReadStderr()), this, SLOT(readFromStderr()));
}

QString TimidityLauncher::errorMsg()
{
	return arguments().join(", ") + " output : " + result + " " + error;
}

void TimidityLauncher::readFromStdout()
{
	result.append(readStdout());
	kdDebug() << "Timidity standart output = " << result << "\n";
}

void TimidityLauncher::readFromStderr()
{
	error.append(readStderr());
	kdDebug() << "Timidity error output = " << error << "\n";
}
