/***************************************************************************
 * chord.h: implementation of ChordSelector class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef CHORD_H
#define CHORD_H

#include <header.h>

class ChordList;
class Fingering;
class FingerList;
class Fingers;
class Strumming;
class TabTrack;

/*!
	This class allow the user to construct, select, 
	or analyse a chord
*/
class ChordSelector: public QDialog {
    Q_OBJECT
public:
	/*!
		Constructor
		\param midiScheduler the midi scheduler
		\param track a track of the song
		\param parent the widget parent
		\param name the name of the widget
	*/
	ChordSelector(TSE3::MidiScheduler* midiScheduler, const TabTrack& track, QWidget* parent = 0, const char* name = 0);
	
	/*!
		Used by the constructor
		TODO remove this function
	*/
	void initChordSelector();
	
	/*!
		TODO i don't know what this function do
	*/
	int  app(int x);
	
	/*!
		TODO i don't know what this function do
	*/
	void setApp(int x, int fret);
	
	/*!
		TODO i don't know what this function do
	*/
	int  scheme();
	
	/*!
		TODO i don't know what this function do
	*/
	Fingering & getFingering() const;
	/*!
		TODO i don't know what this function do
	*/
	ChordList & getChordList() const;
public slots:
	/*!
		Try to detect some chord forms from a given applicature.
	*/
	void detectChord();
	
	/*!
		I DON'T KNOW
	*/
	void setStep3();
	
	/*!
		I DON'T KNOW
	*/
	void setHighSteps();
	
	/*!
		I DON'T KNOW
	*/
	void setStepsFromChord();
	
	/*!
		Analyses st[] combobox array and find out steps templating
		listboxes selections from it
	*/
	void findSelection();
	
	/*!
		Most complex and longest method that does the real calculation of
		chords. Translates steps settings input to the list of chords and
		adds them to displayer.
	*/
	void findChords();
	
	/*!
		I DON'T KNOW
	*/
	void askStrum();
	
	/*!
		Try to decipher text-written chord name and set steps accordingly
	*/
	void analyzeChordName();
	
	/*!
		Analyze chord by text-written name, automatically select best one
		and insert it into track.
	*/
	void quickInsert();
	
private slots:
	/*!
		Play a chord
	*/
	void playMidi();
	
private:
	/*!
		Calculate absolute notes from tonic + step user input
	*/
	bool calculateNotesFromSteps(int[], int &);
	
	static const uint stepsize;
	
	Fingering *fng;
	ChordList *chords;
	const TabTrack& tabTrack;
	
	QLineEdit *chordName;
	QListBox *tonic, *step3, *stephigh;
	QComboBox *st[7], *inv, *bassnote;
	QLabel *cnote[7];
	QButtonGroup *complexity;
	QRadioButton *complexer[3];
	QPushButton *play;
	FingerList *fnglist;

	int strum_scheme;
	TSE3::MidiScheduler* scheduler;
};

#endif
