/***************************************************************************
 * chordanalyzer.h: implementation of ChordAnalyzer class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef CHORDANALYZER_H
#define CHORDANALYZER_H

#include <header.h>

/*!
	Analyse a chord, checks if it's correct.
*/
class ChordAnalyzer {
public:
	/*!
		Initialisation and give the chord.
		\param name of the chord.
	*/
	ChordAnalyzer(QString name);
	
	/*!
		Check if the chord is correct.
		\return true if it's correct
	*/
	bool analyze();
	
	/*!
		I DON'T KNOW
	*/
	const QString & getMsg()  { return msg; }
	
	/*!
		I DON'T KNOW
	*/
	void setMsg(const QString &s)  { msg = s; }
	
	/*!
		I DON'T KNOW
	*/
	int getStep(uchar i)  { return step[i]; }
	
	/*!
		I DON'T KNOW
	*/
	int getTonic()  { return tonic; }
private:
	QString name;
	bool fixed[6];
	int pos;
	int tonic;
	int step[6];
	bool result;
	QString msg;

	/*!
		Checks if the sample string comes next in the line of analyze
	*/
	bool checkNext(QString sample);
	
	/*!
		Sets and fixes the step "index" to value "value", if still not
		fixed. If already fixed, bails out complaining about "reason"
	*/
	bool setStep(int step, int value, QString reason);
};

#endif
