/***************************************************************************
 * chordlist.cpp: implementation of ChordList class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "chordlist.h"
#include "chordlistitem.h"

ChordList::ChordList(QWidget *parent, const char *name)
: QListBox(parent, name)
{
}

void ChordList::inSort(ChordListItem *it)
{
    uint l = ((QString) it->text()).length();
    uint best = 0;

    for (uint i = 0; i < count(); i++) {
		if (((QString) item(i)->text()).length() < l)
			best++;
		else
			break;
    }

    insertItem(it, best);
}

ChordListItem* ChordList::currentItemPointer()
{
    return (ChordListItem*) item(currentItem());
}
