/***************************************************************************
 * fingerlist.h: implementation of FingerList class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef FINGERLIST_H
#define FINGERLIST_H

#define ICONCHORD	   50

#include <header.h>

#include "global.h"

class TabTrack;

/*!
	TODO
*/
struct fingering{
	/*!
	TODO
	*/
	int f[MAX_STRINGS];
};

/*!
	I DON'T KNOW
*/
class FingerList: public QGridView {
	Q_OBJECT
public:
	/*!
		TODO
	*/
	FingerList(const TabTrack& track, QWidget* parent = 0, const char* name = 0);
	
	/*!
		TODO
	*/
	~FingerList();
	
	/*!
		TODO
	*/
	void addFingering(const int a[MAX_STRINGS]);
	
	/*!
		TODO
	*/
	void clear();
	
	/*!
		Begins new "session" for fingering list, i.e. clears it and
		prepares for adding new chords.
	*/
	void beginSession();
	
	/*!
		Ends adding "session" for the list, setting proper number of
		columns / rows, updating it, etc.
	*/
	void endSession();
	
	/*!
		TODO
	*/
	int count() { return appl.count(); };
	
	/*!
		TODO
	*/
	void selectFirst();
	
signals:
	void chordSelected(const int *);
	
protected:
	virtual void paintCell(QPainter *, int row, int col);
	virtual void resizeEvent(QResizeEvent *);
	virtual void mousePressEvent(QMouseEvent *);
	
private:
	enum { SCALE=6, CIRCLE=5, CIRCBORD=1, BORDER=1, SPACER=1, FRETTEXT=9 };
	
	static const uint iconChord;
	static const double fontFactor;
	
	int num, perRow;
	QMemArray<fingering> appl;
	
	int curSel, oldCol, oldRow;
	const TabTrack& tabTrack;
	
	QFont *fretNumberFont;
};

#endif
