/***************************************************************************
 * clipboard.cpp: implementation of Clipboard class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/
 
#include "clipboard.h"

Clipboard::Clipboard(uint begin, uint bar, QWidget* parent, const char* name)
: QDialog(parent, name),
  layout(this, 5, 2, 0, -1, "Clipboard layout"),
  fromLabel("from", this, "from label"),
  toLabel("to", this, "to label"),
  from(1, bar, 1, this, "from spinbox"),
  to(1, bar, 1, this ,"to spinbox"),
  ok(this, "ok button"), cancel(this, "cancel button"),
  toEnd("to the end", this, "toEnd checkbox"),
  lastBar(bar)
{
	from.setValue(begin);
	to.setValue(begin);
	
	ok.setText("ok");
	cancel.setText("cancel");
	
	layout.addWidget(&fromLabel, 0,0);
	layout.addWidget(&from, 0, 1);
	layout.addWidget(&toLabel, 1,0);
	layout.addWidget(&to, 1, 1);
	layout.addWidget(&toEnd, 2, 0);
	layout.addWidget(&ok, 3, 0);
	layout.addWidget(&cancel, 3, 1);
	
	connect(&ok, SIGNAL(clicked()), this, SLOT(okClick()));
	connect(&cancel, SIGNAL(clicked()), this, SLOT(cancelClick()));
}

uint Clipboard::getFrom()
{
	return from.value();
}

uint Clipboard::getTo()
{
	return to.value();
}

void Clipboard::okClick()
{
	if (toEnd.isChecked() == true)
		to.setValue(lastBar);
	
	setResult(QDialog::Accepted);
	hide();
}

void Clipboard::cancelClick()
{
	setResult(QDialog::Rejected);
	hide();
}

Clipboard::~Clipboard()
{
}
