#ifndef CONVERT_BASE_H
#define CONVERT_BASE_H

class TabSong;

//! Abstract base class for all converters.
/*!
	Pure abstract base class to define basic structure of all
	converters - classes that manage loading / saving of internal
	KGuitar representation of tabulature data into some file format.
*/
class ConvertBase {
public:
	/*!
		Store the song var into the song class var.
		\param song The song.
	*/
	ConvertBase(TabSong *song) { this->song = song; };
	
	/*!
		Called to save current data from TabSong into file named
		fileName.
	*/
	virtual bool save(QString fileName) = 0;
	
	/*!
		Called to load data from file named fileName into TabSong.
	*/
	virtual bool load(QString fileName) = 0;
	
protected:
	//! The song to saved or load.
	TabSong *song;

};

#endif
