/***************************************************************************
 * guitarpro.h: implementation of GuitarPro class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef GUITARPRO4_H
#define GUITARPRO4_H

#include <header.h>

#include "fileimport.h"

class TabBarProperties;
class TabChord;
class TabBar;
class TabNote;
class TabSong;
class TabTimes;
class TrackMidiProperties;

/*!
	TODO
*/
class GuitarPro4 : public FileImport
{
public:
	/*!
		TODO
	*/
	GuitarPro4();
	
	/*!
		TODO
	*/
	virtual ~GuitarPro4();
	
	/*!
		TODO
	*/
	TabSong loadFile(const QString &);
	
	/*!
		TODO
	*/
	bool saveFile(const QString &, const TabSong &);
private:
	void readHeader(TabSong&);
	void readMidi();
	void readBars(TabSong&);
	void readTracks(TabSong&);
	
	TabChord readChords();
	void readChanges(TabBar& bar);
	void readEffectsOnBeat(TabTimes& times);
	void readEffectsOnNote(TabNote& note);
	void readNotes(bool rest, uchar beatduration, TabTimes& notes, uint noteLength);
	
	unsigned char *buffer;
	unsigned char *buf;
	long size, totalsize;
	uint nbbars, nbtrack;
	
	unsigned char getBeatDuration();
	
	inline bool isChar(unsigned char c);
	unsigned char getByte();
	inline unsigned long getLong();
	inline QString getString();
	inline QString getDelphiString();
	inline QString getStringNoInc(int i);
	inline QString getChordName();
	inline void dummies(int);
	
	QValueVector<TrackMidiProperties> instruments;
	QValueVector<TabBarProperties> trackProperties;
};

#endif
