/***************************************************************************
 * kguitartab.h: implementation of KGuitarTab class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef KGUITARTAB_H
#define KGUITARTAB_H

#include <header.h>

#include "fileimport.h"

class TabBar;
class TabBeatEffects;
class TabBend;
class TabBendPoint;
class TabChord;
class TabGraceNote;
class TabLyrics;
class TabNote;
class TabProperties;
class TabSong;
class TabTimes;
class TabTrack;
class TabTrill;
class TrackProperties;

/*!
	TODO
*/
class KGuitarTab : public FileImport
{
public:
	/*!
		TODO
	*/
	KGuitarTab();
	
	/*!
		TODO
	*/
	virtual ~KGuitarTab();
	
	/*!
		TODO
	*/
	TabSong loadFile(const QString&);
	
	/*!
		TODO
	*/
	bool saveFile(const QString&, const TabSong&);
	
private:
	void readSongInformation(QDomNode, TabSong&);
	
	void readSongProperties(QDomNode, TabProperties&);
	void readLyricsProperties(QDomNode, TabLyrics&);
	
	void readTrackInformation(QDomNode, TabSong&);
	void readTrackProperties(QDomNode, TrackProperties&);
	void readTrackSong(QDomNode, TabTrack&);
	
	TabBar   readBar(QDomNode);
	TabTimes readTime(QDomNode);
	
	void readTimesEffect(QDomNode, TabBeatEffects&);
	void readBendEffect(QDomNode, TabBend&);
	TabBendPoint readPointBend(QDomNode);
	void readChordEffect(QDomNode, TabChord&);
	
	TabNote readNote(QDomNode);
	void readTrillEffect(QDomNode, TabTrill&);
	void readGraceNoteEffect(QDomNode, TabGraceNote&);
	
	void oldKGuitar(QFile&, TabSong&);
	void kguitarElement(QDomNode, TabSong&);
	void songPropertiesElement(QDomNode, TabSong&);
	void tracksElement(QDomNode, TabSong&, uint);
	void trackPropertiesElement(QDomNode, TabSong&, uint);
	void trackSongElement(QDomNode, TabSong&, uint);
	void trackBarElement(QDomNode, TabTrack*, uint);
	void trackNoteElement(QDomNode, TabBar&, uint);
	
	void writeSongInformation(const QString&, QTextStream&, const TabSong&);
	void writeLyricsInformation(const QString&, QTextStream&, const TabLyrics&);
	void writeTrackInformation(const QString&, QTextStream&, const TabTrack&);
	void writeBarInformation(const QString&, QTextStream&, const TabBar&);
	void writeTimesInformation(const QString&, QTextStream&, const TabTimes&);
	void writeTimesEffectInformation(const QString&, QTextStream&, const TabBeatEffects&);
	void writeBendInformation(const QString&, QTextStream&, const TabBend&);
	void writeChordInformation(const QString&, QTextStream&, const TabChord&);
	void writeNoteInformation(const QString&, QTextStream&, const TabNote&);
	void writeTrillInformation(const QString&, QTextStream&, const TabTrill&);
	void writeGraceNoteInformation(const QString&, QTextStream&, const TabGraceNote&);
};

#endif
