/***************************************************************************
 * powertabl.h: implementation of PowerTab class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#ifndef POWERTAB_H
#define POWERTAB_H

#include <header.h>

#include "fileimport.h"

class TabBar;
class TabSong;
class TabTimes;
class TabTrack;

class PowerTab : public FileImport
{
public:
	PowerTab();
	virtual ~PowerTab();
	
	TabSong loadFile(const QString &) throw (const char*);
	bool saveFile(const QString &, const TabSong &);
private:
	inline unsigned char readUChar(QFile& file) throw (const char*);
	inline unsigned int readUInt(QFile& file) throw (const char*);
	inline unsigned long readULong(QFile& file) throw (const char*);
	template <class T> inline const T readUCType(QFile& file) throw (const char*);
	template <class T> inline const T readUIType(QFile& file) throw (const char*);
	
	inline unsigned long readMFCLength(QFile& file);
	inline QString readMFCString(QFile& file) throw (const char*);
	
	int readHeaderItems(QFile& file, QString& name) throw (const char*);
	inline void readItemNext(QFile& file) throw (const char*);
	
	inline void callSection(QFile& file, int nbCall, TabSong& tabSong, void (PowerTab::*pf)(QFile&, TabSong&)) throw (const char*);
	inline void callSection(QFile& file, void (PowerTab::*pf)(QFile&)) throw (const char*);
	
	void checkHeader(QFile& file) throw (const char*);
	
	void readHeaderVersion1(QFile& file, TabSong& tabSong);
	void readHeaderVersion15(QFile& file, TabSong& tabSong);
	void readHeaderVersion17(QFile& file, TabSong& tabSong);
	
	
	void readTrackInfo(QFile& file, TabSong& tabSong) throw (const char*);
	
	void readChord(QFile& file);
	void readGuitarIn(QFile& file);
	void readTempoMarker(QFile& file);
	void readDynamic(QFile& file);
	void readSectionSymbol(QFile& file);
	void readFloattingText(QFile& file);
	void readFontSetting(QFile& file);
	
	void readDirection(QFile& file);
	void readChordText(QFile& file);
	void readRhythmSlash(QFile& file);
	void readBarLine(QFile& file);
	
	void readDataInstruments(QFile& file, TabSong& tabSong, uint trackNb) throw (const char*);
	void readSection15(QFile& file, TabTrack& tabTrack) throw (const char*);
	void readStaff(QFile& file, TabTrack& tabTrack) throw (const char*);
	void readPosition(QFile& file, TabBar& bar) throw (const char*);
	void readNote(QFile& file, TabTimes& time) throw (const char*);
	
	void readKeySignature(QFile& file);
	void readTimeSignature(QFile& file);
	void readRehearsalSign(QFile& file);
	
	// Version 1.00 to 1.20
	//
	void readFormatVersion1(QFile& file, TabSong& tabSong, uint trackNb);
	void readOldTimeSignature(QFile& file);
	void readDynamic1(QFile& file);
	void readOldRehearsalSign(QFile& file);
	void readSection1(QFile& file, TabTrack& tabTrack);
	
	static const uint nullTag;
	static const uint newTagClass;
	static const uint tagClass;
	static const uint BigTagClass;
	static const uint objectTag;
	static const uint MaxMapCount;
	
	class release1{
	public:
		enum releaseType1 { Single, Ep,  Lp, DoubleLp, TripleLp, Boxset, BootLeg, Demo, Soundtrack, Video, None};
		enum authorType1  { AuthorUnknown = 0, Traditional};
	};
	
	class release17 {
	public:
		enum classificationSong { song, lesson};
		enum contentType  { None, Guitar, Bass, Percussion, All = 7};
		enum releaseType  { publicAudio, publicVideo, bootleg};
		enum audioRelease { Single, Ep, Album, DoubleAlbum, TripleAlbum, Boxset};
		enum musicStyle { Alternative, BlueGrass, Blues, Country, FingerPick, Flamenco, Folk, Funk, Fusion, 
						General, Jazz, Metal, Other, Pop, Progressive, Punk, Reggae, Rock, Swing};
		enum lessonLevel { Beginner, Intermediate, Advanced};
	};
	
	uint version;
};

#endif
