/***************************************************************************
 * textab.cpp: implementation of TexTab class
 *
 * This file is part of KGuitar, a KDE tabulature editor
 *
 * copyright (C) 2002-2003 the KGuitar development team
 ***************************************************************************/

/***************************************************************************
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * See the file COPYING for more information.
 ***************************************************************************/

#include "tabsong.h"
#include "textab.h"

TexTab::TexTab()
{
}

TexTab::~TexTab()
{
}

TabSong TexTab::loadFile(const QString &)
{
}

bool TexTab::saveFile(const QString &fileName, const TabSong &tabSong)
{
/*	QFile f(fileName);

	if (!f.open(IO_WriteOnly))
		return FALSE;

	QTextStream s(&f);

	QString nn[MAX_STRINGS];
	QString tmp;
	bool flatnote;

	QString bar, notes, tsize, showstr;

	bar = "\\bar";
	bar += "\n";
	notes = "\\Notes";
	showstr = "\\showstrings";

	switch (Settings::texTabSize()){
	case 0: tsize = "\\smalltabsize";
		break;
	case 1: tsize = "\\normaltabsize";
		break;
	case 2: tsize = "\\largetabsize";
		break;
	case 3: tsize = "\\Largetabsize";
		break;
	default: tsize = "\\largetabsize";
		break;
	}
	tsize += "\n";

	QListIterator<TabTrack>it(t);
	TabTrack *trk=it.current();

	// Stuff if globalShowStr=TRUE

	flatnote = FALSE;
	for (int i = 0; i < trk->getString(); i++) {
		nn[i] = Settings::noteName(trk->getTune(i) % 12);
		if ((nn[i].contains("#", FALSE) == 1) && (nn[i].length() == 2)) {
			nn[i] = nn[i].left(1) + "$\\sharp$";
			flatnote = TRUE;
		}
		if ((nn[i].contains("b", FALSE) == 1) && (nn[i].length() == 2)) {
			nn[i] = nn[i].left(1) + "$\\flat$";
			flatnote = TRUE;
		}
	}

	tmp = "\\othermention{%";
	tmp += "\n";
	tmp += "\\noindent Tuning:\\\\";
	tmp += "\n";

	if (trk->getString() == 4){
		tmp += "\\tuning{1}{" + nn[3];
		tmp += "} \\quad \\tuning{3}{" + nn[1] + "} \\quad \\\\";
		tmp += "\n";
		tmp += "\\tuning{2}{" + nn[2];
		tmp += "} \\quad \\tuning{4}{" + nn[0] + "}";
		tmp += "\n";
	}

	if (trk->getString() == 5){
		tmp += "\\tuning{1}{" + nn[4];
		tmp += "} \\quad \\tuning{4}{" + nn[1] + "} \\quad \\\\";
		tmp += "\n";
		tmp += "\\tuning{2}{" + nn[3];
		tmp += "} \\quad \\tuning{5}{" + nn[0] + "} \\quad \\\\";
		tmp += "\n";
		tmp += "\\tuning{3}{" + nn[2] + "}";
		tmp += "\n";
	}

	if (trk->getString() == 6){
		tmp += "\\tuning{1}{" + nn[5];
		tmp += "} \\quad \\tuning{4}{" + nn[2] + "} \\quad \\\\";
		tmp += "\n";
		tmp += "\\tuning{2}{" + nn[4];
		tmp += "} \\quad \\tuning{5}{" + nn[1]+"} \\quad \\\\";
		tmp += "\n";
		tmp += "\\tuning{3}{" + nn[3];
		tmp += "} \\quad \\tuning{6}{" + nn[0]+"}";
		tmp += "\n";
	}

	if (trk->getString() >= 7){
		s << "Sorry, but MusiXTeX/kgtabs.tex has only 6 tablines" << "\n";
		s << "\\end" << "\n";
		f.close();
		return FALSE;
	}

	tmp += "}";
	tmp += "\n";

	if (trk->getString() < 4)
		tmp = "";

	for (int i = (trk->getString() - 1); i >= 0; i--){
		showstr += " ";
		showstr += Settings::noteName(trk->getTune(i) % 12);
	}

	switch (trk->getString()){
	case 1: showstr += " X X X X X";         // now it is a defined control sequence
		break;
	case 2: showstr += " X X X X";
		break;
	case 3: showstr += " X X X";
		break;
	case 4: showstr += " X X";
		break;
	case 5: showstr += " X";
		break;
	default: break;
	}

	showstr += "\n";

	// TeX-File INFO-HEADER

	s << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" << "\n";
	s << "%" << "\n";
	s << "% This MusiXTex File was created with KGuitar " << VERSION << "\n";
	s << "% $Id: tabsong.cpp,v 1.54 2004/07/02 20:29:28 lvinken Exp $" << "\n";
	s << "%" << "\n";
	s << "% You can download the latest version at:" << "\n";
	s << "%      http://kguitar.sourceforge.net" << "\n";
	s << "%" << "\n";
	s << "% MusiXTeX is required to use this file." << "\n";
	s << "% You can download it at one of the following sites:" << "\n";
	s << "%" << "\n";
	s << "%      ftp://ftp.dante.de/tex-archive/macros/musixtex/taupin/" << "\n";
	s << "%      http://www.gmd.de/Misc/Music/" << "\n";
	s << "%" << "\n";
	s << "% IMPORTANT: This file should not be used with LaTeX!" << "\n";
	s << "%" << "\n";
	s << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" << "\n";

	// TeX-File HEADER
	s << "\\input musixtex" << "\n";
	s << "\\input musixsty" << "\n";
	s << "\\input kgtabs.tex" << "\n";

	// SONG HEADER

	if (!Settings::texShowPageNumber())
		s << "\\nopagenumbers" << "\n";

	s << "\\fulltitle{" << cleanString(title) << "}";
	s << "\n";
	s << "\\subtitle{\\svtpoint\\bf Author: " << cleanString(author) << "}" << "\n";
	s << "\\author{Transcribed by: " << cleanString(transcriber);
	s << "\\\\%" << "\n";
	s << "        Tempo: " << tempo << "}";
	s << "\n";

	if (!Settings::texShowStr())
		s << tmp;

	s << "\\maketitle" << "\n";
	s << "\n";
	s << "\\settab1" << "\n";

	if (!Settings::texShowBarNumber())
		s << "\\nobarnumbers" << "\n";

	s << "\\let\\extractline\\leftline" << "\n";
	s << "\n";

	// TRACK DATA
	int n = 1;       // Trackcounter
	int cho;         // more than one string in this column
	int width;
	uint trksize;
	uint bbar;       // who are bars?

	for (; it.current(); ++it) { // For every track
		TabTrack *trk = it.current();

		s << "Track " << n << ": " << trk->getName();
		s << "\n";
		s << "\\generalmeter{\\meterfrac{" << trk->getVectTabBar(0).time1;
		s << "}{" << trk->getVectTabBar(0).time2 << "}}";
		s << "\n" << "\n"; // the 2nd LF is very important!!
		s << tsize;

		if (Settings::texShowStr() && (!flatnote))
			s << showstr;

		s << "\\startextract" << "\n";

		// make here the tabs

		cho = 0;
		width = 0;
		bbar = 1;
		trksize = trk->getTabColumnSize();

		QString tmpline;

		for (uint j = 0; j < trksize; j++) { // for every column (j)
			tmpline = notes;

			if ((bbar + 1) < (uint)trk->getTabBarSize()) { // looking for bars
				if ((uint)trk->getVectTabBar(bbar + 1).start == j)  bbar++;
			}
			if ((uint)trk->getVectTabBar(bbar).start == j)  s << bar;

			for (int x = 0; x < trk->getString(); x++) // test how much tabs in this column
				if (trk->getVectTabColumn(j).getNbFret(x)>=0)  cho++;

			for (int x = 0; x < trk->getString(); x++) {
				if ((trk->getVectTabColumn(j).getNbFret(x) >= 0) && (cho == 1))
					s << notes << tab(FALSE, trk->getString() - x, trk->getVectTabColumn(j).getNbFret(x));
				if ((trk->getVectTabColumn(j).getNbFret(x) >= 0) && (cho > 1))
					tmpline += tab(TRUE, trk->getString() - x, trk->getVectTabColumn(j).getNbFret(x));
			}

			if (cho > 1)
				s << tmpline;
			if (cho > 0) width++;                  // if tab is set
			if (((j + 1) == trksize) && (cho > 0)) // Last time?
				s << "\\sk\\en";
			else {
				if (cho > 0)  s << "\\en" << "\n";
				if ((cho > 0) && (width >= 26)){       // we need a LF in tab
					s << "\\endextract" << "\n";
					if (Settings::texShowStr() && (!flatnote))
						s << showstr;
					s << "\\startextract" << "\n";
					width = 0;
				}
			}
			cho = 0;
		}                        //end of (j)

		s << "\n";
		s << "\\endextract" << "\n";

		n++;
	}
	// End of TeX-File
	s << "\\end";

	f.close();*/
	return TRUE;
}
